/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.basex.data.DataText;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.ft.FTPos;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.http.MediaType;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

abstract class MarkupSerializer
extends StandardSerializer {
    private static final QNm Q_HTTP_EQUIV = new QNm(DataText.HTTP_EQUIV);
    String docsys;
    String docpub;
    boolean root;
    int script;
    final boolean html5;
    final boolean escape;
    final boolean saomit;
    final boolean content;
    private final boolean undecl;
    private QNmSet suppress;
    private final String media;
    private final boolean indAttr;
    protected long indAttrLength;
    private final PrintOutput.Fallback fallbackCDATA = cp -> {
        this.out.print(DataText.CDATA_C);
        this.printHex(cp);
        this.out.print(DataText.CDATA_O);
    };
    private final PrintOutput.Fallback fallback = this::printHex;
    private QNmSet cdata;

    protected MarkupSerializer(OutputStream os, SerializerOptions sopts, String ... versions) throws IOException {
        super(os, sopts);
        boolean xml;
        String version = sopts.get(SerializerOptions.VERSION);
        String hv = sopts.get(SerializerOptions.HTML_VERSION);
        if (hv.matches("\\d+(\\.\\d+)?")) {
            hv = Double.toString(Double.parseDouble(hv));
        }
        this.html5 = hv.equals("5.0") || versions[0].equals("5.0") && hv.isEmpty() && (version.isEmpty() || version.equals("5.0"));
        version = MarkupSerializer.checkVersion(SerializerOptions.VERSION, version, versions);
        MarkupSerializer.checkVersion(SerializerOptions.VERSION, hv, "5.0", "4.01", "4.0");
        boolean omitDecl = sopts.yes(SerializerOptions.OMIT_XML_DECLARATION);
        Options.YesNoOmit sa = sopts.get(SerializerOptions.STANDALONE);
        this.saomit = sa == Options.YesNoOmit.OMIT;
        this.docsys = sopts.get(SerializerOptions.DOCTYPE_SYSTEM);
        this.docpub = sopts.get(SerializerOptions.DOCTYPE_PUBLIC);
        this.media = sopts.get(SerializerOptions.MEDIA_TYPE);
        this.escape = sopts.yes(SerializerOptions.ESCAPE_URI_ATTRIBUTES);
        this.content = sopts.yes(SerializerOptions.INCLUDE_CONTENT_TYPE);
        this.undecl = sopts.yes(SerializerOptions.UNDECLARE_PREFIXES);
        this.indAttr = sopts.yes(SerializerOptions.INDENT_ATTRIBUTES);
        if (this.docsys.isEmpty()) {
            this.docsys = null;
        }
        if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        boolean html = this instanceof HTMLSerializer;
        boolean bl = xml = this instanceof XMLSerializer || this instanceof XHTMLSerializer;
        if (xml || html) {
            if (this.undecl && version.equals("1.0")) {
                throw QueryError.SERUNDECL.getIO(new Object[0]);
            }
            if (xml) {
                if (omitDecl) {
                    if (!this.saomit || !version.equals("1.0") && this.docsys != null) {
                        throw QueryError.SERSTAND.getIO(new Object[0]);
                    }
                } else {
                    this.out.print(DataText.PI_O);
                    this.out.print("xml version=\"");
                    this.out.print(version);
                    this.out.print("\" encoding=\"");
                    this.out.print(sopts.get(SerializerOptions.ENCODING));
                    if (!this.saomit) {
                        this.out.print("\" standalone=\"");
                        this.out.print(sa.toString());
                    }
                    this.out.print(DataText.ATT2);
                    this.out.print(DataText.PI_C);
                    if (this.indent) {
                        this.out.print(10);
                    }
                }
            }
        }
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            for (Item it : MarkupSerializer.flatten(array)) {
                super.serialize(it);
            }
        } else {
            super.serialize(item);
        }
    }

    @Override
    protected void namespace(byte[] prefix, byte[] uri, boolean standalone) throws IOException {
        if (this.undecl || prefix.length == 0 || uri.length != 0) {
            super.namespace(prefix, uri, standalone);
        }
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (!standalone) {
            this.delimitAttribute();
        }
        this.out.print(name);
        this.out.print(DataText.ATT1);
        byte[] val = Token.normalize(value, this.form);
        int vl = val.length;
        for (int v = 0; v < vl; v += Token.cl(val, v)) {
            int cp = Token.cp(val, v);
            if (cp == 34) {
                this.out.print(DataText.E_QUOT);
                continue;
            }
            if (cp == 9 || cp == 10) {
                this.printHex(cp);
                continue;
            }
            this.printChar(cp);
        }
        this.out.print(DataText.ATT2);
    }

    protected void delimitAttribute() throws IOException {
        if (this.indAttr && this.out.lineLength() > this.indAttrLength) {
            this.out.print(10);
            int i = 0;
            while ((long)i < this.indAttrLength) {
                this.out.print(32);
                ++i;
            }
        }
        this.out.print(32);
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        if (this.opened.isEmpty()) {
            this.checkRoot(null);
        }
        byte[] val = Token.normalize(value, this.form);
        if (ftp == null) {
            QNmSet qnames = this.cdata();
            int vl = val.length;
            if (qnames.isEmpty() || this.opened.isEmpty() || !qnames.contains((QNm)this.opened.peek())) {
                for (int v = 0; v < vl; v += Token.cl(val, v)) {
                    this.printChar(Token.cp(val, v));
                }
            } else {
                this.out.print(DataText.CDATA_O);
                int c = 0;
                for (int v = 0; v < vl; v += Token.cl(val, v)) {
                    int cp = Token.cp(val, v);
                    if (cp == 93) {
                        ++c;
                    } else {
                        if (c > 1 && cp == 62) {
                            this.out.print(DataText.CDATA_C);
                            this.out.print(DataText.CDATA_O);
                        }
                        c = 0;
                    }
                    this.out.print(cp, this.fallbackCDATA);
                }
                this.out.print(DataText.CDATA_C);
            }
        } else {
            FTLexer lexer = new FTLexer().original().init(val);
            while (lexer.hasNext()) {
                FTSpan span = lexer.next();
                if (!span.del && ftp.contains(span.pos)) {
                    this.out.print(63740);
                }
                byte[] text = span.text;
                int tl = text.length;
                for (int t = 0; t < tl; t += Token.cl(text, t)) {
                    this.printChar(Token.cp(text, t));
                }
            }
        }
        this.sep = false;
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.COMM_O);
        this.out.print(value);
        this.out.print(DataText.COMM_C);
        this.sep = true;
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.PI_O);
        this.out.print(value.length > 0 ? Token.concat(name, Token.cpToken(32), value) : name);
        this.out.print(DataText.PI_C);
        this.sep = true;
    }

    @Override
    protected void openDoc(byte[] name) {
        this.sep = false;
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        if (this.opened.isEmpty()) {
            this.checkRoot(name);
        }
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_O);
        this.out.print(name.string());
        this.indAttrLength = this.out.lineLength();
        this.sep = true;
    }

    final void checkRoot(QNm name) throws IOException {
        if (this.root) {
            if (!this.saomit) {
                throw QueryError.SERSA.getIO(new Object[0]);
            }
            if (this.docsys != null) {
                throw QueryError.SERDT.getIO(new Object[0]);
            }
        }
        if (name != null) {
            this.doctype(name);
        }
        this.root = true;
    }

    @Override
    protected void finishOpen() throws IOException {
        this.out.print(DataText.ELEM_C);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.out.print(DataText.ELEM_SC);
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_OS);
        this.out.print(this.elem.string());
        this.out.print(DataText.ELEM_C);
        this.sep = true;
    }

    @Override
    protected void atomic(Item item) throws IOException {
        if (this.opened.isEmpty()) {
            this.checkRoot(null);
        }
        super.atomic(item);
    }

    @Override
    protected void print(int cp) throws IOException {
        if (cp < 32 && cp != 10 && cp != 9 || cp >= 127 && cp < 160) {
            this.printHex(cp);
        } else if (cp == 38) {
            this.out.print(DataText.E_AMP);
        } else if (cp == 62) {
            this.out.print(DataText.E_GT);
        } else if (cp == 60) {
            this.out.print(DataText.E_LT);
        } else if (cp == 8232) {
            this.out.print(DataText.E_2028);
        } else {
            this.out.print(cp, this.fallback);
        }
    }

    protected abstract void doctype(QNm var1) throws IOException;

    @Override
    protected boolean skipElement(ANode node) {
        if (node.type == NodeType.ELEMENT && Token.eq(node.name(), DataText.META)) {
            byte[] value = node.attribute(Q_HTTP_EQUIV);
            return value != null && Token.eq(Token.trim(value), DataText.CONTENT_TYPE);
        }
        return false;
    }

    protected final void printDoctype(byte[] name, String pub, String sys) throws IOException {
        if (this.level != 0 || this.root) {
            return;
        }
        if (this.sep) {
            this.indent();
        }
        this.out.print("<!DOCTYPE ");
        this.out.print(name);
        if (sys != null || pub != null) {
            if (pub != null) {
                this.out.print(" PUBLIC \"" + pub + "\"");
            } else {
                this.out.print(" SYSTEM");
            }
            if (sys != null) {
                this.out.print(" \"" + sys + "\"");
            }
        }
        this.out.print(DataText.ELEM_C);
        this.sep = true;
    }

    @Override
    protected void indent() throws IOException {
        if (this.atomic) {
            this.atomic = false;
        } else if (this.indent) {
            if (this.inline()) {
                return;
            }
            for (QNm qname : this.opened) {
                if (!this.suppressIndentation(qname)) continue;
                return;
            }
            super.indent();
        }
    }

    protected final boolean printCT(boolean empty, boolean html) throws IOException {
        if (this.skip != 1) {
            return false;
        }
        ++this.skip;
        if (empty) {
            this.finishOpen();
        }
        ++this.level;
        this.startOpen(new QNm(this.elem.hasPrefix() ? Token.concat(this.elem.prefix(), ":", DataText.META) : DataText.META));
        if (this.html5) {
            this.attribute(DataText.CHARSET, Token.token(this.encoding), false);
        } else {
            this.attribute(DataText.HTTP_EQUIV, DataText.CONTENT_TYPE, false);
            this.attribute(DataText.CONTENT, Token.concat(this.media.isEmpty() ? MediaType.TEXT_HTML : this.media, "; ", DataText.CHARSET, "=", this.encoding), false);
        }
        this.out.print(html ? DataText.ELEM_C : DataText.ELEM_SC);
        --this.level;
        if (empty) {
            this.finishClose();
        }
        return true;
    }

    static String checkVersion(StringOption option, String string, String ... allowed) throws QueryIOException {
        if (string.isEmpty()) {
            return allowed.length > 0 ? allowed[0] : string;
        }
        if (Strings.eq(string, allowed)) {
            return string;
        }
        throw QueryError.SERNOTSUPP_X.getIO(Options.allowed(option, string, allowed));
    }

    private QNmSet cdata() throws QueryIOException {
        if (this.cdata == null) {
            this.cdata = new QNmSet();
            boolean html = this instanceof HTMLSerializer;
            for (QNm name : this.qnames(SerializerOptions.CDATA_SECTION_ELEMENTS)) {
                byte[] uri = name.uri();
                if (html && (uri.length == 0 || this.html5 && Token.eq(uri, DataText.XHTML_URI))) continue;
                this.cdata.add(name);
            }
        }
        return this.cdata;
    }

    boolean inline() {
        return false;
    }

    boolean suppressIndentation(QNm qname) throws QueryIOException {
        if (this.suppress == null) {
            this.suppress = new QNmSet();
            for (QNm name : this.qnames(SerializerOptions.SUPPRESS_INDENTATION)) {
                this.suppress.add(new QNm(Token.lc(name.string()), name.uri()));
            }
        }
        return !this.suppress.isEmpty() && this.suppress.contains(new QNm(Token.lc(qname.string()), qname.uri()));
    }

    private ArrayList<QNm> qnames(StringOption option) throws QueryIOException {
        ArrayList<QNm> list = new ArrayList<QNm>();
        for (byte[] name : Token.distinctTokens(Token.token(this.sopts.get(option)))) {
            try {
                list.add(QNm.parse(name, this.sc != null ? this.sc.elemNS : null, this.sc, null));
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        return list;
    }
}

