/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import net.xqj.core.XQDynamicExpression;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;

public class LexicalValidator {
    private static Pattern[] atomicPatterns = new Pattern[52];

    private static void loadPatterns() {
        Properties properties = new Properties();
        try {
            XQToolkit.loadProperties(properties, XQToolkit.loadResource("/resources/xdm-regex.xml"));
        }
        catch (XQException e) {
            throw new ExceptionInInitializerError(e);
        }
        for (int i = 1; i < 52; ++i) {
            LexicalValidator.atomicPatterns[i] = Pattern.compile(properties.getProperty(XQDynamicExpression.XQJ_BASETYPE_MAP[i]), 32);
        }
    }

    public static final void validate(String lexicalString, XQItemType type) throws XQException {
        switch (type.getItemKind()) {
            case 1: {
                LexicalValidator.validateAtomicValue(lexicalString, type.getBaseType());
            }
        }
    }

    public static final void validate(char[] lexicalString, XQItemType type) throws XQException {
        LexicalValidator.validate(new String(lexicalString), type);
    }

    static final void validateAtomicValue(String lexicalString, int basetype) throws XQException {
        Matcher matcher = atomicPatterns[basetype].matcher(lexicalString);
        if (matcher.matches()) {
            if (XQToolkit.isDerivedFromRestriction(13, basetype)) {
                BigInteger integer = new BigInteger(lexicalString);
                LexicalValidator.validateInteger(integer, basetype);
            } else if (basetype == 17 || basetype == 18 || basetype == 20) {
                BigDecimal decimal = new BigDecimal(lexicalString);
                LexicalValidator.validateDecimal(decimal, basetype);
            }
        } else {
            throw new XQExceptionImpl("value " + lexicalString + " does not pass the lexical conditions of " + XQDynamicExpression.XQJ_BASETYPE_MAP[basetype], "XQJLEX13");
        }
    }

    static void validateDecimal(BigDecimal decimal, int basetype) throws XQException {
        if (basetype == 20) {
            // empty if block
        }
        if (basetype != 18 || decimal.precision() >= 64) {
            // empty if block
        }
        if (basetype == 17) {
            // empty if block
        }
    }

    static void validateInteger(BigInteger integer, int basetype) throws XQException {
        if (basetype == 31 && integer.bitLength() >= 8) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:byte.", "XQJLEX01");
        }
        if (basetype == 14 && integer.bitLength() >= 16) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:short.", "XQJLEX02");
        }
        if (basetype == 12 && integer.bitLength() >= 32) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:int.", "XQJLEX03");
        }
        if (basetype == 15 && integer.bitLength() >= 64) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:long.", "XQJLEX04");
        }
        if (basetype == 32 && BigInteger.ZERO.compareTo(integer) > 0) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:nonPositiveInteger.", "XQJLEX05");
        }
        if (basetype == 34 && BigInteger.ZERO.compareTo(integer) > -1) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:negativeInteger.", "XQJLEX06");
        }
        if (basetype == 33 && BigInteger.ZERO.compareTo(integer) < 0) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:nonNegativeInteger.", "XQJLEX06");
        }
        if (basetype == 35 && BigInteger.ONE.compareTo(integer) < 0) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:positiveInteger.", "XQJLEX07");
        }
        if (basetype == 36 && (integer.bitLength() >= 64 || BigInteger.ZERO.compareTo(integer) < 0)) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:unsignedLong.", "XQJLEX08");
        }
        if (basetype == 37 && (integer.bitLength() >= 32 || BigInteger.ZERO.compareTo(integer) < 0)) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:unsignedInt.", "XQJLEX09");
        }
        if (basetype == 38 && (integer.bitLength() >= 16 || BigInteger.ZERO.compareTo(integer) < 0)) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:unsignedShort.", "XQJLEX10");
        }
        if (basetype == 39 && (integer.bitLength() >= 8 || BigInteger.ZERO.compareTo(integer) < 0)) {
            throw new XQExceptionImpl(integer + " is outside the range of xs:unsignedByte.", "XQJLEX11");
        }
        if (basetype == 13) {
            // empty if block
        }
    }

    static {
        LexicalValidator.loadPatterns();
    }
}

