/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.basex.core.users.Perm;
import org.basex.query.QueryText;
import org.basex.query.func.AFunction;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.request.RequestAddress;
import org.basex.query.func.request.RequestAttribute;
import org.basex.query.func.request.RequestAttributeMap;
import org.basex.query.func.request.RequestAttributeNames;
import org.basex.query.func.request.RequestContextPath;
import org.basex.query.func.request.RequestCookie;
import org.basex.query.func.request.RequestCookieMap;
import org.basex.query.func.request.RequestCookieNames;
import org.basex.query.func.request.RequestHeader;
import org.basex.query.func.request.RequestHeaderMap;
import org.basex.query.func.request.RequestHeaderNames;
import org.basex.query.func.request.RequestHostname;
import org.basex.query.func.request.RequestMethod;
import org.basex.query.func.request.RequestParameter;
import org.basex.query.func.request.RequestParameterMap;
import org.basex.query.func.request.RequestParameterNames;
import org.basex.query.func.request.RequestPath;
import org.basex.query.func.request.RequestPort;
import org.basex.query.func.request.RequestQuery;
import org.basex.query.func.request.RequestRemoteAddress;
import org.basex.query.func.request.RequestRemoteHostname;
import org.basex.query.func.request.RequestRemotePort;
import org.basex.query.func.request.RequestScheme;
import org.basex.query.func.request.RequestSetAttribute;
import org.basex.query.func.request.RequestUri;
import org.basex.query.func.rest.RestBaseUri;
import org.basex.query.func.rest.RestInit;
import org.basex.query.func.rest.RestUri;
import org.basex.query.func.rest.RestWadl;
import org.basex.query.func.session.SessionAccessed;
import org.basex.query.func.session.SessionClientId;
import org.basex.query.func.session.SessionClose;
import org.basex.query.func.session.SessionCreated;
import org.basex.query.func.session.SessionDelete;
import org.basex.query.func.session.SessionGet;
import org.basex.query.func.session.SessionId;
import org.basex.query.func.session.SessionNames;
import org.basex.query.func.session.SessionSet;
import org.basex.query.func.sessions.SessionsAccessed;
import org.basex.query.func.sessions.SessionsClose;
import org.basex.query.func.sessions.SessionsCreated;
import org.basex.query.func.sessions.SessionsDelete;
import org.basex.query.func.sessions.SessionsGet;
import org.basex.query.func.sessions.SessionsIds;
import org.basex.query.func.sessions.SessionsNames;
import org.basex.query.func.sessions.SessionsSet;
import org.basex.query.func.ws.WsBroadcast;
import org.basex.query.func.ws.WsClose;
import org.basex.query.func.ws.WsDelete;
import org.basex.query.func.ws.WsEmit;
import org.basex.query.func.ws.WsEval;
import org.basex.query.func.ws.WsGet;
import org.basex.query.func.ws.WsId;
import org.basex.query.func.ws.WsIds;
import org.basex.query.func.ws.WsPath;
import org.basex.query.func.ws.WsSend;
import org.basex.query.func.ws.WsSet;
import org.basex.query.util.Flag;
import org.basex.query.value.type.SeqType;

public enum ApiFunction implements AFunction
{
    _REQUEST_ADDRESS(RequestAddress::new, "address()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_ATTRIBUTE(RequestAttribute::new, "attribute(name[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.ITEM_ZM, QueryText.REQUEST_URI),
    _REQUEST_ATTRIBUTE_MAP(RequestAttributeMap::new, "attribute-map()", ApiFunction.params(new SeqType[0]), SeqType.MAP_O, QueryText.REQUEST_URI),
    _REQUEST_ATTRIBUTE_NAMES(RequestAttributeNames::new, "attribute-names()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.REQUEST_URI),
    _REQUEST_CONTEXT_PATH(RequestContextPath::new, "context-path()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_COOKIE(RequestCookie::new, "cookie(name[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O), SeqType.STRING_ZO, QueryText.REQUEST_URI),
    _REQUEST_COOKIE_MAP(RequestCookieMap::new, "cookie-map()", ApiFunction.params(new SeqType[0]), SeqType.MAP_O, QueryText.REQUEST_URI),
    _REQUEST_COOKIE_NAMES(RequestCookieNames::new, "cookie-names()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.REQUEST_URI),
    _REQUEST_HEADER(RequestHeader::new, "header(name[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O), SeqType.STRING_ZO, QueryText.REQUEST_URI),
    _REQUEST_HEADER_MAP(RequestHeaderMap::new, "header-map()", ApiFunction.params(new SeqType[0]), SeqType.MAP_O, QueryText.REQUEST_URI),
    _REQUEST_HEADER_NAMES(RequestHeaderNames::new, "header-names()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.REQUEST_URI),
    _REQUEST_HOSTNAME(RequestHostname::new, "hostname()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_METHOD(RequestMethod::new, "method()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_PARAMETER(RequestParameter::new, "parameter(name[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.ITEM_ZM, QueryText.REQUEST_URI),
    _REQUEST_PARAMETER_MAP(RequestParameterMap::new, "parameter-map()", ApiFunction.params(new SeqType[0]), SeqType.MAP_O, QueryText.REQUEST_URI),
    _REQUEST_PARAMETER_NAMES(RequestParameterNames::new, "parameter-names()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.REQUEST_URI),
    _REQUEST_PATH(RequestPath::new, "path()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_PORT(RequestPort::new, "port()", ApiFunction.params(new SeqType[0]), SeqType.INTEGER_O, QueryText.REQUEST_URI),
    _REQUEST_QUERY(RequestQuery::new, "query()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZO, QueryText.REQUEST_URI),
    _REQUEST_REMOTE_ADDRESS(RequestRemoteAddress::new, "remote-address()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_REMOTE_HOSTNAME(RequestRemoteHostname::new, "remote-hostname()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_REMOTE_PORT(RequestRemotePort::new, "remote-port()", ApiFunction.params(new SeqType[0]), SeqType.INTEGER_O, QueryText.REQUEST_URI),
    _REQUEST_SCHEME(RequestScheme::new, "scheme()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.REQUEST_URI),
    _REQUEST_SET_ATTRIBUTE(RequestSetAttribute::new, "set-attribute(name,value)", ApiFunction.params(SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.EMPTY_SEQUENCE_Z, QueryText.REQUEST_URI, Perm.ADMIN),
    _REQUEST_URI(RequestUri::new, "uri()", ApiFunction.params(new SeqType[0]), SeqType.ANY_URI_O, QueryText.REQUEST_URI),
    _RESTXQ_BASE_URI(RestBaseUri::new, "base-uri()", ApiFunction.params(new SeqType[0]), SeqType.ANY_URI_O, QueryText.REST_URI),
    _RESTXQ_INIT(RestInit::new, "init([update])", ApiFunction.params(SeqType.BOOLEAN_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.REST_URI),
    _RESTXQ_URI(RestUri::new, "uri()", ApiFunction.params(new SeqType[0]), SeqType.ANY_URI_O, QueryText.REST_URI),
    _RESTXQ_WADL(RestWadl::new, "wadl()", ApiFunction.params(new SeqType[0]), SeqType.ELEMENT_O, QueryText.REST_URI),
    _SESSION_ACCESSED(SessionAccessed::new, "accessed()", ApiFunction.params(new SeqType[0]), SeqType.DATE_TIME_O, QueryText.SESSION_URI),
    _SESSION_CLIENT_ID(SessionClientId::new, "client-id()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZO, QueryText.SESSION_URI),
    _SESSION_CLOSE(SessionClose::new, "close()", ApiFunction.params(new SeqType[0]), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSION_URI),
    _SESSION_CREATED(SessionCreated::new, "created()", ApiFunction.params(new SeqType[0]), SeqType.DATE_TIME_O, QueryText.SESSION_URI),
    _SESSION_DELETE(SessionDelete::new, "delete(key)", ApiFunction.params(SeqType.STRING_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSION_URI),
    _SESSION_GET(SessionGet::new, "get(key[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.ITEM_ZM, QueryText.SESSION_URI),
    _SESSION_ID(SessionId::new, "id()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.SESSION_URI),
    _SESSION_NAMES(SessionNames::new, "names()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.SESSION_URI),
    _SESSION_SET(SessionSet::new, "set(key,value)", ApiFunction.params(SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSION_URI),
    _SESSIONS_ACCESSED(SessionsAccessed::new, "accessed(id)", ApiFunction.params(SeqType.STRING_O), SeqType.DATE_TIME_O, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_CLOSE(SessionsClose::new, "close(id)", ApiFunction.params(SeqType.STRING_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_CREATED(SessionsCreated::new, "created(id)", ApiFunction.params(SeqType.STRING_O), SeqType.DATE_TIME_O, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_DELETE(SessionsDelete::new, "delete(id,key)", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_GET(SessionsGet::new, "get(id,key[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.ITEM_ZM, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_IDS(SessionsIds::new, "ids()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_NAMES(SessionsNames::new, "names(id)", ApiFunction.params(SeqType.STRING_O), SeqType.STRING_ZM, QueryText.SESSIONS_URI, Perm.ADMIN),
    _SESSIONS_SET(SessionsSet::new, "set(id,key,value)", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.EMPTY_SEQUENCE_Z, QueryText.SESSIONS_URI, Perm.ADMIN),
    _WS_BROADCAST(WsBroadcast::new, "broadcast(message)", ApiFunction.params(SeqType.ITEM_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI),
    _WS_CLOSE(WsClose::new, "close(id)", ApiFunction.params(SeqType.STRING_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI),
    _WS_DELETE(WsDelete::new, "delete(id,key)", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI),
    _WS_EMIT(WsEmit::new, "emit(message)", ApiFunction.params(SeqType.ITEM_O), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI),
    _WS_EVAL(WsEval::new, "eval(string[,bindings,options])", ApiFunction.params(SeqType.STRING_O, SeqType.MAP_ZO, SeqType.MAP_ZO), SeqType.STRING_O, QueryText.WS_URI),
    _WS_GET(WsGet::new, "get(id,key[,default])", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.ITEM_ZM, QueryText.WS_URI),
    _WS_ID(WsId::new, "id()", ApiFunction.params(new SeqType[0]), SeqType.STRING_O, QueryText.WS_URI),
    _WS_IDS(WsIds::new, "ids()", ApiFunction.params(new SeqType[0]), SeqType.STRING_ZM, QueryText.WS_URI),
    _WS_PATH(WsPath::new, "path(id)", ApiFunction.params(SeqType.STRING_O), SeqType.STRING_O, QueryText.WS_URI),
    _WS_SEND(WsSend::new, "send(message[,ids])", ApiFunction.params(SeqType.ITEM_O, SeqType.STRING_ZM), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI),
    _WS_SET(WsSet::new, "set(id,key,value)", ApiFunction.params(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_ZM), SeqType.EMPTY_SEQUENCE_Z, QueryText.WS_URI);

    private final FuncDefinition definition;

    private ApiFunction(Supplier<? extends StandardFunc> supplier, String desc, SeqType[] params, SeqType seqType, byte[] uri) {
        this(supplier, desc, params, seqType, uri, Perm.NONE);
    }

    private ApiFunction(Supplier<? extends StandardFunc> supplier, String desc, SeqType[] params, SeqType seqType, byte[] uri, Perm perm) {
        this.definition = new FuncDefinition(supplier, desc, params, seqType, ApiFunction.flag(Flag.NDT), uri, perm);
    }

    public FuncDefinition definition() {
        return this.definition;
    }

    private static SeqType[] params(SeqType ... params) {
        return params;
    }

    private static EnumSet<Flag> flag(Flag ... flags) {
        EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
        Collections.addAll(set, flags);
        return set;
    }

    public static void init(ArrayList<FuncDefinition> list) {
        for (ApiFunction function : ApiFunction.values()) {
            list.add(function.definition);
        }
    }

    public final String toString() {
        return this.definition.toString();
    }
}

