/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.ArrayDeque;
import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;

public final class ArrayFlatten
extends ArrayFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final ArrayDeque<Iter> stack = new ArrayDeque<Iter>();
        stack.push(this.arg(0).iter(qc));
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                while (!stack.isEmpty()) {
                    Item next = ((Iter)stack.peek()).next();
                    if (next == null) {
                        stack.pop();
                        continue;
                    }
                    if (next instanceof XQArray) {
                        XQArray array = (XQArray)next;
                        final Iterator<Value> values = array.iterable().iterator();
                        stack.push(new Iter(){
                            private Iter iter = Empty.ITER;

                            @Override
                            public Item next() throws QueryException {
                                Item item;
                                while ((item = this.iter.next()) == null) {
                                    if (!values.hasNext()) {
                                        return null;
                                    }
                                    Value value = (Value)values.next();
                                    if (value.size() == 1L) {
                                        this.iter = Empty.ITER;
                                        return (Item)value;
                                    }
                                    this.iter = value.iter();
                                }
                                return item;
                            }
                        });
                        continue;
                    }
                    return next;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        ArrayFlatten.add(vb, this.arg(0), qc);
        return vb.value(this);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (!st.mayBeArray()) {
            return input;
        }
        this.exprType.assign(ArrayFlatten.type(st.type));
        return this;
    }

    private static Type type(Type type) {
        Type type2;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            type2 = ArrayFlatten.type(at.valueType().type);
        } else {
            type2 = type;
        }
        return type2;
    }

    private static void add(ValueBuilder vb, Expr expr, QueryContext qc) throws QueryException {
        Item item;
        Iter iter = expr.iter(qc);
        while ((item = qc.next(iter)) != null) {
            if (item instanceof XQArray) {
                XQArray array = (XQArray)item;
                for (Value value : array.iterable()) {
                    ArrayFlatten.add(vb, value, qc);
                }
                continue;
            }
            vb.add(item);
        }
    }
}

