/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class ArchiveExtractTo
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        block29: {
            Path path = this.toPath(this.arg(0), qc);
            HashSet<String> entries = this.toEntries(this.arg(2), qc);
            try {
                Object archive = this.toInput(this.arg(1), qc, entries != null);
                if (archive instanceof Bin) {
                    Bin bin = (Bin)archive;
                    try (BufferInput bi = bin.input(this.info);
                         ArchiveIn in = ArchiveIn.get(bi, this.info);){
                        while (in.more() && (entries == null || !entries.isEmpty())) {
                            ZipEntry ze = in.entry();
                            String name = ze.getName();
                            if (entries != null && !entries.remove(name)) continue;
                            Path file = path.resolve(name);
                            if (ze.isDirectory()) {
                                Files.createDirectories(file, new FileAttribute[0]);
                                continue;
                            }
                            Files.createDirectories(file.getParent(), new FileAttribute[0]);
                            try (BufferOutput out = new BufferOutput(new IOFile(file));){
                                in.write(out);
                            }
                        }
                        break block29;
                    }
                }
                try (ZipFile zip = new ZipFile(archive.toString());){
                    for (String entry : entries) {
                        ZipEntry ze = zip.getEntry(entry);
                        if (ze == null) continue;
                        Path file = path.resolve(ze.getName());
                        if (ze.isDirectory()) {
                            Files.createDirectories(file, new FileAttribute[0]);
                            continue;
                        }
                        Files.createDirectories(file.getParent(), new FileAttribute[0]);
                        IO.write(zip.getInputStream(ze), new IOFile(file).outputStream());
                    }
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
        return Empty.VALUE;
    }
}

