module Probability.Distribution.Binomial where

import Probability.Random
import Control.Monad.IO.Class
import MCMC

foreign import bpcall "Distribution:binomial_density" binomial_density :: Int -> Double -> Int -> LogDouble
foreign import bpcall "Distribution:sample_binomial" builtin_sample_binomial :: Int -> Double -> RealWorld -> Int
sample_binomial n p = makeIO $ builtin_sample_binomial n p

data Binomial = Binomial Int Prob

instance Dist Binomial where
    type Result Binomial = Int
    dist_name _ = "binomial"

instance IOSampleable Binomial where
    sampleIO (Binomial n p) = sample_binomial n (toFloating p)

instance HasPdf Binomial where
    pdf (Binomial n p) x = binomial_density n (toFloating p) x

instance Dist1D Binomial where
    cdf (Binomial n p) x  = undefined

instance MaybeMean Binomial where
    maybeMean (Binomial n p) = Just $ fromIntegral n * (toFloating p)

instance Mean Binomial

instance MaybeVariance Binomial where
    maybeVariance (Binomial n p) = Just $ toFloating $ fromIntegral n * p * (1-p)

instance Variance Binomial

instance HasAnnotatedPdf Binomial where
    annotated_densities dist x = return [ pdf dist x ]

instance Sampleable Binomial where
    sample dist@(Binomial n _) = RanDistribution2 dist (binomial_effect n)

binomial :: Int -> Double -> Binomial
binomial n p = Binomial n (toFloating p)

binomial_bounds n = integer_between 0 n

binomial_effect n x = do
  add_move $ slice_sample_integer_random_variable x (binomial_bounds n)
  add_move $ inc_dec_mh x (binomial_bounds n)
