/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include "message.h"
#include "fileobj.h"
#include "settings.h"
#include "log.h"

SMessageManager MessageManager;

int
SMessageManager::initialize (void)
{
	File::Reader reader;
	File::Node node;

	Log::Info << "Loading messages";

	// open messages file
	if (reader.open(settings::get_path("misc", "data") + "/messages"))
		return -1;

	// read said file
	FO_READ_BEGIN
		FO_ATTR
			messages[node.get_name()] = node.get_data();
	FO_READ_ERROR
		// damnable errors!
		return -1;
	FO_READ_END

	// all good
	return 0;
}

void
SMessageManager::shutdown (void)
{
	messages.clear();
}

String
SMessageManager::get (StringArg id)
{
	MessageMap::iterator i = messages.find(id);
	return i != messages.end() ? i->second : String();
}
