/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#include "attribute.h"
#include "log.h"

using namespace std;

bool
AttributeHolder::get_int (StringArg name, int& value) const
{
	// find it
	AttributeMap::const_iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		// check type
		const Attribute& attr = (*iter).second;
		if (attr.type == Attribute::INT) {
			value = attr.ival;
			return true;
		}
	}
	
	// not find it
	return false;
}

bool
AttributeHolder::get_string (StringArg name, String& value) const
{
	// find it
	AttributeMap::const_iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		// check type
		const Attribute& attr = (*iter).second;
		if (attr.type == Attribute::STRING) {
			value = attr.sval;
			return true;
		}
	}
	
	// not find it
	return false;
}

bool
AttributeHolder::get_attr (StringArg name, Attribute& value) const
{
	// find it
	AttributeMap::const_iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		value = (*iter).second;
		return true;
	}
	
	// not find it
	return false;
}

void
AttributeHolder::set_int (StringArg name, int value)
{
	// find it
	AttributeMap::iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		// assign
		Attribute& attr = (*iter).second;
		attr = value;
		return;
	}

	// add it
	Attribute attr;
	attr = value;
	attrs.insert(pair<String,Attribute>(name, attr));
}

void
AttributeHolder::set_string (StringArg name, StringArg value)
{
	// find it
	AttributeMap::iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		// assign
		Attribute& attr = (*iter).second;
		attr = value;
		return;
	}

	// add it
	Attribute attr;
	attr = value;
	attrs.insert(pair<String,Attribute>(name, attr));
}
   
void 
AttributeHolder::remove_attr(StringArg name)
{
	// find it 
	AttributeMap::iterator iter = attrs.find(name);
	if (iter != attrs.end()) {
		// and remove 
	    attrs.erase(iter);
	    return;
	}
}

void
AttributeHolder::save (File::Writer& writer) const
{
	for(AttributeMap::const_iterator iter = attrs.begin(); iter != attrs.end(); ++iter) {
		if ((*iter).second.type == Attribute::INT)
			writer.attr("int", (*iter).first, (*iter).second.ival);
		else
			writer.attr("string", (*iter).first, (*iter).second.sval);
	}
}
