/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef SERVER_H
#define SERVER_H

#include <time.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "awestr.h"
#include "log.h"
#include "network.h"

#define SERV_PID_FILE "awemud.pid"
#define SERV_PORT 4545
#define SERV_XMLRPC_PORT 4547

#define TICKS_PER_SEC 5
#define MSECS_PER_TICK (1000 / TICKS_PER_SEC)

// all *Manager classes should derive from this...
class IManager
{
	public:
	inline virtual ~IManager (void) {}

	// methods to implement in children
	virtual int initialize (void) = 0;
	virtual void shutdown (void) = 0;
};

class Server
{
	public:
	Server (void);

	// tcp connections
	TCPServer tcp_players;
	UNIXServer ctrl_users;

	// managers
	int require (IManager& manager);

	// misc functions
	int init (int argc, char** argv);
	int run (void);
	int finish (void);
	void shutdown (void);
	void reboot (void);
	void save (void) const;
	void update (void);

	// lofs
	void log_msg (int, const char *text);
	void log_reset (void);

	// time
	time_t get_start_time (void) const { return start_time; }
	unsigned long get_ticks (void) const { return game_ticks; }

	// current hostname
	StringArg get_host(void) const { return host; }

	private:
	// log file
	LogFile *log;

	// time
	struct timeval last_time;
	unsigned long int game_ticks;		// the total number of games ticks that have been processed
	time_t start_time;

	// our host name
	String host;
	// socket manager
	SocketManager sockets;

	// are we running still?
	bool running;
	
	// managers; store order we're initialized in
	std::vector<IManager*> managers;
};

extern Server server;

#endif
