/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef RACE_H
#define RACE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <vector>
#include <algorithm>

#include "awestr.h"
#include "scripts.h"
#include "fileobj.h"
#include "char.h"
#include "pdesc.h"
#include "server.h"

/* store information about a race */
class
Race : public Scriptable
{
	public:
	// this is an ugly hack, but it lets us construct the linked
	// list as we need to do
	Race (StringArg s_name, Race *s_next) : Scriptable(AweMUD_PlayerRaceType), name(s_name.c_str()) { next = s_next; }

	int load (File::Reader&);

	int get_rand_age (void) const;
	int get_life_span (void) const { return life_span; }
	int get_stat (int i) const { if (i >= 0 && i < CharStatID::COUNT) return stats[i] ; else return 0; }

	StringArg get_name (void) const { return name; }
	StringArg get_adj (void) const { return adj; }
	StringArg get_body (void) const { return body; }
	StringArg get_about (void) const { return about; }
	StringArg get_desc (void) const { return desc; }

	bool has_eye_color (ColorType color) const { return find(eye_colors.begin(), eye_colors.end(), color) != eye_colors.end(); }
	bool has_hair_color (ColorType color) const { return find(hair_colors.begin(), hair_colors.end(), color) != hair_colors.end(); }
	bool has_skin_color (ColorType color) const { return find(skin_colors.begin(), skin_colors.end(), color) != skin_colors.end(); }
	const std::vector<ColorType>& get_eye_colors (void) const { return eye_colors; }
	const std::vector<ColorType>& get_hair_colors (void) const { return hair_colors; }
	const std::vector<ColorType>& get_skin_colors (void) const { return skin_colors; }
	StringArg get_skin_type (void) const { return skin_type; }

	Race *get_next (void) const { return next; }

	// ---- data ----
	protected:
	String name;
	String adj;
	String body;
	String about;
	String desc;
	String skin_type;

	std::vector<ColorType> eye_colors;
	std::vector<ColorType> hair_colors;
	std::vector<ColorType> skin_colors;

	int age_min, age_max, life_span;

	int stats[CharStatID::COUNT];

	Race* next;

	SX_TYPEDEF
};

class SRaceManager : public IManager
{
	public:
	inline SRaceManager (void) : head(NULL) {}

	int initialize (void);

	void shutdown (void);

	Race *get (StringArg name);

	inline Race *first (void) { return head; }

	private:
	Race* head;
};
extern SRaceManager RaceManager;

#endif
