/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef PDESC_H
#define PDESC_H

#include "awestr.h"

// Player colors (eye, hair, fur, skin, etc.)
class ColorType {
	public:
	ColorType (uint s_value) : value(s_value) {}
	ColorType (void) : value(0) {}

	inline String get_name(void) const { return value ? names[value - 1] : String(); }

	inline uint get_value (void) const { return value; }

	static ColorType lookup (StringArg name);

	inline bool valid (void) const { return value != 0; }

	inline operator bool (void) const { return valid(); }
	inline bool operator == (const ColorType& dir) const { return dir.value == value; }
	inline bool operator != (const ColorType& dir) const { return dir.value != value; }

	private:
	uint value;

	static StringList names;
};

// Player hair styles
class HairStyleType {
	public:
	typedef enum {
		SHAVED = 0,
		LONG,
		SHORT,
		FLOWING,
		BUN,
		PONYTAIL,
		CURLED,
		SPIKED,
		COUNT
	} type_t;
	
	public:
	HairStyleType (int s_value) : value((type_t)s_value) {}
	HairStyleType (void) : value(SHAVED) {}

	StringArg get_name(void) const { return names[value]; }
	StringArg get_desc(void) const { return descs[value]; }

	type_t get_value (void) const { return value; }

	static HairStyleType lookup (StringArg name);

	inline bool operator == (const HairStyleType& dir) const { return dir.value == value; }
	inline bool operator != (const HairStyleType& dir) const { return dir.value != value; }

	private:
	type_t value;

	static String names[];
	static String descs[];
};

// Player body/frame styles
class BodyBuildType {
	public:
	typedef enum {
		LEAN = 0,
		SLIM,
		BROAD,
		STOCKY,
		LARGE,
		HUNCHED,
		COUNT
	} type_t;
	
	public:
	BodyBuildType (int s_value) : value((type_t)s_value) {}
	BodyBuildType (void) : value(LEAN) {}

	StringArg get_name(void) const { return names[value]; }

	type_t get_value (void) const { return value; }

	static BodyBuildType lookup (StringArg name);

	inline bool operator == (const BodyBuildType& dir) const { return dir.value == value; }
	inline bool operator != (const BodyBuildType& dir) const { return dir.value != value; }

	private:
	type_t value;

	static String names[];
};

#endif
