/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef __LOG_H__
#define __LOG_H__

#define LOG_NONE 0
#define LOG_CRITICAL 1
#define LOG_ERROR 2
#define LOG_NOTICE 3
#define LOG_MINOR 4
#define LOG_DEBUG 5

#include <stdio.h>

#include "awestr.h"
#include "error.h"
#include "streams.h"

class
LogFile
{
	protected:
	String file;
	FILE *f;

	public:
	LogFile (StringArg);
	LogFile (FILE *, StringArg);
	~LogFile (void);

	void print (int, StringArg);

	void reset (void);

	StringArg get_file (void) const { return file; }
};

void message (char const *, ...);
void message (int, char const *, ...);

// C++ logging
namespace Log
{
	// wrap message(), error(), warning() - ICKY!!!!
	struct LogWrapper : public IStreamSink
	{
		int level;
		String pre, msg;

		LogWrapper (StringArg s_pre, int s_level) : level(s_level), pre(s_pre), msg() {}

		virtual void stream_put (const char* str, size_t len) { msg.append(str, len); }
		virtual bool stream_end (void);
	};

	// the output
	extern LogWrapper Error;
	extern LogWrapper Warning;
	extern LogWrapper Info;
}

#endif
