/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef HELP_H
#define HELP_H

struct HelpTopic {
	String name;
	String about;
};

struct HelpCategory {
	String name;
	String about;
	bool list_topics;
	std::vector<HelpTopic*> topics;
};

class SHelpManager : public IManager
{
	public:
	// startup the manager
	virtual int initialize (void);

	// close the manager
	virtual void shutdown (void);

	// print out help to a player (FIXME: should be a stream)
	void print (class Player*, StringArg section);

	// get a category
	HelpCategory* get_category (StringArg name);

	// get a topic; category is optional, its use limits
	// the topic search to topics in the given category
	HelpTopic* get_topic (StringArg name, HelpCategory* category = NULL);

	private:
	typedef std::vector<HelpTopic*> TopicList;
	TopicList topics;
	typedef std::vector<HelpCategory*> CategoryList;
	CategoryList categories;
};
extern SHelpManager HelpManager;

#endif
