/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef GCBASE_H
#define GCBASE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gc/gc.h>
#include <gc/gc_cpp.h>

/* fix for this file being broken... */
#ifndef AWESOMEPLAY_GC_ALLOCATOR_H
#define AWESOMEPLAY_GC_ALLOCATOR_H
#include <gc/gc_allocator.h>
#endif

#include <map>
#include <list>
#include <typeinfo>
#include <vector>

/* Provide a base class for GC objects.  Very similar to the GC's normal
 * gc_cleanup class, except it uses the no_order variant of the finalizer
 * registration; this allows us to have destructors even when we've cyclic
 * links of objects.  Destructors should never use pointers to GC'd data,
 * only free non-GC'd resources, like strings and file handles.
 */

/* Also provide some GC-friendly wrappers for std::vector, std::map, and
 * std::list.
 */

namespace GCType
{
	/* if the object should be collectable, use this */
	class Collectable : virtual public ::gc
	{
		public:
		Collectable (void);
		inline virtual ~Collectable (void) {}
		private:
		static void cleanup(void* obj, void* data);
	};

	/* if the object is simple (NO *IMPLICIT OR EXPLICIT* DESTRUCTOR USED) */
	typedef ::gc Simple;

	// GC traced version of std::map
	template <typename K, typename T>
	struct map : public std::map<K, T, std::less<K>, traceable_allocator<std::pair<K, T> > > { };

	// GC traced version of std::list
	template <typename T>
	struct list : public std::list<T, traceable_allocator<T> > { };

	// GC traced version of std::vector
	template <typename T>
	struct vector : public std::vector<T, traceable_allocator<T> >
	{
		public:
		vector(void) : std::vector<T, traceable_allocator<T> >() {}
		vector(size_t n) : std::vector<T, traceable_allocator<T> >(n) {}
	};
}

#endif
