/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef TIME_H
#define TIME_H

#include <vector>

#include "types.h"
#include "awestr.h"
#include "fileobj.h"
#include "server.h"

#define TICKS_PER_HOUR 900

#define SUN_UP_HOUR 6
#define SUN_DOWN_HOUR 19

class
GameCalendar
{
	public:
	struct Month
	{
		String name;
		uint16 day_count;
		uint8 leap_years;	// each leap_years year, month has extra day

		Month (void) : name(), day_count(0), leap_years(0) {}
	};
	struct Holiday
	{
		String name;
		int year; // year count it occurs (every year, every three years, etc.)
		int day; // day of months it occurs
		int weekday; // weekday it occurs
		int wdindex; // count of weekday it occurs (first monday, second tuesday, etc.)
		int month; // month it occurs

		Holiday (void) : name(), year(0), day(0), weekday(0), wdindex(0), month(0) {}
	};
	typedef std::vector<Holiday> HolidayList;
	typedef std::vector<Month> MonthList;
	
	MonthList months;
	HolidayList holidays;
	StringList weekdays;
	StringList day_text;
	StringList night_text;
	StringList sunrise_text;
	StringList sunset_text;

	GameCalendar (void) : months(), holidays(), weekdays(), day_text(), night_text(), sunrise_text(), sunset_text() {}

	uint8 get_weekday (const class GameTime &) const;
	uint16 days_in_month (const class GameTime &) const;
	String get_holiday (const class GameTime &) const;

	int find_month (StringArg name);
	int find_weekday (StringArg name);

	int load (void);
};

class
GameTime
{
	private:
	uint year;
	uint16 month;
	uint16 day;
	uint8 hour;
	uint16 ticks_in_hour;

	public:
	GameTime (void) : year(0), month(1), day(1), hour(0), ticks_in_hour(0) {}

	uint get_year(void) const { return year; }
	uint set_year(uint val) { year = val; clip_time(); return year; }
	uint16 get_month(void) const { return month; }
	uint16 set_month(uint16 val) { month = val; clip_time(); return month; }
	uint16 get_day(void) const { return day; }
	uint16 set_day(uint16 val) { day = val; clip_time(); return day; }
	uint8 get_hour(void) const { return hour; }
	uint8 set_hour(uint8 val) { hour = val; clip_time(); return hour; }
	uint16 get_ticks(void) const { return ticks_in_hour; }
	uint16 set_ticks(uint16 val) { ticks_in_hour = val; clip_time(); return ticks_in_hour; }
	uint8 get_minutes(void) const { return ticks_in_hour * 60 / TICKS_PER_HOUR; }

	void time_str (char *buf, int len) const;
	void date_str (char *buf, int len) const;
	String time_str (void) const;
	String date_str (void) const;

	bool is_day (void) const { return hour >= SUN_UP_HOUR && hour < SUN_DOWN_HOUR; }
	bool is_night (void) const { return !is_day (); }

	void update (uint);
	void clip_time (void);

	int load (File::Reader& reader);
	void save (File::Writer& writer) const;
};

class STimeManager : public IManager
{
	public:
	virtual int initialize (void);
	virtual void shutdown (void);

	int save (void);

	GameCalendar calendar;
	GameTime time;
};
extern STimeManager TimeManager;

#endif
