/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef EVENT_H 
#define EVENT_H

#include "fileobj.h"
#include "scripts.h"
#include "attribute.h"
#include "rdqueue.h"

/* external classes */
class Entity;
class Room;

// ID class
class EventID {
	public:
	inline EventID (size_t s_id) : id(s_id) {}
	inline EventID (void) : id(0) {}

	static EventID lookup (StringArg name);

	String get_name (void) const;

	inline bool valid (void) const { return id > 0 && id <= registry.size(); }

	inline EventID operator= (EventID s_id) { id = s_id.id; return *this; }
	inline friend bool operator < (EventID id1, EventID id2) { return id1.id < id2.id; }
	inline friend bool operator == (EventID id1, EventID id2) { return id1.id == id2.id; }
	inline friend bool operator != (EventID id1, EventID id2) { return id1.id != id2.id; }

	private:
	size_t id;

	static StringList registry;
};

class EventHandler : public Scriptable {
	SX_TYPEDEF

	protected:
	EventID event;
	String script;
	Scriptix::Function* sxfunc;

	public:
	EventHandler (void) : Scriptable(AweMUD_EventType), event(0), script(), sxfunc(NULL) {}
	EventHandler (EventID s_event) : Scriptable(AweMUD_EventType), event(s_event), script(), sxfunc(NULL) {}
	~EventHandler (void) {}

	int load (File::Reader& reader);
	void save (File::Writer& writer) const;

	EventID get_event (void) const { return event; }
	Scriptix::Function* get_func (void) const { return sxfunc; }
};

class Event : public Scriptable, public AttributeHolder
{
	SX_TYPEDEF

	private:
	EventID id;
	Room* room; // room the event occured in
	Entity* actor; // who/what initiated the event
	Entity* target; // the recipient/target of the action
	Scriptix::Value* data; // misc data

	public:
	Event (EventID s_id, Room* s_room, Entity* s_actor, Entity* s_target = NULL, Scriptix::Value* s_data = NULL);

	EventID get_id (void) const { return id; }
	String get_name (void) const { return id.get_name(); }
	
	Room* get_room (void) const { return room; }
	Entity* get_actor (void) const { return actor; }
	Entity* get_target (void) const { return target; }
	Scriptix::Value* get_data (void) const { return data; }
};

class SEventManager : public IManager
{
	public:
	// initialize manager
	virtual int initialize (void);

	// shutdown the manager
	virtual void shutdown (void);

	// send a quickie event
	int send (EventID id, class Room* room, class Entity* actor, class Entity* target, Scriptix::Value* data = NULL);

	// send a full event
	int send (Event* event);

	// process events
	void process (void);

	private:
	size_t count;
	typedef RDQueue<Event, 64> EQueue;
	EQueue events;
};
extern SEventManager EventManager;

#endif
