/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef CONTROL_H
#define CONTROL_H

#include "network.h"
#include "server.h"
#include "streams.h"

#define CONTROL_BUFFER_SIZE 1024

// a control user
class ControlUser : public IStreamSink
{
	public:
	ControlUser (Socket& s_socket);
	inline ~ControlUser (void) { sock.close(); }

	// process
	void process (void);

	// output strings
	virtual void stream_put (const char* str, size_t len) { if (sock.alive()) sock.send(str, len); } 

	// network control
	inline bool net_alive (void) const { return sock.alive(); }
	inline bool net_inready (void) const { return sock.in_ready(); }
	inline bool net_hungup (void) const { return sock.hung_up(); }
	inline void net_disconnect (void) { sock.close(); }

	private:
	Socket sock;
	char buffer[CONTROL_BUFFER_SIZE];

	// handle command
	void handle (int argc, char** argv);

	friend class SControlManager;
};

// manage control users
class SControlManager : public IManager
{
	public:
	// initialize the control manager
	virtual int initialize (void);

	// shutdown the control manager
	virtual void shutdown (void);

	// count of connected controls
	inline size_t count (void) { return control_list.size(); }

	// add
	void add (ControlUser* cuser);

	// input processing of all controls
	void process (void);

	private:
	// list of *connected* controls
	std::vector<ControlUser*> control_list;

	// yuck - let Control class manage their own membership
	friend class Control;
};
extern SControlManager ControlManager;

#endif
