/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef CONTAINER_H
#define CONTAINER_H

#include "awestr.h"

// Container type object
class ContainerType {
	public:
	typedef enum {
		NONE = 0,
		IN,
		ON,
		UNDER,
		BEHIND,
		COUNT
	} type_t;
	
	public:
	ContainerType (int s_value) : value((type_t)s_value) {}
	ContainerType (void) : value(NONE) {}

	bool valid (void) const { return value != NONE; }

	StringArg get_name(void) const { return names[value]; }

	type_t get_value (void) const { return value; }

	static ContainerType lookup (StringArg name);

	inline bool operator == (const ContainerType& dir) const { return dir.value == value; }
	inline bool operator != (const ContainerType& dir) const { return dir.value != value; }

	private:
	type_t value;

	static String names[];
};

#endif
