/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef BODY_H
#define BODY_H

#include <vector>

#include "awestr.h"
#include "fileobj.h"

// Gender
class GenderType {
	public:
	typedef enum {
		NONE = 0,
		FEMALE,
		MALE,
		COUNT
	} type_t;
	
	public:
	inline GenderType (int s_value) : value((type_t)s_value) {}
	inline GenderType (void) : value(NONE) {}

	inline StringArg get_name(void) const { return names[value]; }

	inline StringArg get_hisher (void) const { return hisher[value]; }
	inline StringArg get_hishers (void) const { return hishers[value]; }
	inline StringArg get_heshe (void) const { return heshe[value]; }
	inline StringArg get_himher (void) const { return himher[value]; }
	inline StringArg get_manwoman (void) const { return manwoman[value]; }
	inline StringArg get_malefemale (void) const { return malefemale[value]; }

	inline type_t get_value (void) const { return value; }

	static GenderType lookup (StringArg name);

	inline bool operator == (const GenderType& gender) const { return gender.value == value; }
	inline bool operator != (const GenderType& gender) const { return gender.value != value; }

	private:
	type_t value;

	static String names[];
	static String hisher[];
	static String hishers[];
	static String heshe[];
	static String himher[];
	static String manwoman[];
	static String malefemale[];
};

// Body parts
class BodyPartType {
	public:
	typedef enum {
		NONE = 0,
		HEAD,
		TORSO,
		ARMS,
		LEGS,
		HANDS,
		FEET,
		NECK,
		BODY,
		BACK,
		WAIST,
		COUNT
	} type_t;
	
	public:
	BodyPartType (int s_value) : value((type_t)s_value) {}
	BodyPartType (void) : value(NONE) {}

	bool valid (void) const { return value != NONE; }

	StringArg get_name(void) const { return names[value]; }

	type_t get_value (void) const { return value; }

	static BodyPartType lookup (StringArg name);

	inline bool operator == (const BodyPartType& dir) const { return dir.value == value; }
	inline bool operator != (const BodyPartType& dir) const { return dir.value != value; }

	private:
	type_t value;

	static String names[];
};

// Specific Body Part IDs
class BodyLocation {
	public:
	typedef enum {
		NONE = 0,
		HEAD,
		TORSO,
		LEFT_ARM,
		RIGHT_ARM,
		LEFT_LEG,
		RIGHT_LEG,
		LEFT_HAND, // holding
		RIGHT_HAND, // holding
		HANDS, // gloves, etc.
		FEET,
		NECK,
		BACK,
		WAIST,
		COUNT
	} type_t;
	
	public:
	BodyLocation (int s_value) : value((type_t)s_value) {}
	BodyLocation (void) : value(NONE) {}

	bool valid (void) const { return value != NONE; }

	StringArg get_name(void) const { return names[value]; }

	type_t get_value (void) const { return value; }

	static BodyLocation lookup (StringArg name);

	inline bool operator == (const BodyLocation& dir) const { return dir.value == value; }
	inline bool operator != (const BodyLocation& dir) const { return dir.value != value; }

	private:
	type_t value;

	static String names[];
};

#endif
