/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef ATTRIBUTE_H
#define ATTRIBUTE_H

#include <map>

#include "awestr.h"
#include "fileobj.h"

struct Attribute {
	enum { INT, STRING } type;
	int ival;
	String sval;

	int operator = (int i) { sval.clear(); ival = i; type = INT; return ival; }
	StringArg operator = (StringArg str) { ival = 0; sval = str; type = STRING; return sval; }
};

class AttributeHolder {
	public:
	bool get_int (StringArg name, int& value) const;
	int get_int (StringArg name) const {
		int ret = 0;
		get_int(name, ret);
		return ret;
	}
	bool get_string (StringArg name, String& value) const;
	String get_string (StringArg name) const {
		String ret;
		get_string(name, ret);
		return ret;
	}
	bool get_attr (StringArg name, Attribute& attr) const;
	void remove_attr(StringArg name);

	void set_int (StringArg name, int value);
	void set_string (StringArg name, StringArg value);

	void save (File::Writer& writer) const;

	private:
	typedef std::map<String,Attribute> AttributeMap;
	AttributeMap attrs;
};

#endif
