/*
 * AweMUD NG - Next Generation AwesomePlay MUD
 * Copyright (C) 2000-2004  AwesomePlay Productions, Inc.
 * See the file COPYING for license details
 * http://www.awemud.net
 */

#ifndef ACTION_H
#define ACTION_H

#include <list>

#include "attribute.h"
#include "scripts.h"
#include "awestr.h"
#include "fileobj.h"

struct ActionScript
{
	String source;
	Scriptix::Function* func;
};

/* Something that can be done with an Object */
class Action : public Scriptable, public AttributeHolder
{
	public:
	Action() : Scriptable(AweMUD_ActionType), AttributeHolder(), name(), scripts() {}
	Action(StringArg s_name) : Scriptable(AweMUD_ActionType), AttributeHolder(), name(s_name), scripts() {}
	~Action();

	String get_name (void) const { return name; }

	bool check (class Object* self, class Entity* trigger, Scriptix::Value* data = NULL);
	void invoke (StringArg name, class Object* self, class Entity* trigger, Scriptix::Value* data = NULL, Scriptix::Value** retval = NULL);

	void save (File::Writer& writer) const;
	int load (File::Reader& reader);

	private:
	String name;
	typedef GCType::map<String,ActionScript> ScriptMap;
	ScriptMap scripts;

	SX_TYPEDEF
};

#endif
