#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Patch 1.0.1.0 manquant"},
    {TR_NO_PATCH_MESSAGE,
        "Votre installation de Caesar 3 ne contient pas le patch 1.0.1.0. "
        "Vous pouvez le télécharger depuis : \n"
        URL_PATCHES "\n"
        "Procédez à vos risques et périls."},
    {TR_MISSING_FONTS_TITLE, "Polices manquantes"},
    {TR_MISSING_FONTS_MESSAGE,
        "Votre installation de Caesar 3 requiert des polices d'écriture supplémentaires. "
        "Vous pouvez les télécharger pour votre langue depuis : \n"
        URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Éditeur manquant"},
    {TR_NO_EDITOR_MESSAGE,
        "Votre installation de Caesar 3 ne contient pas le fichier éditeur. "
        "Vous pouvez le télécharger depuis : \n"
        URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Répertoire de langue invalide"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Le répertoire que vous avez sélectionné ne contient pas de pack de langue valide. "
        "Veuillez consulter les erreurs dans le fichier de log."},
    {TR_BUILD_ALL_TEMPLES, "Tous"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Annuler"},
    {TR_BUTTON_RESET_DEFAULTS, "Réinitialiser"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Contrôles"},
    {TR_CONFIG_ARE_YOU_SURE, "Réinitialiser les paramètres par défaut ?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Vous perdrez toutes vos personnalisations."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Vous perdrez tous vos raccourcis."},
    {TR_CONFIG_TITLE, "Options de configuration d'Augustus"},
    {TR_CONFIG_HEADER_GENERAL, "Configuration générale"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Configuration de l'interface"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Difficulté"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Gestion de la cité"},
    {TR_CONFIG_LANGUAGE_LABEL, "Langue :"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(par défaut)"},
    {TR_CONFIG_GAME_SPEED, "Vitesse du jeu :"},
    {TR_CONFIG_VIDEO, "Options vidéo"},
    {TR_CONFIG_FULLSCREEN, "Plein écran"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Résolution :"},
    {TR_CONFIG_DISPLAY_SCALE, "Mise à l'échelle de l'affichage :"},
    {TR_CONFIG_CURSOR_SCALE, "Taille du curseur de souris :"},
    {TR_CONFIG_USE_COLOR_CURSORS, "Utiliser des curseurs colorés"},
    {TR_CONFIG_AUDIO, "Options audio"},
    {TR_CONFIG_VOLUME, "Volume"},
    {TR_CONFIG_ENABLE_AUDIO, "Activer l'audio"},
    {TR_CONFIG_MUSIC, "Activer la musique"},
    {TR_CONFIG_SPEECH, "Activer les voix"},
    {TR_CONFIG_EFFECTS, "Activer les effets sonores"},
    {TR_CONFIG_CITY_SOUNDS, "Activer les sons de la cité"},
    {TR_CONFIG_VIDEO_SOUND, "Activer le son des vidéos"},
    {TR_CONFIG_SCROLL_SPEED, "Vitesse de défilement :"},
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Jouer la vidéo d'introduction"},
    {TR_CONFIG_SIDEBAR_INFO, "Afficher des informations supplémentaires dans le panneau latéral"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Activer le défilement doux"},
    {TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Désactiver le défilement de la carte sur le bord de la fenêtre"},
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Désactiver le clic droit pour déplacer la vue de la cité"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Améliore le retour visuel durant le dégagement du terrain"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Permet de construire tous les temples successivement"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Voir la portée en plaçant les réservoirs, fontaines, et puits"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE_HOUSES, "Voir la portée des fontaines et puits en plaçant les maisons"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Voir la taille des constructions durant le glissement de la souris"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Mettre en surbrillance les légions au survol du curseur"},
    {TR_CONFIG_ROTATE_MANUALLY, "Rotation corps de garde et l'arc de triomphe par raccourci clavier"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Activer la barre latérale militaire"},
    {TR_CONFIG_UI_INVERSE_MAP_DRAG, "Inverser le déplacement de la carte avec le clic droit"},    
    {TR_CONFIG_UI_MESSAGE_ALERTS, "Remplacer les messages urgents par des bandeaux d'alerte"},
    {TR_CONFIG_UI_SHOW_GRID, "Afficher la grille complète"},
    {TR_CONFIG_UI_SHOW_PARTIAL_GRID_AROUND_CONSTRUCTION, "Afficher la grille partielle en plaçant un bâtiment"},
    {TR_CONFIG_UI_ALWAYS_SHOW_ROTATION_BUTTONS, "Toujours afficher les boutons de rotation"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Corrige le bug d'immigration en mode très difficile"},
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Corrige le bug des fantômes de 100 ans"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Corrige \"Nouvel Empereur\" et la survie des parties créees avec l'éditeur"},
    {TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Un clic droit sur un bâtiment affiche les points de passage"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Corrige les colonnes d'évaluation incomplètes"},
    {TR_CONFIG_GRANDFESTIVAL, "Les grandes fêtes permettent une bénédiction supplémentaire d'un dieu"},
    {TR_CONFIG_DIFFICULTY, "Difficulté :"},
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Nombre maximum de temples monumentaux par cité :"},
    {TR_CONFIG_INFINITE, "Infini"},
    {TR_CONFIG_GODS_EFFECTS, "Activer les malédictions/bénédictions des dieux"},
    {TR_CONFIG_JEALOUS_GODS, "Désactiver la jalousie des dieux"},
    {TR_CONFIG_GLOBAL_LABOUR, "Activer la main-d'œuvre globale"},
    {TR_CONFIG_SCHOOL_WALKERS, "Augmente la couverture des écoliers"},
    {TR_CONFIG_RETIRE_AT_60, "Changer l'âge de retraite des citoyens de 50 à 60 ans"},
    {TR_CONFIG_FIXED_WORKERS, "Main-d'œuvre fixe - 38 % de la population plébéienne"},
    {TR_CONFIG_EXTRA_FORTS, "Autoriser la construction de 4 forts supplémentaires"},
    {TR_CONFIG_WOLVES_BLOCK, "Bloquer la construction autour des loups"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Bloquer les routes non connectées des greniers"},
    {TR_CONFIG_MORE_STOCKPILE, "Les maisons stockent plus de marchandises du marché"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Les acheteuses du marché ne distribuent pas les marchandises"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Destruction immédiate des bâtiments"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Autoriser les magasiniers des greniers à évoluer hors route"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Doubler la capacité des magasiniers employés par les greniers"},
    {TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Autoriser l'exportation depuis les greniers"},
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Les gardes des tours n'ont pas besoin de route depuis la caserne"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Fermes et quais livrent en priorité les greniers à proximité"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Pas de nourriture livrée aux greniers allant chercher les biens"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Tous les logements de même rang fusionnent"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Ouvrir des routes commerciales fournit différents types de vins"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Les effondrements coûtent de l'argent au lieu de détruire les mines"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Autoriser la construction de plusieurs casernes"},
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Les entrepôts et les greniers n'acceptent rien par défaut"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Les logements ne s'étendent pas sur les jardins"},
    {TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Les marcheurs itinérants ne coupent pas les virages"},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Afficher la prospérité maximale atteignable avec le logement actuel"},
    {TR_CONFIG_AUTO_KILL_ANIMALS, "Les citoyens abattent automatiquement les animaux inoffensifs"},
    {TR_HOTKEY_TITLE, "Configuration raccourcis clavier"},
    {TR_HOTKEY_LABEL, "Touche"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternative"},
    {TR_HOTKEY_HEADER_ARROWS, "Flèches directionnelles"},
    {TR_HOTKEY_HEADER_GLOBAL, "Contrôles globaux"},
    {TR_HOTKEY_HEADER_CITY, "Contrôles de la cité"},
    {TR_HOTKEY_HEADER_ADVISORS, "Rapports des conseillers"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Cartes de visualisation"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Points d'intérêt de la cité"},
    {TR_HOTKEY_HEADER_EDITOR, "Éditeur"},
    {TR_HOTKEY_HEADER_BUILD, "Contrôles de construction"},
    {TR_HOTKEY_ARROW_UP, "Haut"},
    {TR_HOTKEY_ARROW_DOWN, "Bas"},
    {TR_HOTKEY_ARROW_LEFT, "Gauche"},
    {TR_HOTKEY_ARROW_RIGHT, "Droite"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Basculer en plein écran"},
    {TR_HOTKEY_CENTER_WINDOW, "Centrer la fenêtre"},
    {TR_HOTKEY_RESIZE_TO_640, "Redimensionner en 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Redimensionner en 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Redimensionner en 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Capturer l'écran de jeu"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Capturer la cité entière"},
    {TR_HOTKEY_SAVE_MINIMAP_SCREENSHOT, "Capturer la mini-carte"},
    {TR_HOTKEY_BUILD_CLONE, "Cloner l'objet sous le curseur"},
    {TR_HOTKEY_LOAD_FILE, "Charger une partie"},
    {TR_HOTKEY_SAVE_FILE, "Sauvegarder une partie"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Augmenter la vitesse du jeu"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Diminuer la vitesse du jeu"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Mettre en pause"},
    {TR_HOTKEY_CYCLE_LEGION, "Parcourir les légions en boucle"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Tourner la carte vers la gauche"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Tourner la carte vers la droite"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Main-d'œuvre"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Légion"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Empereur"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Évaluation"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Commerce"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Population"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Hygiène"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Éducation"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Loisirs"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religion"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Finances"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Conseiller"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Logement"},
    {TR_HOTKEY_TOGGLE_OVERLAY, "Cartes de visualisation"},
    {TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Cartes de visualisation relatives"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Eau"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Incendies"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Dégâts"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Criminalité"},
    {TR_HOTKEY_ROTATE_BUILDING, "Rotation de bâtiment suivante"},
    {TR_HOTKEY_ROTATE_BUILDING_BACK, "Rotation de bâtiment précédente"},
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problèmes"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Aller au point d'intérêt 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Aller au point d'intérêt 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Aller au point d'intérêt 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Aller au point d'intérêt 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Définir comme point d'intérêt 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Définir comme point d'intérêt 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Définir comme point d'intérêt 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Définir comme point d'intérêt 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Afficher les infos de bataille"},
    {TR_HOTKEY_EDIT_TITLE, "Appuyez sur une touche"},
    {TR_BUILDING_ROADBLOCK, "Barrage routier" },
    {TR_BUILDING_ROADBLOCK_DESC, "Les barrages routiers stoppent les citoyens itinérants."},
    {TR_BUILDING_ARCHITECT_GUILD, "Guilde des architectes"},
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Ici, les architectes travaillent sans relâche afin de construire des monuments pour la gloire de Rome."},
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Accorder une épithète au temple"},
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Cérès"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptune"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Mercure"},
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Vénus"},
    {TR_BUILDING_PANTHEON, "Panthéon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Temple monumental de Cérès"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Temple monumental de Neptune"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Temple monumental de Mercure"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Temple monumental de Mars"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Temple monumental de Vénus"},
    {TR_BUILDING_PANTHEON_DESC, "Panthéon"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Cérès stimule les charretiers des fermes de la cité, les poussant à se déplacer 50 % plus vite."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Neptune accorde +1 de portée aux fontaines et puits, +2 aux réservoirs. Le service des eaux requiert -50 % d'employés, les navires marchands voyagent 25 % plus vite. Les maladies dans les maisons chutent fortement."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Mercure gratifie les marchands terrestres et maritimes d'une capacité supplémentaire de 50 %, et encourage les marchands terrestres à se déplacer 25 % plus vite."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Mars exhorte vos citoyens à s'enrôler, formant des recrues pour les forts de votre cité, et permettant la construction de quatre forts supplémentaires."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Vénus illumine de sa beauté les jardins, statues et temples de la cité, augmentant leur attrait. Les logements stockent plus de biens et régressent plus lentement."},
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Le Panthéon procure aux citoyens un accès à tous les dieux et organise des festivals annuels. Les frais des bâtiments religieux et culturels sont réduits de 25 %."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Les prêtres réduisent la consommation de nourriture de 20 %."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Les temples forment des auriges pour l'Hippodrome."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Les prêtres réduisent de 20 % la consommation de poteries et de meubles."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Les temples génèrent de la nourriture selon le nombre de logements qu'ils couvrent, et la livrent au réfectoire. Les frais des forts sont réduits de 25 %."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Le temple monumental produit du vin pour la population ayant accès aux temples de Vénus, qui le collectent et distribuent dans les logements et tavernes."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Les prêtres collectent et distribuent à la fois de l'huile et un type de nourriture depuis les entrepôts de la cité."},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Les prêtres augmentent la capacité de logement de 5 %. Le temple monumental fait office de réservoir rempli et fournit de l'eau."},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Les prêtres réduisent de 20 % la consommation d'huile et de vin."},
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Les prêtres réduisent de 10 % la consommation de tous les biens."},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Les prêtres offrent des divertissements et embellissent eux-mêmes les habitations, augmentant ainsi l'attrait du quartier sans décoration supplémentaire."},
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Tous les temples de la cité envoient des prêtres au Panthéon, répandant la foi et les bénédictions de leurs dieux."},
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Les logements avec accès au Panthéon peuvent évoluer d'une étape supplémentaire."},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Temple de Ceres Fecunda"},
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Temple de Ceres Frugifera"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Temple de Neptunus Equester"},
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Temple de Neptunus Adiutor"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Temple de Mercurius Fortunus"},
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Temple de Mercurius Mercator"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Temple de Mars Ultor"},
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Temple de Mars Quirinus"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Temple de Venus Verticordia"},
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Temple de Venus Genetrix"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima"},
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna"},
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Temple monumental"},
    {TR_BUILDING_WORK_CAMP, "Camp de travail"},
    {TR_BUILDING_WORK_CAMP_DESC, "Les ouvriers se rassemblent ici pour transporter les matériaux vers les chantiers de construction."},
    {TR_HEADER_HOUSING, "Logement"},
    {TR_ADVISOR_HOUSING_ROOM, "Les logements ont de la place pour"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Il n'y a plus de place dans les logements"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Résidences demandant des poteries"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Résidences demandant des meubles"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Résidences demandant de l'huile"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Résidences demandant du vin"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Total des résidences :"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Capacité disponible :"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Capacité totale :"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Population - Logement"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Graphiques"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Cote de prospérité du logement :"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Pourcentage de la population dans des villas et palais :"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Pourcentage de la population dans des tentes et huttes :"},
    {TR_ADVISOR_AVERAGE_TAX, "Revenu fiscal moyen par résidence :"},
    {TR_ADVISOR_AVERAGE_AGE, "Âge moyen de la population :"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Pourcentage de la population active :"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Naissances l'an dernier :"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Morts l'an dernier :"},
    {TR_ADVISOR_TOTAL_POPULATION, "Résidents"},
    {TR_ADVISOR_IN_STORAGE, "en stock"},
    {TR_ADVISOR_FROM_GRANARIES, "dans les greniers"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Expédier depuis les greniers" },
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT,"Êtes-vous sûr ?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Continuer à stocker la ressource"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Prospérité maximale pour le niveau actuel de logement :"},
    {TR_ADVISOR_POPULATION_AGE, "Âge"},
    {TR_ADVISOR_POPULATION_RESIDENTS, "résidents"},
    {TR_ADVISOR_POPULATION_DWELLERS, "habitants"},
    {TR_REQUIRED_RESOURCES, "Ressources livrées pour la phase actuelle :"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "La construction des temples monumentaux nécessite du matériel stocké dans un entrepôt, des ouvriers d'un camp de travail et des architectes d'une guilde des architectes."},
    {TR_CONSTRUCTION_PHASE, "Phase de construction :"},
    {TR_ADD_MODULE, "Redédier le temple ?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Épithète accordée."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Cérès inventa le soc qui déchire et féconde la terre.\nL'homme lui doit ses premiers fruits,\nDes aliments plus doux, et ses premières lois.\nNous devons tout aux bienfaits de Cérès.\nC'est elle que je vais chanter.\n-Ovide, les Métamorphoses, Livre V"},
    {TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Les flots s'apaisent, lorsque Neptune dépose son trident\nSur la mer agitée et lisse son visage sillonné.\nDéjà Triton, à son appel, apparaît au-dessus des vagues;\nSa robe tyrienne couvrant ses épaules d'azur;\nEt dans sa main une conque cave, longue et recourbée.\n-Ovide, les Métamorphoses, Livre I "},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Les bœufs, les grasses brebis, les trépieds,\nLes blondes crinières des chevaux,\nTout cela peut être conquis,\nMais l'âme qui s'est une fois échappée d'entre nos dents,\nNe peut être ressaisie ni rappelée.\n-Homère, L'Illiade, Livre IX "},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Non loin se façonnaient pour Mars ce char,\nCes roues rapides dont le fracas réveille les guerriers,\nÉpouvante les cités éperdues, et répand dans les airs,\nLe son éclatant des trompettes.\n-Virgile, l'Énéide, Livre VIII"},
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "Ô Vénus ! Ô Amour !\nQuels doux transports ravissaient tous mes sens !\nQuel délire agitait mon âme !\nDans quel tendre abandon il me semblait cesser de vivre!\n-Ovide, les Métamorphoses, Livre IX "},
    {TR_BUILDING_PANTHEON_QUOTE, "S'ouvre dans l'Olympe, le palais de la toute-puissance :\nLe père des dieux, le souverain des hommes,\nRassemble les Immortels sous ses lambris étoilés;\nLà, du haut de son trône, abaissés sur la terre,\nSes regards embrassent l'immensité du monde.\nLes dieux prirent séance sous ces portiques majestueux.\n-Virgile, L'Énéide, Livre X "},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portico)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Les ouvriers construisent le podium qui élèvera le temple et fournira une base solide pour résister au passage du temps."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Les artisans fabriquent le portique qui supporte l'autel sacrificiel du temple."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Les ingénieurs élaborent la cella, l'intérieur du temple abritant les images sacrées."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Les travaux sur le praecinctum du temple ont commencé, où les fidèles se rassembleront pour les cérémonies publiques en extérieur."},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Le temple étant presque terminé, les prêtres se rassemblent pour accomplir les rites de consécration."},
    {TR_BUILDING_MENU_TREES, "Arbres"},
    {TR_BUILDING_MENU_PATHS, "Allées"},
    {TR_BUILDING_MENU_PARKS, "Parcs"},
    {TR_BUILDING_SMALL_POND, "Petit bassin"},
    {TR_BUILDING_LARGE_POND, "Grand bassin"},
    {TR_BUILDING_PINE_TREE, "Pin"},
    {TR_BUILDING_FIR_TREE, "Sapin"},
    {TR_BUILDING_OAK_TREE, "Chêne"},
    {TR_BUILDING_ELM_TREE, "Orme"},
    {TR_BUILDING_FIG_TREE, "Figuier"},
    {TR_BUILDING_PLUM_TREE, "Prunier"},
    {TR_BUILDING_PALM_TREE, "Palmier"},
    {TR_BUILDING_DATE_TREE, "Dattier"},
    {TR_BUILDING_PINE_PATH, "Allée de pin"},
    {TR_BUILDING_FIR_PATH, "Allée de sapin"},
    {TR_BUILDING_OAK_PATH, "Allée de chêne"},
    {TR_BUILDING_ELM_PATH, "Allée d'orme"},
    {TR_BUILDING_FIG_PATH, "Allée de figuier"},
    {TR_BUILDING_PLUM_PATH, "Allée de prunier"},
    {TR_BUILDING_PALM_PATH, "Allée de palmier"},
    {TR_BUILDING_DATE_PATH, "Allée de dattier"},
    {TR_BUILDING_BLUE_PAVILION, "Pavillon"},
    {TR_BUILDING_RED_PAVILION, "Pavillon rouge"},
    {TR_BUILDING_ORANGE_PAVILION, "Pavillon orange"},
    {TR_BUILDING_YELLOW_PAVILION, "Pavillon jaune"},
    {TR_BUILDING_GREEN_PAVILION, "Pavillon vert"},
    {TR_BUILDING_SMALL_STATUE_ALT, "Statue de déesse"},
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Statue de sénateur"},
    {TR_BUILDING_OBELISK, "Obélisque"},
    {TR_BUILDING_POND_DESC, "Les bassins sont alimentés par les réservoirs de la cité et fournissent de l'eau pour les plantes et les animaux, ainsi qu'une oasis fraîche et relaxante pour les gens. Tous les citoyens aimeraient vivre près d'un bassin."},
    {TR_BUILDING_WINDOW_POND, "Bassin"},
    {TR_BUILDING_OBELISK_DESC, "Un monument prestigieux, œuvre d'un ancien roi du Nil. Les Égyptiens ne l'utilisaient pas."},
    {TR_ADVISOR_FINANCE_LEVIES, "Frais des édifices"},
    {TR_CONFIRM_DELETE_MONUMENT, "Démolir ce monument"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Sélectionnez l'épithète à accorder"},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Accorder une épithète consacrera définitivement votre temple à un aspect de sa divinité, conférant aux prêtres un pouvoir divin."},
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/Mois"},
    {TR_BUILDING_MESS_HALL, "Réfectoire"},
    {TR_BUILDING_MESS_HALL_DESC, "Le réfectoire collecte la nourriture des greniers afin de nourrir les soldats stationnés dans les forts. Un mauvais ravitaillement ralentira le recrutement et nuira au moral."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Ravitaillement du mois dernier :"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Les soldats sont : "},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Bien nourris"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Nourris"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Affamés"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Très affamés"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "En famine"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "Le régime alimentaire varié des soldats augmente grandement leur moral."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Le régime alimentaire riche et nutritif apprécié des soldats augmente grandement leur moral."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Vous n'avez pas de soldats à nourrir."},
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Mois de nourriture en réserve :"},
    {TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Instructions pour l'intendant"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Les pénuries alimentaires à votre réfectoire ralentissent le recrutement de soldats."},
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Les pénuries alimentaires critiques à votre réfectoire paralysent le recrutement de soldats."},
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Moral diminué par la récente pénurie alimentaire"},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Moral très diminué par la récente pénurie alimentaire"},
    {TR_BUILDING_LEGION_STARVING, "Pénurie alimentaire"},
    {TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "sans limite"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importable"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exportable"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Aucun acheteur pour ce bien"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Aucun vendeur pour ce bien"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Ne pas importer"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Ne pas exporter"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Démarrer l'importation"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Démarrer l'exportation"},
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Vos soldats ont toute la nourriture dont ils ont besoin."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Vos soldats ont besoin de plus de nourriture."},
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Vos soldats meurent de faim !"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Mois de nourriture en réserve au réfectoire :"},
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Soldats affamés"},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Votre réfectoire manque cruellement de nourriture et le moral de vos troupes diminue. Assurez-vous que votre réfectoire peut accéder à un grenier bien approvisionné."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Votre cité a perdu son réfectoire et vos troupes meurent de faim. Construisez immédiatement un réfectoire."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Instructions du marché"},
    {TR_DOCK_SPECIAL_ORDERS_HEADER, "Instructions du dock"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Instructions du temple"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Instructions de la taverne"},
    {TR_WARNING_NO_MESS_HALL, "Construisez en premier un réfectoire pour vos soldats."},
    {TR_WARNING_MAX_GRAND_TEMPLES, "Seuls deux temples monumentaux peuvent être construits."},
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Temple monumental terminé"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Les prêtres et les fidèles affluent vers le nouveau temple monumental pour les rites de consécration. Votre peuple est impressionné par la majesté de vos œuvres et la divinité que vous avez choisie vous comble de faveur."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "Une bénédiction de Mercure"},
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Ravi de votre dévouement, Mercure a béni votre industrie en offrant des matières premières à vos artisans."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Contremaître"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Transporteur"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Architecte"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Intendant"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Aide de camp"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Le temple monumental envoie des prêtres de Cérès aider à distribuer de la nourriture et de l'huile aux citoyens ayant faim."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Le temple monumental permet aux prêtres de Vénus de fournir du vin sacré à vos citoyens."},
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Le temple monumental envoie des prêtres de Mars ravitailler en nourriture votre réfectoire."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Temple de Cérès"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Temple de Neptune"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Temple de Mercure"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Temple de Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Temple de Vénus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Prêtre"},
    {TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Cités avec route commerciale maritime ouverte :" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Aucune route commerciale maritime ouverte." },
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Je vais faire tout mon possible pour tenter de calmer ces barbares. Laissez-moi leur parler et ils cesseront leur attaque contre la cité.\""},
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "Festival annuel"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "Les fidèles affluent vers les temples pour la célébration de Cerealia, en l'honneur de Cérès. Les agriculteurs offrent des sacrifices pour de riches récoltes dans les années à venir."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "C'est aujourd'hui la fête de Neptunalia, en l'honneur de Neptune. Les fidèles construisent des huttes de branches et de feuillages et se réjouissent sous la chaleur ardente du soleil d'été."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Les commerçants et les marchands se rassemblent en masse pour célébrer Mercuralia. Les navires et les entrepôts sont aspergés d'eau sacrée dans l'espoir d'obtenir la protection divine du dieu Mercure."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Les citoyens se rassemblent à l'extérieur de la cité pour la célébration d'Equirria, pour solliciter la faveur de Mars. L'air est empli du tonnerre des sabots et du grincement des chars alors que les fidèles font la course en l'honneur de leur dieu."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "Les fidèles se rassemblent pour la célébration de Veneralia, un jour consacré à Vénus. Vos citoyens l'implorent de leur accorder bonne fortune en affaire de cœur."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Supprimer les messages lus"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Désactiver ce bâtiment"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Activer ce bâtiment"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Autoriser les dames du marché à acheter ici"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Autoriser les caravanes à commercer ici"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Autoriser les navires à commercer ici"},
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Suspendre la livraison des biens vers les ateliers, fabriques, ou greniers"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, " Activer le stockage vers un entrepôt"},
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Désactiver le stockage"},
    {TR_BUILDING_LIGHTHOUSE, "Phare"},
    {TR_BUILDING_CARAVANSERAI, "Caravansérail"},
    {TR_BUILDING_CARAVANSERAI_DESC, "Les caravanes marchandes profitent de ce lieu de repos, consomment de la nourriture et reposent leurs bêtes. Les perturbations commerciales terrestres durent deux fois moins longtemps."},
    {TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Instructions du caravansérail"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Fondations)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Les ingénieurs terrassent les fondations de ce futur lieu de repos."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Fournisseur du caravansérail" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Porteur du caravansérail" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Commerce terrestre" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Aucune politique commerciale terrestre actuellement" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Sélectionnez une politique commerciale terrestre pour votre cité. Vous pouvez modifier celle-ci à tout moment." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Les exportations terrestres rapportent 20 % de plus, mais les importations terrestres sont 10 % plus chères." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium acquisitionem terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Les importations terrestres sont 20 % moins chères, mais les exportations terrestres rapportent 10 % de moins." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Les caravanes peuvent porter 4 biens de plus, mais consomment 20 % de nourriture en plus dans le Caravansérail." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Fondations)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Piédestal)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Tour)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Couronne)"},
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Les ingénieurs établissent des bases solides pouvant supporter le poids d'une impressionnante tour de pierre."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Les maçons construisent le piédestal qui élèvera la flamme du phare bien au-dessus de l'horizon."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "La tour du phare s'élève toujours plus haut chaque jour, tandis que les maçons érigent l'édifice pierre après pierre."},
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Les ingénieurs effectuent les derniers ajustements sur le phare. Bientôt, il brillera sur des kilomètres, guidant les navires à bon port."},
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "La construction du phare nécessite des matériaux stockés dans un entrepôt, des ouvriers d'un camp de travail, et des architectes d'une guilde d'architectes."},
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Sa lumière guide les marins de l'empire vers votre cité. Les navires de pêche se déplacent 10 % plus vite et les tempêtes marines durent deux fois moins longtemps."},
    {TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Commerce maritime" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Aucune politique commerciale maritime actuellement" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Sélectionnez une politique commerciale maritime pour votre cité. Vous pouvez modifier celle-ci à tout moment." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Les exportations maritimes rapportent 20 % de plus, mais les importations maritimes sont 10 % plus chères." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Les importations maritimes sont 20 % moins chères, mais les exportations maritimes rapportent 10 % de moins." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Les navires marchands peuvent transporter 4 biens de plus, mais le Phare consomme 20 % de bois en plus." },
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monuments"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Le phare achevé, une imposante tour de pierre se profile à l'horizon. Que sa lumière guide les navires jusqu'à la fin des temps."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Le Panthéon est achevé. Il trône inégalé en tant que monument dédié à la puissance impressionnante des dieux et du peuple de Rome."},
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument achevé"},
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "Une bénédiction de Neptune"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Récompensant le dévouement de votre cité, Neptune accorde un passage en douceur aux marchands pendant douze mois, durant lesquels vos exportations rapporteront 50 % de plus."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "Une bénédiction de Vénus"},
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Ravie de la vénération joyeuse qui lui est témoignée, Vénus accorde jeunesse, santé et bonheur à votre peuple, augmentant ainsi la taille de votre population active. L'humeur dans votre cité s'améliore grâce au sourire de Vénus."},
    {TR_BUILDING_MENU_STATUES, "Statues"},
    {TR_BUILDING_MENU_GOV_RES, "Gouverneur"},
    {TR_OVERLAY_ROADS, "Routes"},
    {TR_NO_EXTRA_ASSETS_TITLE, "Le dossier assets ne peut être trouvé"},
    {TR_NO_EXTRA_ASSETS_MESSAGE,
        "Votre installation de Caesar 3 n'a pas de dossier assets correctement installé. "
        "Les nouveaux bâtiments ne seront pas correctement affichés.\n"
        "Veuillez vous assurer qu'un dossier '/assets' à jour existe dans le répertoire d'installation de Caesar 3."},
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Le phare doit être placé près de l'eau"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Cette maison a accès aux cinq dieux vénérés au Panthéon"},
    {TR_BUILDING_LEGION_FOOD_BONUS, "La nourriture abondante renforce le moral"},
    {TR_BUILDING_LEGION_FOOD_STATUS, "Statut alimentaire"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Autoriser l'intendant à obtenir de la nourriture ici"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Vous ne pouvez pas obtenir les matériaux nécessaires"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Les temples monumentaux confèrent un bonus de culture de +6"},
    {TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Désactiver la réapparition des loups"},
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Retour menu principal"},
    {TR_LABEL_PAUSE_MENU, "Pause"},
    {TR_OVERLAY_LEVY, "Frais"},
    {TR_TOOLTIP_OVERLAY_LEVY, " denarii dépensés en frais chaque mois."},
    {TR_MAP_EDITOR_OPTIONS, "Réglages du scénario" },
    {TR_BUILDING_TAVERN, "Taverne" },
    {TR_BUILDING_GRAND_GARDEN, "Grand jardin" },
    {TR_BUILDING_TAVERN_DESC_1, "Cette taverne n'a pas d'employés, et ne peut donc pas accueillir de clients." },
    {TR_BUILDING_TAVERN_DESC_2, "Cette taverne n'a pas de vin, et ne peut donc pas accueillir de clients." },
    {TR_BUILDING_TAVERN_DESC_3, "Cette taverne divertit ses clients tant que le vin coule à flots. Un approvisionnement en viande augmenterait sa réputation." },
    {TR_BUILDING_TAVERN_DESC_4, "Le vin abondant et le fumet de viande rôtie attirent dans cette taverne une foule amatrice de jeux de hasard, de musique et de fête." },
    {TR_FIGURE_TYPE_BARKEEP, "Tavernière" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Livreuse de la taverne" },
    {TR_OVERLAY_TAVERN, "Taverne" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Cette maison n'a pas accès à une taverne, ou sa taverne n'a plus de vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Aucune tavernière n'est passée dernièrement. Cette maison perdra bientôt accès à sa taverne." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Une tavernière approvisionnée en vin, est passée près de cette maison." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Une tavernière approvisionnée en vin et en viande, est passée près de cette maison." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Une tavernière approvisionnée en vin, est passée récemment près de cette maison." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Une tavernière approvisionnée en vin et en viande, est passée récemment près de cette maison. Que la fête commence !" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "Les résidents exècrent jusqu'à votre nom."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "Les résidents sont très furieux contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "Les résidents sont furieux contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "Les résidents sont très en colère contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "Les résidents sont en colère contre vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "Les résidents sont mitigés envers vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "Les résidents sont indifférents envers vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "Les résidents sont contents de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "Les résidents sont très contents de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "Les résidents sont extrêmement contents de vous." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "Les résidents vous adorent." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "Vous êtes un dieu aux yeux des résidents." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "Les résidents sont mécontents du fort taux d'impôts." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "Les résidents sont mécontents des bas salaires." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "Les résidents sont mécontents du manque d'emplois." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "Les résidents sont déprimés par leur habitat misérable." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "Les résidents apprécieraient plus de divertissement." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "Les résidents apprécieraient une nourriture plus variée." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "Les résidents apprécieraient un meilleur cadre de vie." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "Les résidents sont stimulés par un événement récent." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "Les résidents sont découragés par un événement récent." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Tavernes" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY, "Rendement :" },
    {TR_BUILDING_WINDOW_INDUSTRY_EFFICIENCY_TOOLTIP, "Le rendement correspond au ratio entre la production potentielle d'un bâtiment sur une année et sa production effective sur l'année passée." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_RAW_MATERIALS, "Ce bâtiment a un rendement faible, peut-être dû à un manque de lieux de livraison à proximité." },
    {TR_BUILDING_WINDOW_INDUSTRY_LOW_EFFICIENCY_WORKSHOPS, "Ce bâtiment a un rendement faible, peut-être dû à un apport irrégulier en matières premières ou à un manque de lieux de livraison à proximité." },
    {TR_BUILDING_WINDOW_INDUSTRY_WHARF_AVERAGE_CATCH, "Prise moyenne mensuelle :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Jeux" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Financer les Grands Jeux du Colisée avec vos fonds personnels et les ressources de votre cité." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Organiser des Jeux" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Les préparatifs des Grands Jeux sont en cours." },
    {TR_SELECT_GAMES_HEADER, "Jeux" },
    {TR_SELECT_GAMES_TEXT, "Les Jeux auront lieu au Colisée, nécessitant vos fonds personnels et les ressources de votre cité." },
    {TR_BUILDING_ARENA, "Arène" },
    {TR_BUILDING_HORSE_STATUE, "Statue équestre" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Fontaine dauphin" },
    {TR_BUILDING_HEDGE_DARK, "Haie verdoyante" },
    {TR_BUILDING_HEDGE_LIGHT, "Haie ensoleillée" },
    {TR_BUILDING_GARDEN_WALL, "Muret arrondi" },
    {TR_BUILDING_LEGION_STATUE, "Statue de légionnaire" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Colonne de marbre" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Fondations)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arcade)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galerie)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Les travailleurs creusent l'hypogée souterrain, les tunnels et mécanismes d'où surgiront des spectacles grandioses." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Les murs du Colisée prennent forme tandis que les gradins de la plèbe et les sièges des empereurs sont placés." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Des arches gracieuses s'élèvent vers les cieux, propulsant le puissant Colisée au firmament." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Alors que le Colisée tutoie les cieux, ses murs sont parés de marbre étincelant et de fabuleuses statues." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Piste)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Fondations)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Gradins)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Façade)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Ce site gigantesque est minutieusement étudié et préparé pour un projet d'une ampleur sans précédent." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Des chemins d'accès et des structures de soutien sont en cours de construction autour de la piste." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Les maçons sculptent dans la pierre les sièges qui accueilleront des dizaines de milliers de personnes." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Plus qu'une simple piste de course, les artisans érigent un monument digne des dieux et du peuple de Rome." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "La construction du monument nécessite des matériaux stockés dans un entrepôt, des ouvriers d'un camp de travail, et des architectes d'une guilde d'architectes." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Construction suspendue." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arènes" },
    {TR_BUILDING_INFO_TOURISM, "(Voyageurs)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Le Colisée est terminé ! Que les jeux commencent !" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "L'Hippodrome est terminé. Vos citoyens attendent avec impatience le lancement des premières courses !" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Jeux inauguraux" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Les courses commencent" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "Les Jeux inauguraux du Colisée ont commencé. Sous vos ordres, ce monument sera consacré du sang des braves !" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Votre cité se vide tandis que des foules pléthoriques affluent vers l'Hippodrome pour les courses de chars inaugurales. Une joie assourdissante emplit l'air alors que les portes s'ouvrent !" },
    {TR_WINDOW_GAMES_OPTION_1, "Combats Navals" },
    {TR_WINDOW_GAMES_OPTION_2, "Jeux des Fauves" },
    {TR_WINDOW_GAMES_OPTION_3, "Jeux des Calendes" },
    {TR_WINDOW_GAMES_OPTION_4, "Jeux Olympiques" },
    {TR_WINDOW_GAMES_OPTION_5, "Jeux Romains" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Le Colisée sera inondé pour reconstituer une grande bataille navale. Augmente la vitesse de déplacement de vos troupes et leur force dans les batailles lointaines pendant 12 mois." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Le Colisée accueillera des combats de bêtes féroces et des exécutions réjouissant la plèbe. Crimes, émeutes et révoltes seront réfrénés pendant 12 mois. Les dresseurs de lions défendront la cité lors des prochaines invasions." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Le Colisée accueillera des jeux en l'honneur des dieux au premier jour de l'année prochaine, sollicitant fortune et prospérité. Les quotas commerciaux seront doublés l'année prochaine." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "L'Hippodrome accueillera les Jeux Olympiques. Des foules de visiteurs afflueront vers votre cité, et si vos athlètes l'honorent bien, vous obtiendrez une augmentation permanente du tourisme et de l'estime." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "Le Colisée accueillera les Jeux Romains. Des compétiteurs afflueront de tout l'Empire vers votre cité, désireux de prouver leur valeur. Ces célébrations vous apporteront l'estime de l'Empereur et de votre peuple pendant 12 mois." },
    {TR_WINDOW_GAMES_COST, "Coût :" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(fonds personnels)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Fonds personnels insuffisants." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Pas assez de ressources stockées." },
    {TR_WINDOW_GAMES_NO_VENUE, "Lieu non construit ou manquant d'employés." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Construction)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Maçons et ingénieurs bâtissent cette structure sacrée à partir d'un marbre étincelant." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Bâtir ce temple requiert des matériaux stockés dans un entrepôt, des ouvriers d'un camp de travail et des architectes de la guilde éponyme." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "L'eau des réservoirs de la cité remplit lentement le Colisée. Les charpentiers commencent à assembler des navires de guerre alors que les gladiateurs s'entraînent au combat naval. Bientôt les Combats Navals commenceront !" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Le Colisée est devenu un lac artificiel alors que les gladiateurs reconstituent de grandes victoires romaines en mer. Le sang et l'eau se mélangent alors que la foule exulte. La Naumachie - les Combats Navals - ont commencé !" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Un long processus de nettoyage et de drainage commence pour rendre au Colisée son usage habituel. Votre peuple parlera de cet extraordinaire spectacle aquatique pendant des années." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "D'étranges cargaisons se font jour dans votre cité, tandis que des commerçants du bout du monde livrent des bêtes terrifiantes dans les cages situées sous le Colisée. Bientôt, un spectacle abominable ravira votre peuple." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Les criminels condamnés et gladiateurs en quête de gloire ultime font face à une mort sauvage. Aux sons des trompettes, les Jeux des Fauves ont commencé !" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Les dernières bêtes sauvages gisent sur les sables du Colisée, leur sang se mêlant à celui des condamnés. Les Jeux des Fauves sont terminés." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Nous saluerons la nouvelle année avec des jeux glorieux en l'honneur des dieux. En retour, nous demandons fortune, prospérité et bénédictions en matière de commerce." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "Les jeux commencent au lever du soleil aux Calendes de Ianuarius. Les prêtres effectuent des sacrifices d'animaux alors que les gladiateurs se préparent à mourir pour la faveur des dieux."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Les augures suggèrent que les dieux furent satisfaits de nos grands jeux, des sacrifices, et de l'attention témoignée à leur égard. On peut s'attendre à une année très rentable !"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Tous les yeux seront rivés sur votre cité alors que les Jeux Olympiques attirent voyageurs, concurrents et dignitaires romains du monde entier. Il ne faudra pas moins d'une année complète pour tout préparer."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Le jour tant attendu est arrivé. La flamme sacrée est allumée et les rues de votre cité sont désertes alors que les citoyens se rassemblent dans le grand hippodrome. Que les jeux commencent !"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "La flamme sacrée est éteinte, voyageurs et citoyens rentrent chez eux exténués mais heureux. La gloire éternelle est vôtre pour avoir organisé avec succès cette célébration ancienne et sacrée honorant les mortels." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Avec l'annonce des Jeux Romains, les citoyens de tout l'Empire affluent vers votre cité, beaucoup espérant gagner les compétitions à venir. Il ne faudra pas moins d'une année complète de préparations." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "La procession solennelle commence, et avec elle, les Jeux Romains. Puisse Jupiter lui-même désigner les champions des courses, combats et autres épreuves. Le Colisée est rempli à ras bord de citoyens attendant les jeux et ses offrandes traditionnelles de blé et d'huile d'olive. Que les jeux commencent !" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Les Jeux Romains touchent à leur fin. Empli d'excitation et rassasié, chaque citoyen a goûté la grandeur de Rome et son style de vie. Gloire aux dieux, gloire aux vainqueurs des jeux, et gloire au gouverneur !" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "Les Grands Jeux"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, "Mois restants avant la tenue des prochains Jeux : " },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Mois restants avant les Combats Navals :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Les Combats Navals sont en cours. Les projections d'eau, le grincement des coques, et les cris de guerre des gladiateurs s'ajoutent aux vivats de la foule." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Mois restants avant les Jeux des Fauves :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Les Jeux des Fauves sont en cours. Épaule contre épaule, la foule elle-même rugit alors que les bêtes sauvages traquent leurs proies humaines." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Mois restants avant les Jeux des Calendes :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Les Jeux des Calendes sont en cours. L'odeur des sacrifices d'animaux et de l'encens domine même le sang et la sueur de l'arène." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Mois restants avant les Jeux Olympiques :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "Les Jeux Olympiques sont en cours. Le feu sacré brûle jour et nuit alors que les athlètes se disputent la gloire immortelle." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Mois restants avant les Jeux Romains :" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "Les Jeux Romains sont en cours. Chaque participant verse son sang, sa sueur et ses larmes pour prouver qu'il est le meilleur des Romains." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "Les Grands Jeux continueront encore" }, // ...XX Days,
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "De Grands Jeux ont eu lieu récemment." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "Les Grands Jeux sont en cours ! Votre cité regorge de voyageurs et de réjouissances." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "L'arène est fermée. Les oiseaux nichent dans les sièges vides." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Cette arène n'accueille ni lions ni gladiateurs, et offre peu de divertissement." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Cette arène propose des combats de gladiateurs et de lions, et jouit d'une grande popularité." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Des spectacles réguliers de gladiateurs divertissent la foule, mais des lions pourraient pimenter le programme." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Des bêtes affamées rôdent dans l'arène en quête de proies, mais le manque de gladiateurs entraînés rend les spectacles très brefs." },
    {TR_OVERLAY_ARENA_COL, "Arène" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Cette maison n'a pas accès à une arène ou au Colisée." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Cette maison a accès à une arène, avec un spectacle." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Cette maison a accès à une arène, avec deux spectacles." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Cette maison a accès au Colisée, avec un spectacle." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Cette maison a accès au Colisée, avec deux spectacles." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Travailleurs en grève" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Pas d'accès à l'eau" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "En attente du charretier" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Aucune ressource disponible" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Bâtiment mis en pause" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_PLAGUE, "Bâtiment pestiféré"},
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "Trop de bâtiments de ce type - les voyageurs évitent cet endroit." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Apport financier des voyageurs cette année :" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "La production de poisson est suspendue sur ordre de votre conseiller commercial."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribut / intérêt"},
    {TR_WINDOW_ADVISOR_TOURISM, "Divers"},
    {TR_WINDOW_FIGURE_TOURIST, "Ce voyageur a dépensé : "},
    {TR_FIGURE_TYPE_TOURIST,  "Voyageur"},
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Version de sauvegarde incompatible" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "La sauvegarde que vous essayez de charger concerne une version différente d'Augustus.\nVeuillez mettre à jour Augustus vers la version la plus récente." },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_TITLE, "Impossible de sauvegarder la partie" },
    {TR_SAVEGAME_NOT_ABLE_TO_SAVE_MESSAGE, "La sauvegarde n'a pas pu être effectuée.\nIl se peut que le dossier dans lequel sont conservées les sauvegardes de Caesar 3 nécessite un accès administrateur.\nVeuillez installer Caesar 3 dans un répertoire ne nécessitant pas de droits d'administrateur ou exécutez Augustus en tant qu'administrateur (non recommandé)." },
    {TR_BUILDING_COLONNADE, "Colonnade" },
    {TR_BUILDING_LARARIUM, "Laraire" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Ce petit sanctuaire est dédié aux Lares, esprits ancestraux du peuple romain. De petits sacrifices et prières peuvent y être effectués."},
    {TR_BUILDING_WATCHTOWER, "Tour de guet"},
    {TR_BUILDING_WATCHTOWER_DESC, "Les archers de la tour guettent les envahisseurs, tandis que des patrouilleurs arpentent les rues en contrebas." },
    {TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Cette tour nécessite un patrouilleur provenant de la caserne avant de pouvoir protéger la cité."},
    {TR_BUILDING_NYMPHAEUM, "Nymphée"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Ce grand temple est dédié aux Nymphes, divinités mineures des sources, des rivières et des mers. Promet beauté et abondance aux terres environnantes et la faveur divine à la cité." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Petit mausolée"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Ce bâtiment est le lieu de repos des générations passées des grandes familles de votre cité, et la demeure finale que nombre de vivants envient." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Grand mausolée"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Les murs et statues de marbre poli de cette magnifique structure reflètent les grandes actions des illustres patriciens ayant mérité le privilège de reposer ici." },
    {TR_FIGURE_TYPE_WATCHMAN, "Patrouilleur" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Ce temple collectera de la nourriture pour le réfectoire, une fois ce dernier construit." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Régler l'accès des préfets et ingénieurs" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Régler l'accès des prêtres" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Régler l'accès du personnel des marchés" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Régler l'accès du personnel de loisirs" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Régler l'accès du personnel éducatif" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Régler l'accès du personnel d'hygiène" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Régler l'accès des collecteurs de taxes" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Régler l'accès des recruteurs de main-d'œuvre" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Régler l'accès des missionnaires" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Régler l'accès des patrouilleurs" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Raccourci déjà utilisé"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Cette combinaison de touches est déjà affectée à l'action suivante :"},
    {TR_BUILDING_GARDEN_PATH, "Allée de jardin" },
    {TR_BUTTON_GO_TO_SITE, "Aller sur le site" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Suspendre la construction" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Reprendre la construction" },
    {TR_RESOURCE_FISH, "Poisson" },
    {TR_WARNING_VARIANT_TOGGLE, "Variantes du bâtiment disponibles avec la touche rotation"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Cette école est opérationnelle. Le développement de la zone a permis d'agrandir le bâtiment. Davantage d'enfants peuvent y étudier."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Ce théâtre est opérationnel. Le développement de la zone a permis d'agrandir le bâtiment. Un public plus nombreux peut assister aux représentations." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Cette bibliothèque est opérationnelle. Le développement de la zone a permis d'agrandir le bâtiment. De nouveaux parchemins et salles de lectures sont disponibles." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Le site de construction du monument n'a pas accès à une route et ne peut pas recevoir de matériaux. Connectez le site à une route pour débuter la construction."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "En raison de la mauvaise humeur dans la cité, les plébéiens de cet atelier ont déclaré la sécession et refusent de travailler !" },
    {TR_CITY_WARNING_SECESSION, "Les Plébéiens refusent de travailler !" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Un entrepôt a été pillé !" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Un grenier a été pillé !" },
    {TR_CITY_WARNING_THEFT, "Des fonds ont été volés dans un forum ou au Sénat !" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Pillage dans la cité !"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Un entrepôt ou un grenier a été pillé par des citoyens en colère et des biens ont été volés. Une mauvaise humeur rend ces incidents plus probables."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasions" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion en cours" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Aucune invasion" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion imminente" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Ennemis proches" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Ennemis éloignés" },
    {TR_SIDEBAR_EXTRA_GODS, "Dieux" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Tout voir" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Armée modeste"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Armée moyenne"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Armée importante"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Envoyer la requête"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Stocker"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Arrêter stockage"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Afficher les graphiques de population" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Consulter le rapport sur le logement" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Tous les matériaux requis pour cette phase ont été livrés. Un architecte de la guilde des architectes est attendu pour superviser la construction." },
    {TR_RETURN_ALL_TO_FORT, "Tous rentrer" },
    {TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Informations sur les Jeux" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Cette statue serait encore plus fabuleuse si sa fontaine pouvait ruisseler. Il lui suffirait juste d'être reliée aux canalisations d'eau." },
    {TR_OPTION_MENU_APPLY, "Appliquer"},
    {TR_OPTION_MENU_COST, "Cela vous coûtera"},
    {TR_FIGURE_TYPE_LOOTER, "Pillard" },
    {TR_FIGURE_TYPE_ROBBER, "Voleur" },
    {TR_OVERLAY_SENTIMENT, "Humeur" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Personne" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Tout le monde" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Sélectionner une politique commerciale terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Un Caravansérail est nécessaire dans votre cité pour définir une politique commerciale terrestre"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Sélectionner une politique commerciale maritime"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Un Phare est nécessaire dans votre cité pour définir une politique commerciale maritime"},
    {TR_TOOLTIP_HOLD_GAME, "Organiser les Jeux"},
    {TR_TOOLTIP_NO_GAME, "Ne pas organiser les Jeux"},
    {TR_WARNING_NEARBY_WOLF, "Impossible de construire si les loups sont à proximité" },
    {TR_MARKET_TRADING, "Vendre"},
    {TR_MARKET_NOT_TRADING, "Ne pas vendre"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuer"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Ne pas distribuer"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Des logements sordides et des bidonvilles empêchent l'immigration"},
    {TR_CITY_MESSAGE_SQUALOR, "Les logements sordides et les bidonvilles sont un problème"},
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Gardien du phare"},
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Le lieu n'a pas accès à un réservoir."},
    {TR_HOTKEY_COPY_SETTINGS, "Copier les réglages du bâtiment" },
    {TR_HOTKEY_PASTE_SETTINGS, "Coller les réglages du bâtiment" },
    {TR_HOTKEY_MOTHBALL_TOGGLE, "Désactiver/Activer le bâtiment" },
    {TR_HOTKEY_SPECIAL_ORDERS, "Ordres spéciaux du bâtiment" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Laraires dans la cité" },
    {TR_WINDOW_RACE_YOUR_BET, "Votre mise"},
    {TR_WINDOW_RACE_BET_BUTTON, "Parier sur la course"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Course en cours..."},
    {TR_WINDOW_RACE_BET_TITLE, "Miser sur un cheval"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Montant"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Parier une partie de vos fonds personnels sur le cheval de votre choix, et doubler votre mise si celui-ci l'emporte. Vos gains seront même quadruplés lors des Jeux du Colisée !"},
    {TR_WARNING_BET_VICTORY, "Votre cheval a remporté la course de l'Hippodrome"},
    {TR_WARNING_BET_DEFEAT, "Votre cheval a perdu la course de l'Hippodrome"},
    {TR_PERSONAL_SAVINGS, "Économies :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Parier sur le cheval bleu"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Parier sur le cheval rouge"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Parier sur le cheval blanc"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Parier sur le cheval vert"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "Sans une équipe complète de prêtres et de serviteurs, ce temple ne peut procéder aux célébrations et rites sacrés. Jusqu'à nouvel ordre, inutile d'espérer la faveur divine."},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Le Colisée manque de main-d'œuvre. Davantage d'employés sont requis pour s'assurer que tous vos citoyens profitent des jeux."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "L'Hippodrome manque de main-d'œuvre. Davantage d'employés sont requis afin de proposer un spectacle grandiose à tous vos citoyens."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Le Phare manque de main-d'œuvre pour entretenir son feu. Les navires se frayent péniblement un chemin jusqu'à nos docks."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Le Caravansérail manque de main-d'œuvre et ne pourra pas satisfaire toutes les caravanes."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Muret couvert"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Arche de jardin"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Cette petite arche permet de gérer les allées et venues dans les lieux les plus retirés et paisibles de votre cité."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Le magasinier est parti chercher des biens dans un autre entrepôt."},
    {TR_BUILDING_PALISADE, "Palissade" },
    {TR_BUILDING_PALISADE_DESC, "Cette profonde tranchée, surmontée d'un grand mur de poteaux de bois acérés, protègera votre cité des envahisseurs et des animaux sauvages."},
    {TR_OVERLAY_MOTHBALL, "En pause"},
    {TR_OVERLAY_ENEMY, "Ennemis"},
    {TR_BUILDING_TAVERN_DESC_5, "Pendant leur temps libre, les citoyens apprécient venir dans cet établissement pour se divertir et déguster un bon repas arrosé de vin." },
    {TR_OVERLAY_WAREHOUSES, "Entrepôts" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "L'équipe Bleue - les protégés de Neptune. Voici les jeunes auriges les plus prometteurs de Rome souhaitant faire leurs preuves." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "L'équipe Rouge - connue pour accueillir le plus talentueux aurige de l'histoire de Rome - un ancien rameur, et sauveur d'un consul Romain." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "L'équipe Blanche - fondée par d'anciens gladiateurs. Le combat coule dans leurs veines, et même en hommes libres, ils ne vivent que pour la compétition." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "L'équipe Verte - les descendants des cavaliers 'Celeres', au temps jadis du Royaume de Rome. Ils se considèrent comme l'élite parmi l'élite." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Reprendre la livraison des biens"},
    {TR_CONFIG_DIGIT_SEPARATOR, "Afficher un séparateur de milliers pour les nombres"},
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_LABOR, "Pas de main-d'œuvre" },
    {TR_WINDOW_BUILDING_DISTRIBUTION_GRANARY_CART_PUSHER_GETTING, "Le magasinier est parti chercher des vivres dans un autre grenier."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_RETURNING_WITH, "Le magasinier revient avec une livraison." },
    {TR_BUTTON_YEARLY_AUTOSAVE_OFF, "Sauvegarde auto /an OFF"},
    {TR_BUTTON_YEARLY_AUTOSAVE_ON, "Sauvegarde auto /an ON" },
    {TR_BUILDING_DOCK_PLAGUE_DESC, "La peste a été propagée ici par un navire marchand. Ce dock est mis en quarantaine le temps qu'un médecin ou chirurgien décontamine le secteur."},
    {TR_BUILDING_GRANARY_PLAGUE_DESC, "La peste a été propagée ici par un visiteur contaminé. Ce grenier est mis en quarantaine le temps qu'un médecin ou chirurgien décontamine le secteur."},
    {TR_BUILDING_WAREHOUSE_PLAGUE_DESC, "La peste a été propagée ici par un visiteur contaminé. Cet entrepôt est mis en quarantaine le temps qu'un médecin ou chirurgien décontamine le secteur."},
    {TR_BUILDING_HOUSE_DISEASE_DESC, "La peste a frappé ici en raison d'un manque d'hygiène, et certains résidents ont péri. Cette maison est mise en quarantaine le temps qu'un médecin ou chirurgien décontamine le secteur."},
    {TR_BUILDING_FUMIGATION_DESC, "Le bâtiment est en cours de désinfection. La fumigation devrait durer quelques jours."},
    {TR_OVERLAY_SICKNESS, "Maladies"},
    {TR_ADVISOR_SICKNESS_LEVEL_LOW, "Très peu de maladies surviennent dans la cité. Le niveau d'hygiène exemplaire de la grande majorité des résidents prévient efficacement la propagation des épidémies."},
    {TR_ADVISOR_SICKNESS_LEVEL_MEDIUM, "Quelques maladies infectieuses sont apparues dans des secteurs à l'hygiène perfectible, mais la situation reste sous contrôle. Veillez à un niveau d'hygiène adéquat afin de prévenir les épidémies."},
    {TR_ADVISOR_SICKNESS_LEVEL_HIGH, "De nombreuses maladies infectieuses se sont répandues dans des secteurs à l'hygiène défaillante. Si vous n'agissez pas rapidement, des bâtiments risquent de passer en quarantaine. Un meilleur accès aux structures d'hygiène permettrait d'enrayer les épidémies."},
    {TR_ADVISOR_SICKNESS_LEVEL_PLAGUE, "La peste s'est propagée dans les secteurs insalubres de la cité ! Des bâtiments sont mis en quarantaine ou incendiés pour endiguer l'épidémie, et médecins et chirurgiens sont envoyés décontaminer les lieux infectés."},
    {TR_TOOLTIP_OVERLAY_SICKNESS_NONE, "Aucune maladie"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_LOW, "Très peu de maladies"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_MEDIUM, "Quelques maladies infectieuses"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_HIGH, "De nombreuses maladies infectieuses circulent"},
    {TR_TOOLTIP_OVERLAY_SICKNESS_PLAGUE, "La peste se propage"},
    {TR_CITY_MESSAGE_TITLE_SICKNESS, "La peste dans la cité"},
    {TR_CITY_MESSAGE_TEXT_SICKNESS, "La peste s'est propagée dans la cité ! Un bâtiment a été placé en quarantaine, et un médecin ou chirurgien est réquisitionné pour le décontaminer."},
    {TR_FIGURES_CARTPUSHER_GOING_TO_ROME, "Va livrer la requête à Rome"},
    {TR_CITY_WARNING_DATA_COPY_SUCCESS, "Réglages copiés" },
    {TR_CITY_WARNING_DATA_COPY_NOT_SUPPORTED, "Impossible de copier des réglages pour ce bâtiment" },
    {TR_CITY_WARNING_DATA_PASTE_SUCCESS, "Réglages appliqués" },
    {TR_CITY_WARNING_DATA_PASTE_NOT_SUPPORTED, "Impossible d'appliquer des réglages à ce bâtiment" },
    {TR_CITY_WARNING_DATA_MOTHBALL_ON, "Le bâtiment est mis en pause" },
    {TR_CITY_WARNING_DATA_MOTHBALL_OFF, "Le bâtiment est maintenant actif" },
    {TR_HOTKEY_SHOW_OVERLAY_FOOD_STOCKS, "Stock Vivres"},
    {TR_HOTKEY_SHOW_OVERLAY_ENTERTAINMENT, "Loisirs" },
    {TR_HOTKEY_SHOW_OVERLAY_EDUCATION, "Éducation" },
    {TR_HOTKEY_SHOW_OVERLAY_SCHOOL, "Écoles" },
    {TR_HOTKEY_SHOW_OVERLAY_LIBRARY, "Bibliothèques" },
    {TR_HOTKEY_SHOW_OVERLAY_ACADEMY, "Universités" },
    {TR_HOTKEY_SHOW_OVERLAY_BARBER, "Barbiers" },
    {TR_HOTKEY_SHOW_OVERLAY_BATHHOUSE, "Thermes" },
    {TR_HOTKEY_SHOW_OVERLAY_CLINIC, "Dispensaires" },
    {TR_HOTKEY_SHOW_OVERLAY_HOSPITAL, "Hôpital" },
    {TR_HOTKEY_SHOW_OVERLAY_SICKNESS, "Maladies" },
    {TR_HOTKEY_SHOW_OVERLAY_TAX_INCOME, "Impôts" },
    {TR_HOTKEY_SHOW_OVERLAY_DESIRABILITY, "Attrait" },
    {TR_HOTKEY_SHOW_OVERLAY_SENTIMENT, "Humeur" },
    {TR_HOTKEY_SHOW_OVERLAY_MOTHBALL, "En pause" },
    {TR_HOTKEY_SHOW_OVERLAY_RELIGION, "Religion" },
    {TR_HOTKEY_SHOW_OVERLAY_ROADS, "Routes" },
    {TR_HOTKEY_SHOW_OVERLAY_LEVY, "Frais" },
    {TR_HOTKEY_ROTATE_MAP_NORTH, "Orienter la carte au Nord" },
    {TR_HOTKEY_BUILD_WHEAT_FARM, "Ferme (Blé)" },
    {TR_HOTKEY_SHOW_MESSAGES, "Afficher les messages"},
    {TR_HOTKEY_SHOW_EMPIRE_MAP, "Afficher la carte de l'Empire"},
    {TR_TOGGLE_GRID, "Grille (on/off)"},
    {TR_WARNING_SCREENSHOT_SAVED, "Capture d'écran enregistrée : "},
    {TR_OUT_OF_MONEY, "Faillite"},
    {TR_CITY_MESSAGE_TITLE_EMPERORS_WRATH, "Fureur de l'Empereur" },
    {TR_CITY_MESSAGE_TEXT_EMPERORS_WRATH, "Vous êtes tombé en disgrâce auprès de César et ce dernier a ordonné votre arrestation. À moins d'améliorer l'estime que l'Empereur vous porte, ses légions d'élite envahiront bientôt votre cité !" },
    {TR_BUILDING_ACADEMY_UPGRADE_DESC, "Cette université est opérationnelle. Le développement de la zone a permis d'agrandir le bâtiment. De nombreuses conférences et recherches peuvent à présent s'y tenir."},
    {TR_BUILDING_PALISADE_GATE, "Portail de palissade"},
    {TR_BUILDING_PALISADE_GATE_DESC, "Cet étroit portail en bois permet de contrôler le passage des citoyens à travers les défenses de la cité."},
    {TR_SAVE_DIALOG_INVALID_FILE, "Fichier invalide"},
    {TR_SAVE_DIALOG_SELECT_FILE, "Choisir un fichier"},
    {TR_SAVE_DIALOG_FUNDS, "Fonds :"},
    {TR_SAVE_DIALOG_POPULATION, "Population :"},
    {TR_SAVE_DIALOG_DATE, "Date :"},
    {TR_SAVE_DIALOG_CUSTOM_SCENARIO, "Scénario bâtisseur"},
    {TR_SAVE_DIALOG_FIRST_MISSION, "Première mission"},
    {TR_SAVE_DIALOG_MISSION, "Mission"},
    {TR_SAVE_DIALOG_MILITARY, "Dangereuse"},
    {TR_SAVE_DIALOG_PEACEFUL, "Paisible"},
    {TR_CITY_MESSAGE_TITLE_MARS_MINOR_CURSE_PREVENTED, "Courroux de Mars" },
    {TR_CITY_MESSAGE_TEXT_MARS_MINOR_CURSE_PREVENTED, "Mars est furieux! Nous avons peu à craindre sur des terres aussi paisibles, mais prenez garde, la paix n'est jamais éternelle !" },
    {TR_TOOLTIP_MONUMENT_PHASE, " phase. "},
    {TR_TOOLTIP_MONUMENT_PHASES, " phases. "},
    {TR_TOOLTIP_MONUMENT_RESOURCE_REQUIREMENTS, "Ressources nécessaires :\n"},
    {TR_BUILDING_GLADIATOR_STATUE, "Statue de gladiateur"},
    {TR_ADVISOR_NO_ACTIVE_COLOSSEUM, "Aucun colisée actif dans la cité"},
    {TR_ADVISOR_ACTIVE_COLOSSEUM, "La cité jouit d'un colisée"},
    {TR_ADVISOR_NO_ACTIVE_HIPPODROME, "Aucun hippodrome actif dans la cité"},
    {TR_ADVISOR_ACTIVE_HIPPODROME, "La cité jouit d'un hippodrome"},
    {TR_WINDOW_ADVISOR_EDUCATION_MISSION_POSTS, "Missions"},
    {TR_CITY_MESSAGE_TITLE_ENEMIES_LEAVING, "L'ennemi se retire"},
    {TR_CITY_MESSAGE_TEXT_ENEMIES_LEAVING, "Humpf! Votre cité de pacotille n'a plus rien d'intéressant à détruire. Nous partons pour l'instant, mais rassurez-vous, nous reviendrons très vite !"},
    {TR_ZOOM, "Zoom :"},    
    {TR_WINDOW_ASSET_PREVIEWER_TITLE, "Visionneuse d'assets"},
    {TR_WINDOW_ASSET_PREVIEWER_GROUP, "Groupe :"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_GROUPS, "( aucun groupe )"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN, "Terrain :"},
    {TR_WINDOW_ASSET_PREVIEWER_PLAY_ANIMATIONS, "Jouer animations"},
    {TR_WINDOW_ASSET_PREVIEWER_REFRESH, "Actualiser"},
    {TR_WINDOW_ASSET_PREVIEWER_QUIT, "Quitter"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSET, "Asset :"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NONE, "Aucun" },
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_CENTRAL, "Central"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_NORTHERN, "Nord"},
    {TR_WINDOW_ASSET_PREVIEWER_TERRAIN_DESERT, "Désert"},
    {TR_WINDOW_ASSET_PREVIEWER_NO_ASSETS, "Pas d'assets"},
    {TR_WINDOW_ASSET_PREVIEWER_UNNAMED_ASSET, "( asset sans nom )"},
    {TR_WINDOW_ASSET_PREVIEWER_ANIMATION_FRAME, "( frame d'animation )"},
    {TR_WINDOW_ASSET_PREVIEWER_SHOW_ANIMATION_FRAMES, "Voir frames d'animation"},
    {TR_WINDOW_ASSET_PREVIEWER_ASSETS_REFRESHED, "Assets actualisés"},
    {TR_CHEAT_ADDED_MONEY, "Fonds ajoutés"},
    {TR_CHEAT_STARTED_INVASION, "Invasion lancée"},
    {TR_CHEAT_YEAR_ADVANCED, "Année suivante"},
    {TR_CHEAT_CASTED_BLESSING, "Bénédiction reçue"},
    {TR_CHEAT_TOGGLE_TOOLTIPS, "Infobulles on/off"},
    {TR_CHEAT_KILLED_ALL_WALKERS, "Tous les marcheurs tués"},
    {TR_CHEAT_FINISHED_MONUMENTS, "Monuments terminés"},
    {TR_CHEAT_UPDATED_MONUMENTS, "Monuments mis à jour"},
    {TR_CHEAT_UNLOCKED_ALL_BUILDINGS, "Tous les bâtiments débloqués"},
    {TR_CHEAT_INCITED_RIOT, "Émeute déclenchée"}
};

void translation_french(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
