### Requirements for Contributing a Performance Improvement

* Fill out the template below. Any pull request that does not include enough information to be reviewed in a timely manner may be closed at the maintainers' discretion.
* The pull request must only affect performance of existing functionality. To contribute other changes, you must use a different template. You can see all templates at https://github.com/atom/atom/tree/master/.github/PULL_REQUEST_TEMPLATE.
* After you create the pull request, all status checks must be pass before a maintainer reviews your contribution. For more details, please see https://github.com/atom/atom/tree/master/CONTRIBUTING.md#pull-requests.

### Description of the Change

<!--

We must be able to understand the design of your change from this description. If we can't get a good idea of what the code will be doing from the description here, the pull request may be closed at the maintainers' discretion. Keep in mind that the maintainer reviewing this PR may not be familiar with or have worked with the code here recently, so please walk us through the concepts.

-->

### Quantitative Performance Benefits

<!--

Describe the exact performance improvement observed (for example, reduced time to complete an operation, reduced memory use, etc.). Describe how you measured this change. Bonus points for including graphs that demonstrate the improvement or attached dumps from the built-in profiling tools.

-->

### Possible Drawbacks

<!-- What are the possible side-effects or negative impacts of the code change? -->

### Verification Process

<!--

What process did you follow to verify that the change has not introduced any regressions? Describe the actions you performed (including buttons you clicked, text you typed, commands you ran, etc.), and describe the results you observed.

-->

### Applicable Issues

<!-- Enter any applicable Issues here -->

### Release Notes

<!--

Please describe the changes in a single line that explains this improvement in
terms that a user can understand.  This text will be used in Atom's release notes.

If this change is not user-facing or notable enough to be included in release notes
you may use the strings "Not applicable" or "N/A" here.

Examples:

- The GitHub package now allows you to add co-authors to commits.
- Fixed an issue where multiple cursors did not work in a file with a single line.
- Increased the performance of searching and replacing across a whole project.

-->
