## Highlights from the past week

- Atom core
  - Separated keyboard enablement from "readOnly" TextEditor state in [atom/atom#17124](https://github.com/atom/atom/pull/17124).
- GitHub Package
  - Completed, merged, and shipped "Create pull request" [atom/github#1376](https://github.com/atom/github/pull/1376), which I used to open this pull request :wink:
  - Updated to Enzyme 3 [atom/github#1386](https://github.com/atom/github/pull/1386) which paves the way for us to upgrade React.
  - Started investigating code coverage to better understand what code lies untested.
  - Fixed broken snapshot tests in atom core.
  - Released version 0.14.0
- Teletype
  - Fixed an issue that could occur when attempting to join a portal that no longer exists while also trying to share a portal ([atom/teletype#357](https://github.com/atom/teletypeissues/atom/teletype/357))
  - Fixed an issue that could occur when existing portal participants are performing actions while a new participant is joining ([atom/teletype#360](https://github.com/atom/teletypeissues/atom/teletype/360))
  - Fixed an issue that prevented mouse clicks from placing the cursor on certain lines while participating in a portal ([atom/teletype#362](https://github.com/atom/teletypeissues/atom/teletype/362))
  - Published [Teletype 0.12.2](https://github.com/atom/teletype/releases/tag/v0.12.2) with the above improvements
- Xray
  - More progress on the RPC system supporting shared workspaces
  - See the [in-depth update](https://github.com/atom/xray/blob/master/docs/updates/2018_04_16.md) for more details
- Reactor Duty
  - Fixed an issue when [using autocomplete-plus in conjunction with `_` configured as a non-word character](https://github.com/atom/autocomplete-plus/issues/956#issuecomment-374303376) ([atom/autocomplete-plus#956](https://github.com/atom/autocomplete-plus/issues/956)) Thanks, [@ariasuni](https://github.com/ariasuni)!
  - Fixed an issue where the wrong items would appear as collapsed in the search results
([atom/find-and-replace#916](https://github.com/atom/find-and-replace/issues/916)). Thanks, [@Lassi](https://github.com/Lassi)!
  - Fixed an issue that prevented snippets with nested tab stops from expanding correctly ([atom/snippets#266](https://github.com/atom/snippets/issues/266)). Thanks, [@savetheclocktower](https://github.com/savetheclocktower)!
  - Fixed an issue that would sometimes prevent the spell-check package from activating ([atom/spell-check#67](https://github.com/atom/spell-check/issues/67#issuecomment-377808833))
  - Shipped [1.26.0-beta2](https://github.com/atom/atom/releases/tag/v1.26.0-beta2)

## Focus for week ahead

- Atom
  - Ship Atom 1.26.0 and 1.27.0-beta0 releases
- Atom IDE
  - Start preparing launch announcement for debugging support
- GitHub Package
  - Update React to 16.3 (@smashwilson)
  - Get [atom/squeegpg](https://github.com/atom/squeegpg) to the point where we can use it to sign a commit from atom/github (without needing to override the pinentry yet). (@smashwilson)
  - Get code coverage working. (@annthurium)
- Teletype
  - Publish RFC for more quickly collaborating with coworkers and friends ([atom/teletype#344](https://github.com/atom/teletype/pull/344))
  - Improve ability to tell which cursor belongs to which collaborator ([atom/teletype#338](https://github.com/atom/teletype/issues/338))
- Tree-sitter
  - Start work on making syntax trees fully persistent so that they can be used in Xray on multiple threads.
- Xray
  - Merge [initial implementation of shared workspaces](https://github.com/atom/xray/pull/61)
