# How to Contribute to asdf

There are many ways to contribute to `asdf`, thanks for taking the time to read and help.

## `asdf` Core

### Did you find a bug?

Ensure the bug is actually an issue with asdf and not a plugin. If the bug only occurs when using one tool installed by `asdf` and not others it is likely an issue with the **plugin**. Find the plugin repo URL with `asdf plugin list --urls`, browse their repo Issues and if no solution is found open a new Issue there.

Ensure the bug was not already reported in existing [Issues](https://github.com/asdf-vm/asdf/issues). If not, then please [open a new Issue](https://github.com/asdf-vm/asdf/issues/new/choose). Please be as specific as possible when reporting the issue.

### New Features/Proposals

Please [open a new Feature Request](https://github.com/asdf-vm/asdf/issues/new/choose) to discuss the feature before implementing a solution.

### Developing with the Core

See [docs/contribute/core.md](docs/contribute/core.md) or on our [Docs Site](https://asdf-vm.com/contribute/core.html).

## Documentation

Documentation can always be improved! See [docs/contribute/documentation.md](docs/contribute/documentation.md) or on our [Docs Site](https://asdf-vm.com/contribute/documentation.html).

## First-Party Plugins

We always need help to maintain our plugins. See [docs/contribute/first-party-plugins.md](docs/contribute/first-party-plugins.md) or on our [Docs Site](https://asdf-vm.com/contribute/first-party-plugins.html).

## Create a Plugin?

Please read the [docs/plugins/create.md](docs/plugins/create.md) or on our [Docs Site](https://asdf-vm.com/plugins/create.html).

## GitHub Action

See the [asdf actions repo](https://github.com/asdf-vm/actions) for existing Issues, conversations and Contributing Guidelines.

---

Thanks for contributing!
