# Hyphenation patterns for Text::Hyphen in Ruby: Basque
#   Converted from the TeX hyphenation/bahyph.tex file, by Juan M.
#   Aguirregabiria (wtpagagj@lg.ehu.es) in 1997 based on work by Julio
#   Sanchez (jsanchez@gmv.es) in 1991.
#
# The original copyright holds and is reproduced in the source to this file.
# The Ruby version of these patterns are copyright 2004 Austin Ziegler.
#--
# Hyphenation patterns for Basque.
# This file has been written by Juan M. Aguirregabiria (wtpagagj@lg.ehu.es)
# on February 1997 and is based on the shyphen.sh script that generates the
# Spanish patterns as compiled by Julio Sanchez (jsanchez@gmv.es) on
# September 1991. The original Copyright follows and applies also to this
# file whose last version will be always available by anonymous ftp from
# tp.lc.ehu.es or by poynting your Web browser to
# http://tp.lc.ehu.es/basque.html
#
# Hyphenation patterns for Spanish.
# Compiled by Julio Sanchez (jsanchez@gmv.es) on September 1991. These
# patterns have been derived from "On Word Division in Spanish", Jos'e A.
# Ma~nas, Communications of the ACM, and implemented in his package ftc. You
# can get ftc and a draft of the abovementioned paper from goya.dit.upm.es
# in src/text.proc/ftc.Z. FTP access may be available. Otherwise, send help
# to info@goya.dit.upm.es for details on use of the mail server.
#
# Rules mentioned below are those described in that paper. After several
# unsatisfactory attempts to pretend I knew better, these patterns closely
# follow that paper. Pattern 'tl' is not considered. It is conflictive and
# ftc does not use it either.
#
# These patterns have been generated by shyphen.sh version 1.0, shyphen.sh
# is a sh script that allows a number of choices. Full benefit from some of
# these options can only be obtained if appropriate fonts are available.
#
# Follows a copyright notice. This is not in the public domain, but the
# copyright is essentially a hold-harmless clause. That is, use it at will,
# but don't sue me if you don't like it.
#
#			COPYRIGHT NOTICE
#
# These patterns and the generating sh script are Copyright (c) GMV 1991
# These patterns were developed for internal GMV use and are made public in
# the hope that they will benefit others. Also, spreading these patterns
# throughout the Spanish-language TeX community is expected to provide
# back-benefits to GMV in that it can help keeping GMV in the mainstream of
# spanish users. However, this is given for free and WITHOUT ANY WARRANTY.
# Under no circumstances can Julio Sanchez, GMV, Jos'e A. Ma~nas or any
# agents or representatives thereof be held responsible for any errors in
# this software nor for any damages derived from its use, even in case any
# of the above has been notified of the possibility of such damages. If any
# such situation arises, you responsible for repair. Use of this software is
# an explicit acceptance of these conditions. 
# 
# You can use this software for any purpose. You cannot delete this
# copyright notice. If you change this software, you must include comments
# explaining who, when and why. You are kindly requested to send any changes
# to tex@gmv.es. If you change the generating script, you must include code
# in it such that any output is clearly labeled as generated by a modified
# script.
#
# Despite the lack of warranty, we would like to hear about any problem you
# find. Please report problems to tex@gmv.es.
#
#               END OF COPYRIGHT NOTICE
#
# Options included in this set: basic
# Open vowels: a e o
# Closed vowels: i u
# Consonants: b c d f g j k l m n p q r s t v w x y z
#
# Some of the patterns below represent combinations that never happen in
# Basque. Would they happen, they would be hyphenated according to the
# rules.
#
# This keeps {cat|lc}code changes, if any, local. Nice to users of
# multilingual versions. These are the minimum changes needed to process the
# patterns. These and other changes will have to be re-enacted when Basque
# be established as the current language. See the babel docs if you don't
# understand this.
#++
require 'text/hyphen/language'

Text::Hyphen::Language::EU = Text::Hyphen::Language.new do |lang|
  lang.patterns <<-PATTERNS
  % Rule SR1
  % Vowels are kept together by the defaults

  % Rule SR2
  % Attach vowel groups to left consonant
1ba 1be 1bo 1bi 1bu 1ca 1ce 1co 1ci 1cu 1da 1de 1do 1di 1du 1fa 1fe 1fo 1fi
1fu 1ga 1ge 1go 1gi 1gu 1ja 1je 1jo 1ji 1ju 1ka 1ke 1ko 1ki 1ku 1la 1le 1lo
1li 1lu 1ma 1me 1mo 1mi 1mu 1na 1ne 1no 1ni 1nu 1pa 1pe 1po 1pi 1pu 1qa 1qe
1qo 1qi 1qu 1ra 1re 1ro 1ri 1ru 1sa 1se 1so 1si 1su 1ta 1te 1to 1ti 1tu 1va
1ve 1vo 1vi 1vu 1wa 1we 1wo 1wi 1wu 1xa 1xe 1xo 1xi 1xu 1ya 1ye 1yo 1yi 1yu
1za 1ze 1zo 1zi 1zu 

  % Rule SR3
  % Build legal consonant groups, leave other consonants bound to 
  % the previous group. This overrides part of the SR2 pattern
  % group.
1l2la 1l2le 1l2lo 1l2li 1l2lu 1r2ra 1r2re 1r2ro 1r2ri 1r2ru 1t2sa 1t2se
1t2so 1t2si 1t2su 1t2xa 1t2xe 1t2xo 1t2xi 1t2xu 1t2za 1t2ze 1t2zo 1t2zi
1t2zu 1b2la 1b2le 1b2lo 1b2li 1b2lu 1b2ra 1b2re 1b2ro 1b2ri 1b2ru 1d2ra
1d2re 1d2ro 1d2ri 1d2ru 1f2la 1f2le 1f2lo 1f2li 1f2lu 1f2ra 1f2re 1f2ro
1f2ri 1f2ru 1g2la 1g2le 1g2lo 1g2li 1g2lu 1g2ra 1g2re 1g2ro 1g2ri 1g2ru
1k2la 1k2le 1k2lo 1k2li 1k2lu 1k2ra 1k2re 1k2ro 1k2ri 1k2ru 1p2la 1p2le
1p2lo 1p2li 1p2lu 1p2ra 1p2re 1p2ro 1p2ri 1p2ru 1t2ra 1t2re 1t2ro 1t2ri
1t2ru 
  % We now avoid some problematic breaks.
su2b2r su2b2l
  PATTERNS
end
