////////////////////////////////////////////////////////////////////////////////
/// @brief Adopt syslog compfort headers from linux
////////////////////////////////////////////////////////////////////////////////
/*
 * Copyright (c) 1982, 1986, 1988, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)syslog.h    8.1 (Berkeley) 6/2/93
 */
typedef struct _code {
  const char* c_name;
  int c_val;
} CODE;

CODE prioritynames[] = {{"alert", LOG_ALERT},     {"crit", LOG_CRIT},
                        {"debug", LOG_DEBUG},     {"emerg", LOG_EMERG},
                        {"err", LOG_ERR},         {"error", LOG_ERR},
                        {"warning", LOG_WARNING}, {NULL, -1}};

CODE facilitynames[] = {{"auth", LOG_AUTH},
#ifdef LOG_AUTHPRIV
                        {"authpriv", LOG_AUTHPRIV},
#endif
                        {"cron", LOG_CRON},         {"daemon", LOG_DAEMON},
#ifdef LOG_FTP
                        {"ftp", LOG_FTP},
#endif
                        {"kern", LOG_KERN},         {"lpr", LOG_LPR},
                        {"mail", LOG_MAIL},         {"news", LOG_NEWS},
                        {"syslog", LOG_SYSLOG},     {"user", LOG_USER},
                        {"uucp", LOG_UUCP},         {"local0", LOG_LOCAL0},
                        {"local1", LOG_LOCAL1},     {"local2", LOG_LOCAL2},
                        {"local3", LOG_LOCAL3},     {"local4", LOG_LOCAL4},
                        {"local5", LOG_LOCAL5},     {"local6", LOG_LOCAL6},
                        {"local7", LOG_LOCAL7},     {NULL, -1}};
