
find_program (SNAP_EXE snapcraft)
if(EXISTS ${SNAP_EXE})
  set(SNAPCRAFT_FOUND ON)
endif()

if(SNAPCRAFT_FOUND)
  set(SNAPCRAFT_TEMPLATE_DIR "${CMAKE_CURRENT_SOURCE_DIR}/Installation/Ubuntu")
  set(SNAPCRAFT_SOURCE_DIR "${CMAKE_BINARY_DIR}/_CPack_Packages/SNAP")

  message(STATUS "Creating snap package")

  if (VERBOSE)
    message(STATUS "CPACK_PACKAGE_FILE_NAME :" ${CPACK_PACKAGE_FILE_NAME})
    message(STATUS "SNAPCRAFT_TEMPLATE_DIR: " ${SNAPCRAFT_TEMPLATE_DIR})
    message(STATUS "SNAPCRAFT_SOURCE_DIR: " ${SNAPCRAFT_SOURCE_DIR})
  endif ()

#  set(SNAP_PORT 8529)
  set(CPACK_STRIP_FILES ON)
  set(CMAKE_INSTALL_PREFIX "/")

  configure_file(
    "${SNAPCRAFT_TEMPLATE_DIR}/snapcraft.yaml.in"
    "${SNAPCRAFT_SOURCE_DIR}/snapcraft.yaml"
    NEWLINE_STYLE UNIX
    @ONLY
  )

  file(
    COPY        "${SNAPCRAFT_TEMPLATE_DIR}/arangodb.png"
    DESTINATION "${SNAPCRAFT_SOURCE_DIR}/"
    )
  
  add_custom_target(snap
    COMMENT "create snap-package"
    COMMAND ${SNAP_EXE} clean ${CPACK_PACKAGE_NAME}
    COMMAND ${SNAP_EXE} snap
    COMMAND ${CMAKE_COMMAND} -E copy ${SNAPCRAFT_SOURCE_DIR}/${CPACK_PACKAGE_NAME}_${CPACK_PACKAGE_VERSION}*_${ARANGODB_PACKAGE_ARCHITECTURE}.snap ${PROJECT_BINARY_DIR}
    DEPENDS TGZ_package
    WORKING_DIRECTORY ${SNAPCRAFT_SOURCE_DIR}
  )

  add_custom_target(copy_snap_packages
    COMMAND ${CMAKE_COMMAND} -E copy ${CPACK_PACKAGE_NAME}_${CPACK_PACKAGE_VERSION}*_${ARANGODB_PACKAGE_ARCHITECTURE}.snap ${PACKAGE_TARGET_DIR})

  list(APPEND COPY_PACKAGES_LIST copy_snap_packages)

  list(APPEND PACKAGES_LIST snap)
endif()
