////////////////////////////////////////////////////////////////////////////////
/// DISCLAIMER
///
/// Copyright 2021-2021 ArangoDB GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is ArangoDB GmbH, Cologne, Germany
///
/// @author Michael Hackstein
////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "Aql/Expression.h"

#include <memory>
#include <vector>

namespace arangodb {

namespace aql {

/// @brief struct to hold the member-indexes in the _condition node
struct NonConstExpression {
  std::unique_ptr<Expression> expression;
  std::vector<size_t> const indexPath;

  NonConstExpression(std::unique_ptr<Expression> exp, std::vector<size_t> idxPath);
};

}
}
