@startDocuBlock general_graph_vertex_create_http_examples
@brief create a new vertex

@RESTHEADER{POST /_api/gharial/{graph}/vertex/{collection}, Create a vertex}

@RESTDESCRIPTION
Adds a vertex to the given collection.

@RESTURLPARAMETERS

@RESTURLPARAM{graph,string,required}
The name of the graph.

@RESTURLPARAM{collection,string,required}
The name of the vertex collection the vertex should be inserted into.

@RESTQUERYPARAMETERS

@RESTQUERYPARAM{waitForSync,boolean,optional}
Define if the request should wait until synced to disk.

@RESTQUERYPARAM{returnNew,boolean,optional}
Define if the response should contain the complete
new version of the document.

@RESTALLBODYPARAM{vertex,object,required}
The body has to be the JSON object to be stored.

@RESTRETURNCODES

@RESTRETURNCODE{201}
Returned if the vertex could be added and waitForSync is true.

@RESTREPLYBODY{error,boolean,required,}
Flag if there was an error (true) or not (false).
It is false in this response.

@RESTREPLYBODY{code,integer,required,}
The response code.

@RESTREPLYBODY{vertex,object,required,vertex_representation}
The internal attributes for the vertex.

@RESTREPLYBODY{new,object,optional,vertex_representation}
The complete newly written vertex document.
Includes all written attributes in the request body
and all internal attributes generated by ArangoDB.
Will only be present if returnNew is true.

@RESTRETURNCODE{202}
Returned if the request was successful but waitForSync is false.

@RESTREPLYBODY{error,boolean,required,}
Flag if there was an error (true) or not (false).
It is false in this response.

@RESTREPLYBODY{code,integer,required,}
The response code.

@RESTREPLYBODY{vertex,object,required,vertex_representation}
The internal attributes generated while storing the vertex.
Does not include any attribute given in request body.

@RESTREPLYBODY{new,object,optional,vertex_representation}
The complete newly written vertex document.
Includes all written attributes in the request body
and all internal attributes generated by ArangoDB.
Will only be present if returnNew is true.

@RESTRETURNCODE{403}
Returned if your user has insufficient rights.
In order to insert vertices into the graph  you at least need to have the following privileges:<br>
  1. `Read Only` access on the Database.
  2. `Write` access on the given collection.

@RESTREPLYBODY{error,boolean,required,}
Flag if there was an error (true) or not (false).
It is true in this response.

@RESTREPLYBODY{code,integer,required,}
The response code.

@RESTREPLYBODY{errorNum,integer,required,}
ArangoDB error number for the error that occurred.

@RESTREPLYBODY{errorMessage,string,required,}
A message created for this error.

@RESTRETURNCODE{404}
Returned if no graph with this name could be found.
Or if a graph is found but this collection is not part of the graph.

@RESTREPLYBODY{error,boolean,required,}
Flag if there was an error (true) or not (false).
It is true in this response.

@RESTREPLYBODY{code,integer,required,}
The response code.

@RESTREPLYBODY{errorNum,integer,required,}
ArangoDB error number for the error that occurred.

@RESTREPLYBODY{errorMessage,string,required,}
A message created for this error.

@EXAMPLES

@EXAMPLE_ARANGOSH_RUN{HttpGharialAddVertex}
  var examples = require("@arangodb/graph-examples/example-graph.js");
~ examples.dropGraph("social");
  examples.loadGraph("social");
  var url = "/_api/gharial/social/vertex/male";
  body = {
    name: "Francis"
  }
  var response = logCurlRequest('POST', url, body);

  assert(response.code === 202);

  logJsonResponse(response);
  examples.dropGraph("social");
@END_EXAMPLE_ARANGOSH_RUN
@endDocuBlock
