#include "unicorn/ucd-tables.hpp"

namespace RS::Unicorn::UnicornDetail {

const std::array<KeyValue<char32_t, PackedPair<long long>>, 1589> numeric_value_array = {{
{0x0,{0,1}},
{0x31,{1,1}},
{0x32,{2,1}},
{0x33,{3,1}},
{0x34,{4,1}},
{0x35,{5,1}},
{0x36,{6,1}},
{0x37,{7,1}},
{0x38,{8,1}},
{0x39,{9,1}},
{0x3a,{0,1}},
{0xb2,{2,1}},
{0xb3,{3,1}},
{0xb4,{0,1}},
{0xb9,{1,1}},
{0xba,{0,1}},
{0xbc,{1,4}},
{0xbd,{1,2}},
{0xbe,{3,4}},
{0xbf,{0,1}},
{0x661,{1,1}},
{0x662,{2,1}},
{0x663,{3,1}},
{0x664,{4,1}},
{0x665,{5,1}},
{0x666,{6,1}},
{0x667,{7,1}},
{0x668,{8,1}},
{0x669,{9,1}},
{0x66a,{0,1}},
{0x6f1,{1,1}},
{0x6f2,{2,1}},
{0x6f3,{3,1}},
{0x6f4,{4,1}},
{0x6f5,{5,1}},
{0x6f6,{6,1}},
{0x6f7,{7,1}},
{0x6f8,{8,1}},
{0x6f9,{9,1}},
{0x6fa,{0,1}},
{0x7c1,{1,1}},
{0x7c2,{2,1}},
{0x7c3,{3,1}},
{0x7c4,{4,1}},
{0x7c5,{5,1}},
{0x7c6,{6,1}},
{0x7c7,{7,1}},
{0x7c8,{8,1}},
{0x7c9,{9,1}},
{0x7ca,{0,1}},
{0x967,{1,1}},
{0x968,{2,1}},
{0x969,{3,1}},
{0x96a,{4,1}},
{0x96b,{5,1}},
{0x96c,{6,1}},
{0x96d,{7,1}},
{0x96e,{8,1}},
{0x96f,{9,1}},
{0x970,{0,1}},
{0x9e7,{1,1}},
{0x9e8,{2,1}},
{0x9e9,{3,1}},
{0x9ea,{4,1}},
{0x9eb,{5,1}},
{0x9ec,{6,1}},
{0x9ed,{7,1}},
{0x9ee,{8,1}},
{0x9ef,{9,1}},
{0x9f0,{0,1}},
{0x9f4,{1,16}},
{0x9f5,{1,8}},
{0x9f6,{3,16}},
{0x9f7,{1,4}},
{0x9f8,{3,4}},
{0x9f9,{16,1}},
{0x9fa,{0,1}},
{0xa67,{1,1}},
{0xa68,{2,1}},
{0xa69,{3,1}},
{0xa6a,{4,1}},
{0xa6b,{5,1}},
{0xa6c,{6,1}},
{0xa6d,{7,1}},
{0xa6e,{8,1}},
{0xa6f,{9,1}},
{0xa70,{0,1}},
{0xae7,{1,1}},
{0xae8,{2,1}},
{0xae9,{3,1}},
{0xaea,{4,1}},
{0xaeb,{5,1}},
{0xaec,{6,1}},
{0xaed,{7,1}},
{0xaee,{8,1}},
{0xaef,{9,1}},
{0xaf0,{0,1}},
{0xb67,{1,1}},
{0xb68,{2,1}},
{0xb69,{3,1}},
{0xb6a,{4,1}},
{0xb6b,{5,1}},
{0xb6c,{6,1}},
{0xb6d,{7,1}},
{0xb6e,{8,1}},
{0xb6f,{9,1}},
{0xb70,{0,1}},
{0xb72,{1,4}},
{0xb73,{1,2}},
{0xb74,{3,4}},
{0xb75,{1,16}},
{0xb76,{1,8}},
{0xb77,{3,16}},
{0xb78,{0,1}},
{0xbe7,{1,1}},
{0xbe8,{2,1}},
{0xbe9,{3,1}},
{0xbea,{4,1}},
{0xbeb,{5,1}},
{0xbec,{6,1}},
{0xbed,{7,1}},
{0xbee,{8,1}},
{0xbef,{9,1}},
{0xbf0,{10,1}},
{0xbf1,{100,1}},
{0xbf2,{1000,1}},
{0xbf3,{0,1}},
{0xc67,{1,1}},
{0xc68,{2,1}},
{0xc69,{3,1}},
{0xc6a,{4,1}},
{0xc6b,{5,1}},
{0xc6c,{6,1}},
{0xc6d,{7,1}},
{0xc6e,{8,1}},
{0xc6f,{9,1}},
{0xc70,{0,1}},
{0xc79,{1,1}},
{0xc7a,{2,1}},
{0xc7b,{3,1}},
{0xc7c,{1,1}},
{0xc7d,{2,1}},
{0xc7e,{3,1}},
{0xc7f,{0,1}},
{0xce7,{1,1}},
{0xce8,{2,1}},
{0xce9,{3,1}},
{0xcea,{4,1}},
{0xceb,{5,1}},
{0xcec,{6,1}},
{0xced,{7,1}},
{0xcee,{8,1}},
{0xcef,{9,1}},
{0xcf0,{0,1}},
{0xd67,{1,1}},
{0xd68,{2,1}},
{0xd69,{3,1}},
{0xd6a,{4,1}},
{0xd6b,{5,1}},
{0xd6c,{6,1}},
{0xd6d,{7,1}},
{0xd6e,{8,1}},
{0xd6f,{9,1}},
{0xd70,{10,1}},
{0xd71,{100,1}},
{0xd72,{1000,1}},
{0xd73,{1,4}},
{0xd74,{1,2}},
{0xd75,{3,4}},
{0xd76,{0,1}},
{0xde7,{1,1}},
{0xde8,{2,1}},
{0xde9,{3,1}},
{0xdea,{4,1}},
{0xdeb,{5,1}},
{0xdec,{6,1}},
{0xded,{7,1}},
{0xdee,{8,1}},
{0xdef,{9,1}},
{0xdf0,{0,1}},
{0xe51,{1,1}},
{0xe52,{2,1}},
{0xe53,{3,1}},
{0xe54,{4,1}},
{0xe55,{5,1}},
{0xe56,{6,1}},
{0xe57,{7,1}},
{0xe58,{8,1}},
{0xe59,{9,1}},
{0xe5a,{0,1}},
{0xed1,{1,1}},
{0xed2,{2,1}},
{0xed3,{3,1}},
{0xed4,{4,1}},
{0xed5,{5,1}},
{0xed6,{6,1}},
{0xed7,{7,1}},
{0xed8,{8,1}},
{0xed9,{9,1}},
{0xeda,{0,1}},
{0xf21,{1,1}},
{0xf22,{2,1}},
{0xf23,{3,1}},
{0xf24,{4,1}},
{0xf25,{5,1}},
{0xf26,{6,1}},
{0xf27,{7,1}},
{0xf28,{8,1}},
{0xf29,{9,1}},
{0xf2a,{1,2}},
{0xf2b,{3,2}},
{0xf2c,{5,2}},
{0xf2d,{7,2}},
{0xf2e,{9,2}},
{0xf2f,{11,2}},
{0xf30,{13,2}},
{0xf31,{15,2}},
{0xf32,{17,2}},
{0xf33,{-1,2}},
{0xf34,{0,1}},
{0x1041,{1,1}},
{0x1042,{2,1}},
{0x1043,{3,1}},
{0x1044,{4,1}},
{0x1045,{5,1}},
{0x1046,{6,1}},
{0x1047,{7,1}},
{0x1048,{8,1}},
{0x1049,{9,1}},
{0x104a,{0,1}},
{0x1091,{1,1}},
{0x1092,{2,1}},
{0x1093,{3,1}},
{0x1094,{4,1}},
{0x1095,{5,1}},
{0x1096,{6,1}},
{0x1097,{7,1}},
{0x1098,{8,1}},
{0x1099,{9,1}},
{0x109a,{0,1}},
{0x1369,{1,1}},
{0x136a,{2,1}},
{0x136b,{3,1}},
{0x136c,{4,1}},
{0x136d,{5,1}},
{0x136e,{6,1}},
{0x136f,{7,1}},
{0x1370,{8,1}},
{0x1371,{9,1}},
{0x1372,{10,1}},
{0x1373,{20,1}},
{0x1374,{30,1}},
{0x1375,{40,1}},
{0x1376,{50,1}},
{0x1377,{60,1}},
{0x1378,{70,1}},
{0x1379,{80,1}},
{0x137a,{90,1}},
{0x137b,{100,1}},
{0x137c,{10000,1}},
{0x137d,{0,1}},
{0x16ee,{17,1}},
{0x16ef,{18,1}},
{0x16f0,{19,1}},
{0x16f1,{0,1}},
{0x17e1,{1,1}},
{0x17e2,{2,1}},
{0x17e3,{3,1}},
{0x17e4,{4,1}},
{0x17e5,{5,1}},
{0x17e6,{6,1}},
{0x17e7,{7,1}},
{0x17e8,{8,1}},
{0x17e9,{9,1}},
{0x17ea,{0,1}},
{0x17f1,{1,1}},
{0x17f2,{2,1}},
{0x17f3,{3,1}},
{0x17f4,{4,1}},
{0x17f5,{5,1}},
{0x17f6,{6,1}},
{0x17f7,{7,1}},
{0x17f8,{8,1}},
{0x17f9,{9,1}},
{0x17fa,{0,1}},
{0x1811,{1,1}},
{0x1812,{2,1}},
{0x1813,{3,1}},
{0x1814,{4,1}},
{0x1815,{5,1}},
{0x1816,{6,1}},
{0x1817,{7,1}},
{0x1818,{8,1}},
{0x1819,{9,1}},
{0x181a,{0,1}},
{0x1947,{1,1}},
{0x1948,{2,1}},
{0x1949,{3,1}},
{0x194a,{4,1}},
{0x194b,{5,1}},
{0x194c,{6,1}},
{0x194d,{7,1}},
{0x194e,{8,1}},
{0x194f,{9,1}},
{0x1950,{0,1}},
{0x19d1,{1,1}},
{0x19d2,{2,1}},
{0x19d3,{3,1}},
{0x19d4,{4,1}},
{0x19d5,{5,1}},
{0x19d6,{6,1}},
{0x19d7,{7,1}},
{0x19d8,{8,1}},
{0x19d9,{9,1}},
{0x19da,{1,1}},
{0x19db,{0,1}},
{0x1a81,{1,1}},
{0x1a82,{2,1}},
{0x1a83,{3,1}},
{0x1a84,{4,1}},
{0x1a85,{5,1}},
{0x1a86,{6,1}},
{0x1a87,{7,1}},
{0x1a88,{8,1}},
{0x1a89,{9,1}},
{0x1a8a,{0,1}},
{0x1a91,{1,1}},
{0x1a92,{2,1}},
{0x1a93,{3,1}},
{0x1a94,{4,1}},
{0x1a95,{5,1}},
{0x1a96,{6,1}},
{0x1a97,{7,1}},
{0x1a98,{8,1}},
{0x1a99,{9,1}},
{0x1a9a,{0,1}},
{0x1b51,{1,1}},
{0x1b52,{2,1}},
{0x1b53,{3,1}},
{0x1b54,{4,1}},
{0x1b55,{5,1}},
{0x1b56,{6,1}},
{0x1b57,{7,1}},
{0x1b58,{8,1}},
{0x1b59,{9,1}},
{0x1b5a,{0,1}},
{0x1bb1,{1,1}},
{0x1bb2,{2,1}},
{0x1bb3,{3,1}},
{0x1bb4,{4,1}},
{0x1bb5,{5,1}},
{0x1bb6,{6,1}},
{0x1bb7,{7,1}},
{0x1bb8,{8,1}},
{0x1bb9,{9,1}},
{0x1bba,{0,1}},
{0x1c41,{1,1}},
{0x1c42,{2,1}},
{0x1c43,{3,1}},
{0x1c44,{4,1}},
{0x1c45,{5,1}},
{0x1c46,{6,1}},
{0x1c47,{7,1}},
{0x1c48,{8,1}},
{0x1c49,{9,1}},
{0x1c4a,{0,1}},
{0x1c51,{1,1}},
{0x1c52,{2,1}},
{0x1c53,{3,1}},
{0x1c54,{4,1}},
{0x1c55,{5,1}},
{0x1c56,{6,1}},
{0x1c57,{7,1}},
{0x1c58,{8,1}},
{0x1c59,{9,1}},
{0x1c5a,{0,1}},
{0x2074,{4,1}},
{0x2075,{5,1}},
{0x2076,{6,1}},
{0x2077,{7,1}},
{0x2078,{8,1}},
{0x2079,{9,1}},
{0x207a,{0,1}},
{0x2081,{1,1}},
{0x2082,{2,1}},
{0x2083,{3,1}},
{0x2084,{4,1}},
{0x2085,{5,1}},
{0x2086,{6,1}},
{0x2087,{7,1}},
{0x2088,{8,1}},
{0x2089,{9,1}},
{0x208a,{0,1}},
{0x2150,{1,7}},
{0x2151,{1,9}},
{0x2152,{1,10}},
{0x2153,{1,3}},
{0x2154,{2,3}},
{0x2155,{1,5}},
{0x2156,{2,5}},
{0x2157,{3,5}},
{0x2158,{4,5}},
{0x2159,{1,6}},
{0x215a,{5,6}},
{0x215b,{1,8}},
{0x215c,{3,8}},
{0x215d,{5,8}},
{0x215e,{7,8}},
{0x215f,{1,1}},
{0x2161,{2,1}},
{0x2162,{3,1}},
{0x2163,{4,1}},
{0x2164,{5,1}},
{0x2165,{6,1}},
{0x2166,{7,1}},
{0x2167,{8,1}},
{0x2168,{9,1}},
{0x2169,{10,1}},
{0x216a,{11,1}},
{0x216b,{12,1}},
{0x216c,{50,1}},
{0x216d,{100,1}},
{0x216e,{500,1}},
{0x216f,{1000,1}},
{0x2170,{1,1}},
{0x2171,{2,1}},
{0x2172,{3,1}},
{0x2173,{4,1}},
{0x2174,{5,1}},
{0x2175,{6,1}},
{0x2176,{7,1}},
{0x2177,{8,1}},
{0x2178,{9,1}},
{0x2179,{10,1}},
{0x217a,{11,1}},
{0x217b,{12,1}},
{0x217c,{50,1}},
{0x217d,{100,1}},
{0x217e,{500,1}},
{0x217f,{1000,1}},
{0x2181,{5000,1}},
{0x2182,{10000,1}},
{0x2183,{0,1}},
{0x2185,{6,1}},
{0x2186,{50,1}},
{0x2187,{50000,1}},
{0x2188,{100000,1}},
{0x2189,{0,1}},
{0x2460,{1,1}},
{0x2461,{2,1}},
{0x2462,{3,1}},
{0x2463,{4,1}},
{0x2464,{5,1}},
{0x2465,{6,1}},
{0x2466,{7,1}},
{0x2467,{8,1}},
{0x2468,{9,1}},
{0x2469,{10,1}},
{0x246a,{11,1}},
{0x246b,{12,1}},
{0x246c,{13,1}},
{0x246d,{14,1}},
{0x246e,{15,1}},
{0x246f,{16,1}},
{0x2470,{17,1}},
{0x2471,{18,1}},
{0x2472,{19,1}},
{0x2473,{20,1}},
{0x2474,{1,1}},
{0x2475,{2,1}},
{0x2476,{3,1}},
{0x2477,{4,1}},
{0x2478,{5,1}},
{0x2479,{6,1}},
{0x247a,{7,1}},
{0x247b,{8,1}},
{0x247c,{9,1}},
{0x247d,{10,1}},
{0x247e,{11,1}},
{0x247f,{12,1}},
{0x2480,{13,1}},
{0x2481,{14,1}},
{0x2482,{15,1}},
{0x2483,{16,1}},
{0x2484,{17,1}},
{0x2485,{18,1}},
{0x2486,{19,1}},
{0x2487,{20,1}},
{0x2488,{1,1}},
{0x2489,{2,1}},
{0x248a,{3,1}},
{0x248b,{4,1}},
{0x248c,{5,1}},
{0x248d,{6,1}},
{0x248e,{7,1}},
{0x248f,{8,1}},
{0x2490,{9,1}},
{0x2491,{10,1}},
{0x2492,{11,1}},
{0x2493,{12,1}},
{0x2494,{13,1}},
{0x2495,{14,1}},
{0x2496,{15,1}},
{0x2497,{16,1}},
{0x2498,{17,1}},
{0x2499,{18,1}},
{0x249a,{19,1}},
{0x249b,{20,1}},
{0x249c,{0,1}},
{0x24eb,{11,1}},
{0x24ec,{12,1}},
{0x24ed,{13,1}},
{0x24ee,{14,1}},
{0x24ef,{15,1}},
{0x24f0,{16,1}},
{0x24f1,{17,1}},
{0x24f2,{18,1}},
{0x24f3,{19,1}},
{0x24f4,{20,1}},
{0x24f5,{1,1}},
{0x24f6,{2,1}},
{0x24f7,{3,1}},
{0x24f8,{4,1}},
{0x24f9,{5,1}},
{0x24fa,{6,1}},
{0x24fb,{7,1}},
{0x24fc,{8,1}},
{0x24fd,{9,1}},
{0x24fe,{10,1}},
{0x24ff,{0,1}},
{0x2776,{1,1}},
{0x2777,{2,1}},
{0x2778,{3,1}},
{0x2779,{4,1}},
{0x277a,{5,1}},
{0x277b,{6,1}},
{0x277c,{7,1}},
{0x277d,{8,1}},
{0x277e,{9,1}},
{0x277f,{10,1}},
{0x2780,{1,1}},
{0x2781,{2,1}},
{0x2782,{3,1}},
{0x2783,{4,1}},
{0x2784,{5,1}},
{0x2785,{6,1}},
{0x2786,{7,1}},
{0x2787,{8,1}},
{0x2788,{9,1}},
{0x2789,{10,1}},
{0x278a,{1,1}},
{0x278b,{2,1}},
{0x278c,{3,1}},
{0x278d,{4,1}},
{0x278e,{5,1}},
{0x278f,{6,1}},
{0x2790,{7,1}},
{0x2791,{8,1}},
{0x2792,{9,1}},
{0x2793,{10,1}},
{0x2794,{0,1}},
{0x2cfd,{1,2}},
{0x2cfe,{0,1}},
{0x3021,{1,1}},
{0x3022,{2,1}},
{0x3023,{3,1}},
{0x3024,{4,1}},
{0x3025,{5,1}},
{0x3026,{6,1}},
{0x3027,{7,1}},
{0x3028,{8,1}},
{0x3029,{9,1}},
{0x302a,{0,1}},
{0x3038,{10,1}},
{0x3039,{20,1}},
{0x303a,{30,1}},
{0x303b,{0,1}},
{0x3192,{1,1}},
{0x3193,{2,1}},
{0x3194,{3,1}},
{0x3195,{4,1}},
{0x3196,{0,1}},
{0x3220,{1,1}},
{0x3221,{2,1}},
{0x3222,{3,1}},
{0x3223,{4,1}},
{0x3224,{5,1}},
{0x3225,{6,1}},
{0x3226,{7,1}},
{0x3227,{8,1}},
{0x3228,{9,1}},
{0x3229,{10,1}},
{0x322a,{0,1}},
{0x3248,{10,1}},
{0x3249,{20,1}},
{0x324a,{30,1}},
{0x324b,{40,1}},
{0x324c,{50,1}},
{0x324d,{60,1}},
{0x324e,{70,1}},
{0x324f,{80,1}},
{0x3250,{0,1}},
{0x3251,{21,1}},
{0x3252,{22,1}},
{0x3253,{23,1}},
{0x3254,{24,1}},
{0x3255,{25,1}},
{0x3256,{26,1}},
{0x3257,{27,1}},
{0x3258,{28,1}},
{0x3259,{29,1}},
{0x325a,{30,1}},
{0x325b,{31,1}},
{0x325c,{32,1}},
{0x325d,{33,1}},
{0x325e,{34,1}},
{0x325f,{35,1}},
{0x3260,{0,1}},
{0x3280,{1,1}},
{0x3281,{2,1}},
{0x3282,{3,1}},
{0x3283,{4,1}},
{0x3284,{5,1}},
{0x3285,{6,1}},
{0x3286,{7,1}},
{0x3287,{8,1}},
{0x3288,{9,1}},
{0x3289,{10,1}},
{0x328a,{0,1}},
{0x32b1,{36,1}},
{0x32b2,{37,1}},
{0x32b3,{38,1}},
{0x32b4,{39,1}},
{0x32b5,{40,1}},
{0x32b6,{41,1}},
{0x32b7,{42,1}},
{0x32b8,{43,1}},
{0x32b9,{44,1}},
{0x32ba,{45,1}},
{0x32bb,{46,1}},
{0x32bc,{47,1}},
{0x32bd,{48,1}},
{0x32be,{49,1}},
{0x32bf,{50,1}},
{0x32c0,{0,1}},
{0x3405,{5,1}},
{0x3406,{0,1}},
{0x3483,{2,1}},
{0x3484,{0,1}},
{0x382a,{5,1}},
{0x382b,{0,1}},
{0x3b4d,{7,1}},
{0x3b4e,{0,1}},
{0x4e00,{1,1}},
{0x4e01,{0,1}},
{0x4e03,{7,1}},
{0x4e04,{0,1}},
{0x4e07,{10000,1}},
{0x4e08,{0,1}},
{0x4e09,{3,1}},
{0x4e0a,{0,1}},
{0x4e5d,{9,1}},
{0x4e5e,{0,1}},
{0x4e8c,{2,1}},
{0x4e8d,{0,1}},
{0x4e94,{5,1}},
{0x4e95,{0,1}},
{0x4e96,{4,1}},
{0x4e97,{0,1}},
{0x4ebf,{100000000,1}},
{0x4ec0,{10,1}},
{0x4ec1,{0,1}},
{0x4edf,{1000,1}},
{0x4ee0,{0,1}},
{0x4ee8,{3,1}},
{0x4ee9,{0,1}},
{0x4f0d,{5,1}},
{0x4f0e,{0,1}},
{0x4f70,{100,1}},
{0x4f71,{0,1}},
{0x5104,{100000000,1}},
{0x5105,{0,1}},
{0x5146,{1000000000000,1}},
{0x5147,{0,1}},
{0x5169,{2,1}},
{0x516a,{0,1}},
{0x516b,{8,1}},
{0x516c,{0,1}},
{0x516d,{6,1}},
{0x516e,{0,1}},
{0x5341,{10,1}},
{0x5342,{0,1}},
{0x5343,{1000,1}},
{0x5344,{20,1}},
{0x5345,{30,1}},
{0x5346,{0,1}},
{0x534c,{40,1}},
{0x534d,{0,1}},
{0x53c1,{3,1}},
{0x53c5,{0,1}},
{0x56db,{4,1}},
{0x56dc,{0,1}},
{0x58f1,{1,1}},
{0x58f2,{0,1}},
{0x58f9,{1,1}},
{0x58fa,{0,1}},
{0x5e7a,{1,1}},
{0x5e7b,{0,1}},
{0x5efe,{9,1}},
{0x5eff,{20,1}},
{0x5f00,{0,1}},
{0x5f0c,{1,1}},
{0x5f0d,{2,1}},
{0x5f0e,{3,1}},
{0x5f0f,{0,1}},
{0x5f10,{2,1}},
{0x5f11,{0,1}},
{0x62fe,{10,1}},
{0x62ff,{0,1}},
{0x634c,{8,1}},
{0x634d,{0,1}},
{0x67d2,{7,1}},
{0x67d3,{0,1}},
{0x6f06,{7,1}},
{0x6f07,{0,1}},
{0x7396,{9,1}},
{0x7397,{0,1}},
{0x767e,{100,1}},
{0x767f,{0,1}},
{0x8086,{4,1}},
{0x8087,{0,1}},
{0x842c,{10000,1}},
{0x842d,{0,1}},
{0x8cae,{2,1}},
{0x8caf,{0,1}},
{0x8cb3,{2,1}},
{0x8cb4,{0,1}},
{0x8d30,{2,1}},
{0x8d31,{0,1}},
{0x9621,{1000,1}},
{0x9622,{0,1}},
{0x9646,{6,1}},
{0x9647,{0,1}},
{0x964c,{100,1}},
{0x964d,{0,1}},
{0x9678,{6,1}},
{0x9679,{0,1}},
{0xa621,{1,1}},
{0xa622,{2,1}},
{0xa623,{3,1}},
{0xa624,{4,1}},
{0xa625,{5,1}},
{0xa626,{6,1}},
{0xa627,{7,1}},
{0xa628,{8,1}},
{0xa629,{9,1}},
{0xa62a,{0,1}},
{0xa6e6,{1,1}},
{0xa6e7,{2,1}},
{0xa6e8,{3,1}},
{0xa6e9,{4,1}},
{0xa6ea,{5,1}},
{0xa6eb,{6,1}},
{0xa6ec,{7,1}},
{0xa6ed,{8,1}},
{0xa6ee,{9,1}},
{0xa6ef,{0,1}},
{0xa830,{1,4}},
{0xa831,{1,2}},
{0xa832,{3,4}},
{0xa833,{1,16}},
{0xa834,{1,8}},
{0xa835,{3,16}},
{0xa836,{0,1}},
{0xa8d1,{1,1}},
{0xa8d2,{2,1}},
{0xa8d3,{3,1}},
{0xa8d4,{4,1}},
{0xa8d5,{5,1}},
{0xa8d6,{6,1}},
{0xa8d7,{7,1}},
{0xa8d8,{8,1}},
{0xa8d9,{9,1}},
{0xa8da,{0,1}},
{0xa901,{1,1}},
{0xa902,{2,1}},
{0xa903,{3,1}},
{0xa904,{4,1}},
{0xa905,{5,1}},
{0xa906,{6,1}},
{0xa907,{7,1}},
{0xa908,{8,1}},
{0xa909,{9,1}},
{0xa90a,{0,1}},
{0xa9d1,{1,1}},
{0xa9d2,{2,1}},
{0xa9d3,{3,1}},
{0xa9d4,{4,1}},
{0xa9d5,{5,1}},
{0xa9d6,{6,1}},
{0xa9d7,{7,1}},
{0xa9d8,{8,1}},
{0xa9d9,{9,1}},
{0xa9da,{0,1}},
{0xa9f1,{1,1}},
{0xa9f2,{2,1}},
{0xa9f3,{3,1}},
{0xa9f4,{4,1}},
{0xa9f5,{5,1}},
{0xa9f6,{6,1}},
{0xa9f7,{7,1}},
{0xa9f8,{8,1}},
{0xa9f9,{9,1}},
{0xa9fa,{0,1}},
{0xaa51,{1,1}},
{0xaa52,{2,1}},
{0xaa53,{3,1}},
{0xaa54,{4,1}},
{0xaa55,{5,1}},
{0xaa56,{6,1}},
{0xaa57,{7,1}},
{0xaa58,{8,1}},
{0xaa59,{9,1}},
{0xaa5a,{0,1}},
{0xabf1,{1,1}},
{0xabf2,{2,1}},
{0xabf3,{3,1}},
{0xabf4,{4,1}},
{0xabf5,{5,1}},
{0xabf6,{6,1}},
{0xabf7,{7,1}},
{0xabf8,{8,1}},
{0xabf9,{9,1}},
{0xabfa,{0,1}},
{0xf96b,{3,1}},
{0xf96c,{0,1}},
{0xf973,{10,1}},
{0xf974,{0,1}},
{0xf978,{2,1}},
{0xf979,{0,1}},
{0xf9d1,{6,1}},
{0xf9d2,{0,1}},
{0xf9d3,{6,1}},
{0xf9d4,{0,1}},
{0xf9fd,{10,1}},
{0xf9fe,{0,1}},
{0xff11,{1,1}},
{0xff12,{2,1}},
{0xff13,{3,1}},
{0xff14,{4,1}},
{0xff15,{5,1}},
{0xff16,{6,1}},
{0xff17,{7,1}},
{0xff18,{8,1}},
{0xff19,{9,1}},
{0xff1a,{0,1}},
{0x10107,{1,1}},
{0x10108,{2,1}},
{0x10109,{3,1}},
{0x1010a,{4,1}},
{0x1010b,{5,1}},
{0x1010c,{6,1}},
{0x1010d,{7,1}},
{0x1010e,{8,1}},
{0x1010f,{9,1}},
{0x10110,{10,1}},
{0x10111,{20,1}},
{0x10112,{30,1}},
{0x10113,{40,1}},
{0x10114,{50,1}},
{0x10115,{60,1}},
{0x10116,{70,1}},
{0x10117,{80,1}},
{0x10118,{90,1}},
{0x10119,{100,1}},
{0x1011a,{200,1}},
{0x1011b,{300,1}},
{0x1011c,{400,1}},
{0x1011d,{500,1}},
{0x1011e,{600,1}},
{0x1011f,{700,1}},
{0x10120,{800,1}},
{0x10121,{900,1}},
{0x10122,{1000,1}},
{0x10123,{2000,1}},
{0x10124,{3000,1}},
{0x10125,{4000,1}},
{0x10126,{5000,1}},
{0x10127,{6000,1}},
{0x10128,{7000,1}},
{0x10129,{8000,1}},
{0x1012a,{9000,1}},
{0x1012b,{10000,1}},
{0x1012c,{20000,1}},
{0x1012d,{30000,1}},
{0x1012e,{40000,1}},
{0x1012f,{50000,1}},
{0x10130,{60000,1}},
{0x10131,{70000,1}},
{0x10132,{80000,1}},
{0x10133,{90000,1}},
{0x10134,{0,1}},
{0x10140,{1,4}},
{0x10141,{1,2}},
{0x10142,{1,1}},
{0x10143,{5,1}},
{0x10144,{50,1}},
{0x10145,{500,1}},
{0x10146,{5000,1}},
{0x10147,{50000,1}},
{0x10148,{5,1}},
{0x10149,{10,1}},
{0x1014a,{50,1}},
{0x1014b,{100,1}},
{0x1014c,{500,1}},
{0x1014d,{1000,1}},
{0x1014e,{5000,1}},
{0x1014f,{5,1}},
{0x10150,{10,1}},
{0x10151,{50,1}},
{0x10152,{100,1}},
{0x10153,{500,1}},
{0x10154,{1000,1}},
{0x10155,{10000,1}},
{0x10156,{50000,1}},
{0x10157,{10,1}},
{0x10158,{1,1}},
{0x1015b,{2,1}},
{0x1015f,{5,1}},
{0x10160,{10,1}},
{0x10165,{30,1}},
{0x10166,{50,1}},
{0x1016a,{100,1}},
{0x1016b,{300,1}},
{0x1016c,{500,1}},
{0x10171,{1000,1}},
{0x10172,{5000,1}},
{0x10173,{5,1}},
{0x10174,{50,1}},
{0x10175,{1,2}},
{0x10177,{2,3}},
{0x10178,{3,4}},
{0x10179,{0,1}},
{0x1018b,{1,4}},
{0x1018c,{0,1}},
{0x102e1,{1,1}},
{0x102e2,{2,1}},
{0x102e3,{3,1}},
{0x102e4,{4,1}},
{0x102e5,{5,1}},
{0x102e6,{6,1}},
{0x102e7,{7,1}},
{0x102e8,{8,1}},
{0x102e9,{9,1}},
{0x102ea,{10,1}},
{0x102eb,{20,1}},
{0x102ec,{30,1}},
{0x102ed,{40,1}},
{0x102ee,{50,1}},
{0x102ef,{60,1}},
{0x102f0,{70,1}},
{0x102f1,{80,1}},
{0x102f2,{90,1}},
{0x102f3,{100,1}},
{0x102f4,{200,1}},
{0x102f5,{300,1}},
{0x102f6,{400,1}},
{0x102f7,{500,1}},
{0x102f8,{600,1}},
{0x102f9,{700,1}},
{0x102fa,{800,1}},
{0x102fb,{900,1}},
{0x102fc,{0,1}},
{0x10320,{1,1}},
{0x10321,{5,1}},
{0x10322,{10,1}},
{0x10323,{50,1}},
{0x10324,{0,1}},
{0x10341,{90,1}},
{0x10342,{0,1}},
{0x1034a,{900,1}},
{0x1034b,{0,1}},
{0x103d1,{1,1}},
{0x103d2,{2,1}},
{0x103d3,{10,1}},
{0x103d4,{20,1}},
{0x103d5,{100,1}},
{0x103d6,{0,1}},
{0x104a1,{1,1}},
{0x104a2,{2,1}},
{0x104a3,{3,1}},
{0x104a4,{4,1}},
{0x104a5,{5,1}},
{0x104a6,{6,1}},
{0x104a7,{7,1}},
{0x104a8,{8,1}},
{0x104a9,{9,1}},
{0x104aa,{0,1}},
{0x10858,{1,1}},
{0x10859,{2,1}},
{0x1085a,{3,1}},
{0x1085b,{10,1}},
{0x1085c,{20,1}},
{0x1085d,{100,1}},
{0x1085e,{1000,1}},
{0x1085f,{10000,1}},
{0x10860,{0,1}},
{0x10879,{1,1}},
{0x1087a,{2,1}},
{0x1087b,{3,1}},
{0x1087c,{4,1}},
{0x1087d,{5,1}},
{0x1087e,{10,1}},
{0x1087f,{20,1}},
{0x10880,{0,1}},
{0x108a7,{1,1}},
{0x108a8,{2,1}},
{0x108a9,{3,1}},
{0x108aa,{4,1}},
{0x108ac,{5,1}},
{0x108ad,{10,1}},
{0x108ae,{20,1}},
{0x108af,{100,1}},
{0x108b0,{0,1}},
{0x108fb,{1,1}},
{0x108fc,{5,1}},
{0x108fd,{10,1}},
{0x108fe,{20,1}},
{0x108ff,{100,1}},
{0x10900,{0,1}},
{0x10916,{1,1}},
{0x10917,{10,1}},
{0x10918,{20,1}},
{0x10919,{100,1}},
{0x1091a,{2,1}},
{0x1091b,{3,1}},
{0x1091c,{0,1}},
{0x109bc,{11,12}},
{0x109bd,{1,2}},
{0x109be,{0,1}},
{0x109c0,{1,1}},
{0x109c1,{2,1}},
{0x109c2,{3,1}},
{0x109c3,{4,1}},
{0x109c4,{5,1}},
{0x109c5,{6,1}},
{0x109c6,{7,1}},
{0x109c7,{8,1}},
{0x109c8,{9,1}},
{0x109c9,{10,1}},
{0x109ca,{20,1}},
{0x109cb,{30,1}},
{0x109cc,{40,1}},
{0x109cd,{50,1}},
{0x109ce,{60,1}},
{0x109cf,{70,1}},
{0x109d0,{0,1}},
{0x109d2,{100,1}},
{0x109d3,{200,1}},
{0x109d4,{300,1}},
{0x109d5,{400,1}},
{0x109d6,{500,1}},
{0x109d7,{600,1}},
{0x109d8,{700,1}},
{0x109d9,{800,1}},
{0x109da,{900,1}},
{0x109db,{1000,1}},
{0x109dc,{2000,1}},
{0x109dd,{3000,1}},
{0x109de,{4000,1}},
{0x109df,{5000,1}},
{0x109e0,{6000,1}},
{0x109e1,{7000,1}},
{0x109e2,{8000,1}},
{0x109e3,{9000,1}},
{0x109e4,{10000,1}},
{0x109e5,{20000,1}},
{0x109e6,{30000,1}},
{0x109e7,{40000,1}},
{0x109e8,{50000,1}},
{0x109e9,{60000,1}},
{0x109ea,{70000,1}},
{0x109eb,{80000,1}},
{0x109ec,{90000,1}},
{0x109ed,{100000,1}},
{0x109ee,{200000,1}},
{0x109ef,{300000,1}},
{0x109f0,{400000,1}},
{0x109f1,{500000,1}},
{0x109f2,{600000,1}},
{0x109f3,{700000,1}},
{0x109f4,{800000,1}},
{0x109f5,{900000,1}},
{0x109f6,{1,12}},
{0x109f7,{1,6}},
{0x109f8,{1,4}},
{0x109f9,{1,3}},
{0x109fa,{5,12}},
{0x109fb,{1,2}},
{0x109fc,{7,12}},
{0x109fd,{2,3}},
{0x109fe,{3,4}},
{0x109ff,{5,6}},
{0x10a00,{0,1}},
{0x10a40,{1,1}},
{0x10a41,{2,1}},
{0x10a42,{3,1}},
{0x10a43,{4,1}},
{0x10a44,{10,1}},
{0x10a45,{20,1}},
{0x10a46,{100,1}},
{0x10a47,{1000,1}},
{0x10a48,{0,1}},
{0x10a7d,{1,1}},
{0x10a7e,{50,1}},
{0x10a7f,{0,1}},
{0x10a9d,{1,1}},
{0x10a9e,{10,1}},
{0x10a9f,{20,1}},
{0x10aa0,{0,1}},
{0x10aeb,{1,1}},
{0x10aec,{5,1}},
{0x10aed,{10,1}},
{0x10aee,{20,1}},
{0x10aef,{100,1}},
{0x10af0,{0,1}},
{0x10b58,{1,1}},
{0x10b59,{2,1}},
{0x10b5a,{3,1}},
{0x10b5b,{4,1}},
{0x10b5c,{10,1}},
{0x10b5d,{20,1}},
{0x10b5e,{100,1}},
{0x10b5f,{1000,1}},
{0x10b60,{0,1}},
{0x10b78,{1,1}},
{0x10b79,{2,1}},
{0x10b7a,{3,1}},
{0x10b7b,{4,1}},
{0x10b7c,{10,1}},
{0x10b7d,{20,1}},
{0x10b7e,{100,1}},
{0x10b7f,{1000,1}},
{0x10b80,{0,1}},
{0x10ba9,{1,1}},
{0x10baa,{2,1}},
{0x10bab,{3,1}},
{0x10bac,{4,1}},
{0x10bad,{10,1}},
{0x10bae,{20,1}},
{0x10baf,{100,1}},
{0x10bb0,{0,1}},
{0x10cfa,{1,1}},
{0x10cfb,{5,1}},
{0x10cfc,{10,1}},
{0x10cfd,{50,1}},
{0x10cfe,{100,1}},
{0x10cff,{1000,1}},
{0x10d00,{0,1}},
{0x10e60,{1,1}},
{0x10e61,{2,1}},
{0x10e62,{3,1}},
{0x10e63,{4,1}},
{0x10e64,{5,1}},
{0x10e65,{6,1}},
{0x10e66,{7,1}},
{0x10e67,{8,1}},
{0x10e68,{9,1}},
{0x10e69,{10,1}},
{0x10e6a,{20,1}},
{0x10e6b,{30,1}},
{0x10e6c,{40,1}},
{0x10e6d,{50,1}},
{0x10e6e,{60,1}},
{0x10e6f,{70,1}},
{0x10e70,{80,1}},
{0x10e71,{90,1}},
{0x10e72,{100,1}},
{0x10e73,{200,1}},
{0x10e74,{300,1}},
{0x10e75,{400,1}},
{0x10e76,{500,1}},
{0x10e77,{600,1}},
{0x10e78,{700,1}},
{0x10e79,{800,1}},
{0x10e7a,{900,1}},
{0x10e7b,{1,2}},
{0x10e7c,{1,4}},
{0x10e7d,{1,3}},
{0x10e7e,{2,3}},
{0x10e7f,{0,1}},
{0x11052,{1,1}},
{0x11053,{2,1}},
{0x11054,{3,1}},
{0x11055,{4,1}},
{0x11056,{5,1}},
{0x11057,{6,1}},
{0x11058,{7,1}},
{0x11059,{8,1}},
{0x1105a,{9,1}},
{0x1105b,{10,1}},
{0x1105c,{20,1}},
{0x1105d,{30,1}},
{0x1105e,{40,1}},
{0x1105f,{50,1}},
{0x11060,{60,1}},
{0x11061,{70,1}},
{0x11062,{80,1}},
{0x11063,{90,1}},
{0x11064,{100,1}},
{0x11065,{1000,1}},
{0x11066,{0,1}},
{0x11067,{1,1}},
{0x11068,{2,1}},
{0x11069,{3,1}},
{0x1106a,{4,1}},
{0x1106b,{5,1}},
{0x1106c,{6,1}},
{0x1106d,{7,1}},
{0x1106e,{8,1}},
{0x1106f,{9,1}},
{0x11070,{0,1}},
{0x110f1,{1,1}},
{0x110f2,{2,1}},
{0x110f3,{3,1}},
{0x110f4,{4,1}},
{0x110f5,{5,1}},
{0x110f6,{6,1}},
{0x110f7,{7,1}},
{0x110f8,{8,1}},
{0x110f9,{9,1}},
{0x110fa,{0,1}},
{0x11137,{1,1}},
{0x11138,{2,1}},
{0x11139,{3,1}},
{0x1113a,{4,1}},
{0x1113b,{5,1}},
{0x1113c,{6,1}},
{0x1113d,{7,1}},
{0x1113e,{8,1}},
{0x1113f,{9,1}},
{0x11140,{0,1}},
{0x111d1,{1,1}},
{0x111d2,{2,1}},
{0x111d3,{3,1}},
{0x111d4,{4,1}},
{0x111d5,{5,1}},
{0x111d6,{6,1}},
{0x111d7,{7,1}},
{0x111d8,{8,1}},
{0x111d9,{9,1}},
{0x111da,{0,1}},
{0x111e1,{1,1}},
{0x111e2,{2,1}},
{0x111e3,{3,1}},
{0x111e4,{4,1}},
{0x111e5,{5,1}},
{0x111e6,{6,1}},
{0x111e7,{7,1}},
{0x111e8,{8,1}},
{0x111e9,{9,1}},
{0x111ea,{10,1}},
{0x111eb,{20,1}},
{0x111ec,{30,1}},
{0x111ed,{40,1}},
{0x111ee,{50,1}},
{0x111ef,{60,1}},
{0x111f0,{70,1}},
{0x111f1,{80,1}},
{0x111f2,{90,1}},
{0x111f3,{100,1}},
{0x111f4,{1000,1}},
{0x111f5,{0,1}},
{0x112f1,{1,1}},
{0x112f2,{2,1}},
{0x112f3,{3,1}},
{0x112f4,{4,1}},
{0x112f5,{5,1}},
{0x112f6,{6,1}},
{0x112f7,{7,1}},
{0x112f8,{8,1}},
{0x112f9,{9,1}},
{0x112fa,{0,1}},
{0x114d1,{1,1}},
{0x114d2,{2,1}},
{0x114d3,{3,1}},
{0x114d4,{4,1}},
{0x114d5,{5,1}},
{0x114d6,{6,1}},
{0x114d7,{7,1}},
{0x114d8,{8,1}},
{0x114d9,{9,1}},
{0x114da,{0,1}},
{0x11651,{1,1}},
{0x11652,{2,1}},
{0x11653,{3,1}},
{0x11654,{4,1}},
{0x11655,{5,1}},
{0x11656,{6,1}},
{0x11657,{7,1}},
{0x11658,{8,1}},
{0x11659,{9,1}},
{0x1165a,{0,1}},
{0x116c1,{1,1}},
{0x116c2,{2,1}},
{0x116c3,{3,1}},
{0x116c4,{4,1}},
{0x116c5,{5,1}},
{0x116c6,{6,1}},
{0x116c7,{7,1}},
{0x116c8,{8,1}},
{0x116c9,{9,1}},
{0x116ca,{0,1}},
{0x11731,{1,1}},
{0x11732,{2,1}},
{0x11733,{3,1}},
{0x11734,{4,1}},
{0x11735,{5,1}},
{0x11736,{6,1}},
{0x11737,{7,1}},
{0x11738,{8,1}},
{0x11739,{9,1}},
{0x1173a,{10,1}},
{0x1173b,{20,1}},
{0x1173c,{0,1}},
{0x118e1,{1,1}},
{0x118e2,{2,1}},
{0x118e3,{3,1}},
{0x118e4,{4,1}},
{0x118e5,{5,1}},
{0x118e6,{6,1}},
{0x118e7,{7,1}},
{0x118e8,{8,1}},
{0x118e9,{9,1}},
{0x118ea,{10,1}},
{0x118eb,{20,1}},
{0x118ec,{30,1}},
{0x118ed,{40,1}},
{0x118ee,{50,1}},
{0x118ef,{60,1}},
{0x118f0,{70,1}},
{0x118f1,{80,1}},
{0x118f2,{90,1}},
{0x118f3,{0,1}},
{0x12400,{2,1}},
{0x12401,{3,1}},
{0x12402,{4,1}},
{0x12403,{5,1}},
{0x12404,{6,1}},
{0x12405,{7,1}},
{0x12406,{8,1}},
{0x12407,{9,1}},
{0x12408,{3,1}},
{0x12409,{4,1}},
{0x1240a,{5,1}},
{0x1240b,{6,1}},
{0x1240c,{7,1}},
{0x1240d,{8,1}},
{0x1240e,{9,1}},
{0x1240f,{4,1}},
{0x12410,{5,1}},
{0x12411,{6,1}},
{0x12412,{7,1}},
{0x12413,{8,1}},
{0x12414,{9,1}},
{0x12415,{1,1}},
{0x12416,{2,1}},
{0x12417,{3,1}},
{0x12418,{4,1}},
{0x12419,{5,1}},
{0x1241a,{6,1}},
{0x1241b,{7,1}},
{0x1241c,{8,1}},
{0x1241d,{9,1}},
{0x1241e,{1,1}},
{0x1241f,{2,1}},
{0x12420,{3,1}},
{0x12421,{4,1}},
{0x12422,{5,1}},
{0x12423,{2,1}},
{0x12424,{3,1}},
{0x12426,{4,1}},
{0x12427,{5,1}},
{0x12428,{6,1}},
{0x12429,{7,1}},
{0x1242a,{8,1}},
{0x1242b,{9,1}},
{0x1242c,{1,1}},
{0x1242d,{2,1}},
{0x1242e,{3,1}},
{0x12430,{4,1}},
{0x12431,{5,1}},
{0x12432,{216000,1}},
{0x12433,{432000,1}},
{0x12434,{1,1}},
{0x12435,{2,1}},
{0x12436,{3,1}},
{0x12438,{4,1}},
{0x12439,{5,1}},
{0x1243a,{3,1}},
{0x1243c,{4,1}},
{0x12440,{6,1}},
{0x12441,{7,1}},
{0x12444,{8,1}},
{0x12446,{9,1}},
{0x1244a,{2,1}},
{0x1244b,{3,1}},
{0x1244c,{4,1}},
{0x1244d,{5,1}},
{0x1244e,{6,1}},
{0x1244f,{1,1}},
{0x12450,{2,1}},
{0x12451,{3,1}},
{0x12452,{4,1}},
{0x12454,{5,1}},
{0x12456,{2,1}},
{0x12457,{3,1}},
{0x12458,{1,1}},
{0x12459,{2,1}},
{0x1245a,{1,3}},
{0x1245b,{2,3}},
{0x1245c,{5,6}},
{0x1245d,{1,3}},
{0x1245e,{2,3}},
{0x1245f,{1,8}},
{0x12460,{1,4}},
{0x12461,{1,6}},
{0x12462,{1,4}},
{0x12464,{1,2}},
{0x12465,{1,3}},
{0x12466,{2,3}},
{0x12467,{40,1}},
{0x12468,{50,1}},
{0x12469,{4,1}},
{0x1246a,{5,1}},
{0x1246b,{6,1}},
{0x1246c,{7,1}},
{0x1246d,{8,1}},
{0x1246e,{9,1}},
{0x1246f,{0,1}},
{0x16a61,{1,1}},
{0x16a62,{2,1}},
{0x16a63,{3,1}},
{0x16a64,{4,1}},
{0x16a65,{5,1}},
{0x16a66,{6,1}},
{0x16a67,{7,1}},
{0x16a68,{8,1}},
{0x16a69,{9,1}},
{0x16a6a,{0,1}},
{0x16b51,{1,1}},
{0x16b52,{2,1}},
{0x16b53,{3,1}},
{0x16b54,{4,1}},
{0x16b55,{5,1}},
{0x16b56,{6,1}},
{0x16b57,{7,1}},
{0x16b58,{8,1}},
{0x16b59,{9,1}},
{0x16b5a,{0,1}},
{0x16b5b,{10,1}},
{0x16b5c,{100,1}},
{0x16b5d,{10000,1}},
{0x16b5e,{1000000,1}},
{0x16b5f,{100000000,1}},
{0x16b60,{10000000000,1}},
{0x16b61,{1000000000000,1}},
{0x16b62,{0,1}},
{0x1d360,{1,1}},
{0x1d361,{2,1}},
{0x1d362,{3,1}},
{0x1d363,{4,1}},
{0x1d364,{5,1}},
{0x1d365,{6,1}},
{0x1d366,{7,1}},
{0x1d367,{8,1}},
{0x1d368,{9,1}},
{0x1d369,{10,1}},
{0x1d36a,{20,1}},
{0x1d36b,{30,1}},
{0x1d36c,{40,1}},
{0x1d36d,{50,1}},
{0x1d36e,{60,1}},
{0x1d36f,{70,1}},
{0x1d370,{80,1}},
{0x1d371,{90,1}},
{0x1d372,{0,1}},
{0x1d7cf,{1,1}},
{0x1d7d0,{2,1}},
{0x1d7d1,{3,1}},
{0x1d7d2,{4,1}},
{0x1d7d3,{5,1}},
{0x1d7d4,{6,1}},
{0x1d7d5,{7,1}},
{0x1d7d6,{8,1}},
{0x1d7d7,{9,1}},
{0x1d7d8,{0,1}},
{0x1d7d9,{1,1}},
{0x1d7da,{2,1}},
{0x1d7db,{3,1}},
{0x1d7dc,{4,1}},
{0x1d7dd,{5,1}},
{0x1d7de,{6,1}},
{0x1d7df,{7,1}},
{0x1d7e0,{8,1}},
{0x1d7e1,{9,1}},
{0x1d7e2,{0,1}},
{0x1d7e3,{1,1}},
{0x1d7e4,{2,1}},
{0x1d7e5,{3,1}},
{0x1d7e6,{4,1}},
{0x1d7e7,{5,1}},
{0x1d7e8,{6,1}},
{0x1d7e9,{7,1}},
{0x1d7ea,{8,1}},
{0x1d7eb,{9,1}},
{0x1d7ec,{0,1}},
{0x1d7ed,{1,1}},
{0x1d7ee,{2,1}},
{0x1d7ef,{3,1}},
{0x1d7f0,{4,1}},
{0x1d7f1,{5,1}},
{0x1d7f2,{6,1}},
{0x1d7f3,{7,1}},
{0x1d7f4,{8,1}},
{0x1d7f5,{9,1}},
{0x1d7f6,{0,1}},
{0x1d7f7,{1,1}},
{0x1d7f8,{2,1}},
{0x1d7f9,{3,1}},
{0x1d7fa,{4,1}},
{0x1d7fb,{5,1}},
{0x1d7fc,{6,1}},
{0x1d7fd,{7,1}},
{0x1d7fe,{8,1}},
{0x1d7ff,{9,1}},
{0x1d800,{0,1}},
{0x1e8c7,{1,1}},
{0x1e8c8,{2,1}},
{0x1e8c9,{3,1}},
{0x1e8ca,{4,1}},
{0x1e8cb,{5,1}},
{0x1e8cc,{6,1}},
{0x1e8cd,{7,1}},
{0x1e8ce,{8,1}},
{0x1e8cf,{9,1}},
{0x1e8d0,{0,1}},
{0x1f102,{1,1}},
{0x1f103,{2,1}},
{0x1f104,{3,1}},
{0x1f105,{4,1}},
{0x1f106,{5,1}},
{0x1f107,{6,1}},
{0x1f108,{7,1}},
{0x1f109,{8,1}},
{0x1f10a,{9,1}},
{0x1f10b,{0,1}},
{0x20001,{7,1}},
{0x20002,{0,1}},
{0x20064,{4,1}},
{0x20065,{0,1}},
{0x200e2,{4,1}},
{0x200e3,{0,1}},
{0x20121,{5,1}},
{0x20122,{0,1}},
{0x2092a,{1,1}},
{0x2092b,{0,1}},
{0x20983,{30,1}},
{0x20984,{0,1}},
{0x2098c,{40,1}},
{0x2098d,{0,1}},
{0x2099c,{40,1}},
{0x2099d,{0,1}},
{0x20aea,{6,1}},
{0x20aeb,{0,1}},
{0x20afd,{3,1}},
{0x20afe,{0,1}},
{0x20b19,{3,1}},
{0x20b1a,{0,1}},
{0x22390,{2,1}},
{0x22391,{0,1}},
{0x22998,{3,1}},
{0x22999,{0,1}},
{0x23b1b,{3,1}},
{0x23b1c,{0,1}},
{0x2626d,{4,1}},
{0x2626e,{0,1}},
{0x2f890,{9,1}},
{0x2f891,{0,1}},
}};

const TableView<char32_t, PackedPair<long long>> numeric_value_table {&numeric_value_array[0], &numeric_value_array[0] + numeric_value_array.size()};

}
