<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" version="1.0">
	<xsl:key name="business" match="DVPSIH" use="BusTeamDescription" />
	<xsl:key name="plan" match="DVPSIH" use="concat(PlanLevelDescription, ':', BusTeamDescription)" />
	<xsl:attribute-set name="table">
		<xsl:attribute name="cellpadding">2</xsl:attribute>
		<xsl:attribute name="cellspacing">0</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table.report">
		<xsl:attribute name="id">tblDisplayArea</xsl:attribute>
		<xsl:attribute name="class">data</xsl:attribute>
	</xsl:attribute-set>
	<xsl:output method="html" indent="yes" />
	
	<xsl:template match="/">
		<xsl:apply-templates select="/*" />
	</xsl:template>
	
	<xsl:template match="/*">
		<table xsl:use-attribute-sets="table.report table">
			<!--Header Rows-->
			<tr valign="top" bgcolor="#FFFFFF" style="font-family: Arial, Helvetica, Sans-Serif; font-size: 10pt; color: #000000;">
				<td width="1"><input type="hidden" /></td>
				<td colspan="3">&#xa0;</td>
				<td align="center" style="border-right: 1px solid #999999; border-left: 1px solid #999999; border-top: 1px solid #999999;" colspan="8"><strong>Selected Period Information</strong></td>
				<td align="center" style="border-right: 1px solid #999999; border-left: 1px solid #999999; border-top: 1px solid #999999;" colspan="7"><strong>Year to Date Information</strong></td>
			</tr>
			<tr style="background:#003366; font-family: Arial, Helvetica, Sans-Serif; font-size: 10pt; color: #FFFFFF;">
				<td width="1"><input type="hidden" /></td>
				<td style="border-left: 0px; border-right: 1px solid #FFFFFF;">Business Team</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Plan Level</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Package Group</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Period Quota</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Current Period Inv Cases</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">LY Inv Cases</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">% TY vs LY</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Current Period Open Orders</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">Current Period ITB Cases</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">% ITB Quota</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #000000;">To Go for Period (Quota-ITB)</td>
				<td style="border-left: 1px solid #000000; border-right: 1px solid #FFFFFF;">New ITB Prior Day</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">YTD Quota</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">YTD Inv Cases</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">YTD Inv Cases LY</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">% TY vs LY</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 1px solid #FFFFFF;">YTD IB Cases</td>
				<td style="border-left: 1px solid #FFFFFF; border-right: 0px">% ITB to YTD Quota</td>
			</tr>
			
			<xsl:for-each select="//DVPSIH[count(.|key('business', BusTeamDescription)[1]) = 1]">
				<xsl:variable name="business" select="BusTeamDescription" />
				<xsl:variable name="business.PeriodCasesVsLastYear">
					<xsl:apply-templates select="key('business', $business)" mode="PeriodCasesVsLastYear" />
				</xsl:variable>
				<xsl:variable name="business.ItbVsQuota">
					<xsl:apply-templates select="key('business', $business)" mode="ItbVsQuota" />
				</xsl:variable>				
				<xsl:variable name="business.YtdCasesVsLastYear">
					<xsl:apply-templates select="key('business', $business)" mode="YtdCasesVsLastYear" />
				</xsl:variable>
				<xsl:variable name="business.YtdItbVsQuota">
					<xsl:apply-templates select="key('business', $business)" mode="YtdItbVsQuota" />
				</xsl:variable>
				
				<tr style="background-color: #8FB5DA; font-family: Arial, Helvetica, Sans-Serif; font-size: 10pt; font-weight: bold;">
					<td width="1"><input type="hidden" /></td>
					<td nowrap="true" style="text-align: left;"><xsl:value-of select="$business" /></td>
					<td nowrap="true" style="text-align: center;">&#xa0;</td>
					<td nowrap="true" style="text-align: center;">&#xa0;</td><!--translate(string(number(EVENTID)), 'NaN', 0)-->
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/Quota)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/InvMTD)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/InvLY)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($business.PeriodCasesVsLastYear)/node()) div count(msxsl:node-set($business.PeriodCasesVsLastYear)/node())), 'NaN', 0), '##,##0%')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/OpenOrders) + sum(key('business', $business)/InvMTD)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($business.ItbVsQuota)/node()) div count(msxsl:node-set($business.ItbVsQuota)/node())), 'NaN', 0), '##,##0%')" /></td>
					<td nowrap="true" style="text-align: center; border-right: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/Quota) - (sum(key('business', $business)/OpenOrders) + sum(key('business', $business)/InvMTD))), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center; border-left: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/PDV)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/QuotaYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/InvYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/InvYTDLY)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($business.YtdCasesVsLastYear)/node()) div count(msxsl:node-set($business.YtdCasesVsLastYear)/node())), 'NaN', 0), '##,##0%')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('business', $business)/InvYTD) + sum(key('business', $business)/QuotaYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
					<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($business.YtdItbVsQuota)/node()) div count(msxsl:node-set($business.YtdItbVsQuota)/node())), 'NaN', 0), '##,##0%')" /></td>
				</tr>
				
				<xsl:for-each select="key('business', $business)[count(.|key('plan', concat(PlanLevelDescription, ':', BusTeamDescription))[1]) = 1]">
					<xsl:variable name="plan" select="PlanLevelDescription" />
					<xsl:variable name="plan.PeriodCasesVsLastYear">
						<xsl:apply-templates select="key('plan', concat($plan, ':', $business))" mode="PeriodCasesVsLastYear" />
					</xsl:variable>
					<xsl:variable name="plan.ItbVsQuota">
						<xsl:apply-templates select="key('plan', concat($plan, ':', $business))" mode="ItbVsQuota" />
					</xsl:variable>
					<xsl:variable name="plan.YtdCasesVsLastYear">
						<xsl:apply-templates select="key('plan', concat($plan, ':', $business))" mode="YtdCasesVsLastYear" />
					</xsl:variable>
					<xsl:variable name="plan.YtdItbVsQuota">
						<xsl:apply-templates select="key('plan', concat($plan, ':', $business))" mode="YtdItbVsQuota" />
					</xsl:variable>
					
					<tr style="background-color: #DFDFDF; font-family: Arial, Helvetica, Sans-Serif; font-size: 9pt;">
						<td width="1"><input type="hidden" /></td>
						<td nowrap="true" style="text-align: center;">&#xa0;</td>
						<td nowrap="true" style="text-align: left;"><xsl:value-of select="$plan" /></td>
						<td nowrap="true" style="text-align: center;">&#xa0;</td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/Quota) div count(key('plan', concat($plan, ':', $business))/Quota)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvMTD)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvLY)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($plan.PeriodCasesVsLastYear)/node()) div count(msxsl:node-set($plan.PeriodCasesVsLastYear)/node())), 'NaN', 0), '##,##0%')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvMTD) + sum(key('plan', concat($plan, ':', $business))/OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($plan.ItbVsQuota)/node()) div count(msxsl:node-set($plan.ItbVsQuota)/node())), 'NaN', 0), '##,##0%')" /></td>
						<td nowrap="true" style="text-align: center; border-right: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/Quota) - (sum(key('plan', concat($plan, ':', $business))/InvMTD) + sum(key('plan', concat($plan, ':', $business))/OpenOrders))), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center; border-left: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/PDV)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/QuotaYTD) div count(key('plan', concat($plan, ':', $business))/QuotaYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvYTDLY)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($plan.YtdCasesVsLastYear)/node()) div count(msxsl:node-set($plan.YtdCasesVsLastYear)/node())), 'NaN', 0), '##,##0%')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(key('plan', concat($plan, ':', $business))/InvYTD) + sum(key('plan', concat($plan, ':', $business))/OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
						<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(sum(msxsl:node-set($plan.YtdItbVsQuota)/node()) div count(msxsl:node-set($plan.YtdItbVsQuota)/node())), 'NaN', 0), '##,##0%')" /></td>
					</tr>
					
					<xsl:for-each select="key('plan', concat($plan, ':', $business))">
						<tr style="background-color: #FFFFFF; font-family: Arial, Helvetica, Sans-Serif; font-size: 8pt;">
							<td width="1"><input type="hidden" /></td>
							<td nowrap="true" style="text-align: center;">&#xa0;</td>
							<td nowrap="true" style="text-align: center;">&#xa0;</td>
							<td nowrap="true" style="text-align: right;"><xsl:value-of select="PkgGrpDescription" /></td>
							<td nowrap="true" style="text-align: center;">0</td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvMTD)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvLY)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvMTD div InvLY)), 'NaN', 0), '##,##0%')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvMTD + OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((number(InvMTD + OpenOrders) div Quota)), 'NaN', 0), '##,##0%')" /></td>
							<td nowrap="true" style="text-align: center; border-right: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(number(Quota - (InvMTD + OpenOrders))), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center; border-left: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(number(PDV)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(QuotaYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvYTD)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvYtdLY)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvYTD div InvYtdLY)), 'NaN', 0), '##,##0%')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(number(InvYTD + OpenOrders)), 'NaN', 0), '###,###,###,##0')" /></td>
							<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((number(InvYTD + OpenOrders) div QuotaYTD)), 'NaN', 0), '##,##0%')" /></td>
						</tr>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:for-each>
			<tr>
				<td width="1"><input type="hidden" /></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td style="border-right: 1px solid #000000;">&#xa0;</td>
				<td style="border-left: 1px solid #000000;">&#xa0;</td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
			</tr>
			<tr style="background-color: #FFFFCC; font-family: Arial, Helvetica, Sans-Serif; font-size: 10pt; font-weight: bold;">
				<td width="1"><input type="hidden" /></td>
				<td>&#xa0;</td>
				<td nowrap="true" style="text-align: left">Grand Total</td>
				<td>&#xa0;</td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/Quota + /Data/Row2/Quota + /Data/Row3/Quota + /Data/Row4/Quota), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/TyCases + /Data/Row2/TyCases + /Data/Row3/TyCases + /Data/Row4/TyCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/LyCases + /Data/Row2/LyCases + /Data/Row3/LyCases + /Data/Row4/LyCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((/Data/Row1/TyCases + /Data/Row2/TyCases + /Data/Row3/TyCases + /Data/Row4/TyCases) div (/Data/Row1/LyCases +K/Data/Row2/LyCases + /Data/Row3/LyCases + /Data/Row4/LyCases)), 'NaN', 0), '##,##0%')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/OpenOrders + /Data/Row2/OpenOrders + /Data/Row3/OpenOrders + /Data/Row4/OpenOrders), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/ItbCases + /Data/Row2/ItbCases + /Data/Row3/ItbCases + /Data/Row4/ItbCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((/Data/Row1/ItbCases + /Data/Row2/ItbCases + /Data/Row3/ItbCases + /Data/Row4/ItbCases) div (/Data/Row1/Quota + /Data/Row2/Quota + /Data/Row3/Quota + /Data/Row4/Quota)), 'NaN', 0), '##,##0%')" /></td>
				<td nowrap="true" style="text-align: center; border-right: 1px solid #000000;"><xsl:value-of select="format-number(translate(string((/Data/Row1/Quota + /Data/Row2/Quota + /Data/Row3/Quota + /Data/Row4/Quota) - (/Data/Row1/ItbCases + /Data/Row2/ItbCases + /Data/Row3/ItbCases + /Data/Row4/ItbCases)), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center; border-left: 1px solid #000000;"><xsl:value-of select="format-number(translate(string(/Data/Row1/NewItbCases + /Data/Row2/NewItbCases + /Data/Row3/NewItbCases + /Data/Row4/NewItbCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/YtdQuota + /Data/Row2/YtdQuota + /Data/Row3/YtdQuota + /Data/Row4/YtdQuota), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/TyYtdInvCases + /Data/Row2/TyYtdInvCases + /Data/Row3/TyYtdInvCases + /Data/Row4/TyYtdInvCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/LyYtdInvCases + /Data/Row2/LyYtdInvCases + /Data/Row3/LyYtdInvCases + /Data/Row4/LyYtdInvCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((/Data/Row1/TyYtdInvCases + /Data/Row2/TyYtdInvCases + /Data/Row3/TyYtdInvCases + /Data/Row4/TyYtdInvCases) div (/Data/Row1/LyYtdInvCases + /Data/Row2/LyYtdInvCases + /Data/Row3/LyYtdInvCases + /Data/Row4/LyYtdInvCases)), 'NaN', 0), '##,##0%')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string(/Data/Row1/YtdItbCases + /Data/Row2/YtdItbCases + /Data/Row3/YtdItbCases + /Data/Row4/YtdItbCases), 'NaN', 0), '###,#####,###,###,##0')" /></td>
				<td nowrap="true" style="text-align: center;"><xsl:value-of select="format-number(translate(string((/Data/Row1/YtdItbCases + /Data/Row2/YtdItbCases + /Data/Row3/YtdItbCases + /Data/Row4/YtdItbCases) div (/Data/Row1/YtdQuota + /Data/Row2/YtdQuota + /Data/Row3/YtdQuota + /Data/Row4/YtdQuota)), 'NaN', 0), '##,##0%')" /></td>
			</tr>			
		</table>
	</xsl:template>
	
	<xsl:template match="Row" mode="PeriodCasesVsLastYear">
		<item><xsl:value-of select="InvMTD div InvLY" /></item>
	</xsl:template>
	
	<xsl:template match="Row" mode="ItbVsQuota">
		<item><xsl:value-of select="(OpenOrders + InvMTD) div Quota" /></item>
	</xsl:template>
	
	<xsl:template match="Row" mode="YtdCasesVsLastYear">
		<item><xsl:value-of select="InvYTD div InvYTDLY" /></item>
	</xsl:template>
	
	<xsl:template match="Row" mode="YtdItbVsQuota">
		<item><xsl:value-of select="(InvYTD div InvYTDLY) div QuotaYTD" /></item>
	</xsl:template>

</xsl:stylesheet>
