# How To Contribute

Thank you for showing interest to contributing to aptdec, these guidelines layout how you should go about reporting issues and contributing.

## Did you Find A Bug?

1. Ensure the bug was not already reported by searching on GitHub under Issues.
2. If you're unable to find an closed issue addressing the problem, open a new one. Be sure to include a title and clear description, as much relevant information as possible and an audio file that demonstrates what is unexpected behaviour.
3. If possible, use the report templates to create the issue.

## Do you have a patch that fixes a bug?

1. Fork the repository and push your changes on a new branch.
2. Add your changes on that branch, make sure to use sensible commit names.
3. Open a new GitHub pull request to pull into master.
4. Ensure the pull request description clearly describes the problem and solution. Include the relevant issue number if applicable.

## Coding style

- Whitespaces should be denoted with tabs
- This is FOSS software, consider that people will read your code, so make it easily readable.
- If you're making major changes, make sure to create an issue to discuss it.

## Commit message style

- Keep titles under 80 characters to prevent wrapping.
- Make sure the commit message is descriptive of the change, dont be afraid to go into detail.
- Split up large changes into multiple commits.
