!! Copyright (C) 2004-2012 M. Oliveira, F. Nogueira
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!

module math_m
  use global_m
  use linalg_m
  implicit none


                    !---Public/Private Statements---!

  private
  public :: sort, &
            polynomial_extrapolative_integration


contains

  !-----------------------------------------------------------------------
  !>
  !-----------------------------------------------------------------------
  subroutine sort(a, ind)
    real(R8),           intent(inout) :: a(:)
    integer,  optional, intent(inout) :: ind(:)

    integer  :: i, j, inc, n, indi, indj
    real(R8) :: v

    n = size(a)

    if(present(ind)) then
      do i = 1, n
        ind(i) = i
      end do
    end if

    inc = 1
    do
      inc = 3*inc + 1
      if (inc > n) exit
    end do

    do
      inc = inc/3
      do i = inc + 1,n
        v = a(i)
        if (present(ind)) indi = ind(i)
        j = i
        do
          if (a(j - inc) <= v) exit
          !if (a(j-inc) >= v) exit
          a(j) = a(j - inc)

          !workaround to a bug in itanium ifort
          !if(present(ind)) ind(j) = ind(j-inc)
          if(present(ind)) indj = ind(j - inc)
          if(present(ind)) ind(j) = indj

          j = j - inc
          if (j <= inc) exit
        end do
        a(j) = v
        if(present(ind)) ind(j) = indi
      end do
      if (inc <= 1) exit
    end do

  end subroutine sort

  !-----------------------------------------------------------------------
  !>
  !-----------------------------------------------------------------------
  function polynomial_extrapolative_integration(n, x, f, a, b) result(int)
    integer,  intent(in) :: n
    real(R8), intent(in) :: x(n), f(n), a, b
    real(R8) :: int

    integer :: i, j
    real(R8), allocatable :: eq(:,:), c(:)

    !First we extrapolate. We will directly solve the system of
    !equations for the coefficients of the polynomial. This is not
    !very efficient, but we will assume "n" to be small.
    allocate(eq(n,n), c(n))
    do j = 1, n
      do i = 1, n
        eq(j, i) = x(j)**(i-1)
      end do
    end do
    call solve_linear_system(n, eq, f, c)

    !Then we compute the integral
    int = M_ZERO
    do i = 1, n
      int = int + c(i)/real(i,R8)*(b**i - a**i)
    end do

    deallocate(eq, c)

  end function polynomial_extrapolative_integration

end module math_m
