!! Copyright (C) 2004-2010 M. Oliveira, F. Nogueira
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!
!! $Id: ape.F90 778 2013-07-11 15:49:39Z micael $

#include "global.h"

program ape
  use global_m
  use oct_parser_m
  use parser_symbols_m
  use utilities_m
  use messages_m
  use run_ape_m
  implicit none

  integer :: ierr
#if LIBXC_VERSION >= 200
  integer :: major, minor
#endif

  !Initialize parser
  ierr = oct_parse_init('parser.log', 0)
  if(ierr .ne. 0) then
    message(1) = "Unable to initialize parser."
    call write_fatal(1)
  end if
  call set_parser_symbols()
  ierr = oct_parse_input('inp.ape')
  if(ierr .ne. 0) then
    ierr = oct_parse_input("-")
    if(ierr .ne. 0) then
      message(1) = "Error initializing the parser."
      message(2) = "Can not open input file or standard input!"
      call write_fatal(2)
    end if
  end if

  !Start messages
  call messages_init()

  !If in debug mode, create the debug directory
  if (in_debug_mode) call sys_mkdir("debug_info")

  !Print some stuff and tell the world when the program started
  message(1) = str_center("APE - Atomic Pseudopotentials Engine", 70)
  call write_info(1)
  call print_date("Program started on ")
  message(1) = "Compilation Info"
  message(2) = "  Version: "// PACKAGE_VERSION
  message(3) = "  Revision: "// LATEST_SVN
  message(4) = "  Build time: "// BUILD_TIME
  message(5) = "  C compiler: "// CC
  message(6) = "  C compiler flags: "// CFLAGS
  message(7) = "  Fortran compiler: "// FC
  message(8) = "  Fortran compiler flags: "// FCFLAGS
#if LIBXC_VERSION >= 200
  call xc_f90_version(major, minor)
  write(message(9),'(A,I1,A,I1)') "  Libxc version: ", major, ".", minor
  message(10) = ""
  call write_info(10)
#else
  message(9) = ""
  call write_info(9)
#endif



  !Now we really run the program
  call run()

  !End parser
  call oct_parse_end()

  !Tell the world when the program finished
  call print_date("Program finished on ")

end program ape


