/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.util.Eigen;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Measure {
    public static final float radiansPerDegree = (float)Math.PI / 180;

    public static float computeAngle(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Vector3f vector3f, Vector3f vector3f2, boolean bl) {
        vector3f.sub(tuple3f, tuple3f2);
        vector3f2.sub(tuple3f3, tuple3f2);
        float f = vector3f.angle(vector3f2);
        return bl ? f / ((float)Math.PI / 180) : f;
    }

    public static float computeAngle(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, boolean bl) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        return Measure.computeAngle(tuple3f, tuple3f2, tuple3f3, vector3f, vector3f2, bl);
    }

    public static float computeTorsion(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, boolean bl) {
        float f;
        float f2 = tuple3f.x - tuple3f2.x;
        float f3 = tuple3f.y - tuple3f2.y;
        float f4 = tuple3f.z - tuple3f2.z;
        float f5 = tuple3f3.x - tuple3f2.x;
        float f6 = tuple3f3.y - tuple3f2.y;
        float f7 = tuple3f3.z - tuple3f2.z;
        float f8 = tuple3f3.x - tuple3f4.x;
        float f9 = tuple3f3.y - tuple3f4.y;
        float f10 = tuple3f3.z - tuple3f4.z;
        float f11 = f3 * f7 - f4 * f6;
        float f12 = f4 * f5 - f2 * f7;
        float f13 = f2 * f6 - f3 * f5;
        float f14 = f6 * f10 - f7 * f9;
        float f15 = f7 * f8 - f5 * f10;
        float f16 = f5 * f9 - f6 * f8;
        float f17 = 1.0f / (f11 * f11 + f12 * f12 + f13 * f13);
        float f18 = 1.0f / (f14 * f14 + f15 * f15 + f16 * f16);
        float f19 = f11 * f14 + f12 * f15 + f13 * f16;
        float f20 = (float)Math.sqrt(f17);
        float f21 = f20 * (f = (float)Math.sqrt(f18));
        float f22 = f19 * f21;
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        if (f22 < -1.0f) {
            f22 = -1.0f;
        }
        float f23 = (float)Math.acos(f22);
        float f24 = f2 * f14 + f3 * f15 + f4 * f16;
        float f25 = Math.abs(f24);
        f23 = f24 / f25 > 0.0f ? f23 : -f23;
        return bl ? f23 / ((float)Math.PI / 180) : f23;
    }

    public static Object computeHelicalAxis(String string, int n, Point3f point3f, Point3f point3f2, Quaternion quaternion) {
        Vector3f vector3f = new Vector3f();
        vector3f.sub(point3f2, point3f);
        float f = quaternion.getTheta();
        Vector3f vector3f2 = quaternion.getNormal();
        float f2 = vector3f.dot(vector3f2);
        if (Math.abs(f2) < 1.0E-4f) {
            f2 = 0.0f;
        }
        if (n == 1073741854) {
            if (f2 != 0.0f) {
                vector3f2.scale(f2);
            }
            return vector3f2;
        }
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        if (vector3f3.dot(vector3f3) != 0.0f) {
            vector3f3.normalize();
        }
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f(vector3f2);
        if (f2 == 0.0f) {
            f2 = Float.MIN_VALUE;
        }
        vector3f5.scale(f2);
        vector3f4.sub(vector3f5, vector3f);
        vector3f4.scale(0.5f);
        vector3f3.scale(f == 0.0f ? 0.0f : (float)((double)vector3f4.length() / Math.tan((double)(f / 2.0f / 180.0f) * Math.PI)));
        Vector3f vector3f6 = new Vector3f(vector3f3);
        if (f != 0.0f) {
            vector3f6.add(vector3f4);
        }
        if (n == 1666189313) {
            return vector3f6;
        }
        Point3f point3f3 = new Point3f(point3f);
        point3f3.sub(vector3f6);
        if (n == 0x8100010) {
            return point3f3;
        }
        if (f2 != Float.MIN_VALUE) {
            vector3f2.scale(f2);
        }
        Point3f point3f4 = new Point3f(point3f3);
        point3f4.add(vector3f2);
        f = Measure.computeTorsion(point3f, point3f3, point3f4, point3f2, true);
        if (Float.isNaN(f) || vector3f6.length() < 1.0E-4f) {
            f = quaternion.getThetaDirected(vector3f2);
        }
        if (n == 0x8100001) {
            return new Float(f);
        }
        if (n == 135184) {
            return "draw ID " + string + " VECTOR " + Escape.escape(point3f3) + " " + Escape.escape(vector3f2) + " color " + (f < 0.0f ? "{255.0 200.0 0.0}" : "{255.0 0.0 128.0}");
        }
        if (n == 1746538509) {
            return "measure " + Escape.escape(point3f) + Escape.escape(point3f3) + Escape.escape(point3f4) + Escape.escape(point3f2);
        }
        float f3 = Math.abs(f == 0.0f ? 0.0f : 360.0f / f);
        float f4 = Math.abs(f2 == Float.MIN_VALUE ? 0.0f : vector3f2.length() * (f == 0.0f ? 1.0f : 360.0f / f));
        switch (n) {
            case 135266306: {
                return new Object[]{point3f3, vector3f2, vector3f6, new Point3f(f, f4, f3)};
            }
            case 7: {
                return new String[]{Escape.escape(point3f3), Escape.escape(vector3f2), Escape.escape(vector3f6), Escape.escape(new Point3f(f, f4, f3))};
            }
        }
        return null;
    }

    public static Point4f getPlaneThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        return new Point4f(vector3f.x, vector3f.y, vector3f.z, f);
    }

    public static Point4f getPlaneThroughPoint(Point3f point3f, Vector3f vector3f) {
        return new Point4f(vector3f.x, vector3f.y, vector3f.z, -vector3f.dot(new Vector3f(point3f)));
    }

    public static float distanceToPlane(Point4f point4f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
    }

    public static float distanceToPlane(Point4f point4f, float f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / f;
    }

    public static float distanceToPlane(Vector3f vector3f, float f, Point3f point3f) {
        return vector3f == null ? Float.NaN : (vector3f.x * point3f.x + vector3f.y * point3f.y + vector3f.z * point3f.z + f) / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
    }

    public static void calcNormalizedNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f2.sub(point3f2, point3f);
        vector3f3.sub(point3f3, point3f);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
    }

    public static float getDirectedNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        if (point3f4 != null) {
            Point3f point3f5 = new Point3f(point3f);
            point3f5.add(vector3f);
            float f2 = point3f5.distance(point3f4);
            point3f5.set(point3f);
            point3f5.sub(vector3f);
            if (f2 > point3f5.distance(point3f4)) {
                vector3f.scale(-1.0f);
                f = -f;
            }
        }
        return f;
    }

    public static float getNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Measure.calcNormalizedNormal(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        vector3f2.set(point3f);
        float f = -vector3f2.dot(vector3f);
        return f;
    }

    public static void moveToPlane(Point4f point4f, Point3f point3f) {
        float f = Measure.distanceToPlane(point4f, point3f);
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        vector3f.scale(-f);
        point3f.add(vector3f);
    }

    public static boolean getNormalFromCenter(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, boolean bl, Vector3f vector3f) {
        boolean bl2;
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        float f = Measure.getNormalThroughPoints(point3f2, point3f3, point3f4, vector3f, vector3f2, vector3f3);
        boolean bl3 = bl2 = Measure.distanceToPlane(vector3f, f, point3f) > 0.0f;
        if (bl2 == bl) {
            vector3f.scale(-1.0f);
        }
        return !bl2;
    }

    public static void calcXYNormalToLine(Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(point3f);
        vector3f2.sub(point3f2);
        vector3f.cross(vector3f2, JmolConstants.axisY);
        vector3f.normalize();
        if (Float.isNaN(vector3f.x)) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        }
    }

    public static void projectOntoAxis(Point3f point3f, Point3f point3f2, Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.sub(point3f, point3f2);
        float f = vector3f2.dot(vector3f);
        point3f.set(vector3f);
        point3f.scaleAdd(f, point3f2);
        vector3f2.sub(point3f, point3f2);
    }

    public static void calcBestAxisThroughPoints(Point3f[] point3fArray, Point3f point3f, Vector3f vector3f, Vector3f vector3f2, int n) {
        int n2 = point3fArray.length;
        point3f.set(point3fArray[0]);
        vector3f.sub(point3fArray[n2 - 1], point3f);
        vector3f.normalize();
        Measure.calcAveragePointN(point3fArray, n2, point3f);
        int n3 = 0;
        while (n3++ < n && (double)Measure.findAxis(point3fArray, n2, point3f, vector3f, vector3f2) > 0.001) {
        }
        Point3f point3f2 = new Point3f(point3fArray[0]);
        Measure.projectOntoAxis(point3f2, point3f, vector3f, vector3f2);
        point3f.set(point3f2);
    }

    public static float findAxis(Point3f[] point3fArray, int n, Point3f point3f, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Vector3f vector3f5 = new Vector3f(vector3f);
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            point3f2.set(point3fArray[n2]);
            point3f3.set(point3f2);
            Measure.projectOntoAxis(point3f3, point3f, vector3f, vector3f2);
            vector3f4.sub(point3f2, point3f3);
            f2 += vector3f4.lengthSquared();
            vector3f4.cross(vector3f2, vector3f4);
            vector3f3.add(vector3f4);
            f += vector3f2.lengthSquared();
        }
        Vector3f vector3f6 = new Vector3f(vector3f3);
        vector3f6.scale(1.0f / f);
        vector3f4.cross(vector3f6, vector3f);
        vector3f.add(vector3f4);
        vector3f.normalize();
        vector3f4.set(vector3f);
        vector3f4.sub(vector3f5);
        return vector3f4.length();
    }

    public static void calcAveragePoint(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        point3f3.set((point3f.x + point3f2.x) / 2.0f, (point3f.y + point3f2.y) / 2.0f, (point3f.z + point3f2.z) / 2.0f);
    }

    public static void calcAveragePointN(Point3f[] point3fArray, int n, Point3f point3f) {
        point3f.set(point3fArray[0]);
        for (int i = 1; i < n; ++i) {
            point3f.add(point3fArray[i]);
        }
        point3f.scale(1.0f / (float)n);
    }

    public static Point3f[] getCenterAndPoints(List<Point3f> list) {
        int n = list.size();
        Point3f[] point3fArray = new Point3f[n + 1];
        point3fArray[0] = new Point3f();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Point3f point3f = list.get(i);
                point3fArray[i + 1] = point3f;
                point3fArray[0].add(point3f);
            }
            point3fArray[0].scale(1.0f / (float)n);
        }
        return point3fArray;
    }

    public static float getTransformMatrix4(List<Point3f> list, List<Point3f> list2, Matrix4f matrix4f, Point3f point3f) {
        Point3f[] point3fArray = Measure.getCenterAndPoints(list);
        Point3f[] point3fArray2 = Measure.getCenterAndPoints(list2);
        float[] fArray = new float[2];
        Quaternion quaternion = Measure.calculateQuaternionRotation(new Point3f[][]{point3fArray, point3fArray2}, fArray, false);
        Vector3f vector3f = new Vector3f(point3fArray2[0]);
        vector3f.sub(point3fArray[0]);
        matrix4f.set(quaternion.getMatrix(), vector3f, 1.0f);
        if (point3f != null) {
            point3f.set(point3fArray[0]);
        }
        return fArray[1];
    }

    public static Quaternion calculateQuaternionRotation(Point3f[][] point3fArray, float[] fArray, boolean bl) {
        Object object;
        Object object2;
        fArray[1] = Float.NaN;
        Quaternion quaternion = new Quaternion();
        if (point3fArray[0].length == 1 || point3fArray[0].length != point3fArray[1].length) {
            return quaternion;
        }
        int n = point3fArray[0].length - 1;
        if (bl) {
            for (int i = 1; i <= n; ++i) {
                Point3f point3f = point3fArray[0][i];
                Point3f point3f2 = point3fArray[1][i];
                if (!(point3f instanceof Atom)) break;
                Logger.info(" atom 1 " + ((Atom)point3f).getInfo() + "\tatom 2 " + ((Atom)point3f2).getInfo());
            }
        }
        if (n < 2) {
            return quaternion;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n2 = n + 1;
        while (--n2 >= 1) {
            object2 = point3fArray[0][n2];
            object = point3fArray[1][n2];
            Point3f point3f = new Point3f((Point3f)object2);
            point3f.sub(point3fArray[0][0]);
            Point3f point3f3 = new Point3f((Point3f)object);
            point3f3.sub(point3fArray[0][1]);
            d += (double)point3f.x * (double)point3f3.x;
            d2 += (double)point3f.x * (double)point3f3.y;
            d3 += (double)point3f.x * (double)point3f3.z;
            d4 += (double)point3f.y * (double)point3f3.x;
            d5 += (double)point3f.y * (double)point3f3.y;
            d6 += (double)point3f.y * (double)point3f3.z;
            d7 += (double)point3f.z * (double)point3f3.x;
            d8 += (double)point3f.z * (double)point3f3.y;
            d9 += (double)point3f.z * (double)point3f3.z;
        }
        fArray[0] = Measure.getRmsd(point3fArray, quaternion);
        double[][] dArray = new double[4][4];
        dArray[0][0] = d + d5 + d9;
        double d10 = d6 - d8;
        dArray[1][0] = d10;
        dArray[0][1] = d10;
        double d11 = d7 - d3;
        dArray[2][0] = d11;
        dArray[0][2] = d11;
        double d12 = d2 - d4;
        dArray[3][0] = d12;
        dArray[0][3] = d12;
        dArray[1][1] = d - d5 - d9;
        double d13 = d2 + d4;
        dArray[2][1] = d13;
        dArray[1][2] = d13;
        double d14 = d7 + d3;
        dArray[3][1] = d14;
        dArray[1][3] = d14;
        dArray[2][2] = -d + d5 - d9;
        double d15 = d6 + d8;
        dArray[3][2] = d15;
        dArray[2][3] = d15;
        dArray[3][3] = -d - d5 + d9;
        object2 = new Eigen(dArray);
        object = ((Eigen)object2).getEigenvectorsFloatTransposed()[3];
        quaternion = new Quaternion(new Point4f((float)object[1], (float)object[2], (float)object[3], (float)object[0]));
        fArray[1] = Measure.getRmsd(point3fArray, quaternion);
        return quaternion;
    }

    public static float getRmsd(Point3f[][] point3fArray, Quaternion quaternion) {
        double d = 0.0;
        double d2 = 0.0;
        int n = point3fArray[0].length - 1;
        Point3f point3f = new Point3f();
        int n2 = n + 1;
        while (--n2 >= 1) {
            point3f.set(point3fArray[0][n2]);
            point3f.sub(point3fArray[0][0]);
            quaternion.transform(point3f, point3f);
            point3f.add(point3fArray[1][0]);
            double d3 = point3f.distance(point3fArray[1][n2]);
            d += d3;
            d2 += d3 * d3;
        }
        return (float)Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1));
    }

    public static List<Point3f> transformPoints(List<Point3f> list, Matrix4f matrix4f, Point3f point3f) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (int i = 0; i < list.size(); ++i) {
            Point3f point3f2 = new Point3f(list.get(i));
            point3f2.sub(point3f);
            matrix4f.transform(point3f2, point3f2);
            point3f2.add(point3f);
            arrayList.add(point3f2);
        }
        return arrayList;
    }
}

