<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Ngociation de Contenus - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /><link href="http://httpd.apache.org/docs/2.2/content-negotiation.html" rel="canonical" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.0</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.0</a></div><div style="width: 90%;" class="outofdate"><h4>Please note</h4>
    This document refers to the 2.0 version of Apache httpd, which is no longer maintained.<br />
    Upgrade, and refer to the current version of httpd instead, documented at:<br /><ul><li><a href="http://httpd.apache.org/docs/current/">Current release version of Apache HTTP Server documentation</a></li></ul>
    You may follow <a href="http://httpd.apache.org/docs/current/content-negotiation.html">this link</a> to 
    go to the current version of this document.
</div><div id="page-content"><div id="preamble"><h1>Ngociation de Contenus</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/content-negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/content-negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/content-negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/content-negotiation.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/content-negotiation.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Consultez la version
            Anglaise pour les changements rcents.</div>


    <p>Apache suit les spcifications HTTP/1.1 en ce qui concerne 
    les ngociations de contenus. Il est ainsi possible d'utiliser
    les informations fournies par le navigateur (prfrences de langues,
    jeu de caractres, encodage et types de mdias). Apache essaye
    aussi d'optimiser les cas des navigateurs envoyant des 
    informations incompltes.</p>

    <p>C'est le module <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> qui fournit
    la ngociation de contenus&nbsp;; ce module est inclus dans Apache 
    par dfaut.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#about"> propos de la Ngociation de Contenus</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#negotiation">Ngociations avec Apache</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#methods">Mthodes de Ngociations</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#better">Tricher sur les Facteurs de Qualit</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#extensions">Extensions vers la Ngociation de Contenu
Transparente</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#naming"> propos des liens hypertextes et des conventions de nommage</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#caching"> propos des Caches</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#more">Plus d'Information</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="about" id="about"> propos de la Ngociation de Contenus</a></h2>

    <p>Diffrentes reprsentations peuvent tre utilises pour 
    communiquer une ressource. Par exemple, plusieurs langues peuvent
    tre disponibles, ou plusieurs types de mdias, voire parfois une
    combinaison de ces possibilits.
    Une mthode pour grer cela est de donner le choix au visiteur,
    en lui proposant un index gnral, qui lui permet par exemple de
    choisir sa langue. Cependant, il est souvent possible de faire ce 
    choix de manire automatique car les navigateurs peuvent prciser 
    avec leurs requtes, la reprsentation qu'ils prfrent recevoir. Par
    exemple, un navigateur pourrait spcifier qu'il prfre recevoir les
    informations en franais si elles sont disponibles, ou en anglais 
    dans le cas contraire. Ce type d'information est communiqu par les
    navigateurs, dans les en-ttes de chaque requte. Un navigateur ne
    demandant que des documents en franais enverrait</p>
    
<div class="example"><p><code>Accept-Language: fr</code></p></div>

    <p>Notez que cette prfrence ne sera gre par le serveur que
    s'il existe un choix de langues du ct du serveur.</p>

    <p>Voici un exemple plus complet, o le navigateur est configur pour
    accepter le franais et l'anglais, mais avec une prfrence pour le
    franais, et pour accepter divers types de mdias, en prfrant le 
    HTML au texte brut, et en prfrant le GIF ou le JPEG aux autres types
    de mdias (sans pour autant refuser ces derniers, le cas chant)&nbsp;:</p>

<div class="example"><p><code>
  Accept-Language: fr; q=1.0, en; q=0.5<br />
  Accept: text/html; q=1.0, text/*; q=0.8, image/gif; q=0.6, image/jpeg; q=0.6, image/*; q=0.5, */*; q=0.1
</code></p></div>

    <p>Apache supporte les ngociations de contenus 'grs par
    le serveur', telles que spcifies dans HTTP/1.1. Les en-ttes
    <code>Accept</code>, <code>Accept-Language</code>, 
    <code>Accept-Charset</code> et <code>Accept-Encoding</code> 
    sont grs. Apache supporte galement les ngociations de 
    contenus 'transparentes', telles que dfinies dans les RFC
    2295 et 2296. En revanche les fonctions de 'feature 
    negotiation' dfinies dans ces RFCs ne sont pas supportes.</p>
    
    <p>On appelle <strong>ressource</strong> une entit conceptuelle
    identifie par un URI (RFC 2396). Le travail d'un serveur HTTP,
    tel Apache, est de donner un accs  des 
    <strong>reprsentations</strong> des ressources  sa disposition,
    chaque reprsentation tant envoye sous la forme d'une squence 
    d'octets dfinie selon un type de mdia, un jeu de caractres, 
    un encodage, etc.  tout moment, chaque ressource est associe 
     zro, une ou plusieurs reprsentations. Si plusieurs reprsentations
    sont disponibles pour une ressource, on dit que cette dernire est
    <strong>ngociable</strong> et chacune de ses reprsentations
    possibles est appele une <strong>variante</strong>.
    Les diffrentes possibilits de choisir les variantes d'une ressource
    ngociable sont appeles <strong>dimensions</strong> de la 
    ngociation.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="negotiation" id="negotiation">Ngociations avec Apache</a></h2>

    <p>Pour qu'Apache puisse procder  la ngociation d'une ressource,
    il faut qu'il dispose d'informations  propos de chacune des variantes.
    Deux mthodes sont possibles&nbsp;:</p>

    <ul>
      <li>Raliser une "Table de Types" (<em>c'est--dire</em>,
      un fichier <code>*.var</code>) qui prcise explicitement les fichiers
      dfinissant les variantes, ou</li>
      
      <li>Utiliser une recherche 'MultiViews', mthode par laquelle
      le serveur ralise une recherche par motifs implicites,
      et choisit parmi les rsultats.</li>
    </ul>

   <h3><a name="type-map" id="type-map">Utilisation d'une Table de Types (Type Map)</a></h3>

    <p>Une table de types est un document qui est associ avec le 
    gestionnaire <code>type-map</code> (ou, dans les plus anciennes 
    versions d'Apache, le type mime <code>application/x-type-map</code>).
    Notez que pour implmenter cette mthode, un 'handler' doit tre
    dfini dans la configuration pour associer une extension de fichier  
    <code>type-map</code>&nbsp;; ce qui est gnralement obtenu au moyen de</p>
    
<div class="example"><p><code>AddHandler type-map .var</code></p></div>

    <p>dans le fichier de configuration du serveur.</p>

    <p>Les fichiers de table de types portent gnralement le nom de la 
    ressource qu'ils dcrivent, et contiennent une entre correspondant
     chaque variante possible&nbsp;; ces entres sont constitues de lignes
    au format d'en-ttes HTTP. Les entres de deux variantes distinctes
    sont  sparer par des lignes vides. Il n'est pas permis d'utiliser
    des lignes vides au sein d'une entre. Il est courant de placer en 
    dbut de fichier une entre pour l'entit combine 
    dans son ensemble (bien que cela ne soit pas ncessaire, et ignor
    par Apache). Un exemple de fichier de table est donn en exemple
    ci-aprs. Le nom de ce fichier serait <code>foo.var</code>, puisque
    le fichier dcrit une ressource appele <code>foo</code>.</p>
    
<div class="example"><p><code>
  URI: foo<br />
<br />
  URI: foo.en.html<br />
  Content-type: text/html<br />
  Content-language: en<br />
<br />
  URI: foo.fr.de.html<br />
  Content-type: text/html;charset=iso-8859-2<br />
  Content-language: fr, de<br />
</code></p></div>

    <p>Notez que les fichiers de table de types sont toujours
    utiliss en priorit par Apache par rapport  l'extension du
    nom du fichier, et ce mme si l'option Multiviews est active.
    Des variantes prsentant des qualits ingales peuvent tre indiques
    au moyen du paramtre de type de mdia&nbsp;: "qs", comme dans le cas de 
    cette image (disponible en JPEG, GIF ou ASCII-art)&nbsp;: </p>
    
<div class="example"><p><code>
  URI: foo<br />
<br />
  URI: foo.jpeg<br />
  Content-type: image/jpeg; qs=0.8<br />
<br />
  URI: foo.gif<br />
  Content-type: image/gif; qs=0.5<br />
<br />
  URI: foo.txt<br />
  Content-type: text/plain; qs=0.01<br />
</code></p></div>

    <p>Les valeurs de qs acceptables sont comprises entre 0.000
    et 1.000. Notez qu'une variante avec un qs de 0.000 ne sera
    jamais choisie. La valeur de qs par dfaut est de 1.0. Le
    paramtre qs sert  indiquer la qualit de la variante, par
    rapport aux autres variantes disponibles, et ce indpendamment
    des possibilits du navigateur. Par exemple, un fichier JPEG
    est gnralement de meilleure qualit qu'un fichier ASCII, si
    les 2 documents sont destins  reprsenter une photographie.
    Bien sr, si la ressource originale est elle-mme un fichier
    ASCII, la reprsentation ASCII sera considr comme de meilleure
    qualit que la reprsentation JPEG. La valeur de qs dpend donc
    de la nature de la ressource que l'on souhaite reprsenter.</p>
    
    <p>La liste complte des en-ttes utilisables est disponible
    dans la documentation de 
    <a href="mod/mod_negotiation.html#typemaps">mod_negotation</a>.</p>


<h3><a name="multiviews" id="multiviews">Multiviews</a></h3>

    <p>L'option <code>MultiViews</code> est  spcifier par rpertoire,
    ce qui signifie qu'elle peut tre utilise au moyen d'une directive
    <code class="directive"><a href="./mod/core.html#options">Options</a></code> dans une section 
    <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, 
    <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> ou 
    <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> 
    du fichier <code>httpd.conf</code>, ou dans les fichiers 
    <code>.htaccess</code> ( condition que l'option <code class="directive"><a href="./mod/core.html#allowoverride">AllowOverride</a></code> soit paramtre pour cela).
    Notez que <code>Options All</code> n'active pas l'option
    <code>MultiViews</code>&nbsp;; cette dernire doit tre positionne
    explicitement.</p>
    
    <p>Voici comment fonctionne <code>MultiViews</code>&nbsp;: supposons qu'un
    serveur reoive une requte pour <code>/some/dir/foo</code>, que l'option
    <code>MultiViews</code> soit active pour <code>/some/dir</code>, 
    et que le fichier <code>/some/dir/foo</code> <em>n'</em>existe 
    <em>pas</em>&nbsp;; alors le serveur cherche les fichiers nomms foo.* 
    dans le rpertoire /some/dir, et construit une table de types  
    partir de ces noms de fichiers. Dans la table, chaque fichier se 
    voit assigner les types de mdias et les encodages de contenu 
    tels qu'ils seraient envoys si le client les demandait par leur
    nom propre. Apache choisit alors la meilleure reprsentation  
    envoyer au client, en fonction de ses prfrences.</p>
    
    <p>L'option <code>MultiViews</code> sert aussi lors du choix d'un
    index, lorsque la directive <code class="directive"><a href="./mod/mod_dir.html#directoryindex">DirectoryIndex</a></code> est prcise. 
    Par exemple, si la configuration contient</p>
<div class="example"><p><code>DirectoryIndex index</code></p></div>
    <p>le serveur devra choisir entre les fichiers <code>index.html</code> et
    <code>index.html3</code>, dans le cas o ces deux fichiers existent. Si
    aucun de ces fichiers n'existe, mais qu'un fichier <code>index.cgi</code>
    est prsent, ce dernier sera excut par le serveur.</p>

    <p>Si  la lecture du rpertoire, un fichier est trouv 
    dont l'extension n'est pas reconnue par <code>mod_mime</code> 
    comme prcisant son jeu de caractres, sa langue, son type de 
    contenu (Content-Type) ou son encodage, alors tout dpendra de la 
    directive <code class="directive"><a href="./mod/mod_mime.html#multiviewsmatch">MultiViewsMatch</a></code>.
    Cette directive prcise en effet quels gestionnaires, filtres, et
    autres types d'extensions peuvent contribuer  la ngociation
    MultiViews.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="methods" id="methods">Mthodes de Ngociations</a></h2>

    <p>Aprs qu'Apache ait dfini la liste de variantes possibles 
    pour une ressource, que ce soit via un fichier de tables de 
    types ou  partir des noms de fichiers contenus dans le rpertoire, 
    deux mthodes peuvent tre invoques pour choisir la 'meilleure' 
    variante qui sera envoye, pour autant qu'il en existe au moins 
    une. Il n'est pas ncessaire de connatre ce fonctionnement pour 
    utiliser les ngociations de contenu avec Apache&nbsp;; cependant pour 
    le lecteur intress la suite de ce document s'attache  dcrire 
    ce fonctionnement.</p>
    
    <p>Il existe deux mthodes de ngociations&nbsp;:</p>

    <ol>
      <li><strong>La ngociation mene par le serveur, selon 
      l'algorithme d'Apache</strong>, est utilise dans la plupart 
      des cas. L'algorithme d'Apache est dtaill dans la suite de 
      ce document. Dans les cas o cet algorithme est utilis, il 
      arrive qu'Apache 'triche' sur le facteur qualit (qs) d'une 
      dimension donne pour parvenir  un meilleur rsultat. Les cas 
      o cela se produit sont prsents dans la suite de ce document.</li>

      <li><strong>La ngociation transparente de contenu</strong> 
      est utilise sur demande spcifique du navigateur, selon la 
      mthode dfinie dans la RFC 2295. Cette mthode de ngociation 
      donne au navigateur les pleins pouvoirs pour choisir la 
      'meilleure' variante, les rsultats dpendent donc des algorithmes 
      de choix propres  chaque navigateur. Cette mthode permet 
      galement au navigateur de demander  Apache d'utiliser 
      l'algorithme de 'slection de variante  distance', tel que dfini 
      par la RFC 2296.</li>
    </ol>
      
<h3><a name="dimensions" id="dimensions">Dimensions d'une Ngociation</a></h3>

    <table>
      
      <tr valign="top">
        <th>Dimension</th>

        <th>Notes</th>
      </tr>

      <tr valign="top">
        <td>Type de Mdia</td>

        <td>Le navigateur prsente ses prfrences au moyen du 
        champ <code>Accept</code> de l'en-tte.  chaque lment peut tre 
        associ un facteur de qualit. De la mme manire, la description 
        de la variante peut prsenter un facteur de qualit (le 
        paramtre "qs").</td>
      </tr>

      <tr valign="top">
        <td>Langues</td>

        <td>Le navigateur prsente ses prfrences au moyen du champ 
        <code>Accept-Language</code> de l'en-tte.  chaque lment 
        peut tre associ un facteur de qualit. Les diffrentes 
        variantes peuvent galement tre associes ou non  une 
        ou plusieurs langues.</td>
      </tr>

      <tr valign="top">
        <td>Encodage</td>

        <td>Le navigateur prsente ses prfrences au moyen du champ 
        <code>Accept-Encoding</code> de l'en-tte.  chaque lment 
        peut tre associ un facteur de qualit.</td>
      </tr>

      <tr valign="top">
        <td>Jeu de caractres</td>

        <td>Le navigateur prsente ses prfrences au moyen du champ 
        <code>Accept-Charset</code> de l'en-tte.  chaque lment 
        peut tre associ un facteur de qualit. Les diffrentes 
        variantes peuvent se voir associer un jeu de caractres 
        comme type de mdia.</td>
      </tr>
    </table>


<h3><a name="algorithm" id="algorithm">Algorithme de Ngociation d'Apache</a></h3>

    <p>Apache peut utiliser l'algorithme prsent ci-aprs pour choisir la
    'meilleure' variante, si elle existe,  renvoyer au navigateur. Cet
    algorithme n'est pas configurable. Il fonctionne de cette manire&nbsp;:</p>

    <ol>
      <li>En premier lieu, pour chaque dimension de la ngociation, 
      vrifier le champ d'en-tte <em>Accept*</em> appropri et 
      attribuer un facteur de qualit  chacune des variantes. Si 
      l'en-tte <em>Accept*</em> d'une dimension indique que cette 
      variante n'est pas acceptable, liminer cette variante. S'il 
      ne reste aucune variante, aller  l'tape 4.</li>

      <li>
        Choisir la 'meilleure' des variantes par limination. 
        Chacun des tests suivants est appliqu dans cet ordre. 
        Toutes les variantes ne passant pas un test sont 
        systmatiquement limines. Aprs chacun des tests, s'il 
        ne reste qu'une variante, la choisir comme la meilleure 
        et aller  l'tape 3. S'il reste plus d'une variante, aller 
         l'tape suivante.
	
        <ol>
          <li>Multiplier le facteur de qualit de l'en-tte 
          <code>Accept</code> par le facteur qualit de la source du 
          type de mdia de cette variante, et choisir les variantes 
          avec le plus grand rsultat.</li>
	  
          <li>Choisir les variantes qui prsentent le plus grand 
          facteur de qualit de langue.</li>

          <li>Choisir les variantes dont la langue correspond le 
          mieux, soit  l'ordre de prfrence des langues dans 
          l'en-tte <code>Accept-Language</code> (s'il existe), 
          soit  l'ordre des langues de la directive 
          <code>LanguagePriority</code> (si elle existe).</li>
	  
          <li>Choisir les variantes prsentant le paramtre de niveau 
          ('level') de mdia le plus grand (c'est ce qui est utilis 
          pour connatre la version des types de mdias text/html).</li>

          <li>Choisir les variantes dont le jeu de caractres est le 
          meilleur, par rapport  l'en-tte <code>Accept-Charset</code>. 
          Le jeu de caractres ISO-8859-1 est toujours acceptable,  
          moins qu'il n'ait t explicitement refus. Les variantes 
          avec un type de mdia <code>test/*</code> et qui ne sont 
          pas explicitement associes  un jeu de caractre donn 
          sont supposes encodes en ISO-8859-1.</li>

          <li>Choisir les variantes qui ont un jeu de caractres 
          dfini et qui <em>n'</em>est <em>pas</em> ISO-8859-1. 
          S'il n'existe pas de telles variantes, alors les 
          choisir toutes.</li>

          <li>Choisir les variantes prsentant le meilleur encodage. 
          S'il existe des variantes avec un encodage acceptable par 
          le 'user-agent' du navigateur, choisir ces variantes seules. 
          Dans le cas contraire, s'il existe  la fois des variantes 
          encodes et non encodes, ne choisir que les variantes 
          non encodes. Dans les autres cas, choisir toutes les 
          variantes.</li>

          <li>Choisir les variantes prsentant la plus petite taille.</li>

          <li>Choisir la premire variante de celles qui restent. Ce 
          sera donc soit la premire variante liste dans le fichier 
          des tables de types, soit, si les variantes sont lues d'un 
          rpertoire, celle dont le nom apparat en premier dans un 
          classement par code ASCII.</li>
        </ol>
      </li>

      <li>Cet algorithme a permis de choisir la 'meilleure' des 
      variantes, qui est renvoye en rponse  la requte du 
      navigateur. L'en-tte <code>Vary</code> de la rponse HTTP 
      est utilis pour indiquer les dimensions de la ngociation 
      (les navigateurs et les serveurs mandataires sont capables de 
      prendre en compte cette information quand il gardent une 
      ressource en cache). Fin des oprations.</li>
      
      <li>Arriver  ce point signifie qu'aucune variante n'a pu tre 
      choisie, car aucune n'est acceptable aux yeux du navigateur. 
      Renvoyer une erreur 406 ("No acceptable representation" - NdT&nbsp;: 
      "Aucune reprsentation acceptable") dans un document HTML 
      prsentant les diverses variantes possibles. L'en-tte HTTP 
      <code>Vary</code> est galement renseign pour prsenter les 
      dimensions de la ngociation.</li>
    </ol>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="better" id="better">Tricher sur les Facteurs de Qualit</a></h2>

    <p>Il arrive qu'Apache modifie les facteurs de qualit par rapport 
     la valeur qu'ils devraient avoir en suivant strictement 
    l'algorithme dcrit plus haut. Ceci permet d'obtenir de meilleurs 
    rsultats pour grer les navigateurs qui n'envoient pas toutes 
    les informations ou envoient des informations errones. Ainsi, 
    certains navigateurs, parmi les plus rpandus du march, envoient 
    des en-ttes <code>Accept</code> qui entraneraient l'envoi de la 
    mauvaise variante dans de nombreux cas. Si le navigateur envoie 
    des informations correctes, Apache ne trichera pas sur les facteurs 
    de qualit.</p>

<h3><a name="wildcards" id="wildcards">Types de Mdias et Jokers</a></h3>

    <p>L'en-tte de requte <code>Accept:</code> indique les prfrences 
    des types de mdias. Elle peut comporter des 'jokers' tels que 
    "image/*" ou "*/*", o * signifie "n'importe quoi". Ainsi, une 
    requte prsentant&nbsp;:</p>

<div class="example"><p><code>Accept: image/*, */*</code></p></div>

    <p>signifierait que tout type commenant par "image/" est 
    acceptable, comme serait acceptable tout autre type. Certains 
    navigateurs envoient sans arrt des jokers en plus des types 
    qu'ils peuvent effectivement grer. Par exemple&nbsp;:</p>

<div class="example"><p><code>
  Accept: text/html, text/plain, image/gif, image/jpeg, */*
</code></p></div>
    <p>Le but de ces informations est d'indiquer que les types 
    explicitement cits sont les prfrs mais que le 
    navigateur accepte galement d'autres reprsentations. 
    En utilisant les facteurs de qualit, voici ce que devrait 
    envoyer le navigateur&nbsp;:</p>
<div class="example"><p><code>
  Accept: text/html, text/plain, image/gif, image/jpeg, */*; q=0.01
</code></p></div>
    <p>Les types explicitement cits ne prsentent pas de facteur 
    de qualit, ils reoivent donc la valeur par dfaut de 1.0 
    (la plus haute valeur possible). Les jokers sont affects 
    d'une prfrence trs basse de 0.01, si bien que les autres 
    types ne seront utiliss que si aucune des variantes ne 
    correspond  un des types explicitement prfrs.</p>

    <p>Si le champ d'en-tte <code>Accept:</code> <em>ne</em> 
    contient <em>aucun</em> facteur de qualit, Apache modifie 
    le facteur de qualit de "*/*" (s'il est prsent) en 0.01 
    afin d'muler le comportement souhait. Apache positionne 
    galement le facteur de qualit des jokers qui se prsentent 
    sous la forme "type/*" en 0.02 (afin que ces derniers soient 
    prfrs  "*/*"). Si un seul ou plusieurs types de mdia de 
    l'en-tte <code>Accept:</code> prsente un facteur de qualit, 
    ces modifications <em>ne</em> sont <em>pas</em> effectues, 
    afin que les requtes des navigateurs qui envoient des 
    informations correctes fonctionnent comme prvu.</p>


<h3><a name="exceptions" id="exceptions">Exceptions aux Ngociations sur la Langue</a></h3>

    <p> partir d'Apache 2.0, certaines exceptions ont t ajoutes 
     l'algorithme de ngociation afin de retomber lgamment sur 
    nos pattes dans les cas o la ngociation sur la langue 
    n'aboutit pas.</p>
    
    <p>Si un client demande une page du serveur, sans que ce dernier 
    ne puisse dterminer une page correspondant au champ 
    <code>Accept-language</code> envoy par le navigateur, le serveur 
    doit renvoyer une rponse parmi "Pas de Variante Acceptable" 
    et "Choix Multiples" au client. Afin d'viter ces messages 
    d'erreur, il est possible de configurer Apache pour qu'il ignore 
    le champ <code>Accept-language</code> dans ces cas et qu'il 
    fournisse au client un document qui ne correspond pas 
    explicitement  sa requte. La directive 
    <code class="directive"><a href="./mod/mod_negotiation.html#forcelanguagepriority">ForceLanguagePriority</a></code> 
    peut tre utilise pour passer outre  ces deux messages d'erreur 
    et modifier la rponse du serveur au moyen de la directive 
    <code class="directive"><a href="./mod/mod_negotiation.html#languagepriority">LanguagePriority</a></code>.</p>

    <p>Le serveur va galement essayer de modifier la sous-classe 
    de langue si aucune correspondance n'est trouve. Par exemple, 
    dans le cas o un client demande des documents avec le langage 
    <code>en-GB</code> pour "British English", le protocole HTTP/1.1 
    n'autorise pas le serveur  rpondre par un document qui serait 
    marqu par <code>en</code>. (Notez que prsenter 
    <code>en-GB</code> dans l'en-tte <code>Accept-language</code> 
    est loin d'tre pertinent, il semble trs peu probable que le 
    lecteur comprenne l'anglais "British" et ne comprenne pas 
    l'anglais "tout court". Il se trouve malheureusement que 
    beaucoup de navigateurs prsentent ce comportement.) Bref, 
    si aucune autre langue ne correspond et que le serveur 
    s'apprterait normalement  envoyer une rponse d'erreur 
    "No Acceptable Variants", ou  utiliser la mthode 
    <code class="directive"><a href="./mod/mod_negociation.html#languagepriority">LanguagePriority</a></code> 
    prsente ci-avant, le serveur va ignorer la sous-classe de 
    langue <code>GB</code> et considrer que la requte 
    <code>en-GB</code> correspond bien au document <code>en</code>. 
    Implicitement, Apache ajoute la langue parente (<code>en</code>) 
     la liste des langues considres comme acceptables par le 
    navigateur, avec un facteur de qualit trs faible. Notez 
    cependant que si le client demande "en-GB; qs=0.9, fr; qs=0.8", 
    et que le serveur dispose de documents marqus comme "en" et 
    "fr", alors le document en franais sera renvoy par le serveur. 
    Ce comportement est ncessaire, afin de garder la compatibilit 
    avec HTTP/1.1 et fonctionner avec les navigateurs correctement 
    configurs.</p>
    
    <p>Pour supporter les techniques avances de dtection de
    prfrence de langues de l'utilisateur (telles que les 
    Cookies, ou les chemins d'URL spciaux), Apache reconnat 
    depuis la version 2.0.47 la <a href="env.html">variable 
    d'environnement</a> <code>prefer-language</code>. Si cette 
    variable existe, et qu'elle prcise une langue valide, 
    <code class="module"><a href="./mod/mod_negociation.html">mod_negociation</a></code> cherchera une variante qui 
    y corresponde. S'il n'en trouve pas, le processus de 
    ngociation normal se droulera.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      SetEnvIf Cookie "language=en" prefer-language=en<br />
      SetEnvIf Cookie "language=fr" prefer-language=fr
    </code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="extensions" id="extensions">Extensions vers la Ngociation de Contenu
Transparente</a></h2>

<p>Apache complte le protocole de ngociation de contenu (RFC 2295) 
comme dcrit ici. Un nouvel lment <code>{encoding ..}</code> est 
utilis dans la liste des variantes pour nommer celles qui ne sont 
disponibles que sous un encodage spcifique. L'implmentation de 
l'algorithme RVSA/1.0 (RFC 2296) est tendue afin d'intgrer les 
variantes encodes dans la liste, et de les proposer comme 
candidates quand leur encodage est acceptable au vu de l'en-tte 
<code>Accept-Encoding</code>. L'implmentation RVSA/1.0 ne tronque 
pas les facteurs de qualit  5 dcimales avant de choisir la 
meilleure des variantes.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="naming" id="naming"> propos des liens hypertextes et des conventions de nommage</a></h2>

    <p>Dans le cas o la ngociation de langues est utilise, il est 
    possible de choisir diverses conventions de nommage, car les 
    fichiers peuvent prsenter plus d'une extension, et l'ordre des 
    extensions n'est normalement pas significatif (voir la 
    documentation <a href="mod/mod_mime.html#multipleext">mod_mime</a> 
    pour plus de dtails).</p>

    <p>Habituellement, un fichier a une extension pour son type MIME 
    (par exemple, <code>html</code>), parfois une extension pour son 
    encodage (par exemple, <code>gz</code>), et bien sr une extension 
    de langue (par exemple, <code>en</code>) pour distinguer les 
    diverses variantes.</p>

    <p>Exemples&nbsp;:</p>

    <ul>
      <li>foo.en.html</li>

      <li>foo.html.en</li>

      <li>foo.en.html.gz</li>
    </ul>

    <p>Voici d'autres exemples de noms de fichiers ainsi que des liens
    hypertextes valides et invalides&nbsp;:</p>

    <table class="bordered">
      
      <tr>
        <th>Nom de Fichier</th>

        <th>Lien valide</th>

        <th>Lien invalide</th>
      </tr>

      <tr>
        <td><em>foo.html.en</em></td>

        <td>foo<br />
         foo.html</td>

        <td>-</td>
      </tr>

      <tr>
        <td><em>foo.en.html</em></td>

        <td>foo</td>

        <td>foo.html</td>
      </tr>

      <tr>
        <td><em>foo.html.en.gz</em></td>

        <td>foo<br />
         foo.html</td>

        <td>foo.gz<br />
         foo.html.gz</td>
      </tr>

      <tr>
        <td><em>foo.en.html.gz</em></td>

        <td>foo</td>

        <td>foo.html<br />
         foo.html.gz<br />
         foo.gz</td>
      </tr>

      <tr>
        <td><em>foo.gz.html.en</em></td>

        <td>foo<br />
         foo.gz<br />
         foo.gz.html</td>

        <td>foo.html</td>
      </tr>

      <tr>
        <td><em>foo.html.gz.en</em></td>

        <td>foo<br />
         foo.html<br />
         foo.html.gz</td>

        <td>foo.gz</td>
      </tr>
    </table>

    <p>Le tableau ci-dessus montre qu'il est toujours possible de 
    spcifier le lien sans aucune extension dans un lien hypertexte. 
    (par exemple, <code>foo</code>). L'avantage en est qu'il est 
    ainsi possible de ne pas montrer le type d'un document, et de 
    le modifier ultrieurement, par exemple le passer de <code>html</code> 
     <code>shtml</code> ou <code>cgi</code> sans avoir besoin de 
    modifier aucun lien.</p>
    
    <p>Pour continuer  utiliser les types MIME dans les liens 
    (par exemple, <code>foo.html</code>), l'extension correspondant 
     la langue (ainsi que l'extension d'encodage, si elle existe) 
    doit tre du cot droit de l'extension du type MIME (par exemple, 
    <code>foo.html.en</code>).</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="caching" id="caching"> propos des Caches</a></h2>

    <p>Quand un cache garde en mmoire une reprsentation, il l'associe 
     l'URL de la requte. Quand la mme URL vient  tre redemande, 
    le cache peut utiliser la reprsentation garde en mmoire, plutt 
    que de refaire une requte au serveur. Cependant, si la ressource 
    est ngociable cot serveur, le rsultat pourrait en tre que la 
    rponse  la premire requte mise en cache serait renvoye de 
    faon errone. Pour prvenir ce problme, Apache marque toutes 
    les rponses issues d'une ngociation comme "non-cachables" par 
    les clients HTTP/1.0. Apache supporte les spcifications du 
    protocole HTTP/1.1 en ce qui concerne la mise en cache des 
    rponses ngocies.</p>

    <p>Les requtes venant d'un client conforme au protocole HTTP/1.0 
    (qu'il s'agisse d'un navigateur ou d'un serveur cache) peuvent 
    tre rendues "cachables" si la directive <code class="directive"><a href="./mod/mod_negociation.html#cachenegotiateddocs">CacheNegotiatedDocs</a></code> est 
    utilise. Cette directive peut tre spcifie aussi bien dans 
    la configuration principale du serveur que dans un serveur 
    virtuel, et ne ncessite pas d'argument. Elle n'a aucun impact 
    sur les requtes des clients fonctionnant en HTTP/1.1.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="more" id="more">Plus d'Information</a></h2>

    <p>Pour plus d'informations au sujet de la ngociation de contenu, voir
    <a href="http://ppewww.ph.gla.ac.uk/~flavell/www/lang-neg.html">Language
    Negotiation Notes</a> de Alan J. Flavell. Notez que ce 
    document ne sera peut-tre pas mis  jour en fonction des 
    changements intervenus dans Apache 2.0.</p>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/content-negotiation.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/content-negotiation.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/content-negotiation.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/content-negotiation.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/content-negotiation.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>