/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.ConcurrentLFUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFUCache<K, V>
implements SolrCache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LFUCache.class);
    public static final String TIME_DECAY_PARAM = "timeDecay";
    public static final String CLEANUP_THREAD_PARAM = "cleanupThread";
    public static final String INITIAL_SIZE_PARAM = "initialSize";
    public static final String MIN_SIZE_PARAM = "minSize";
    public static final String ACCEPTABLE_SIZE_PARAM = "acceptableSize";
    public static final String AUTOWARM_COUNT_PARAM = "autowarmCount";
    public static final String SHOW_ITEMS_PARAM = "showItems";
    private List<ConcurrentLFUCache.Stats> statsList;
    private long warmupTime = 0L;
    private String name;
    private int autowarmCount;
    private SolrCache.State state;
    private CacheRegenerator regenerator;
    private String description = "Concurrent LFU Cache";
    private ConcurrentLFUCache<K, V> cache;
    private int showItems = 0;
    private Boolean timeDecay = true;
    private int maxIdleTimeSec;
    private MetricsMap cacheMap;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private SolrMetricsContext solrMetricsContext;
    private int maxSize;
    private int minSizeLimit;
    private int initialSize;
    private int acceptableSize;
    private boolean cleanupThread;

    @Override
    public Object init(Map args, Object persistence, CacheRegenerator regenerator) {
        this.state = SolrCache.State.CREATED;
        this.regenerator = regenerator;
        this.name = (String)args.get("name");
        String str = (String)args.get("size");
        this.maxSize = str == null ? 1024 : Integer.parseInt(str);
        str = (String)args.get(MIN_SIZE_PARAM);
        this.minSizeLimit = str == null ? (int)((double)this.maxSize * 0.9) : Integer.parseInt(str);
        this.checkAndAdjustLimits();
        str = (String)args.get(ACCEPTABLE_SIZE_PARAM);
        this.acceptableSize = str == null ? (int)((double)this.maxSize * 0.95) : Integer.parseInt(str);
        this.acceptableSize = Math.max(this.minSizeLimit, this.acceptableSize);
        str = (String)args.get(INITIAL_SIZE_PARAM);
        this.initialSize = str == null ? this.maxSize : Integer.parseInt(str);
        str = (String)args.get(AUTOWARM_COUNT_PARAM);
        this.autowarmCount = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get(CLEANUP_THREAD_PARAM);
        this.cleanupThread = str == null ? false : Boolean.parseBoolean(str);
        str = (String)args.get(SHOW_ITEMS_PARAM);
        this.showItems = str == null ? 0 : Integer.parseInt(str);
        str = (String)args.get(TIME_DECAY_PARAM);
        this.timeDecay = str == null ? true : Boolean.parseBoolean(str);
        str = (String)args.get("maxIdleTime");
        this.maxIdleTimeSec = str == null ? -1 : Integer.parseInt(str);
        this.description = this.generateDescription();
        this.cache = new ConcurrentLFUCache(this.maxSize, this.minSizeLimit, this.acceptableSize, this.initialSize, this.cleanupThread, false, null, this.timeDecay, this.maxIdleTimeSec);
        this.cache.setAlive(false);
        this.statsList = (List)persistence;
        if (this.statsList == null) {
            this.statsList = new CopyOnWriteArrayList<ConcurrentLFUCache.Stats>();
            this.statsList.add(new ConcurrentLFUCache.Stats());
        }
        this.statsList.add(this.cache.getStats());
        return this.statsList;
    }

    private String generateDescription() {
        String descr = "Concurrent LFU Cache(maxSize=" + this.maxSize + ", initialSize=" + this.initialSize + ", minSize=" + this.minSizeLimit + ", acceptableSize=" + this.acceptableSize + ", cleanupThread=" + this.cleanupThread + ", timeDecay=" + this.timeDecay + ", maxIdleTime=" + this.maxIdleTimeSec;
        if (this.autowarmCount > 0) {
            descr = descr + ", autowarmCount=" + this.autowarmCount + ", regenerator=" + this.regenerator;
        }
        descr = descr + ')';
        return descr;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V remove(K key) {
        return this.cache.remove(key);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void setState(SolrCache.State state) {
        this.state = state;
        this.cache.setAlive(state == SolrCache.State.LIVE);
    }

    @Override
    public SolrCache.State getState() {
        return this.state;
    }

    @Override
    public void warm(SolrIndexSearcher searcher, SolrCache old) {
        if (this.regenerator == null) {
            return;
        }
        long warmingStartTime = System.nanoTime();
        LFUCache other = (LFUCache)old;
        if (this.autowarmCount != 0) {
            int sz = other.size();
            if (this.autowarmCount != -1) {
                sz = Math.min(sz, this.autowarmCount);
            }
            Map<K, V> items = other.cache.getMostUsedItems(sz);
            Map.Entry[] itemsArr = new Map.Entry[items.size()];
            int counter = 0;
            for (Map.Entry<K, V> mapEntry : items.entrySet()) {
                itemsArr[counter++] = mapEntry;
            }
            for (int i = itemsArr.length - 1; i >= 0; --i) {
                try {
                    boolean continueRegen = this.regenerator.regenerateItem(searcher, this, old, itemsArr[i].getKey(), itemsArr[i].getValue());
                    if (continueRegen) continue;
                    break;
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)("Error during auto-warming of key:" + itemsArr[i].getKey()), (Throwable)e);
                }
            }
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void close() throws IOException {
        SolrCache.super.close();
        this.statsList.get(0).add(this.cache.getStats());
        this.statsList.remove(this.cache.getStats());
        this.cache.destroy();
    }

    @Override
    public String getName() {
        return LFUCache.class.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CACHE;
    }

    private static String calcHitRatio(long lookups, long hits) {
        if (lookups == 0L) {
            return "0.00";
        }
        if (lookups == hits) {
            return "1.00";
        }
        int hundredths = (int)(hits * 100L / lookups);
        if (hundredths < 10) {
            return "0.0" + hundredths;
        }
        return "0." + hundredths;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.cacheMap = new MetricsMap((detailed, map) -> {
            if (this.cache != null) {
                ConcurrentLFUCache.Stats stats = this.cache.getStats();
                long lookups = stats.getCumulativeLookups();
                long hits = stats.getCumulativeHits();
                long inserts = stats.getCumulativePuts();
                long evictions = stats.getCumulativeEvictions();
                long idleEvictions = stats.getCumulativeIdleEvictions();
                long size = stats.getCurrentSize();
                map.put("lookups", lookups);
                map.put("hits", hits);
                map.put("hitratio", LFUCache.calcHitRatio(lookups, hits));
                map.put("inserts", inserts);
                map.put("evictions", evictions);
                map.put("size", size);
                map.put("maxSize", this.maxSize);
                map.put(MIN_SIZE_PARAM, this.minSizeLimit);
                map.put(ACCEPTABLE_SIZE_PARAM, this.acceptableSize);
                map.put(AUTOWARM_COUNT_PARAM, this.autowarmCount);
                map.put(CLEANUP_THREAD_PARAM, this.cleanupThread);
                map.put(SHOW_ITEMS_PARAM, this.showItems);
                map.put(TIME_DECAY_PARAM, this.timeDecay);
                map.put("ramBytesUsed", this.ramBytesUsed());
                map.put("maxIdleTime", this.maxIdleTimeSec);
                map.put("idleEvictions", idleEvictions);
                map.put("warmupTime", this.warmupTime);
                long clookups = 0L;
                long chits = 0L;
                long cinserts = 0L;
                long cevictions = 0L;
                long cidleEvictions = 0L;
                for (ConcurrentLFUCache.Stats statistics : this.statsList) {
                    clookups += statistics.getCumulativeLookups();
                    chits += statistics.getCumulativeHits();
                    cinserts += statistics.getCumulativePuts();
                    cevictions += statistics.getCumulativeEvictions();
                    cidleEvictions += statistics.getCumulativeIdleEvictions();
                }
                map.put("cumulative_lookups", clookups);
                map.put("cumulative_hits", chits);
                map.put("cumulative_hitratio", LFUCache.calcHitRatio(clookups, chits));
                map.put("cumulative_inserts", cinserts);
                map.put("cumulative_evictions", cevictions);
                map.put("cumulative_idleEvictions", cidleEvictions);
                if (detailed.booleanValue() && this.showItems != 0) {
                    Map<K, V> items = this.cache.getMostUsedItems(this.showItems == -1 ? Integer.MAX_VALUE : this.showItems);
                    for (Map.Entry<K, V> e : items.entrySet()) {
                        K k = e.getKey();
                        V v = e.getValue();
                        String ks = "item_" + k;
                        String vs = v.toString();
                        map.put(ks, vs);
                    }
                }
            }
        });
        this.solrMetricsContext.gauge(this, this.cacheMap, true, scope, this.getCategory().toString());
    }

    MetricsMap getMetricsMap() {
        return this.cacheMap;
    }

    @Override
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    public String toString() {
        return this.name + (this.cacheMap != null ? this.cacheMap.getValue().toString() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ramBytesUsed() {
        List<ConcurrentLFUCache.Stats> list = this.statsList;
        synchronized (list) {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject((Object)this.name) + RamUsageEstimator.sizeOfObject(this.metricNames) + RamUsageEstimator.sizeOfObject(this.statsList) + RamUsageEstimator.sizeOfObject(this.cache);
        }
    }

    @Override
    public int getMaxSize() {
        return this.maxSize != Integer.MAX_VALUE ? this.maxSize : -1;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize > 0 ? maxSize : Integer.MAX_VALUE;
        this.checkAndAdjustLimits();
        this.cache.setUpperWaterMark(maxSize);
        this.cache.setLowerWaterMark(this.minSizeLimit);
        this.description = this.generateDescription();
    }

    @Override
    public int getMaxRamMB() {
        return -1;
    }

    @Override
    public void setMaxRamMB(int maxRamMB) {
    }

    private void checkAndAdjustLimits() {
        if (this.minSizeLimit <= 0) {
            this.minSizeLimit = 1;
        }
        if (this.maxSize <= this.minSizeLimit) {
            if (this.maxSize > 1) {
                this.minSizeLimit = this.maxSize - 1;
            } else {
                this.maxSize = this.minSizeLimit + 1;
            }
        }
    }
}

