/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantDoubleValue;

public interface DoubleValue
extends DoubleValueStream,
AnalyticsValue {
    public double getDouble();

    public static abstract class AbstractDoubleValue
    implements CastingDoubleValue {
        @Override
        public String getString() {
            double val = this.getDouble();
            return this.exists() ? Double.toString(val) : null;
        }

        @Override
        public Object getObject() {
            double val = this.getDouble();
            return this.exists() ? Double.valueOf(val) : null;
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double val = this.getDouble();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String val = this.getString();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object val = this.getObject();
            if (this.exists()) {
                cons.accept(val);
            }
        }

        @Override
        public AnalyticsValue convertToConstant() {
            if (this.getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST)) {
                return new ConstantDoubleValue(this.getDouble());
            }
            return this;
        }

        @Override
        public ExpressionComparator<Double> getObjectComparator(String expression) {
            return new ExpressionComparator<Double>(expression);
        }
    }

    public static interface CastingDoubleValue
    extends DoubleValue,
    StringValue,
    ComparableValue {
    }
}

