/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.ico;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.ico.IcoDirectory;

public class IcoDescriptor
extends TagDescriptor<IcoDirectory> {
    public IcoDescriptor(@NotNull IcoDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getImageTypeDescription();
            }
            case 2: {
                return this.getImageWidthDescription();
            }
            case 3: {
                return this.getImageHeightDescription();
            }
            case 4: {
                return this.getColourPaletteSizeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getImageTypeDescription() {
        return this.getIndexedDescription(1, 1, "Icon", "Cursor");
    }

    @Nullable
    public String getImageWidthDescription() {
        Integer width = ((IcoDirectory)this._directory).getInteger(2);
        if (width == null) {
            return null;
        }
        return (width == 0 ? 256 : width) + " pixels";
    }

    @Nullable
    public String getImageHeightDescription() {
        Integer width = ((IcoDirectory)this._directory).getInteger(3);
        if (width == null) {
            return null;
        }
        return (width == 0 ? 256 : width) + " pixels";
    }

    @Nullable
    public String getColourPaletteSizeDescription() {
        Integer size = ((IcoDirectory)this._directory).getInteger(4);
        if (size == null) {
            return null;
        }
        return size == 0 ? "No palette" : size + " colour" + (size == 1 ? "" : "s");
    }
}

