/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.response.transform.ElevatedMarkerFactory;
import org.apache.solr.response.transform.ExcludedMarkerFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.VersionedFile;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QueryElevationComponent
extends SearchComponent
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @VisibleForTesting
    static final String FIELD_TYPE = "queryFieldType";
    @VisibleForTesting
    static final String CONFIG_FILE = "config-file";
    private static final String EXCLUDE = "exclude";
    private static final String BOOSTED_DOCIDS = "BOOSTED_DOCIDS";
    public static final String BOOSTED = "BOOSTED";
    public static final String EXCLUDED = "EXCLUDED";
    private static final boolean DEFAULT_FORCE_ELEVATION = false;
    private static final boolean DEFAULT_USE_CONFIGURED_ELEVATED_ORDER = true;
    private static final boolean DEFAULT_SUBSET_MATCH = false;
    private static final String DEFAULT_EXCLUDE_MARKER_FIELD_NAME = "excluded";
    private static final String DEFAULT_EDITORIAL_MARKER_FIELD_NAME = "elevated";
    protected SolrParams initArgs;
    protected Analyzer queryAnalyzer;
    protected SchemaField uniqueKeyField;
    protected boolean forceElevation;
    protected boolean useConfiguredElevatedOrder;
    protected boolean initialized;
    private final Map<IndexReader, ElevationProvider> elevationProviderCache = new WeakHashMap<IndexReader, ElevationProvider>();
    protected static final ElevationProvider NO_OP_ELEVATION_PROVIDER = new ElevationProvider(){

        @Override
        public Elevation getElevationForQuery(String queryString) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public void init(NamedList args) {
        this.initArgs = args.toSolrParams();
    }

    @Override
    public void inform(SolrCore core) {
        this.initialized = false;
        try {
            this.parseFieldType(core);
            this.setUniqueKeyField(core);
            this.parseExcludedMarkerFieldName(core);
            this.parseEditorialMarkerFieldName(core);
            this.parseForceElevation();
            this.parseUseConfiguredOrderForElevations();
            this.loadElevationConfiguration(core);
            this.initialized = true;
        }
        catch (InitializationException e) {
            assert (!this.initialized);
            this.handleInitializationException(e, e.exceptionCause);
        }
        catch (Exception e) {
            assert (!this.initialized);
            this.handleInitializationException(e, InitializationExceptionCause.OTHER);
        }
    }

    private void parseFieldType(SolrCore core) throws InitializationException {
        String a = this.initArgs.get(FIELD_TYPE);
        if (a != null) {
            FieldType ft = core.getLatestSchema().getFieldTypes().get(a);
            if (ft == null) {
                throw new InitializationException("Parameter queryFieldType defines an unknown field type \"" + a + "\"", InitializationExceptionCause.UNKNOWN_FIELD_TYPE);
            }
            this.queryAnalyzer = ft.getQueryAnalyzer();
        }
    }

    private void setUniqueKeyField(SolrCore core) throws InitializationException {
        this.uniqueKeyField = core.getLatestSchema().getUniqueKeyField();
        if (this.uniqueKeyField == null) {
            throw new InitializationException("This component requires the schema to have a uniqueKeyField", InitializationExceptionCause.MISSING_UNIQUE_KEY_FIELD);
        }
    }

    private void parseExcludedMarkerFieldName(SolrCore core) {
        String markerName = this.initArgs.get("excludeMarkerFieldName", DEFAULT_EXCLUDE_MARKER_FIELD_NAME);
        core.addTransformerFactory(markerName, new ExcludedMarkerFactory());
    }

    private void parseEditorialMarkerFieldName(SolrCore core) {
        String markerName = this.initArgs.get("editorialMarkerFieldName", DEFAULT_EDITORIAL_MARKER_FIELD_NAME);
        core.addTransformerFactory(markerName, new ElevatedMarkerFactory());
    }

    private void parseForceElevation() {
        this.forceElevation = this.initArgs.getBool("forceElevation", false);
    }

    private void parseUseConfiguredOrderForElevations() {
        this.useConfiguredElevatedOrder = this.initArgs.getBool("useConfiguredElevatedOrder", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadElevationConfiguration(SolrCore core) throws Exception {
        Map<IndexReader, ElevationProvider> map = this.elevationProviderCache;
        synchronized (map) {
            this.elevationProviderCache.clear();
            String configFileName = this.initArgs.get(CONFIG_FILE);
            if (configFileName == null) {
                throw new InitializationException("Missing component parameter config-file - it has to define the path to the elevation configuration file", InitializationExceptionCause.NO_CONFIG_FILE_DEFINED);
            }
            boolean configFileExists = false;
            ElevationProvider elevationProvider = NO_OP_ELEVATION_PROVIDER;
            ZkController zkController = core.getCoreContainer().getZkController();
            if (zkController != null) {
                configFileExists = zkController.configFileExists(zkController.getZkStateReader().readConfigName(core.getCoreDescriptor().getCloudDescriptor().getCollectionName()), configFileName);
            } else {
                File fC = new File(core.getResourceLoader().getConfigDir(), configFileName);
                File fD = new File(core.getDataDir(), configFileName);
                if (fC.exists() == fD.exists()) {
                    InitializationException e = new InitializationException("Missing config file \"" + configFileName + "\" - either " + fC.getAbsolutePath() + " or " + fD.getAbsolutePath() + " must exist, but not both", InitializationExceptionCause.MISSING_CONFIG_FILE);
                    elevationProvider = this.handleConfigLoadingException(e, true);
                    this.elevationProviderCache.put(null, elevationProvider);
                } else if (fC.exists()) {
                    if (fC.length() == 0L) {
                        InitializationException e = new InitializationException("Empty config file \"" + configFileName + "\" - " + fC.getAbsolutePath(), InitializationExceptionCause.EMPTY_CONFIG_FILE);
                        elevationProvider = this.handleConfigLoadingException(e, true);
                    } else {
                        configFileExists = true;
                        if (log.isInfoEnabled()) {
                            log.info("Loading QueryElevation from: {}", (Object)fC.getAbsolutePath());
                        }
                        XmlConfigFile cfg = new XmlConfigFile(core.getResourceLoader(), configFileName);
                        elevationProvider = this.loadElevationProvider(cfg);
                    }
                    this.elevationProviderCache.put(null, elevationProvider);
                }
            }
            if (!configFileExists) {
                RefCounted<SolrIndexSearcher> searchHolder = null;
                try {
                    searchHolder = core.getNewestSearcher(false);
                    if (searchHolder == null) {
                        elevationProvider = NO_OP_ELEVATION_PROVIDER;
                    } else {
                        DirectoryReader reader = searchHolder.get().getIndexReader();
                        elevationProvider = this.getElevationProvider((IndexReader)reader, core);
                    }
                }
                finally {
                    if (searchHolder != null) {
                        searchHolder.decref();
                    }
                }
            }
            return elevationProvider.size();
        }
    }

    protected void handleInitializationException(Exception exception, InitializationExceptionCause cause) {
        if (cause != InitializationExceptionCause.NO_CONFIG_FILE_DEFINED) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing " + QueryElevationComponent.class.getSimpleName(), (Throwable)exception);
        }
    }

    protected <E extends Exception> ElevationProvider handleConfigLoadingException(E e, boolean resourceAccessIssue) throws E {
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ElevationProvider getElevationProvider(IndexReader reader, SolrCore core) throws Exception {
        Map<IndexReader, ElevationProvider> map = this.elevationProviderCache;
        synchronized (map) {
            ElevationProvider elevationProvider = this.elevationProviderCache.get(null);
            if (elevationProvider != null) {
                return elevationProvider;
            }
            elevationProvider = this.elevationProviderCache.get(reader);
            if (elevationProvider == null) {
                Exception loadingException = null;
                boolean resourceAccessIssue = false;
                try {
                    elevationProvider = this.loadElevationProvider(core);
                }
                catch (IOException e) {
                    loadingException = e;
                    resourceAccessIssue = true;
                }
                catch (Exception e) {
                    loadingException = e;
                }
                boolean shouldCache = true;
                if (loadingException != null && (elevationProvider = this.handleConfigLoadingException(loadingException, resourceAccessIssue)) == null) {
                    elevationProvider = NO_OP_ELEVATION_PROVIDER;
                    shouldCache = false;
                }
                if (shouldCache) {
                    this.elevationProviderCache.put(reader, elevationProvider);
                }
            }
            assert (elevationProvider != null);
            return elevationProvider;
        }
    }

    private ElevationProvider loadElevationProvider(SolrCore core) throws IOException, SAXException, ParserConfigurationException {
        XmlConfigFile cfg;
        String configFileName = this.initArgs.get(CONFIG_FILE);
        if (configFileName == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent must specify argument: config-file");
        }
        log.info("Loading QueryElevation from data dir: {}", (Object)configFileName);
        ZkController zkController = core.getCoreContainer().getZkController();
        if (zkController != null) {
            cfg = new XmlConfigFile(core.getResourceLoader(), configFileName, null, null);
        } else {
            InputStream is = VersionedFile.getLatestFile(core.getDataDir(), configFileName);
            cfg = new XmlConfigFile(core.getResourceLoader(), configFileName, new InputSource(is), null);
        }
        ElevationProvider elevationProvider = this.loadElevationProvider(cfg);
        assert (elevationProvider != null);
        return elevationProvider;
    }

    protected ElevationProvider loadElevationProvider(XmlConfigFile config) {
        LinkedHashMap<ElevatingQuery, ElevationBuilder> elevationBuilderMap = new LinkedHashMap<ElevatingQuery, ElevationBuilder>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)config.evaluate("elevate/query", XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeList children;
            Node node = nodes.item(i);
            String queryString = DOMUtil.getAttr(node, "text", "missing query 'text'");
            String matchString = DOMUtil.getAttr(node, "match");
            ElevatingQuery elevatingQuery = new ElevatingQuery(queryString, this.isSubsetMatchPolicy(matchString));
            try {
                children = (NodeList)xpath.evaluate("doc", node, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "query requires '<doc .../>' child");
            }
            if (children.getLength() == 0) continue;
            ElevationBuilder elevationBuilder = new ElevationBuilder();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String id = DOMUtil.getAttr(child, "id", "missing 'id'");
                String e = DOMUtil.getAttr(child, EXCLUDE, null);
                if (e != null && Boolean.valueOf(e).booleanValue()) {
                    elevationBuilder.addExcludedIds(Collections.singleton(id));
                    continue;
                }
                elevationBuilder.addElevatedIds(Collections.singletonList(id));
            }
            ElevationBuilder previousElevationBuilder = (ElevationBuilder)elevationBuilderMap.get(elevatingQuery);
            if (previousElevationBuilder == null) {
                elevationBuilderMap.put(elevatingQuery, elevationBuilder);
                continue;
            }
            previousElevationBuilder.merge(elevationBuilder);
        }
        return this.createElevationProvider(elevationBuilderMap);
    }

    protected boolean isSubsetMatchPolicy(String matchString) {
        if (matchString == null) {
            return false;
        }
        if (matchString.equalsIgnoreCase("exact")) {
            return false;
        }
        if (matchString.equalsIgnoreCase("subset")) {
            return true;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid value \"" + matchString + "\" for query match attribute");
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (!this.initialized || !rb.req.getParams().getBool("enableElevation", true)) {
            return;
        }
        Elevation elevation = this.getElevation(rb);
        if (elevation != null) {
            this.setQuery(rb, elevation);
            this.setSort(rb, elevation);
        }
        if (rb.isDebug() && rb.isDebugQuery()) {
            this.addDebugInfo(rb, elevation);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
    }

    protected Elevation getElevation(ResponseBuilder rb) {
        String queryString;
        SolrParams localParams = rb.getQparser().getLocalParams();
        String string = queryString = localParams == null ? rb.getQueryString() : localParams.get("v");
        if (queryString == null || rb.getQuery() == null) {
            return null;
        }
        SolrParams params = rb.req.getParams();
        String paramElevatedIds = params.get("elevateIds");
        String paramExcludedIds = params.get("excludeIds");
        try {
            if (paramElevatedIds != null || paramExcludedIds != null) {
                List elevatedIds = paramElevatedIds != null ? StrUtils.splitSmart((String)paramElevatedIds, (String)",", (boolean)true) : Collections.emptyList();
                List excludedIds = paramExcludedIds != null ? StrUtils.splitSmart((String)paramExcludedIds, (String)",", (boolean)true) : Collections.emptyList();
                return new ElevationBuilder().addElevatedIds(elevatedIds).addExcludedIds(excludedIds).build();
            }
            DirectoryReader reader = rb.req.getSearcher().getIndexReader();
            return this.getElevationProvider((IndexReader)reader, rb.req.getCore()).getElevationForQuery(queryString);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading elevation", (Throwable)e);
        }
    }

    private void setQuery(ResponseBuilder rb, Elevation elevation) {
        rb.req.getContext().put(BOOSTED, elevation.elevatedIds);
        SolrParams params = rb.req.getParams();
        if (params.getBool("exclusive", false)) {
            rb.setQuery((Query)new BoostQuery((Query)elevation.includeQuery, 0.0f));
        } else {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            queryBuilder.add(rb.getQuery(), BooleanClause.Occur.SHOULD);
            queryBuilder.add((Query)new BoostQuery((Query)elevation.includeQuery, 0.0f), BooleanClause.Occur.SHOULD);
            if (elevation.excludeQueries != null) {
                if (params.getBool("markExcludes", false)) {
                    rb.req.getContext().put(EXCLUDED, elevation.excludedIds);
                } else {
                    for (TermQuery tq : elevation.excludeQueries) {
                        queryBuilder.add((Query)tq, BooleanClause.Occur.MUST_NOT);
                    }
                }
            }
            rb.setQuery((Query)queryBuilder.build());
        }
    }

    private void setSort(ResponseBuilder rb, Elevation elevation) throws IOException {
        if (elevation.elevatedIds.isEmpty()) {
            return;
        }
        boolean forceElevation = rb.req.getParams().getBool("forceElevation", this.forceElevation);
        boolean useConfigured = rb.req.getParams().getBool("useConfiguredElevatedOrder", this.useConfiguredElevatedOrder);
        IntIntHashMap elevatedWithPriority = QueryElevationComponent.getBoostDocs(rb.req.getSearcher(), elevation.elevatedIds, rb.req.getContext());
        ElevationComparatorSource comparator = new ElevationComparatorSource(elevatedWithPriority, useConfigured);
        this.setSortSpec(rb, forceElevation, comparator);
        this.setGroupingSpec(rb, forceElevation, comparator);
    }

    private void setSortSpec(ResponseBuilder rb, boolean forceElevation, ElevationComparatorSource comparator) {
        SortSpec sortSpec = rb.getSortSpec();
        if (sortSpec.getSort() == null) {
            sortSpec.setSortAndFields(new Sort(new SortField[]{new SortField("_elevate_", (FieldComparatorSource)comparator, true), new SortField(null, SortField.Type.SCORE, false)}), Arrays.asList(new SchemaField[2]));
        } else {
            SortSpec modSortSpec = this.modifySortSpec(sortSpec, forceElevation, comparator);
            if (null != modSortSpec) {
                rb.setSortSpec(modSortSpec);
            }
        }
    }

    private void setGroupingSpec(ResponseBuilder rb, boolean forceElevation, ElevationComparatorSource comparator) {
        GroupingSpecification groupingSpec = rb.getGroupingSpec();
        if (groupingSpec != null) {
            SortSpec withinGroupSortSpec;
            SortSpec modWithinGroupSortSpec;
            SortSpec groupSortSpec = groupingSpec.getGroupSortSpec();
            SortSpec modGroupSortSpec = this.modifySortSpec(groupSortSpec, forceElevation, comparator);
            if (modGroupSortSpec != null) {
                groupingSpec.setGroupSortSpec(modGroupSortSpec);
            }
            if ((modWithinGroupSortSpec = this.modifySortSpec(withinGroupSortSpec = groupingSpec.getWithinGroupSortSpec(), forceElevation, comparator)) != null) {
                groupingSpec.setWithinGroupSortSpec(modWithinGroupSortSpec);
            }
        }
    }

    private SortSpec modifySortSpec(SortSpec current, boolean forceElevation, ElevationComparatorSource comparator) {
        boolean modify = false;
        SortField[] currentSorts = current.getSort().getSort();
        List<SchemaField> currentFields = current.getSchemaFields();
        ArrayList<SortField> sorts = new ArrayList<SortField>(currentSorts.length + 1);
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>(currentFields.size() + 1);
        if (forceElevation && currentSorts[0].getType() != SortField.Type.SCORE) {
            sorts.add(new SortField("_elevate_", (FieldComparatorSource)comparator, true));
            fields.add(null);
            modify = true;
        }
        for (int i = 0; i < currentSorts.length; ++i) {
            SortField sf = currentSorts[i];
            if (sf.getType() == SortField.Type.SCORE) {
                sorts.add(new SortField("_elevate_", (FieldComparatorSource)comparator, !sf.getReverse()));
                fields.add(null);
                modify = true;
            }
            sorts.add(sf);
            fields.add(currentFields.get(i));
        }
        return modify ? new SortSpec(new Sort(sorts.toArray(new SortField[0])), fields, current.getCount(), current.getOffset()) : null;
    }

    private void addDebugInfo(ResponseBuilder rb, Elevation elevation) {
        ArrayList<String> match = null;
        if (elevation != null) {
            match = new ArrayList<String>(elevation.includeQuery.clauses().size());
            for (BooleanClause clause : elevation.includeQuery.clauses()) {
                TermQuery tq = (TermQuery)clause.getQuery();
                match.add(tq.getTerm().text());
            }
        }
        SimpleOrderedMap dbg = new SimpleOrderedMap();
        dbg.add("q", (Object)rb.getQueryString());
        dbg.add("match", match);
        rb.addDebugInfo("queryBoosting", dbg);
    }

    public static IntIntHashMap getBoostDocs(SolrIndexSearcher indexSearcher, Set<BytesRef> boosted, Map context) throws IOException {
        IntIntHashMap boostDocs = null;
        if (boosted != null) {
            if (context != null && (boostDocs = (IntIntHashMap)context.get(BOOSTED_DOCIDS)) != null) {
                return boostDocs;
            }
            boostDocs = new IntIntHashMap(boosted.size());
            int priority = boosted.size() + 1;
            for (BytesRef uniqueKey : boosted) {
                --priority;
                long segAndId = indexSearcher.lookupId(uniqueKey);
                if (segAndId == -1L) continue;
                int seg = (int)(segAndId >> 32);
                int localDocId = (int)segAndId;
                IndexReaderContext indexReaderContext = (IndexReaderContext)indexSearcher.getTopReaderContext().children().get(seg);
                int docId = indexReaderContext.docBaseInParent + localDocId;
                boostDocs.put(docId, priority);
            }
            assert (priority == 1);
        }
        if (context != null) {
            context.put(BOOSTED_DOCIDS, boostDocs);
        }
        return boostDocs;
    }

    @Override
    public String getDescription() {
        return "Query Boosting -- boost particular documents for a given query";
    }

    protected ElevationProvider createElevationProvider(Map<ElevatingQuery, ElevationBuilder> elevationBuilderMap) {
        return new DefaultElevationProvider(new TrieSubsetMatcher.Builder<String, Elevation>(), elevationBuilderMap);
    }

    public String analyzeQuery(String query) {
        StringBuilder concatTerms = new StringBuilder();
        this.analyzeQuery(query, concatTerms::append);
        return concatTerms.toString();
    }

    protected void analyzeQuery(String query, Consumer<CharSequence> termsConsumer) {
        try (TokenStream tokens = this.queryAnalyzer.tokenStream("", query);){
            tokens.reset();
            CharTermAttribute termAtt = (CharTermAttribute)tokens.addAttribute(CharTermAttribute.class);
            while (tokens.incrementToken()) {
                termsConsumer.accept((CharSequence)termAtt);
            }
            tokens.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setTopQueryResults(IndexReader reader, String queryString, boolean subsetMatch, String[] elevatedIds, String[] excludedIds) {
        this.clearElevationProviderCache();
        ElevatingQuery elevatingQuery = new ElevatingQuery(queryString, subsetMatch);
        ElevationBuilder elevationBuilder = new ElevationBuilder();
        elevationBuilder.addElevatedIds(elevatedIds == null ? Collections.emptyList() : Arrays.asList(elevatedIds));
        elevationBuilder.addExcludedIds(excludedIds == null ? Collections.emptyList() : Arrays.asList(excludedIds));
        ImmutableMap elevationBuilderMap = ImmutableMap.of((Object)elevatingQuery, (Object)elevationBuilder);
        Map<IndexReader, ElevationProvider> map = this.elevationProviderCache;
        synchronized (map) {
            this.elevationProviderCache.computeIfAbsent(reader, arg_0 -> this.lambda$setTopQueryResults$0((Map)elevationBuilderMap, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void clearElevationProviderCache() {
        Map<IndexReader, ElevationProvider> map = this.elevationProviderCache;
        synchronized (map) {
            this.elevationProviderCache.clear();
        }
    }

    private /* synthetic */ ElevationProvider lambda$setTopQueryResults$0(Map elevationBuilderMap, IndexReader k) {
        return this.createElevationProvider(elevationBuilderMap);
    }

    protected static class TrieSubsetMatcher<E extends Comparable<? super E>, M> {
        private final Node<E, M> root;
        private final int subsetCount;

        private TrieSubsetMatcher(Node<E, M> root, int subsetCount) {
            this.root = root;
            this.subsetCount = subsetCount;
        }

        public int getSubsetCount() {
            return this.subsetCount;
        }

        public Iterator<M> findSubsetsMatching(Collection<E> set) {
            return new MatchIterator(ImmutableSortedSet.copyOf(set));
        }

        private class MatchIterator
        implements Iterator<M> {
            private final Iterator<E> sortedSetIterator;
            private final Queue<Node<E, M>> currentNodes;
            private final Queue<M> nextMatchValues;

            MatchIterator(SortedSet<E> set) {
                this.sortedSetIterator = set.iterator();
                this.currentNodes = new ArrayDeque();
                this.currentNodes.offer(TrieSubsetMatcher.this.root);
                this.nextMatchValues = new ArrayDeque();
            }

            @Override
            public boolean hasNext() {
                return !this.nextMatchValues.isEmpty() || this.nextSubsetMatch();
            }

            @Override
            public M next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                assert (!this.nextMatchValues.isEmpty());
                return this.nextMatchValues.poll();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean nextSubsetMatch() {
                while (this.sortedSetIterator.hasNext()) {
                    Comparable e = (Comparable)this.sortedSetIterator.next();
                    int currentNodeCount = this.currentNodes.size();
                    for (int i = 0; i < currentNodeCount; ++i) {
                        Node currentNode = this.currentNodes.remove();
                        Node child = currentNode.getChild(e);
                        if (child != null) {
                            this.currentNodes.offer(child);
                            this.nextMatchValues.addAll(child.getMatchValues());
                        }
                        if (!currentNode.hasMorePotentialChildren(e)) continue;
                        this.currentNodes.offer(currentNode);
                    }
                    if (this.nextMatchValues.isEmpty()) continue;
                    return true;
                }
                return false;
            }
        }

        private static class Node<E extends Comparable<? super E>, M> {
            private Map<E, Node<E, M>> children;
            private E greatestEdge;
            private List<M> matchValues;

            private Node() {
            }

            Node<E, M> getChild(E e) {
                return this.children == null ? null : this.children.get(e);
            }

            Node<E, M> getOrCreateChild(E e) {
                Node<E, M> child;
                if (this.children == null) {
                    this.children = new HashMap<E, Node<E, M>>(4);
                }
                if ((child = this.children.get(e)) == null) {
                    child = new Node<E, M>();
                    this.children.put(e, child);
                    if (this.greatestEdge == null || e.compareTo(this.greatestEdge) > 0) {
                        this.greatestEdge = e;
                    }
                }
                return child;
            }

            boolean hasMorePotentialChildren(E e) {
                return this.greatestEdge != null && e.compareTo(this.greatestEdge) < 0;
            }

            void addMatchValue(M matchValue) {
                if (this.matchValues == null) {
                    this.matchValues = new ArrayList<M>(1);
                }
                this.matchValues.add(matchValue);
            }

            List<M> getMatchValues() {
                return this.matchValues == null ? Collections.emptyList() : this.matchValues;
            }

            void trimAndMakeImmutable() {
                if (this.children != null && !(this.children instanceof ImmutableMap)) {
                    for (Node<E, M> child : this.children.values()) {
                        child.trimAndMakeImmutable();
                    }
                    this.children = ImmutableMap.copyOf(this.children);
                }
                if (this.matchValues != null && !(this.matchValues instanceof ImmutableList)) {
                    this.matchValues = ImmutableList.copyOf(this.matchValues);
                }
            }
        }

        public static class Builder<E extends Comparable<? super E>, M> {
            private final Node<E, M> root = new Node();
            private int subsetCount;

            public Builder<E, M> addSubset(Collection<E> subset, M matchValue) {
                if (!subset.isEmpty()) {
                    Node<Comparable, M> node = this.root;
                    for (Comparable e : ImmutableSortedSet.copyOf(subset)) {
                        node = node.getOrCreateChild(e);
                    }
                    node.addMatchValue(matchValue);
                    ++this.subsetCount;
                }
                return this;
            }

            public TrieSubsetMatcher<E, M> build() {
                this.root.trimAndMakeImmutable();
                return new TrieSubsetMatcher(this.root, this.subsetCount);
            }
        }
    }

    private class ElevationComparatorSource
    extends FieldComparatorSource {
        private final IntIntHashMap elevatedWithPriority;
        private final boolean useConfiguredElevatedOrder;
        private final int[] sortedElevatedDocIds;

        private ElevationComparatorSource(IntIntHashMap elevatedWithPriority, boolean useConfiguredElevatedOrder) {
            this.elevatedWithPriority = elevatedWithPriority;
            this.useConfiguredElevatedOrder = useConfiguredElevatedOrder;
            this.sortedElevatedDocIds = new int[elevatedWithPriority.size()];
            Iterator iterator = elevatedWithPriority.iterator();
            for (int i = 0; i < this.sortedElevatedDocIds.length; ++i) {
                IntIntCursor next = (IntIntCursor)iterator.next();
                this.sortedElevatedDocIds[i] = next.key;
            }
            assert (!iterator.hasNext());
            Arrays.sort(this.sortedElevatedDocIds);
        }

        public FieldComparator<Integer> newComparator(String fieldName, final int numHits, int sortPos, boolean reversed) {
            return new SimpleFieldComparator<Integer>(){
                final int[] values;
                int bottomVal;
                int topVal;
                int docBase;
                boolean hasElevatedDocsThisSegment;
                {
                    this.values = new int[numHits];
                }

                protected void doSetNextReader(LeafReaderContext context) {
                    int nextElevatedDocId;
                    int nextIdx;
                    this.docBase = context.docBase;
                    int idx = Arrays.binarySearch(ElevationComparatorSource.this.sortedElevatedDocIds, this.docBase);
                    if (idx < 0 && (nextIdx = -idx - 1) < ElevationComparatorSource.this.sortedElevatedDocIds.length && (nextElevatedDocId = ElevationComparatorSource.this.sortedElevatedDocIds[nextIdx]) > this.docBase + context.reader().maxDoc()) {
                        this.hasElevatedDocsThisSegment = false;
                        return;
                    }
                    this.hasElevatedDocsThisSegment = true;
                }

                public int compare(int slot1, int slot2) {
                    return this.values[slot1] - this.values[slot2];
                }

                public void setBottom(int slot) {
                    this.bottomVal = this.values[slot];
                }

                public void setTopValue(Integer value) {
                    this.topVal = value;
                }

                private int docVal(int doc) {
                    if (!this.hasElevatedDocsThisSegment) {
                        assert (!ElevationComparatorSource.this.elevatedWithPriority.containsKey(this.docBase + doc));
                        return -1;
                    }
                    if (ElevationComparatorSource.this.useConfiguredElevatedOrder) {
                        return ElevationComparatorSource.this.elevatedWithPriority.getOrDefault(this.docBase + doc, -1);
                    }
                    return ElevationComparatorSource.this.elevatedWithPriority.containsKey(this.docBase + doc) ? 1 : -1;
                }

                public int compareBottom(int doc) {
                    return this.bottomVal - this.docVal(doc);
                }

                public void copy(int slot, int doc) {
                    this.values[slot] = this.docVal(doc);
                }

                public Integer value(int slot) {
                    return this.values[slot];
                }

                public int compareTop(int doc) {
                    int docValue = this.docVal(doc);
                    return this.topVal - docValue;
                }
            };
        }
    }

    protected static class Elevation {
        private static final BooleanQuery EMPTY_QUERY = new BooleanQuery.Builder().build();
        public final Set<BytesRef> elevatedIds;
        public final BooleanQuery includeQuery;
        public final Set<BytesRef> excludedIds;
        public final TermQuery[] excludeQueries;

        public Elevation(Set<BytesRef> elevatedIds, Set<BytesRef> excludedIds, String queryFieldName) {
            if (elevatedIds == null || elevatedIds.isEmpty()) {
                this.includeQuery = EMPTY_QUERY;
                this.elevatedIds = Collections.emptySet();
            } else {
                this.elevatedIds = ImmutableSet.copyOf(elevatedIds);
                BooleanQuery.Builder includeQueryBuilder = new BooleanQuery.Builder();
                for (BytesRef elevatedId : elevatedIds) {
                    includeQueryBuilder.add((Query)new TermQuery(new Term(queryFieldName, elevatedId)), BooleanClause.Occur.SHOULD);
                }
                this.includeQuery = includeQueryBuilder.build();
            }
            if (excludedIds == null || excludedIds.isEmpty()) {
                this.excludedIds = Collections.emptySet();
                this.excludeQueries = null;
            } else {
                this.excludedIds = ImmutableSet.copyOf(excludedIds);
                ArrayList<TermQuery> excludeQueriesBuilder = new ArrayList<TermQuery>(excludedIds.size());
                for (BytesRef excludedId : excludedIds) {
                    excludeQueriesBuilder.add(new TermQuery(new Term(queryFieldName, excludedId)));
                }
                this.excludeQueries = excludeQueriesBuilder.toArray(new TermQuery[0]);
            }
        }

        protected Elevation(Set<BytesRef> elevatedIds, BooleanQuery includeQuery, Set<BytesRef> excludedIds, TermQuery[] excludeQueries) {
            this.elevatedIds = elevatedIds;
            this.includeQuery = includeQuery;
            this.excludedIds = excludedIds;
            this.excludeQueries = excludeQueries;
        }

        protected Elevation mergeWith(Elevation elevation) {
            TermQuery[] excludeQueries;
            if (elevation == null) {
                return this;
            }
            ImmutableSet elevatedIds = ImmutableSet.builder().addAll(this.elevatedIds).addAll(elevation.elevatedIds).build();
            boolean overlappingElevatedIds = elevatedIds.size() != this.elevatedIds.size() + elevation.elevatedIds.size();
            BooleanQuery.Builder includeQueryBuilder = new BooleanQuery.Builder();
            HashSet clauseSet = overlappingElevatedIds ? Sets.newHashSetWithExpectedSize((int)elevatedIds.size()) : null;
            for (BooleanClause clause : this.includeQuery.clauses()) {
                if (overlappingElevatedIds && !clauseSet.add(clause)) continue;
                includeQueryBuilder.add(clause);
            }
            for (BooleanClause clause : elevation.includeQuery.clauses()) {
                if (overlappingElevatedIds && !clauseSet.add(clause)) continue;
                includeQueryBuilder.add(clause);
            }
            ImmutableSet excludedIds = ImmutableSet.builder().addAll(this.excludedIds).addAll(elevation.excludedIds).build();
            if (this.excludeQueries == null) {
                excludeQueries = elevation.excludeQueries;
            } else if (elevation.excludeQueries == null) {
                excludeQueries = this.excludeQueries;
            } else {
                boolean overlappingExcludedIds = excludedIds.size() != this.excludedIds.size() + elevation.excludedIds.size();
                excludeQueries = overlappingExcludedIds ? (TermQuery[])ImmutableSet.builder().add((Object[])this.excludeQueries).add((Object[])elevation.excludeQueries).build().toArray((Object[])new TermQuery[0]) : (TermQuery[])ObjectArrays.concat((Object[])this.excludeQueries, (Object[])elevation.excludeQueries, TermQuery.class);
            }
            return new Elevation((Set<BytesRef>)elevatedIds, includeQueryBuilder.build(), (Set<BytesRef>)excludedIds, excludeQueries);
        }

        public String toString() {
            return "{elevatedIds=" + Collections2.transform(this.elevatedIds, BytesRef::utf8ToString) + ", excludedIds=" + Collections2.transform(this.excludedIds, BytesRef::utf8ToString) + "}";
        }
    }

    public class ElevationBuilder {
        private LinkedHashSet<BytesRef> elevatedIds;
        private Set<BytesRef> excludedIds;
        private final BytesRefBuilder scratch = new BytesRefBuilder();

        public ElevationBuilder addElevatedIds(List<String> ids) {
            if (this.elevatedIds == null) {
                this.elevatedIds = new LinkedHashSet(Math.max(10, ids.size()));
            }
            for (String id : ids) {
                this.elevatedIds.add(this.toBytesRef(id));
            }
            return this;
        }

        public ElevationBuilder addExcludedIds(Collection<String> ids) {
            if (this.excludedIds == null) {
                this.excludedIds = new HashSet<BytesRef>(Math.max(10, ids.size()));
            }
            for (String id : ids) {
                this.excludedIds.add(this.toBytesRef(id));
            }
            return this;
        }

        public BytesRef toBytesRef(String id) {
            QueryElevationComponent.this.uniqueKeyField.getType().readableToIndexed(id, this.scratch);
            return this.scratch.toBytesRef();
        }

        public ElevationBuilder merge(ElevationBuilder elevationBuilder) {
            if (this.elevatedIds == null) {
                this.elevatedIds = elevationBuilder.elevatedIds;
            } else if (elevationBuilder.elevatedIds != null) {
                this.elevatedIds.addAll(elevationBuilder.elevatedIds);
            }
            if (this.excludedIds == null) {
                this.excludedIds = elevationBuilder.excludedIds;
            } else if (elevationBuilder.excludedIds != null) {
                this.excludedIds.addAll(elevationBuilder.excludedIds);
            }
            return this;
        }

        public Elevation build() {
            return new Elevation(this.elevatedIds, this.excludedIds, QueryElevationComponent.this.uniqueKeyField.getName());
        }
    }

    protected static class ElevatingQuery {
        public final String queryString;
        public final boolean subsetMatch;

        protected ElevatingQuery(String queryString, boolean subsetMatch) {
            this.queryString = queryString;
            this.subsetMatch = subsetMatch;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ElevatingQuery)) {
                return false;
            }
            ElevatingQuery eq = (ElevatingQuery)o;
            return this.queryString.equals(eq.queryString) && this.subsetMatch == eq.subsetMatch;
        }

        public int hashCode() {
            return this.queryString.hashCode() + (this.subsetMatch ? 1 : 0);
        }
    }

    protected class DefaultElevationProvider
    implements ElevationProvider {
        private final TrieSubsetMatcher<String, Elevation> subsetMatcher;
        private final Map<String, Elevation> exactMatchElevationMap = new LinkedHashMap<String, Elevation>();

        protected DefaultElevationProvider(TrieSubsetMatcher.Builder<String, Elevation> subsetMatcherBuilder, Map<ElevatingQuery, ElevationBuilder> elevationBuilderMap) {
            ArrayList queryTerms = new ArrayList();
            Consumer<CharSequence> termsConsumer = term -> queryTerms.add(term.toString());
            StringBuilder concatTerms = new StringBuilder();
            Consumer<CharSequence> concatConsumer = concatTerms::append;
            for (Map.Entry<ElevatingQuery, ElevationBuilder> entry : elevationBuilderMap.entrySet()) {
                ElevatingQuery elevatingQuery = entry.getKey();
                Elevation elevation = entry.getValue().build();
                if (elevatingQuery.subsetMatch) {
                    queryTerms.clear();
                    QueryElevationComponent.this.analyzeQuery(elevatingQuery.queryString, termsConsumer);
                    subsetMatcherBuilder.addSubset(queryTerms, elevation);
                    continue;
                }
                concatTerms.setLength(0);
                QueryElevationComponent.this.analyzeQuery(elevatingQuery.queryString, concatConsumer);
                this.exactMatchElevationMap.put(concatTerms.toString(), elevation);
            }
            this.subsetMatcher = subsetMatcherBuilder.build();
        }

        @Override
        public Elevation getElevationForQuery(String queryString) {
            boolean hasExactMatchElevationRules;
            boolean bl = hasExactMatchElevationRules = this.exactMatchElevationMap.size() != 0;
            if (this.subsetMatcher.getSubsetCount() == 0) {
                if (!hasExactMatchElevationRules) {
                    return null;
                }
                return this.exactMatchElevationMap.get(QueryElevationComponent.this.analyzeQuery(queryString));
            }
            ArrayList queryTerms = new ArrayList();
            Consumer<CharSequence> termsConsumer = term -> queryTerms.add(term.toString());
            StringBuilder concatTerms = null;
            if (hasExactMatchElevationRules) {
                concatTerms = new StringBuilder();
                termsConsumer = termsConsumer.andThen(concatTerms::append);
            }
            QueryElevationComponent.this.analyzeQuery(queryString, termsConsumer);
            Elevation mergedElevation = null;
            if (hasExactMatchElevationRules) {
                mergedElevation = this.exactMatchElevationMap.get(concatTerms.toString());
            }
            Iterator<Elevation> elevationIterator = this.subsetMatcher.findSubsetsMatching(queryTerms);
            while (elevationIterator.hasNext()) {
                Elevation elevation = elevationIterator.next();
                mergedElevation = mergedElevation == null ? elevation : mergedElevation.mergeWith(elevation);
            }
            return mergedElevation;
        }

        @Override
        public int size() {
            return this.exactMatchElevationMap.size() + this.subsetMatcher.getSubsetCount();
        }
    }

    protected static interface ElevationProvider {
        public Elevation getElevationForQuery(String var1);

        @VisibleForTesting
        public int size();
    }

    protected static enum InitializationExceptionCause {
        UNKNOWN_FIELD_TYPE,
        MISSING_UNIQUE_KEY_FIELD,
        NO_CONFIG_FILE_DEFINED,
        MISSING_CONFIG_FILE,
        EMPTY_CONFIG_FILE,
        OTHER;

    }

    private static class InitializationException
    extends Exception {
        private final InitializationExceptionCause exceptionCause;

        InitializationException(String message, InitializationExceptionCause exceptionCause) {
            super(message);
            this.exceptionCause = exceptionCause;
        }
    }
}

