/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.rest.schema.FieldTypeXmlAdapter;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FieldTypePluginLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class ManagedIndexSchema
extends IndexSchema {
    private final boolean isMutable;
    final String managedSchemaResourceName;
    int schemaZkVersion;
    final Object schemaUpdateLock;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    ManagedIndexSchema(SolrConfig solrConfig, String name, InputSource is, boolean isMutable, String managedSchemaResourceName, int schemaZkVersion, Object schemaUpdateLock) {
        super(name, is, solrConfig.luceneMatchVersion, solrConfig.getResourceLoader(), solrConfig.getSubstituteProperties());
        this.isMutable = isMutable;
        this.managedSchemaResourceName = managedSchemaResourceName;
        this.schemaZkVersion = schemaZkVersion;
        this.schemaUpdateLock = schemaUpdateLock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean persistManagedSchema(boolean createOnly) {
        if (this.loader instanceof ZkSolrResourceLoader) {
            return this.persistManagedSchemaToZooKeeper(createOnly);
        }
        File managedSchemaFile = new File(this.loader.getConfigDir(), this.managedSchemaResourceName);
        OutputStreamWriter writer = null;
        try {
            File parentDir = managedSchemaFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                String msg = "Can't create managed schema directory " + parentDir.getAbsolutePath();
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            FileOutputStream out = new FileOutputStream(managedSchemaFile);
            writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            this.persist(writer);
            if (log.isInfoEnabled()) {
                log.info("Upgraded to managed schema at {}", (Object)managedSchemaFile.getPath());
            }
        }
        catch (IOException e) {
            try {
                String msg = "Error persisting managed schema " + managedSchemaFile;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                try {
                    FileUtils.sync(managedSchemaFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    String msg = "Error syncing the managed schema file " + managedSchemaFile;
                    log.error(msg, (Throwable)e2);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        try {
            FileUtils.sync(managedSchemaFile);
            return true;
        }
        catch (IOException e) {
            String msg = "Error syncing the managed schema file " + managedSchemaFile;
            log.error(msg, (Throwable)e);
            return true;
        }
    }

    boolean persistManagedSchemaToZooKeeper(boolean createOnly) {
        ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.loader;
        ZkController zkController = zkLoader.getZkController();
        SolrZkClient zkClient = zkController.getZkClient();
        String managedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + this.managedSchemaResourceName;
        boolean success = true;
        boolean schemaChangedInZk = false;
        try {
            StringWriter writer = new StringWriter();
            this.persist(writer);
            byte[] data = writer.toString().getBytes(StandardCharsets.UTF_8);
            if (createOnly) {
                try {
                    zkClient.create(managedSchemaPath, data, CreateMode.PERSISTENT, true);
                    this.schemaZkVersion = 0;
                    log.info("Created and persisted managed schema znode at {}", (Object)managedSchemaPath);
                }
                catch (KeeperException.NodeExistsException e) {
                    log.info("Managed schema znode at {} already exists - no need to create it", (Object)managedSchemaPath);
                }
            } else {
                try {
                    Stat stat = zkClient.setData(managedSchemaPath, data, this.schemaZkVersion, true);
                    this.schemaZkVersion = stat.getVersion();
                    log.info("Persisted managed schema version {}  at {}", (Object)this.schemaZkVersion, (Object)managedSchemaPath);
                }
                catch (KeeperException.BadVersionException e) {
                    log.error("Bad version when trying to persist schema using {} due to: ", (Object)this.schemaZkVersion, (Object)e);
                    success = false;
                    schemaChangedInZk = true;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String msg = "Error persisting managed schema at " + managedSchemaPath;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        if (schemaChangedInZk) {
            String msg = "Failed to persist managed schema at " + managedSchemaPath + " - version mismatch";
            log.info(msg);
            throw new SchemaChangedInZkException(SolrException.ErrorCode.CONFLICT, msg + ", retry.");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForSchemaZkVersionAgreement(String collection, String localCoreNodeName, int schemaZkVersion, ZkController zkController, int maxWaitSecs) {
        RTimer timer = new RTimer();
        ArrayList<GetZkSchemaVersionCallable> concurrentTasks = new ArrayList<GetZkSchemaVersionCallable>();
        for (String coreUrl : ManagedIndexSchema.getActiveReplicaCoreUrls(zkController, collection, localCoreNodeName)) {
            concurrentTasks.add(new GetZkSchemaVersionCallable(coreUrl, schemaZkVersion));
        }
        if (concurrentTasks.isEmpty()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Waiting up to {} secs for {} replicas to apply schema update version {} for collection {}", new Object[]{maxWaitSecs, concurrentTasks.size(), schemaZkVersion, collection});
        }
        int poolSize = Math.min(concurrentTasks.size(), 10);
        ExecutorService parallelExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)poolSize, (ThreadFactory)new SolrNamedThreadFactory("managedSchemaExecutor"));
        try {
            List results = parallelExecutor.invokeAll(concurrentTasks, maxWaitSecs, TimeUnit.SECONDS);
            ArrayList<String> failedList = null;
            for (int f = 0; f < results.size(); ++f) {
                int vers = -1;
                Future next = results.get(f);
                if (next.isDone() && !next.isCancelled()) {
                    try {
                        vers = (Integer)next.get();
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                if (vers != -1) continue;
                String coreUrl = ((GetZkSchemaVersionCallable)concurrentTasks.get(f)).coreUrl;
                log.warn("Core {} version mismatch! Expected {} but got {}", new Object[]{coreUrl, schemaZkVersion, vers});
                if (failedList == null) {
                    failedList = new ArrayList<String>();
                }
                failedList.add(coreUrl);
            }
            if (failedList != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, failedList.size() + " out of " + (concurrentTasks.size() + 1) + " replicas failed to update their schema to version " + schemaZkVersion + " within " + maxWaitSecs + " seconds! Failed cores: " + failedList);
            }
        }
        catch (InterruptedException ie) {
            log.warn("Core {} was interrupted waiting for schema version {} to propagate to {} replicas for collection {}", new Object[]{localCoreNodeName, schemaZkVersion, concurrentTasks.size(), collection});
            Thread.currentThread().interrupt();
        }
        finally {
            if (!parallelExecutor.isShutdown()) {
                parallelExecutor.shutdown();
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Took {}ms for {} replicas to apply schema update version {} for collection {}", new Object[]{timer.getTime(), concurrentTasks.size(), schemaZkVersion, collection});
        }
    }

    protected static List<String> getActiveReplicaCoreUrls(ZkController zkController, String collection, String localCoreNodeName) {
        ArrayList<String> activeReplicaCoreUrls = new ArrayList<String>();
        ZkStateReader zkStateReader = zkController.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Set liveNodes = clusterState.getLiveNodes();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection != null && docCollection.getActiveSlicesArr().length > 0) {
            Slice[] activeSlices;
            for (Slice next : activeSlices = docCollection.getActiveSlicesArr()) {
                Map replicasMap = next.getReplicasMap();
                if (replicasMap == null) continue;
                for (Map.Entry entry : replicasMap.entrySet()) {
                    Replica replica = (Replica)entry.getValue();
                    if (localCoreNodeName.equals(replica.getName()) || replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps((ZkNodeProps)replica);
                    activeReplicaCoreUrls.add(replicaCoreProps.getCoreUrl());
                }
            }
        }
        return activeReplicaCoreUrls;
    }

    @Override
    public ManagedIndexSchema addFields(Collection<SchemaField> newFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            boolean success = false;
            if (copyFieldNames == null) {
                copyFieldNames = Collections.emptyMap();
            }
            newSchema = this.shallowCopy(true);
            for (SchemaField newField : newFields) {
                Collection<String> copyFields;
                if (null != newSchema.fields.get(newField.getName())) {
                    String msg = "Field '" + newField.getName() + "' already exists.";
                    throw new FieldExistsException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                newSchema.fields.put(newField.getName(), newField);
                if (null != newField.getDefaultValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} contains default value: {}", (Object)newField.getName(), (Object)newField.getDefaultValue());
                    }
                    newSchema.fieldsWithDefaultValue.add(newField);
                }
                if (newField.isRequired()) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} is required in this schema", (Object)newField.getName());
                    }
                    newSchema.requiredFields.add(newField);
                }
                if ((copyFields = copyFieldNames.get(newField.getName())) == null) continue;
                for (String copyField : copyFields) {
                    newSchema.registerCopyField(newField.getName(), copyField);
                }
            }
            newSchema.postReadInform();
            newSchema.refreshAnalyzers();
            if (persist) {
                success = newSchema.persistManagedSchema(false);
                if (success) {
                    log.debug("Added field(s): {}", newFields);
                } else {
                    log.error("Failed to add field(s): {}", newFields);
                    newSchema = null;
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return newSchema;
    }

    @Override
    public ManagedIndexSchema deleteFields(Collection<String> names) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            newSchema = this.shallowCopy(true);
            for (String name : names) {
                SchemaField field = this.getFieldOrNull(name);
                if (null != field) {
                    String message = "Can't delete field '" + name + "' because it's referred to by at least one copy field directive.";
                    if (newSchema.copyFieldsMap.containsKey(name) || newSchema.isCopyFieldTarget(field)) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                    for (int i = 0; i < newSchema.dynamicCopyFields.length; ++i) {
                        IndexSchema.DynamicCopy dynamicCopy = newSchema.dynamicCopyFields[i];
                        if (!name.equals(dynamicCopy.getRegex())) continue;
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                    newSchema.fields.remove(name);
                    newSchema.fieldsWithDefaultValue.remove(field);
                    newSchema.requiredFields.remove(field);
                    continue;
                }
                String msg = "The field '" + name + "' is not present in this schema, and so cannot be deleted.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    public ManagedIndexSchema replaceField(String fieldName, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            SchemaField oldField = (SchemaField)this.fields.get(fieldName);
            if (null == oldField) {
                String msg = "The field '" + fieldName + "' is not present in this schema, and so cannot be replaced.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
            newSchema = this.shallowCopy(true);
            newSchema.copyFieldsMap = this.cloneCopyFieldsMap(this.copyFieldsMap);
            newSchema.copyFieldTargetCounts = (Map)((HashMap)this.copyFieldTargetCounts).clone();
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length];
            System.arraycopy(this.dynamicCopyFields, 0, newSchema.dynamicCopyFields, 0, this.dynamicCopyFields.length);
            newSchema.fields.remove(fieldName);
            newSchema.fieldsWithDefaultValue.remove(oldField);
            newSchema.requiredFields.remove(oldField);
            SchemaField replacementField = SchemaField.create(fieldName, replacementFieldType, replacementArgs);
            newSchema.fields.put(fieldName, replacementField);
            if (null != replacementField.getDefaultValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} contains default value: {}", (Object)replacementField.getName(), (Object)replacementField.getDefaultValue());
                }
                newSchema.fieldsWithDefaultValue.add(replacementField);
            }
            if (replacementField.isRequired()) {
                if (log.isDebugEnabled()) {
                    log.debug("{} is required in this schema", (Object)replacementField.getName());
                }
                newSchema.requiredFields.add(replacementField);
            }
            ArrayList<CopyField> copyFieldsToRebuild = new ArrayList<CopyField>();
            newSchema.removeCopyFieldSource(fieldName, copyFieldsToRebuild);
            newSchema.copyFieldTargetCounts.remove(oldField);
            for (Map.Entry entry : newSchema.copyFieldsMap.entrySet()) {
                List perSourceCopyFields = (List)entry.getValue();
                Iterator checkDestCopyFieldsIter = perSourceCopyFields.iterator();
                while (checkDestCopyFieldsIter.hasNext()) {
                    CopyField checkDestCopyField = (CopyField)checkDestCopyFieldsIter.next();
                    if (!fieldName.equals(checkDestCopyField.getDestination().getName())) continue;
                    checkDestCopyFieldsIter.remove();
                    copyFieldsToRebuild.add(checkDestCopyField);
                }
            }
            newSchema.rebuildCopyFields(copyFieldsToRebuild);
            ArrayList<IndexSchema.DynamicCopy> dynamicCopyFieldsToRebuild = new ArrayList<IndexSchema.DynamicCopy>();
            ArrayList<IndexSchema.DynamicCopy> newDynamicCopyFields = new ArrayList<IndexSchema.DynamicCopy>();
            for (int i = 0; i < newSchema.dynamicCopyFields.length; ++i) {
                IndexSchema.DynamicCopy dynamicCopy = newSchema.dynamicCopyFields[i];
                SchemaField destinationPrototype = dynamicCopy.getDestination().getPrototype();
                if (fieldName.equals(dynamicCopy.getRegex()) || fieldName.equals(destinationPrototype.getName())) {
                    dynamicCopyFieldsToRebuild.add(dynamicCopy);
                    continue;
                }
                newDynamicCopyFields.add(dynamicCopy);
            }
            if (dynamicCopyFieldsToRebuild.size() > 0) {
                newSchema.dynamicCopyFields = newDynamicCopyFields.toArray(new IndexSchema.DynamicCopy[newDynamicCopyFields.size()]);
                for (IndexSchema.DynamicCopy dynamicCopy : dynamicCopyFieldsToRebuild) {
                    newSchema.registerCopyField(dynamicCopy.getRegex(), dynamicCopy.getDestFieldName(), dynamicCopy.getMaxChars());
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    public ManagedIndexSchema addDynamicFields(Collection<SchemaField> newDynamicFields, Map<String, Collection<String>> copyFieldNames, boolean persist) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            boolean success = false;
            if (copyFieldNames == null) {
                copyFieldNames = Collections.emptyMap();
            }
            newSchema = this.shallowCopy(true);
            for (SchemaField newDynamicField : newDynamicFields) {
                ArrayList<IndexSchema.DynamicField> dFields = new ArrayList<IndexSchema.DynamicField>(Arrays.asList(newSchema.dynamicFields));
                if (this.isDuplicateDynField(dFields, newDynamicField)) {
                    String msg = "Dynamic field '" + newDynamicField.getName() + "' already exists.";
                    throw new FieldExistsException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                dFields.add(new IndexSchema.DynamicField(newDynamicField));
                newSchema.dynamicFields = ManagedIndexSchema.dynamicFieldListToSortedArray(dFields);
                Collection<String> copyFields = copyFieldNames.get(newDynamicField.getName());
                if (copyFields == null) continue;
                for (String copyField : copyFields) {
                    newSchema.registerCopyField(newDynamicField.getName(), copyField);
                }
            }
            newSchema.postReadInform();
            newSchema.refreshAnalyzers();
            if (persist) {
                success = newSchema.persistManagedSchema(false);
                if (success) {
                    log.debug("Added dynamic field(s): {}", newDynamicFields);
                } else {
                    log.error("Failed to add dynamic field(s): {}", newDynamicFields);
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return newSchema;
    }

    @Override
    public ManagedIndexSchema deleteDynamicFields(Collection<String> fieldNamePatterns) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            newSchema = this.shallowCopy(true);
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length];
            System.arraycopy(this.dynamicCopyFields, 0, newSchema.dynamicCopyFields, 0, this.dynamicCopyFields.length);
            ArrayList<IndexSchema.DynamicCopy> dynamicCopyFieldsToRebuild = new ArrayList<IndexSchema.DynamicCopy>();
            ArrayList<IndexSchema.DynamicCopy> newDynamicCopyFields = new ArrayList<IndexSchema.DynamicCopy>();
            for (String fieldNamePattern : fieldNamePatterns) {
                int dfPos;
                IndexSchema.DynamicField dynamicField = null;
                for (dfPos = 0; dfPos < newSchema.dynamicFields.length; ++dfPos) {
                    IndexSchema.DynamicField df = newSchema.dynamicFields[dfPos];
                    if (!df.getRegex().equals(fieldNamePattern)) continue;
                    dynamicField = df;
                    break;
                }
                if (null == dynamicField) {
                    String msg = "The dynamic field '" + fieldNamePattern + "' is not present in this schema, and so cannot be deleted.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                for (int i = 0; i < newSchema.dynamicCopyFields.length; ++i) {
                    IndexSchema.DynamicCopy dynamicCopy = newSchema.dynamicCopyFields[i];
                    IndexSchema.DynamicField destDynamicBase = dynamicCopy.getDestDynamicBase();
                    IndexSchema.DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                    if (null != destDynamicBase && fieldNamePattern.equals(destDynamicBase.getRegex()) || null != sourceDynamicBase && fieldNamePattern.equals(sourceDynamicBase.getRegex()) || dynamicField.matches(dynamicCopy.getRegex()) || dynamicField.matches(dynamicCopy.getDestFieldName())) {
                        dynamicCopyFieldsToRebuild.add(dynamicCopy);
                        newSchema.decrementCopyFieldTargetCount(dynamicCopy.getDestination().getPrototype());
                        continue;
                    }
                    newDynamicCopyFields.add(dynamicCopy);
                }
                if (newSchema.dynamicFields.length > 1) {
                    IndexSchema.DynamicField[] temp = new IndexSchema.DynamicField[newSchema.dynamicFields.length - 1];
                    System.arraycopy(newSchema.dynamicFields, 0, temp, 0, dfPos);
                    System.arraycopy(newSchema.dynamicFields, dfPos + 1, temp, dfPos, newSchema.dynamicFields.length - dfPos - 1);
                    newSchema.dynamicFields = temp;
                    continue;
                }
                newSchema.dynamicFields = new IndexSchema.DynamicField[0];
            }
            if (dynamicCopyFieldsToRebuild.size() > 0) {
                newSchema.dynamicCopyFields = newDynamicCopyFields.toArray(new IndexSchema.DynamicCopy[newDynamicCopyFields.size()]);
                for (IndexSchema.DynamicCopy dynamicCopy : dynamicCopyFieldsToRebuild) {
                    newSchema.registerCopyField(dynamicCopy.getRegex(), dynamicCopy.getDestFieldName(), dynamicCopy.getMaxChars());
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    public ManagedIndexSchema replaceDynamicField(String fieldNamePattern, FieldType replacementFieldType, Map<String, ?> replacementArgs) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            IndexSchema.DynamicField oldDynamicField = null;
            for (int dfPos = 0; dfPos < this.dynamicFields.length; ++dfPos) {
                IndexSchema.DynamicField dynamicField = this.dynamicFields[dfPos];
                if (!dynamicField.getRegex().equals(fieldNamePattern)) continue;
                oldDynamicField = dynamicField;
                break;
            }
            if (null == oldDynamicField) {
                String msg = "The dynamic field '" + fieldNamePattern + "' is not present in this schema, and so cannot be replaced.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
            newSchema = this.shallowCopy(true);
            newSchema.copyFieldTargetCounts = (Map)((HashMap)this.copyFieldTargetCounts).clone();
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length];
            System.arraycopy(this.dynamicCopyFields, 0, newSchema.dynamicCopyFields, 0, this.dynamicCopyFields.length);
            SchemaField prototype = SchemaField.create(fieldNamePattern, replacementFieldType, replacementArgs);
            newSchema.dynamicFields[dfPos] = new IndexSchema.DynamicField(prototype);
            ArrayList<IndexSchema.DynamicCopy> dynamicCopyFieldsToRebuild = new ArrayList<IndexSchema.DynamicCopy>();
            ArrayList<IndexSchema.DynamicCopy> newDynamicCopyFields = new ArrayList<IndexSchema.DynamicCopy>();
            for (int i = 0; i < newSchema.dynamicCopyFields.length; ++i) {
                IndexSchema.DynamicCopy dynamicCopy = newSchema.dynamicCopyFields[i];
                IndexSchema.DynamicField destDynamicBase = dynamicCopy.getDestDynamicBase();
                IndexSchema.DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                if (fieldNamePattern.equals(dynamicCopy.getRegex()) || fieldNamePattern.equals(dynamicCopy.getDestFieldName()) || null != destDynamicBase && fieldNamePattern.equals(destDynamicBase.getRegex()) || null != sourceDynamicBase && fieldNamePattern.equals(sourceDynamicBase.getRegex())) {
                    dynamicCopyFieldsToRebuild.add(dynamicCopy);
                    newSchema.decrementCopyFieldTargetCount(dynamicCopy.getDestination().getPrototype());
                    continue;
                }
                newDynamicCopyFields.add(dynamicCopy);
            }
            if (dynamicCopyFieldsToRebuild.size() > 0) {
                newSchema.dynamicCopyFields = newDynamicCopyFields.toArray(new IndexSchema.DynamicCopy[newDynamicCopyFields.size()]);
                for (IndexSchema.DynamicCopy dynamicCopy : dynamicCopyFieldsToRebuild) {
                    newSchema.registerCopyField(dynamicCopy.getRegex(), dynamicCopy.getDestFieldName(), dynamicCopy.getMaxChars());
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    public ManagedIndexSchema addCopyFields(Map<String, Collection<String>> copyFields, boolean persist) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            boolean success = false;
            newSchema = this.shallowCopy(true);
            for (Map.Entry<String, Collection<String>> entry : copyFields.entrySet()) {
                for (String destination : entry.getValue()) {
                    newSchema.registerCopyField(entry.getKey(), destination);
                }
            }
            newSchema.postReadInform();
            newSchema.refreshAnalyzers();
            if (persist) {
                success = newSchema.persistManagedSchema(false);
                if (success) {
                    if (log.isDebugEnabled()) {
                        log.debug("Added copy fields for {} sources", (Object)copyFields.size());
                    }
                } else {
                    log.error("Failed to add copy fields for {} sources", (Object)copyFields.size());
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return newSchema;
    }

    @Override
    public ManagedIndexSchema addCopyFields(String source, Collection<String> destinations, int maxChars) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            newSchema = this.shallowCopy(true);
            for (String destination : destinations) {
                newSchema.registerCopyField(source, destination, maxChars);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    public ManagedIndexSchema deleteCopyFields(Map<String, Collection<String>> copyFields) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            newSchema = this.shallowCopy(true);
            newSchema.copyFieldsMap = this.cloneCopyFieldsMap(this.copyFieldsMap);
            newSchema.copyFieldTargetCounts = (Map)((HashMap)this.copyFieldTargetCounts).clone();
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length];
            System.arraycopy(this.dynamicCopyFields, 0, newSchema.dynamicCopyFields, 0, this.dynamicCopyFields.length);
            for (Map.Entry<String, Collection<String>> entry : copyFields.entrySet()) {
                for (String destination : entry.getValue()) {
                    newSchema.deleteCopyField(entry.getKey(), destination);
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    private void deleteCopyField(String source, String dest) {
        List copyFieldList;
        SchemaField destSchemaField = (SchemaField)this.fields.get(dest);
        SchemaField sourceSchemaField = (SchemaField)this.fields.get(source);
        String invalidGlobMessage = "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
        if (source.contains("*") && !ManagedIndexSchema.isValidFieldGlob(source)) {
            String msg = "copyField source '" + source + "' " + "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        if (dest.contains("*") && !ManagedIndexSchema.isValidFieldGlob(dest)) {
            String msg = "copyField dest '" + dest + "' " + "is an invalid glob: either it contains more than one asterisk, or the asterisk occurs neither at the start nor at the end.";
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        boolean found = false;
        if (null == destSchemaField || null == sourceSchemaField) {
            for (int i = 0; i < this.dynamicCopyFields.length; ++i) {
                IndexSchema.DynamicCopy dynamicCopy = this.dynamicCopyFields[i];
                if (!source.equals(dynamicCopy.getRegex()) || !dest.equals(dynamicCopy.getDestFieldName())) continue;
                found = true;
                SchemaField destinationPrototype = dynamicCopy.getDestination().getPrototype();
                if (this.copyFieldTargetCounts.containsKey(destinationPrototype)) {
                    this.decrementCopyFieldTargetCount(destinationPrototype);
                }
                if (this.dynamicCopyFields.length > 1) {
                    IndexSchema.DynamicCopy[] temp = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length - 1];
                    System.arraycopy(this.dynamicCopyFields, 0, temp, 0, i);
                    System.arraycopy(this.dynamicCopyFields, i + 1, temp, i, this.dynamicCopyFields.length - i - 1);
                    this.dynamicCopyFields = temp;
                    break;
                }
                this.dynamicCopyFields = new IndexSchema.DynamicCopy[0];
                break;
            }
        }
        if (!found && (copyFieldList = (List)this.copyFieldsMap.get(source)) != null) {
            Iterator iter = copyFieldList.iterator();
            while (iter.hasNext()) {
                CopyField copyField = (CopyField)iter.next();
                if (!dest.equals(copyField.getDestination().getName())) continue;
                found = true;
                this.decrementCopyFieldTargetCount(copyField.getDestination());
                iter.remove();
                if (!copyFieldList.isEmpty()) break;
                this.copyFieldsMap.remove(source);
                break;
            }
        }
        if (!found) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Copy field directive not found: '" + source + "' -> '" + dest + "'");
        }
    }

    private void removeCopyFieldSource(String sourceFieldName, List<CopyField> removedCopyFields) {
        List sourceCopyFields = (List)this.copyFieldsMap.remove(sourceFieldName);
        if (null != sourceCopyFields) {
            for (CopyField sourceCopyField : sourceCopyFields) {
                this.decrementCopyFieldTargetCount(sourceCopyField.getDestination());
                removedCopyFields.add(sourceCopyField);
            }
        }
    }

    private void rebuildCopyFields(List<CopyField> oldCopyFields) {
        if (oldCopyFields.size() > 0) {
            for (CopyField copyField : oldCopyFields) {
                SchemaField source = (SchemaField)this.fields.get(copyField.getSource().getName());
                SchemaField destination = (SchemaField)this.fields.get(copyField.getDestination().getName());
                this.registerExplicitSrcAndDestFields(copyField.getSource().getName(), copyField.getMaxChars(), destination, source);
            }
        }
    }

    private void decrementCopyFieldTargetCount(SchemaField dest) {
        Integer count = (Integer)this.copyFieldTargetCounts.get(dest);
        assert (count != null);
        if (count <= 1) {
            this.copyFieldTargetCounts.remove(dest);
        } else {
            this.copyFieldTargetCounts.put(dest, count - 1);
        }
    }

    @Override
    public ManagedIndexSchema addFieldTypes(List<FieldType> fieldTypeList, boolean persist) {
        if (!this.isMutable) {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        ManagedIndexSchema newSchema = this.shallowCopy(true);
        HashMap clone = (HashMap)((HashMap)newSchema.fieldTypes).clone();
        newSchema.fieldTypes = clone;
        for (FieldType fieldType : fieldTypeList) {
            String typeName = fieldType.getTypeName();
            if (newSchema.getFieldTypeByName(typeName) != null) {
                throw new FieldExistsException(SolrException.ErrorCode.BAD_REQUEST, "Field type '" + typeName + "' already exists!");
            }
            newSchema.fieldTypes.put(typeName, fieldType);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        if (persist) {
            boolean success = newSchema.persistManagedSchema(false);
            if (success) {
                if (log.isDebugEnabled()) {
                    StringBuilder fieldTypeNames = new StringBuilder();
                    for (int i = 0; i < fieldTypeList.size(); ++i) {
                        if (i > 0) {
                            fieldTypeNames.append(", ");
                        }
                        fieldTypeNames.append(fieldTypeList.get((int)i).typeName);
                    }
                    log.debug("Added field types: {}", (Object)fieldTypeNames);
                }
            } else {
                log.error("Failed to add field types: {}", fieldTypeList);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to persist updated schema due to underlying storage issue; check log for more details!");
            }
        }
        return newSchema;
    }

    @Override
    public ManagedIndexSchema deleteFieldTypes(Collection<String> names) {
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            for (String name : names) {
                if (!this.fieldTypes.containsKey(name)) {
                    String msg = "The field type '" + name + "' is not present in this schema, and so cannot be deleted.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                for (SchemaField field : this.fields.values()) {
                    if (!field.getType().getTypeName().equals(name)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't delete '" + name + "' because it's the field type of field '" + field.getName() + "'.");
                }
                for (IndexSchema.DynamicField dynamicField : this.dynamicFields) {
                    if (!dynamicField.getPrototype().getType().getTypeName().equals(name)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't delete '" + name + "' because it's the field type of dynamic field '" + dynamicField.getRegex() + "'.");
                }
            }
            newSchema = this.shallowCopy(true);
            for (String name : names) {
                newSchema.fieldTypes.remove(name);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    private Map<String, List<CopyField>> cloneCopyFieldsMap(Map<String, List<CopyField>> original) {
        HashMap<String, List<CopyField>> clone = new HashMap<String, List<CopyField>>(original.size());
        for (Map.Entry<String, List<CopyField>> entry : original.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return clone;
    }

    @Override
    public ManagedIndexSchema replaceFieldType(String typeName, String replacementClassName, Map<String, Object> replacementArgs) {
        ArrayList<CopyField> copyFieldsToRebuild;
        ManagedIndexSchema newSchema;
        if (this.isMutable) {
            if (!this.fieldTypes.containsKey(typeName)) {
                String msg = "The field type '" + typeName + "' is not present in this schema, and so cannot be replaced.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
            }
            newSchema = this.shallowCopy(true);
            newSchema.fieldTypes = (Map)((HashMap)this.fieldTypes).clone();
            newSchema.copyFieldsMap = this.cloneCopyFieldsMap(this.copyFieldsMap);
            newSchema.copyFieldTargetCounts = (Map)((HashMap)this.copyFieldTargetCounts).clone();
            newSchema.dynamicCopyFields = new IndexSchema.DynamicCopy[this.dynamicCopyFields.length];
            System.arraycopy(this.dynamicCopyFields, 0, newSchema.dynamicCopyFields, 0, this.dynamicCopyFields.length);
            newSchema.dynamicFields = new IndexSchema.DynamicField[this.dynamicFields.length];
            System.arraycopy(this.dynamicFields, 0, newSchema.dynamicFields, 0, this.dynamicFields.length);
            newSchema.fieldTypes.remove(typeName);
            FieldType replacementFieldType = newSchema.newFieldType(typeName, replacementClassName, replacementArgs);
            newSchema.fieldTypes.put(typeName, replacementFieldType);
            copyFieldsToRebuild = new ArrayList<CopyField>();
            ArrayList<SchemaField> replacementFields = new ArrayList<SchemaField>();
            Iterator fieldsIter = newSchema.fields.entrySet().iterator();
            while (fieldsIter.hasNext()) {
                Map.Entry entry = fieldsIter.next();
                SchemaField oldField = (SchemaField)entry.getValue();
                if (!oldField.getType().getTypeName().equals(typeName)) continue;
                String fieldName = oldField.getName();
                fieldsIter.remove();
                newSchema.fieldsWithDefaultValue.remove(oldField);
                newSchema.requiredFields.remove(oldField);
                SchemaField replacementField = SchemaField.create(fieldName, replacementFieldType, oldField.getArgs());
                replacementFields.add(replacementField);
                if (null != replacementField.getDefaultValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} contains default value: {}", (Object)replacementField.getName(), (Object)replacementField.getDefaultValue());
                    }
                    newSchema.fieldsWithDefaultValue.add(replacementField);
                }
                if (replacementField.isRequired()) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} is required in this schema", (Object)replacementField.getName());
                    }
                    newSchema.requiredFields.add(replacementField);
                }
                newSchema.removeCopyFieldSource(fieldName, copyFieldsToRebuild);
            }
            for (SchemaField replacementField : replacementFields) {
                newSchema.fields.put(replacementField.getName(), replacementField);
            }
            Iterator copyFieldsMapIter = newSchema.copyFieldsMap.entrySet().iterator();
            while (copyFieldsMapIter.hasNext()) {
                Map.Entry entry = copyFieldsMapIter.next();
                List perSourceCopyFields = (List)entry.getValue();
                Iterator checkDestCopyFieldsIter = perSourceCopyFields.iterator();
                while (checkDestCopyFieldsIter.hasNext()) {
                    CopyField checkDestCopyField = (CopyField)checkDestCopyFieldsIter.next();
                    SchemaField destination = checkDestCopyField.getDestination();
                    if (!typeName.equals(destination.getType().getTypeName())) continue;
                    checkDestCopyFieldsIter.remove();
                    copyFieldsToRebuild.add(checkDestCopyField);
                    newSchema.copyFieldTargetCounts.remove(destination);
                }
                if (!perSourceCopyFields.isEmpty()) continue;
                copyFieldsMapIter.remove();
            }
            for (int i = 0; i < newSchema.dynamicFields.length; ++i) {
                SchemaField prototype = newSchema.dynamicFields[i].getPrototype();
                if (!typeName.equals(prototype.getType().getTypeName())) continue;
                newSchema.dynamicFields[i] = new IndexSchema.DynamicField(SchemaField.create(prototype.getName(), replacementFieldType, prototype.getArgs()));
            }
            ArrayList<IndexSchema.DynamicCopy> dynamicCopyFieldsToRebuild = new ArrayList<IndexSchema.DynamicCopy>();
            ArrayList<IndexSchema.DynamicCopy> newDynamicCopyFields = new ArrayList<IndexSchema.DynamicCopy>();
            for (int i = 0; i < newSchema.dynamicCopyFields.length; ++i) {
                IndexSchema.DynamicCopy dynamicCopy = newSchema.dynamicCopyFields[i];
                IndexSchema.DynamicField sourceDynamicBase = dynamicCopy.getSourceDynamicBase();
                SchemaField destinationPrototype = dynamicCopy.getDestination().getPrototype();
                if (typeName.equals(destinationPrototype.getType().getTypeName()) || null != sourceDynamicBase && typeName.equals(sourceDynamicBase.getPrototype().getType().getTypeName())) {
                    dynamicCopyFieldsToRebuild.add(dynamicCopy);
                    if (!newSchema.copyFieldTargetCounts.containsKey(destinationPrototype)) continue;
                    newSchema.decrementCopyFieldTargetCount(destinationPrototype);
                    continue;
                }
                newDynamicCopyFields.add(dynamicCopy);
            }
            if (dynamicCopyFieldsToRebuild.size() > 0) {
                newSchema.dynamicCopyFields = newDynamicCopyFields.toArray(new IndexSchema.DynamicCopy[newDynamicCopyFields.size()]);
                for (IndexSchema.DynamicCopy dynamicCopy : dynamicCopyFieldsToRebuild) {
                    newSchema.registerCopyField(dynamicCopy.getRegex(), dynamicCopy.getDestFieldName(), dynamicCopy.getMaxChars());
                }
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        newSchema.rebuildCopyFields(copyFieldsToRebuild);
        newSchema.postReadInform();
        newSchema.refreshAnalyzers();
        return newSchema;
    }

    @Override
    protected void postReadInform() {
        super.postReadInform();
        for (FieldType fieldType : this.fieldTypes.values()) {
            this.informResourceLoaderAwareObjectsForFieldType(fieldType);
        }
    }

    protected void informResourceLoaderAwareObjectsForFieldType(FieldType fieldType) {
        TextField textFieldType;
        Analyzer multiTermAnalyzer;
        Analyzer queryAnalyzer;
        if (!fieldType.supportsAnalyzers()) {
            return;
        }
        Analyzer indexAnalyzer = fieldType.getIndexAnalyzer();
        if (indexAnalyzer != null && indexAnalyzer instanceof TokenizerChain) {
            this.informResourceLoaderAwareObjectsInChain((TokenizerChain)indexAnalyzer);
        }
        if ((queryAnalyzer = fieldType.getQueryAnalyzer()) != null && queryAnalyzer != indexAnalyzer && queryAnalyzer instanceof TokenizerChain) {
            this.informResourceLoaderAwareObjectsInChain((TokenizerChain)queryAnalyzer);
        }
        if (fieldType instanceof TextField && (multiTermAnalyzer = (textFieldType = (TextField)fieldType).getMultiTermAnalyzer()) != null && multiTermAnalyzer != indexAnalyzer && multiTermAnalyzer != queryAnalyzer && multiTermAnalyzer instanceof TokenizerChain) {
            this.informResourceLoaderAwareObjectsInChain((TokenizerChain)multiTermAnalyzer);
        }
    }

    @Override
    public SchemaField newField(String fieldName, String fieldType, Map<String, ?> options) {
        SchemaField sf;
        if (this.isMutable) {
            try {
                if (-1 != fieldName.indexOf(42)) {
                    String msg = "Can't add dynamic field '" + fieldName + "'.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                SchemaField existingFieldWithTheSameName = (SchemaField)this.fields.get(fieldName);
                if (null != existingFieldWithTheSameName) {
                    String msg = "Field '" + fieldName + "' already exists.";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                FieldType type = this.getFieldTypeByName(fieldType);
                if (null == type) {
                    String msg = "Field '" + fieldName + "': Field type '" + fieldType + "' not found.";
                    log.error(msg);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                }
                sf = SchemaField.create(fieldName, type, options);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        } else {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return sf;
    }

    public int getSchemaZkVersion() {
        return this.schemaZkVersion;
    }

    @Override
    public SchemaField newDynamicField(String fieldNamePattern, String fieldType, Map<String, ?> options) {
        SchemaField sf;
        block6: {
            if (this.isMutable) {
                try {
                    FieldType type = this.getFieldTypeByName(fieldType);
                    if (null == type) {
                        String msg = "Dynamic field '" + fieldNamePattern + "': Field type '" + fieldType + "' not found.";
                        log.error(msg);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                    }
                    sf = SchemaField.create(fieldNamePattern, type, options);
                    if (!this.isValidDynamicField(Arrays.asList(this.dynamicFields), sf)) {
                        String msg = "Invalid dynamic field '" + fieldNamePattern + "'";
                        log.error(msg);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
                    }
                    break block6;
                }
                catch (SolrException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        return sf;
    }

    @Override
    public FieldType newFieldType(String typeName, String className, Map<String, ?> options) {
        if (!this.isMutable) {
            String msg = "This ManagedIndexSchema is not mutable.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
        }
        if (this.getFieldTypeByName(typeName) != null) {
            String msg = "Field type '" + typeName + "' already exists.";
            log.error(msg);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        HashMap<String, FieldType> newFieldTypes = new HashMap<String, FieldType>();
        ArrayList<SchemaAware> schemaAwareList = new ArrayList<SchemaAware>();
        FieldTypePluginLoader typeLoader = new FieldTypePluginLoader(this, newFieldTypes, schemaAwareList);
        typeLoader.loadSingle(this.solrClassLoader, FieldTypeXmlAdapter.toNode(options));
        FieldType ft = (FieldType)newFieldTypes.get(typeName);
        if (!schemaAwareList.isEmpty()) {
            this.schemaAware.addAll(schemaAwareList);
        }
        return ft;
    }

    protected void informResourceLoaderAwareObjectsInChain(TokenizerChain chain) {
        TokenFilterFactory[] filters;
        CharFilterFactory[] charFilters;
        for (CharFilterFactory next : charFilters = chain.getCharFilterFactories()) {
            if (!(next instanceof ResourceLoaderAware)) continue;
            try {
                SolrResourceLoader.informAware(this.loader, (ResourceLoaderAware)next);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        TokenizerFactory tokenizerFactory = chain.getTokenizerFactory();
        if (tokenizerFactory instanceof ResourceLoaderAware) {
            try {
                SolrResourceLoader.informAware(this.loader, (ResourceLoaderAware)tokenizerFactory);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        for (TokenFilterFactory next : filters = chain.getTokenFilterFactories()) {
            if (!(next instanceof ResourceLoaderAware)) continue;
            try {
                SolrResourceLoader.informAware(this.loader, (ResourceLoaderAware)next);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    private ManagedIndexSchema(Version luceneVersion, SolrResourceLoader loader, boolean isMutable, String managedSchemaResourceName, int schemaZkVersion, Object schemaUpdateLock, Properties substitutableProps) {
        super(luceneVersion, loader, substitutableProps);
        this.isMutable = isMutable;
        this.managedSchemaResourceName = managedSchemaResourceName;
        this.schemaZkVersion = schemaZkVersion;
        this.schemaUpdateLock = schemaUpdateLock;
    }

    ManagedIndexSchema shallowCopy(boolean includeFieldDataStructures) {
        ManagedIndexSchema newSchema = new ManagedIndexSchema(this.luceneVersion, this.loader, this.isMutable, this.managedSchemaResourceName, this.schemaZkVersion, this.getSchemaUpdateLock(), this.substitutableProperties);
        newSchema.name = this.name;
        newSchema.version = this.version;
        newSchema.similarity = this.similarity;
        newSchema.similarityFactory = this.similarityFactory;
        newSchema.isExplicitSimilarity = this.isExplicitSimilarity;
        newSchema.uniqueKeyField = this.uniqueKeyField;
        newSchema.uniqueKeyFieldName = this.uniqueKeyFieldName;
        newSchema.uniqueKeyFieldType = this.uniqueKeyFieldType;
        newSchema.resourceName = this.managedSchemaResourceName;
        if (includeFieldDataStructures) {
            newSchema.fields.putAll(this.fields);
            newSchema.fieldsWithDefaultValue.addAll(this.fieldsWithDefaultValue);
            newSchema.requiredFields.addAll(this.requiredFields);
        }
        newSchema.fieldTypes = this.fieldTypes;
        newSchema.dynamicFields = this.dynamicFields;
        newSchema.dynamicCopyFields = this.dynamicCopyFields;
        newSchema.copyFieldsMap = this.copyFieldsMap;
        newSchema.copyFieldTargetCounts = this.copyFieldTargetCounts;
        newSchema.schemaAware = this.schemaAware;
        return newSchema;
    }

    @Override
    public Object getSchemaUpdateLock() {
        return this.schemaUpdateLock;
    }

    public static class SchemaChangedInZkException
    extends SolrException {
        public SchemaChangedInZkException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    public static class FieldExistsException
    extends SolrException {
        public FieldExistsException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    private static class GetZkSchemaVersionCallable
    extends SolrRequest
    implements Callable<Integer> {
        private String coreUrl;
        private int expectedZkVersion;

        GetZkSchemaVersionCallable(String coreUrl, int expectedZkVersion) {
            super(SolrRequest.METHOD.GET, "/schema/zkversion");
            this.coreUrl = coreUrl;
            this.expectedZkVersion = expectedZkVersion;
        }

        public SolrParams getParams() {
            ModifiableSolrParams wparams = new ModifiableSolrParams();
            wparams.set("refreshIfBelowVersion", this.expectedZkVersion);
            return wparams;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Integer call() throws Exception {
            int remoteVersion = -1;
            try (HttpSolrClient solr = new HttpSolrClient.Builder(this.coreUrl).build();){
                while (true) {
                    if (remoteVersion != -1) {
                        if (remoteVersion >= this.expectedZkVersion) return remoteVersion;
                    }
                    try {
                        HttpSolrClient.HttpUriRequestResponse mrr = solr.httpUriRequest((SolrRequest)this);
                        NamedList zkversionResp = (NamedList)mrr.future.get();
                        if (zkversionResp != null) {
                            remoteVersion = (Integer)zkversionResp.get("zkversion");
                        }
                        if (remoteVersion >= this.expectedZkVersion) continue;
                        log.error("Replica {} returned schema version {} and has not applied schema version {}", new Object[]{this.coreUrl, remoteVersion, this.expectedZkVersion});
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            return remoteVersion;
                        }
                        log.warn("Failed to get /schema/zkversion from {} due to: ", (Object)this.coreUrl, (Object)e);
                    }
                }
            }
        }

        protected SolrResponse createResponse(SolrClient client) {
            return null;
        }
    }
}

