/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.mjpeg;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Edit;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ObjectDescriptorFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneJpegPerIframe
extends AbstractTrack {
    File[] jpegs;
    TrackMetaData trackMetaData = new TrackMetaData();
    long[] sampleDurations;
    SampleDescriptionBox stsd;
    long[] syncSamples;

    public OneJpegPerIframe(String name, File[] jpegs, Track alignTo) throws IOException {
        super(name);
        this.jpegs = jpegs;
        if (alignTo.getSyncSamples().length != jpegs.length) {
            throw new RuntimeException("Number of sync samples doesn't match the number of stills (" + alignTo.getSyncSamples().length + " vs. " + jpegs.length + ")");
        }
        BufferedImage a = ImageIO.read(jpegs[0]);
        this.trackMetaData.setWidth(a.getWidth());
        this.trackMetaData.setHeight(a.getHeight());
        this.trackMetaData.setTimescale(alignTo.getTrackMetaData().getTimescale());
        long[] sampleDurationsToiAlignTo = alignTo.getSampleDurations();
        long[] syncSamples = alignTo.getSyncSamples();
        int currentSyncSample = 1;
        long duration = 0L;
        this.sampleDurations = new long[syncSamples.length];
        int i = 1;
        while (i < sampleDurationsToiAlignTo.length) {
            if (currentSyncSample < syncSamples.length && (long)i == syncSamples[currentSyncSample]) {
                this.sampleDurations[currentSyncSample - 1] = duration;
                duration = 0L;
                ++currentSyncSample;
            }
            duration += sampleDurationsToiAlignTo[i];
            ++i;
        }
        this.sampleDurations[this.sampleDurations.length - 1] = duration;
        this.stsd = new SampleDescriptionBox();
        VisualSampleEntry mp4v = new VisualSampleEntry("mp4v");
        this.stsd.addBox(mp4v);
        ESDescriptorBox esds = new ESDescriptorBox();
        esds.setData(ByteBuffer.wrap(Hex.decodeHex("038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102")));
        esds.setEsDescriptor((ESDescriptor)ObjectDescriptorFactory.createFrom(-1, ByteBuffer.wrap(Hex.decodeHex("038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102"))));
        mp4v.addBox(esds);
        this.syncSamples = new long[jpegs.length];
        int i2 = 0;
        while (i2 < this.syncSamples.length) {
            this.syncSamples[i2] = i2 + 1;
            ++i2;
        }
        double earliestTrackPresentationTime = 0.0;
        boolean acceptDwell = true;
        boolean acceptEdit = true;
        for (Edit edit : alignTo.getEdits()) {
            if (edit.getMediaTime() == -1L && !acceptDwell) {
                throw new RuntimeException("Cannot accept edit list for processing (1)");
            }
            if (edit.getMediaTime() >= 0L && !acceptEdit) {
                throw new RuntimeException("Cannot accept edit list for processing (2)");
            }
            if (edit.getMediaTime() == -1L) {
                earliestTrackPresentationTime += edit.getSegmentDuration();
                continue;
            }
            earliestTrackPresentationTime -= (double)edit.getMediaTime() / (double)edit.getTimeScale();
            acceptEdit = false;
            acceptDwell = false;
        }
        if (alignTo.getCompositionTimeEntries() != null && alignTo.getCompositionTimeEntries().size() > 0) {
            long currentTime = 0L;
            int[] ptss = CompositionTimeToSample.blowupCompositionTimes(alignTo.getCompositionTimeEntries());
            int j = 0;
            while (j < ptss.length && j < 50) {
                int n = j;
                ptss[n] = (int)((long)ptss[n] + currentTime);
                currentTime += alignTo.getSampleDurations()[j];
                ++j;
            }
            Arrays.sort(ptss);
            earliestTrackPresentationTime += (double)ptss[0] / (double)alignTo.getTrackMetaData().getTimescale();
        }
        if (earliestTrackPresentationTime < 0.0) {
            this.getEdits().add(new Edit((long)(-earliestTrackPresentationTime * (double)this.getTrackMetaData().getTimescale()), this.getTrackMetaData().getTimescale(), 1.0, (double)this.getDuration() / (double)this.getTrackMetaData().getTimescale()));
        } else if (earliestTrackPresentationTime > 0.0) {
            this.getEdits().add(new Edit(-1L, this.getTrackMetaData().getTimescale(), 1.0, earliestTrackPresentationTime));
            this.getEdits().add(new Edit(0L, this.getTrackMetaData().getTimescale(), 1.0, (double)this.getDuration() / (double)this.getTrackMetaData().getTimescale()));
        }
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.sampleDurations;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public long[] getSyncSamples() {
        return this.syncSamples;
    }

    @Override
    public List<Sample> getSamples() {
        return new AbstractList<Sample>(){

            @Override
            public int size() {
                return OneJpegPerIframe.this.jpegs.length;
            }

            @Override
            public Sample get(final int index) {
                return new Sample(){
                    ByteBuffer sample = null;

                    public void writeTo(WritableByteChannel channel) throws IOException {
                        RandomAccessFile raf = new RandomAccessFile((this).OneJpegPerIframe.this.jpegs[index], "r");
                        raf.getChannel().transferTo(0L, raf.length(), channel);
                        raf.close();
                    }

                    public long getSize() {
                        return (this).OneJpegPerIframe.this.jpegs[index].length();
                    }

                    public ByteBuffer asByteBuffer() {
                        if (this.sample == null) {
                            try {
                                RandomAccessFile raf = new RandomAccessFile((this).OneJpegPerIframe.this.jpegs[index], "r");
                                this.sample = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.sample;
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
    }
}

