/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdRandomAccessFileBackendFactory;
import org.rrd4j.core.RrdSafeFileBackend;

@RrdBackendAnnotation(name="SAFE", shouldValidateHeader=true, cachingAllowed=false)
public class RrdSafeFileBackendFactory
extends RrdRandomAccessFileBackendFactory {
    public static final long LOCK_WAIT_TIME = 3000L;
    private static long defaultLockWaitTime = 3000L;
    public static final long LOCK_RETRY_PERIOD = 50L;
    private static long defaultLockRetryPeriod = 50L;
    private final long lockWaitTime;
    private final long lockRetryPeriod;

    public RrdSafeFileBackendFactory() {
        this.lockWaitTime = defaultLockWaitTime;
        this.lockRetryPeriod = defaultLockRetryPeriod;
    }

    public RrdSafeFileBackendFactory(long lockWaitTime, long lockRetryPeriod) {
        this.lockWaitTime = lockWaitTime;
        this.lockRetryPeriod = lockRetryPeriod;
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdSafeFileBackend(path, this.lockWaitTime, this.lockRetryPeriod);
    }

    public static long getLockWaitTime() {
        return defaultLockWaitTime;
    }

    public static void setLockWaitTime(long lockWaitTime) {
        defaultLockWaitTime = lockWaitTime;
    }

    public static long getLockRetryPeriod() {
        return defaultLockRetryPeriod;
    }

    public static void setLockRetryPeriod(long lockRetryPeriod) {
        defaultLockRetryPeriod = lockRetryPeriod;
    }
}

