/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.DistributedQueueFactory;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.cloud.autoscaling.sim.NoopDistributedQueueFactory;
import org.apache.solr.cloud.autoscaling.sim.SimUtils;
import org.apache.solr.cloud.autoscaling.sim.SnapshotClusterStateProvider;
import org.apache.solr.cloud.autoscaling.sim.SnapshotDistribStateManager;
import org.apache.solr.cloud.autoscaling.sim.SnapshotNodeStateProvider;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.RedactionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCloudManager
implements SolrCloudManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ObjectCache objectCache = new ObjectCache();
    private SnapshotClusterStateProvider clusterStateProvider;
    private SnapshotNodeStateProvider nodeStateProvider;
    private SnapshotDistribStateManager distribStateManager;
    private TimeSource timeSource;
    public static final String MANAGER_STATE_KEY = "managerState";
    public static final String CLUSTER_STATE_KEY = "clusterState";
    public static final String NODE_STATE_KEY = "nodeState";
    public static final String DISTRIB_STATE_KEY = "distribState";
    public static final String AUTOSCALING_STATE_KEY = "autoscalingState";
    public static final String STATISTICS_STATE_KEY = "statistics";
    public static final String AUTOSCALING_JSON_KEY = "autoscaling";
    public static final List<String> REQUIRED_KEYS = Arrays.asList("managerState", "clusterState", "nodeState", "distribState");

    public SnapshotCloudManager(SolrCloudManager other, AutoScalingConfig config) throws Exception {
        this.timeSource = other.getTimeSource();
        this.clusterStateProvider = new SnapshotClusterStateProvider(other.getClusterStateProvider());
        this.nodeStateProvider = new SnapshotNodeStateProvider(other, config);
        this.distribStateManager = new SnapshotDistribStateManager(other.getDistribStateManager(), config);
        SimUtils.checkConsistency(this, config);
    }

    public SnapshotCloudManager(Map<String, Object> snapshot) throws Exception {
        Objects.requireNonNull(snapshot);
        this.init(snapshot.getOrDefault(MANAGER_STATE_KEY, Collections.emptyMap()), snapshot.getOrDefault(CLUSTER_STATE_KEY, Collections.emptyMap()), snapshot.getOrDefault(NODE_STATE_KEY, Collections.emptyMap()), snapshot.getOrDefault(DISTRIB_STATE_KEY, Collections.emptyMap()), snapshot.getOrDefault(AUTOSCALING_JSON_KEY, Collections.emptyMap()));
    }

    public void saveSnapshot(File targetDir, boolean withAutoscaling, boolean redact) throws Exception {
        Map<String, Object> snapshot = this.getSnapshot(withAutoscaling, redact);
        ClusterState clusterState = this.getClusterStateProvider().getClusterState();
        RedactionUtils.RedactionContext ctx = SimUtils.getRedactionContext(clusterState);
        targetDir.mkdirs();
        for (Map.Entry<String, Object> e : snapshot.entrySet()) {
            FileOutputStream out = new FileOutputStream(new File(targetDir, e.getKey() + ".json"));
            if (redact) {
                String data = Utils.toJSONString((Object)e.getValue());
                data = RedactionUtils.redactNames(ctx.getRedactions(), data);
                IOUtils.write((byte[])data.getBytes("UTF-8"), (OutputStream)out);
            } else {
                IOUtils.write((byte[])Utils.toJSON((Object)e.getValue()), (OutputStream)out);
            }
            out.flush();
            out.close();
        }
    }

    public static SnapshotCloudManager readSnapshot(File sourceDir) throws Exception {
        if (!sourceDir.exists()) {
            throw new Exception("Source path doesn't exist: " + sourceDir);
        }
        if (!sourceDir.isDirectory()) {
            throw new Exception("Source path is not a directory: " + sourceDir);
        }
        HashMap<String, Object> snapshot = new HashMap<String, Object>();
        ArrayList<String> allKeys = new ArrayList<String>(REQUIRED_KEYS);
        allKeys.add(AUTOSCALING_JSON_KEY);
        int validData = 0;
        for (String key : allKeys) {
            File src = new File(sourceDir, key + ".json");
            if (!src.exists()) continue;
            FileInputStream is = new FileInputStream(src);
            Map data = (Map)Utils.fromJSON((InputStream)is);
            ((InputStream)is).close();
            snapshot.put(key, data);
            if (!REQUIRED_KEYS.contains(key)) continue;
            ++validData;
        }
        if (validData < REQUIRED_KEYS.size()) {
            throw new Exception("Some data is missing - expected: " + REQUIRED_KEYS + ", found: " + snapshot.keySet());
        }
        return new SnapshotCloudManager(snapshot);
    }

    private void init(Map<String, Object> managerState, Map<String, Object> clusterState, Map<String, Object> nodeState, Map<String, Object> distribState, Map<String, Object> autoscalingJson) throws Exception {
        Objects.requireNonNull(managerState);
        Objects.requireNonNull(clusterState);
        Objects.requireNonNull(nodeState);
        Objects.requireNonNull(distribState);
        this.timeSource = TimeSource.get((String)((String)managerState.getOrDefault("timeSource", "simTime:50")));
        this.clusterStateProvider = new SnapshotClusterStateProvider(clusterState);
        this.nodeStateProvider = new SnapshotNodeStateProvider(nodeState);
        this.distribStateManager = autoscalingJson == null || autoscalingJson.isEmpty() ? new SnapshotDistribStateManager(distribState) : new SnapshotDistribStateManager(distribState, new AutoScalingConfig(autoscalingJson));
        SimUtils.checkConsistency(this, null);
    }

    public Map<String, Object> getSnapshot(boolean withAutoscaling, boolean redact) throws Exception {
        LinkedHashMap<String, Object> snapshot = new LinkedHashMap<String, Object>(4);
        HashMap<String, String> managerState = new HashMap<String, String>();
        managerState.put("timeSource", this.timeSource.toString());
        snapshot.put(MANAGER_STATE_KEY, managerState);
        RedactionUtils.RedactionContext ctx = redact ? SimUtils.getRedactionContext(this.clusterStateProvider.getClusterState()) : null;
        snapshot.put(CLUSTER_STATE_KEY, this.clusterStateProvider.getSnapshot());
        snapshot.put(NODE_STATE_KEY, this.nodeStateProvider.getSnapshot());
        snapshot.put(DISTRIB_STATE_KEY, this.distribStateManager.getSnapshot(ctx));
        if (withAutoscaling) {
            AutoScalingConfig config = this.distribStateManager.getAutoScalingConfig();
            Policy.Session session = config.getPolicy().createSession((SolrCloudManager)this);
            List suggestions = PolicyHelper.getSuggestions((AutoScalingConfig)config, (SolrCloudManager)this);
            LinkedHashMap diagnostics = new LinkedHashMap();
            PolicyHelper.getDiagnostics((Policy.Session)session).toMap(diagnostics);
            ArrayList suggestionDetails = new ArrayList(suggestions.size());
            suggestions.forEach(s -> {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("suggestion", s);
                if (s.getOperation() != null) {
                    ReplicaInfo info;
                    SolrParams params = s.getOperation().getParams();
                    if (s.getOperation() instanceof V2Request) {
                        params = SimUtils.v2AdminRequestToV1Params((V2Request)s.getOperation());
                    }
                    if ((info = this.nodeStateProvider.getReplicaInfo(params.get("collection"), params.get("replica"))) == null) {
                        log.warn("Can't find ReplicaInfo for suggested operation: " + s);
                    } else {
                        map.put("replica", info);
                    }
                }
                suggestionDetails.add(map);
            });
            LinkedHashMap<String, Cloneable> autoscaling = new LinkedHashMap<String, Cloneable>();
            autoscaling.put("suggestions", suggestionDetails);
            autoscaling.put("diagnostics", diagnostics);
            snapshot.put(AUTOSCALING_STATE_KEY, autoscaling);
        }
        snapshot.put(STATISTICS_STATE_KEY, SimUtils.calculateStats(this, this.distribStateManager.getAutoScalingConfig(), true));
        return snapshot;
    }

    public ClusterStateProvider getClusterStateProvider() {
        return this.clusterStateProvider;
    }

    public NodeStateProvider getNodeStateProvider() {
        return this.nodeStateProvider;
    }

    public DistribStateManager getDistribStateManager() {
        return this.distribStateManager;
    }

    public DistributedQueueFactory getDistributedQueueFactory() {
        return NoopDistributedQueueFactory.INSTANCE;
    }

    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public SolrResponse request(SolrRequest req) throws IOException {
        throw new UnsupportedOperationException("request");
    }

    public byte[] httpRequest(String url, SolrRequest.METHOD method, Map<String, String> headers, String payload, int timeout, boolean followRedirects) throws IOException {
        throw new UnsupportedOperationException("httpRequest");
    }

    public void close() throws IOException {
    }
}

