/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.IntToLongFunction;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.junit.Assert;

public class RandomPostingsTester {
    private static final IntToLongFunction DOC_TO_NORM = doc -> 1 + (doc & 0xF);
    private static final long MAX_NORM = 16L;
    private long totalPostings;
    private long totalPayloadBytes;
    private Map<String, SortedMap<BytesRef, SeedAndOrd>> fields = new TreeMap<String, SortedMap<BytesRef, SeedAndOrd>>();
    private FieldInfos fieldInfos;
    List<FieldAndTerm> allTerms;
    private int maxDoc;
    final Random random;
    private FieldInfos currentFieldInfos;

    public RandomPostingsTester(Random random) throws IOException {
        this.random = random;
        int numFields = TestUtil.nextInt(random, 1, 5);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: " + numFields + " fields");
        }
        this.maxDoc = 0;
        FieldInfo[] fieldInfoArray = new FieldInfo[numFields];
        int fieldUpto = 0;
        while (fieldUpto < numFields) {
            String field = TestUtil.randomSimpleString(random);
            if (this.fields.containsKey(field)) continue;
            fieldInfoArray[fieldUpto] = new FieldInfo(field, fieldUpto, false, false, true, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, DocValuesType.NONE, -1L, new HashMap(), 0, 0, 0, false);
            ++fieldUpto;
            TreeMap<BytesRef, SeedAndOrd> postings = new TreeMap<BytesRef, SeedAndOrd>();
            this.fields.put(field, postings);
            HashSet<String> seenTerms = new HashSet<String>();
            int numTerms = random.nextInt(10) == 7 ? LuceneTestCase.atLeast(random, 50) : TestUtil.nextInt(random, 2, 20);
            while (postings.size() < numTerms) {
                int doc;
                int termUpto = postings.size();
                String term = TestUtil.randomSimpleString(random);
                if (seenTerms.contains(term)) continue;
                seenTerms.add(term);
                term = LuceneTestCase.TEST_NIGHTLY && termUpto == 0 && fieldUpto == 1 ? "big_" + term : (termUpto == 1 && fieldUpto == 1 ? "medium_" + term : (random.nextBoolean() ? "low_" + term : "verylow_" + term));
                long termSeed = random.nextLong();
                postings.put(new BytesRef((CharSequence)term), new SeedAndOrd(termSeed));
                SeedPostings postingsEnum = RandomPostingsTester.getSeedPostings(term, termSeed, IndexOptions.DOCS, true);
                int lastDoc = 0;
                while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    lastDoc = doc;
                }
                this.maxDoc = Math.max(lastDoc, this.maxDoc);
            }
            long ord = 0L;
            for (SeedAndOrd ent : postings.values()) {
                ++ord;
                ent.ord = ent.ord;
            }
        }
        this.fieldInfos = new FieldInfos(fieldInfoArray);
        ++this.maxDoc;
        this.allTerms = new ArrayList<FieldAndTerm>();
        for (Map.Entry<String, SortedMap<BytesRef, SeedAndOrd>> fieldEnt : this.fields.entrySet()) {
            String field = fieldEnt.getKey();
            long ord = 0L;
            for (Map.Entry<BytesRef, SeedAndOrd> termEnt : fieldEnt.getValue().entrySet()) {
                this.allTerms.add(new FieldAndTerm(field, termEnt.getKey(), ord++));
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: done init postings; " + this.allTerms.size() + " total terms, across " + this.fieldInfos.size() + " fields");
        }
    }

    public static SeedPostings getSeedPostings(String term, long seed, IndexOptions options, boolean allowPayloads) {
        int maxDocFreq;
        int minDocFreq;
        if (term.startsWith("big_")) {
            minDocFreq = LuceneTestCase.RANDOM_MULTIPLIER * 50000;
            maxDocFreq = LuceneTestCase.RANDOM_MULTIPLIER * 70000;
        } else if (term.startsWith("medium_")) {
            minDocFreq = LuceneTestCase.RANDOM_MULTIPLIER * 3000;
            maxDocFreq = LuceneTestCase.RANDOM_MULTIPLIER * 6000;
        } else if (term.startsWith("low_")) {
            minDocFreq = LuceneTestCase.RANDOM_MULTIPLIER;
            maxDocFreq = LuceneTestCase.RANDOM_MULTIPLIER * 40;
        } else {
            minDocFreq = 1;
            maxDocFreq = 3;
        }
        return new SeedPostings(seed, minDocFreq, maxDocFreq, options, allowPayloads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer buildIndex(Codec codec, Directory dir, IndexOptions maxAllowed, boolean allowPayloads, boolean alwaysTestMax) throws IOException {
        FieldInfos newFieldInfos;
        SegmentInfo segmentInfo;
        block9: {
            FieldsConsumer consumer;
            block8: {
                segmentInfo = new SegmentInfo(dir, Version.LATEST, Version.LATEST, "_0", this.maxDoc, false, codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap(), null);
                int maxIndexOption = Arrays.asList(IndexOptions.values()).indexOf(maxAllowed);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("\nTEST: now build index");
                }
                FieldInfo[] newFieldInfoArray = new FieldInfo[this.fields.size()];
                for (int fieldUpto = 0; fieldUpto < this.fields.size(); ++fieldUpto) {
                    FieldInfo oldFieldInfo = this.fieldInfos.fieldInfo(fieldUpto);
                    IndexOptions indexOptions = IndexOptions.values()[alwaysTestMax ? maxIndexOption : TestUtil.nextInt(this.random, 1, maxIndexOption)];
                    boolean doPayloads = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && allowPayloads;
                    newFieldInfoArray[fieldUpto] = new FieldInfo(oldFieldInfo.name, fieldUpto, false, false, doPayloads, indexOptions, DocValuesType.NONE, -1L, new HashMap(), 0, 0, 0, false);
                }
                newFieldInfos = new FieldInfos(newFieldInfoArray);
                long bytes = this.totalPostings * 8L + this.totalPayloadBytes;
                SegmentWriteState writeState = new SegmentWriteState(null, dir, segmentInfo, newFieldInfos, null, new IOContext(new FlushInfo(this.maxDoc, bytes)));
                SeedFields seedFields = new SeedFields(this.fields, newFieldInfos, maxAllowed, allowPayloads);
                NormsProducer fakeNorms = new NormsProducer(){

                    public void close() throws IOException {
                    }

                    public long ramBytesUsed() {
                        return 0L;
                    }

                    public NumericDocValues getNorms(FieldInfo field) throws IOException {
                        if (newFieldInfos.fieldInfo(field.number).hasNorms()) {
                            return new NumericDocValues(){
                                int doc = -1;

                                public int nextDoc() throws IOException {
                                    if (++this.doc == segmentInfo.maxDoc()) {
                                        this.doc = Integer.MAX_VALUE;
                                        return Integer.MAX_VALUE;
                                    }
                                    return this.doc;
                                }

                                public int docID() {
                                    return this.doc;
                                }

                                public long cost() {
                                    return segmentInfo.maxDoc();
                                }

                                public int advance(int target) throws IOException {
                                    this.doc = target >= segmentInfo.maxDoc() ? Integer.MAX_VALUE : target;
                                    return this.doc;
                                }

                                public boolean advanceExact(int target) throws IOException {
                                    this.doc = target;
                                    return true;
                                }

                                public long longValue() throws IOException {
                                    return DOC_TO_NORM.applyAsLong(this.doc);
                                }
                            };
                        }
                        return null;
                    }

                    public void checkIntegrity() throws IOException {
                    }
                };
                consumer = codec.postingsFormat().fieldsConsumer(writeState);
                boolean success = false;
                try {
                    consumer.write((Fields)seedFields, fakeNorms);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{consumer});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{consumer});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{consumer});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{consumer});
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: after indexing: files=");
            for (String file : dir.listAll()) {
                System.out.println("  " + file + ": " + dir.fileLength(file) + " bytes");
            }
        }
        this.currentFieldInfos = newFieldInfos;
        SegmentReadState readState = new SegmentReadState(dir, segmentInfo, newFieldInfos, false, IOContext.READ, Collections.emptyMap());
        return codec.postingsFormat().fieldsProducer(readState);
    }

    private void verifyEnum(Random random, ThreadState threadState, String field, BytesRef term, TermsEnum termsEnum, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, EnumSet<Option> options, boolean alwaysTestMax) throws IOException {
        double offsetCheckChance;
        int stopAt;
        PostingsEnum postingsEnum;
        int flags;
        if (LuceneTestCase.VERBOSE) {
            System.out.println("  verifyEnum: options=" + options + " maxTestOptions=" + maxTestOptions);
        }
        Assert.assertEquals((Object)term, (Object)termsEnum.term());
        FieldInfo fieldInfo = this.currentFieldInfos.fieldInfo(field);
        SeedPostings expected = RandomPostingsTester.getSeedPostings(term.utf8ToString(), ((SeedAndOrd)this.fields.get((Object)field).get((Object)term)).seed, maxIndexOptions, true);
        Assert.assertEquals((long)expected.docFreq, (long)termsEnum.docFreq());
        boolean allowFreqs = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean doCheckFreqs = allowFreqs && (alwaysTestMax || random.nextInt(3) <= 2);
        boolean allowPositions = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean doCheckPositions = allowPositions && (alwaysTestMax || random.nextInt(3) <= 2);
        boolean allowOffsets = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean doCheckOffsets = allowOffsets && (alwaysTestMax || random.nextInt(3) <= 2);
        boolean doCheckPayloads = options.contains((Object)Option.PAYLOADS) && allowPositions && fieldInfo.hasPayloads() && (alwaysTestMax || random.nextInt(3) <= 2);
        PostingsEnum prevPostingsEnum = null;
        if (!doCheckPositions) {
            if (allowPositions && random.nextInt(10) == 7) {
                if (options.contains((Object)Option.REUSE_ENUMS) && random.nextInt(10) < 9) {
                    prevPostingsEnum = threadState.reusePostingsEnum;
                }
                flags = 24;
                if (alwaysTestMax || random.nextBoolean()) {
                    flags |= 0x38;
                }
                if (alwaysTestMax || random.nextBoolean()) {
                    flags |= 0x58;
                }
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  get DocsEnum (but we won't check positions) flags=" + flags);
                }
                postingsEnum = threadState.reusePostingsEnum = termsEnum.postings(prevPostingsEnum, flags);
            } else {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  get DocsEnum");
                }
                if (options.contains((Object)Option.REUSE_ENUMS) && random.nextInt(10) < 9) {
                    prevPostingsEnum = threadState.reusePostingsEnum;
                }
                postingsEnum = threadState.reusePostingsEnum = termsEnum.postings(prevPostingsEnum, doCheckFreqs ? 8 : 0);
            }
        } else {
            if (options.contains((Object)Option.REUSE_ENUMS) && random.nextInt(10) < 9) {
                prevPostingsEnum = threadState.reusePostingsEnum;
            }
            flags = 24;
            if (alwaysTestMax || doCheckOffsets || random.nextInt(3) == 1) {
                flags |= 0x38;
            }
            if (alwaysTestMax || doCheckPayloads || random.nextInt(3) == 1) {
                flags |= 0x58;
            }
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  get DocsEnum flags=" + flags);
            }
            postingsEnum = threadState.reusePostingsEnum = termsEnum.postings(prevPostingsEnum, flags);
        }
        Assert.assertNotNull((String)"null DocsEnum", (Object)postingsEnum);
        int initialDocID = postingsEnum.docID();
        Assert.assertEquals((String)("inital docID should be -1" + postingsEnum), (long)-1L, (long)initialDocID);
        if (LuceneTestCase.VERBOSE) {
            if (prevPostingsEnum == null) {
                System.out.println("  got enum=" + postingsEnum);
            } else if (prevPostingsEnum == postingsEnum) {
                System.out.println("  got reuse enum=" + postingsEnum);
            } else {
                System.out.println("  got enum=" + postingsEnum + " (reuse of " + prevPostingsEnum + " failed)");
            }
        }
        if (!alwaysTestMax && options.contains((Object)Option.PARTIAL_DOC_CONSUME) && expected.docFreq > 1 && random.nextInt(10) == 7) {
            stopAt = random.nextInt(expected.docFreq - 1);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  will not consume all docs (" + stopAt + " vs " + expected.docFreq + ")");
            }
        } else {
            stopAt = expected.docFreq;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  consume all docs");
            }
        }
        double skipChance = alwaysTestMax ? 0.5 : random.nextDouble();
        int numSkips = expected.docFreq < 3 ? 1 : TestUtil.nextInt(random, 1, Math.min(20, expected.docFreq / 3));
        int skipInc = expected.docFreq / numSkips;
        int skipDocInc = this.maxDoc / numSkips;
        boolean doAllSkipping = options.contains((Object)Option.SKIPPING) && random.nextInt(7) == 1;
        double freqAskChance = alwaysTestMax ? 1.0 : random.nextDouble();
        double payloadCheckChance = alwaysTestMax ? 1.0 : random.nextDouble();
        double d = offsetCheckChance = alwaysTestMax ? 1.0 : random.nextDouble();
        if (LuceneTestCase.VERBOSE) {
            if (options.contains((Object)Option.SKIPPING)) {
                System.out.println("  skipChance=" + skipChance + " numSkips=" + numSkips);
            } else {
                System.out.println("  no skipping");
            }
            if (doCheckFreqs) {
                System.out.println("  freqAskChance=" + freqAskChance);
            }
            if (doCheckPayloads) {
                System.out.println("  payloadCheckChance=" + payloadCheckChance);
            }
            if (doCheckOffsets) {
                System.out.println("  offsetCheckChance=" + offsetCheckChance);
            }
        }
        while (expected.upto <= stopAt) {
            int freq;
            if (expected.upto == stopAt) {
                if (stopAt != expected.docFreq) break;
                Assert.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.nextDoc());
                Assert.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.docID());
                break;
            }
            if (options.contains((Object)Option.SKIPPING) && (doAllSkipping || random.nextDouble() <= skipChance)) {
                int targetDocID = -1;
                if (expected.upto < stopAt && random.nextBoolean()) {
                    int skipCount = TestUtil.nextInt(random, 1, skipInc);
                    for (int skip = 0; skip < skipCount && expected.nextDoc() != Integer.MAX_VALUE; ++skip) {
                    }
                } else {
                    int skipDocIDs = TestUtil.nextInt(random, 1, skipDocInc);
                    if (skipDocIDs > 0) {
                        targetDocID = expected.docID() + skipDocIDs;
                        expected.advance(targetDocID);
                    }
                }
                if (expected.upto >= stopAt) {
                    int target;
                    int n = target = random.nextBoolean() ? this.maxDoc : Integer.MAX_VALUE;
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  now advance to end (target=" + target + ")");
                    }
                    Assert.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.advance(target));
                    break;
                }
                if (LuceneTestCase.VERBOSE) {
                    if (targetDocID != -1) {
                        System.out.println("  now advance to random target=" + targetDocID + " (" + expected.upto + " of " + stopAt + ") current=" + postingsEnum.docID());
                    } else {
                        System.out.println("  now advance to known-exists target=" + expected.docID() + " (" + expected.upto + " of " + stopAt + ") current=" + postingsEnum.docID());
                    }
                }
                int docID = postingsEnum.advance(targetDocID != -1 ? targetDocID : expected.docID());
                Assert.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
            } else {
                expected.nextDoc();
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  now nextDoc to " + expected.docID() + " (" + expected.upto + " of " + stopAt + ")");
                }
                int docID = postingsEnum.nextDoc();
                Assert.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
                if (docID == Integer.MAX_VALUE) break;
            }
            if (doCheckFreqs && random.nextDouble() <= freqAskChance) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("    now freq()=" + expected.freq());
                }
                freq = postingsEnum.freq();
                Assert.assertEquals((String)"freq is wrong", (long)expected.freq(), (long)freq);
            }
            if (!doCheckPositions) continue;
            freq = postingsEnum.freq();
            int numPosToConsume = !alwaysTestMax && options.contains((Object)Option.PARTIAL_POS_CONSUME) && random.nextInt(5) == 1 ? random.nextInt(freq) : freq;
            for (int i2 = 0; i2 < numPosToConsume; ++i2) {
                int pos = expected.nextPosition();
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("    now nextPosition to " + pos);
                }
                Assert.assertEquals((String)"position is wrong", (long)pos, (long)postingsEnum.nextPosition());
                if (doCheckPayloads) {
                    BytesRef expectedPayload = expected.getPayload();
                    if (random.nextDouble() <= payloadCheckChance) {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("      now check expectedPayload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                        }
                        if (expectedPayload == null || expectedPayload.length == 0) {
                            Assert.assertNull((String)"should not have payload", (Object)postingsEnum.getPayload());
                        } else {
                            BytesRef payload = postingsEnum.getPayload();
                            Assert.assertNotNull((String)"should have payload but doesn't", (Object)payload);
                            Assert.assertEquals((String)"payload length is wrong", (long)expectedPayload.length, (long)payload.length);
                            for (int byteUpto = 0; byteUpto < expectedPayload.length; ++byteUpto) {
                                Assert.assertEquals((String)"payload bytes are wrong", (long)expectedPayload.bytes[expectedPayload.offset + byteUpto], (long)payload.bytes[payload.offset + byteUpto]);
                            }
                            payload = BytesRef.deepCopyOf((BytesRef)payload);
                            Assert.assertEquals((String)"2nd call to getPayload returns something different!", (Object)payload, (Object)postingsEnum.getPayload());
                        }
                    } else if (LuceneTestCase.VERBOSE) {
                        System.out.println("      skip check payload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                    }
                }
                if (doCheckOffsets) {
                    if (random.nextDouble() <= offsetCheckChance) {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("      now check offsets: startOff=" + expected.startOffset() + " endOffset=" + expected.endOffset());
                        }
                        Assert.assertEquals((String)"startOffset is wrong", (long)expected.startOffset(), (long)postingsEnum.startOffset());
                        Assert.assertEquals((String)"endOffset is wrong", (long)expected.endOffset(), (long)postingsEnum.endOffset());
                        continue;
                    }
                    if (!LuceneTestCase.VERBOSE) continue;
                    System.out.println("      skip check offsets");
                    continue;
                }
                if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) continue;
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("      now check offsets are -1");
                }
                Assert.assertEquals((String)"startOffset isn't -1", (long)-1L, (long)postingsEnum.startOffset());
                Assert.assertEquals((String)"endOffset isn't -1", (long)-1L, (long)postingsEnum.endOffset());
            }
        }
        if (options.contains((Object)Option.SKIPPING)) {
            IntToLongFunction docToNorm = fieldInfo.hasNorms() ? DOC_TO_NORM : doc -> 1L;
            int max = -1;
            List<Object> impactsCopy = null;
            int flags2 = 8;
            if (doCheckPositions) {
                flags2 |= 0x18;
                if (doCheckOffsets) {
                    flags2 |= 0x38;
                }
                if (doCheckPayloads) {
                    flags2 |= 0x58;
                }
            }
            ImpactsEnum impactsEnum = termsEnum.impacts(flags2);
            PostingsEnum postings = termsEnum.postings(null, flags2);
            int doc2 = impactsEnum.nextDoc();
            while (true) {
                long norm;
                int idx;
                Assert.assertEquals((long)postings.nextDoc(), (long)doc2);
                if (doc2 == Integer.MAX_VALUE) break;
                int freq = postings.freq();
                Assert.assertEquals((String)"freq is wrong", (long)freq, (long)impactsEnum.freq());
                for (int i3 = 0; i3 < freq; ++i3) {
                    int pos = postings.nextPosition();
                    Assert.assertEquals((String)"position is wrong", (long)pos, (long)impactsEnum.nextPosition());
                    if (doCheckOffsets) {
                        Assert.assertEquals((String)"startOffset is wrong", (long)postings.startOffset(), (long)impactsEnum.startOffset());
                        Assert.assertEquals((String)"endOffset is wrong", (long)postings.endOffset(), (long)impactsEnum.endOffset());
                    }
                    if (!doCheckPayloads) continue;
                    Assert.assertEquals((String)"payload is wrong", (Object)postings.getPayload(), (Object)impactsEnum.getPayload());
                }
                if (doc2 > max) {
                    impactsEnum.advanceShallow(doc2);
                    Impacts impacts = impactsEnum.getImpacts();
                    CheckIndex.checkImpacts((Impacts)impacts, (int)doc2);
                    impactsCopy = impacts.getImpacts(0).stream().map(i -> new Impact(i.freq, i.norm)).collect(Collectors.toList());
                }
                if ((idx = Collections.binarySearch(impactsCopy, new Impact(freq = impactsEnum.freq(), norm = docToNorm.applyAsLong(doc2)), Comparator.comparing(i -> i.freq))) < 0) {
                    idx = -1 - idx;
                }
                Assert.assertTrue((String)("Got " + new Impact(freq, norm) + " in postings, but no impact triggers equal or better scores in " + impactsCopy), (idx <= impactsCopy.size() && ((Impact)impactsCopy.get((int)idx)).norm <= norm ? 1 : 0) != 0);
                doc2 = impactsEnum.nextDoc();
            }
            impactsEnum = termsEnum.impacts(flags2);
            postings = termsEnum.postings(postings, flags2);
            max = -1;
            while (true) {
                long norm;
                int idx;
                int delta;
                int target;
                boolean advance;
                doc2 = impactsEnum.docID();
                if (random.nextBoolean()) {
                    advance = false;
                    target = doc2 + 1;
                } else {
                    advance = true;
                    delta = Math.min(1 + random.nextInt(512), Integer.MAX_VALUE - doc2);
                    target = impactsEnum.docID() + delta;
                }
                if (target > max && random.nextBoolean()) {
                    delta = Math.min(random.nextInt(512), Integer.MAX_VALUE - target);
                    max = target + delta;
                    impactsEnum.advanceShallow(target);
                    Impacts impacts = impactsEnum.getImpacts();
                    CheckIndex.checkImpacts((Impacts)impacts, (int)target);
                    impactsCopy = Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                    for (int level = 0; level < impacts.numLevels(); ++level) {
                        if (impacts.getDocIdUpTo(level) < max) continue;
                        impactsCopy = impacts.getImpacts(level).stream().map(i -> new Impact(i.freq, i.norm)).collect(Collectors.toList());
                        break;
                    }
                }
                doc2 = advance ? impactsEnum.advance(target) : impactsEnum.nextDoc();
                Assert.assertEquals((long)postings.advance(target), (long)doc2);
                if (doc2 == Integer.MAX_VALUE) break;
                int freq = postings.freq();
                Assert.assertEquals((String)"freq is wrong", (long)freq, (long)impactsEnum.freq());
                for (int i4 = 0; i4 < postings.freq(); ++i4) {
                    int pos = postings.nextPosition();
                    Assert.assertEquals((String)"position is wrong", (long)pos, (long)impactsEnum.nextPosition());
                    if (doCheckOffsets) {
                        Assert.assertEquals((String)"startOffset is wrong", (long)postings.startOffset(), (long)impactsEnum.startOffset());
                        Assert.assertEquals((String)"endOffset is wrong", (long)postings.endOffset(), (long)impactsEnum.endOffset());
                    }
                    if (!doCheckPayloads) continue;
                    Assert.assertEquals((String)"payload is wrong", (Object)postings.getPayload(), (Object)impactsEnum.getPayload());
                }
                if (doc2 > max) {
                    int delta2 = Math.min(1 + random.nextInt(512), Integer.MAX_VALUE - doc2);
                    max = doc2 + delta2;
                    Impacts impacts = impactsEnum.getImpacts();
                    CheckIndex.checkImpacts((Impacts)impacts, (int)doc2);
                    impactsCopy = Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                    for (int level = 0; level < impacts.numLevels(); ++level) {
                        if (impacts.getDocIdUpTo(level) < max) continue;
                        impactsCopy = impacts.getImpacts(level).stream().map(i -> new Impact(i.freq, i.norm)).collect(Collectors.toList());
                        break;
                    }
                }
                if ((idx = Collections.binarySearch(impactsCopy, new Impact(freq = impactsEnum.freq(), norm = docToNorm.applyAsLong(doc2)), Comparator.comparing(i -> i.freq))) < 0) {
                    idx = -1 - idx;
                }
                Assert.assertTrue((String)("Got " + new Impact(freq, norm) + " in postings, but no impact triggers equal or better scores in " + impactsCopy), (idx <= impactsCopy.size() && ((Impact)impactsCopy.get((int)idx)).norm <= norm ? 1 : 0) != 0);
            }
        }
    }

    public void testTerms(Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) throws Exception {
        if (options.contains((Object)Option.THREADS)) {
            int threadUpto;
            int numThreads = LuceneTestCase.TEST_NIGHTLY ? TestUtil.nextInt(this.random, 2, 5) : 2;
            Thread[] threads = new Thread[numThreads];
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto] = new TestThread(new Random(this.random.nextLong()), this, fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
                threads[threadUpto].start();
            }
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto].join();
            }
        } else {
            this.testTermsOneThread(this.random, fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
        }
    }

    private void testTermsOneThread(Random random, Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) throws IOException {
        ThreadState threadState = new ThreadState();
        ArrayList<TermState> termStates = new ArrayList<TermState>();
        ArrayList<FieldAndTerm> termStateTerms = new ArrayList<FieldAndTerm>();
        boolean supportsOrds = true;
        Collections.shuffle(this.allTerms, random);
        int upto = 0;
        while (upto < this.allTerms.size()) {
            long termOrd;
            FieldAndTerm fieldAndTerm;
            boolean useTermState = termStates.size() != 0 && random.nextInt(5) == 1;
            boolean useTermOrd = supportsOrds && !useTermState && random.nextInt(5) == 1;
            TermState termState = null;
            if (!useTermState) {
                fieldAndTerm = this.allTerms.get(upto++);
                if (LuceneTestCase.VERBOSE) {
                    if (useTermOrd) {
                        System.out.println("\nTEST: seek to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString() + " using ord=" + fieldAndTerm.ord);
                    } else {
                        System.out.println("\nTEST: seek to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                    }
                }
            } else {
                int idx = random.nextInt(termStates.size());
                fieldAndTerm = (FieldAndTerm)termStateTerms.get(idx);
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("\nTEST: seek using TermState to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                }
                termState = (TermState)termStates.get(idx);
            }
            Terms terms = fieldsSource.terms(fieldAndTerm.field);
            Assert.assertNotNull((Object)terms);
            TermsEnum termsEnum = terms.iterator();
            if (!useTermState) {
                if (useTermOrd) {
                    try {
                        termsEnum.seekExact(fieldAndTerm.ord);
                    }
                    catch (UnsupportedOperationException uoe) {
                        supportsOrds = false;
                        Assert.assertTrue((boolean)termsEnum.seekExact(fieldAndTerm.term));
                    }
                } else {
                    Assert.assertTrue((boolean)termsEnum.seekExact(fieldAndTerm.term));
                }
            } else {
                termsEnum.seekExact(fieldAndTerm.term, termState);
            }
            Assert.assertEquals((Object)fieldAndTerm.term, (Object)termsEnum.term());
            if (supportsOrds) {
                try {
                    termOrd = termsEnum.ord();
                }
                catch (UnsupportedOperationException uoe) {
                    supportsOrds = false;
                    termOrd = -1L;
                }
            } else {
                termOrd = -1L;
            }
            if (termOrd != -1L) {
                Assert.assertEquals((long)fieldAndTerm.ord, (long)termsEnum.ord());
            }
            boolean savedTermState = false;
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && random.nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                savedTermState = true;
            }
            this.verifyEnum(random, threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && !savedTermState && random.nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                useTermState = true;
            }
            if (!alwaysTestMax && random.nextInt(10) != 7) continue;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: try enum again on same term");
            }
            this.verifyEnum(random, threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
        }
        for (String field : this.fields.keySet()) {
            BytesRef term;
            BytesRef startTerm;
            CompiledAutomaton ca;
            while (true) {
                Automaton a = AutomatonTestUtil.randomAutomaton(random);
                ca = new CompiledAutomaton(a, null, true, Integer.MAX_VALUE, false);
                if (ca.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) continue;
                startTerm = null;
                if (!random.nextBoolean()) break;
                AutomatonTestUtil.RandomAcceptedStrings ras = new AutomatonTestUtil.RandomAcceptedStrings(a);
                for (int iter = 0; iter < 100; ++iter) {
                    int[] codePoints = ras.getRandomAcceptedString(random);
                    if (codePoints.length == 0) continue;
                    startTerm = new BytesRef((CharSequence)UnicodeUtil.newString((int[])codePoints, (int)0, (int)codePoints.length));
                    break;
                }
                if (startTerm != null) break;
            }
            TermsEnum intersected = fieldsSource.terms(field).intersect(ca, startTerm);
            HashSet<BytesRef> intersectedTerms = new HashSet<BytesRef>();
            while ((term = intersected.next()) != null) {
                if (startTerm != null) {
                    Assert.assertTrue((startTerm.compareTo(term) < 0 ? 1 : 0) != 0);
                }
                intersectedTerms.add(BytesRef.deepCopyOf((BytesRef)term));
                this.verifyEnum(random, threadState, field, term, intersected, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
            }
            if (ca.runAutomaton == null) {
                Assert.assertTrue((boolean)intersectedTerms.isEmpty());
                continue;
            }
            for (BytesRef term2 : this.fields.get(field).keySet()) {
                boolean expected = startTerm != null && startTerm.compareTo(term2) >= 0 ? false : ca.runAutomaton.run(term2.bytes, term2.offset, term2.length);
                Assert.assertEquals((String)("term=" + term2), (Object)expected, (Object)intersectedTerms.contains(term2));
            }
        }
    }

    public void testFields(Fields fields) throws Exception {
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                throw new AssertionError((Object)"Fields.iterator() allows for removal");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        LuceneTestCase.expectThrows(NoSuchElementException.class, () -> iterator.next());
    }

    public void testFull(Codec codec, Path path, IndexOptions options, boolean withPayloads) throws Exception {
        BaseDirectoryWrapper dir = LuceneTestCase.newFSDirectory(path);
        FieldsProducer fieldsProducer = this.buildIndex(codec, (Directory)dir, options, withPayloads, true);
        this.testFields((Fields)fieldsProducer);
        IndexOptions[] allOptions = IndexOptions.values();
        int maxIndexOption = Arrays.asList(allOptions).indexOf(options);
        for (int i = 0; i <= maxIndexOption; ++i) {
            this.testTerms((Fields)fieldsProducer, EnumSet.allOf(Option.class), allOptions[i], options, true);
            if (!withPayloads) continue;
            this.testTerms((Fields)fieldsProducer, EnumSet.complementOf(EnumSet.of(Option.PAYLOADS)), allOptions[i], options, true);
        }
        fieldsProducer.close();
        dir.close();
    }

    private static class TestThread
    extends Thread {
        private Fields fieldsSource;
        private EnumSet<Option> options;
        private IndexOptions maxIndexOptions;
        private IndexOptions maxTestOptions;
        private boolean alwaysTestMax;
        private RandomPostingsTester postingsTester;
        private Random random;

        public TestThread(Random random, RandomPostingsTester postingsTester, Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) {
            this.random = random;
            this.fieldsSource = fieldsSource;
            this.options = options;
            this.maxTestOptions = maxTestOptions;
            this.maxIndexOptions = maxIndexOptions;
            this.alwaysTestMax = alwaysTestMax;
            this.postingsTester = postingsTester;
        }

        @Override
        public void run() {
            try {
                try {
                    this.postingsTester.testTermsOneThread(this.random, this.fieldsSource, this.options, this.maxTestOptions, this.maxIndexOptions, this.alwaysTestMax);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            finally {
                this.fieldsSource = null;
                this.postingsTester = null;
            }
        }
    }

    private static class ThreadState {
        public PostingsEnum reusePostingsEnum;

        private ThreadState() {
        }
    }

    private static class SeedTermsEnum
    extends BaseTermsEnum {
        final SortedMap<BytesRef, SeedAndOrd> terms;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;
        private Iterator<Map.Entry<BytesRef, SeedAndOrd>> iterator;
        private Map.Entry<BytesRef, SeedAndOrd> current;

        public SeedTermsEnum(SortedMap<BytesRef, SeedAndOrd> terms, IndexOptions maxAllowed, boolean allowPayloads) {
            this.terms = terms;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        void reset() {
            this.iterator = this.terms.entrySet().iterator();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) {
            SortedMap<BytesRef, SeedAndOrd> tailMap = this.terms.tailMap(text);
            if (tailMap.isEmpty()) {
                return TermsEnum.SeekStatus.END;
            }
            this.iterator = tailMap.entrySet().iterator();
            this.current = this.iterator.next();
            if (tailMap.firstKey().equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public BytesRef next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return this.term();
            }
            return null;
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public BytesRef term() {
            return this.current.getKey();
        }

        public long ord() {
            return this.current.getValue().ord;
        }

        public int docFreq() {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() {
            throw new UnsupportedOperationException();
        }

        public final PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            if (PostingsEnum.featureRequested((int)flags, (short)24)) {
                if (this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    return null;
                }
                if (PostingsEnum.featureRequested((int)flags, (short)56) && this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) < 0) {
                    return null;
                }
                if (PostingsEnum.featureRequested((int)flags, (short)88) && !this.allowPayloads) {
                    return null;
                }
            }
            if (PostingsEnum.featureRequested((int)flags, (short)8) && this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) < 0) {
                return null;
            }
            return RandomPostingsTester.getSeedPostings(this.current.getKey().utf8ToString(), this.current.getValue().seed, this.maxAllowed, this.allowPayloads);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SeedTerms
    extends Terms {
        final SortedMap<BytesRef, SeedAndOrd> terms;
        final FieldInfo fieldInfo;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;

        public SeedTerms(SortedMap<BytesRef, SeedAndOrd> terms, FieldInfo fieldInfo, IndexOptions maxAllowed, boolean allowPayloads) {
            this.terms = terms;
            this.fieldInfo = fieldInfo;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        public TermsEnum iterator() {
            SeedTermsEnum termsEnum = new SeedTermsEnum(this.terms, this.maxAllowed, this.allowPayloads);
            termsEnum.reset();
            return termsEnum;
        }

        public long size() {
            return this.terms.size();
        }

        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException();
        }

        public long getSumDocFreq() {
            throw new UnsupportedOperationException();
        }

        public int getDocCount() {
            throw new UnsupportedOperationException();
        }

        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.allowPayloads && this.fieldInfo.hasPayloads();
        }
    }

    private static class SeedFields
    extends Fields {
        final Map<String, SortedMap<BytesRef, SeedAndOrd>> fields;
        final FieldInfos fieldInfos;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;

        public SeedFields(Map<String, SortedMap<BytesRef, SeedAndOrd>> fields, FieldInfos fieldInfos, IndexOptions maxAllowed, boolean allowPayloads) {
            this.fields = fields;
            this.fieldInfos = fieldInfos;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        public Iterator<String> iterator() {
            return this.fields.keySet().iterator();
        }

        public Terms terms(String field) {
            SortedMap<BytesRef, SeedAndOrd> terms = this.fields.get(field);
            if (terms == null) {
                return null;
            }
            return new SeedTerms(terms, this.fieldInfos.fieldInfo(field), this.maxAllowed, this.allowPayloads);
        }

        public int size() {
            return this.fields.size();
        }
    }

    private static class SeedAndOrd {
        final long seed;
        long ord;

        public SeedAndOrd(long seed) {
            this.seed = seed;
        }
    }

    public static class FieldAndTerm {
        final String field;
        final BytesRef term;
        final long ord;

        public FieldAndTerm(String field, BytesRef term, long ord) {
            this.field = field;
            this.term = BytesRef.deepCopyOf((BytesRef)term);
            this.ord = ord;
        }
    }

    public static class SeedPostings
    extends PostingsEnum {
        private final Random docRandom;
        private final Random random;
        public int docFreq;
        private final int maxDocSpacing;
        private final int payloadSize;
        private final boolean fixedPayloads;
        private final BytesRef payload;
        private final boolean doPositions;
        private final boolean allowPayloads;
        private int docID = -1;
        private int freq;
        public int upto;
        private int pos;
        private int offset;
        private int startOffset;
        private int endOffset;
        private int posSpacing;
        private int posUpto;

        public SeedPostings(long seed, int minDocFreq, int maxDocFreq, IndexOptions options, boolean allowPayloads) {
            this.random = new Random(seed);
            this.docRandom = new Random(this.random.nextLong());
            this.docFreq = TestUtil.nextInt(this.random, minDocFreq, maxDocFreq);
            this.allowPayloads = allowPayloads;
            this.maxDocSpacing = TestUtil.nextInt(this.random, 1, 100);
            this.payloadSize = this.random.nextInt(10) == 7 ? 1 + this.random.nextInt(3) : 1 + this.random.nextInt(1);
            this.fixedPayloads = this.random.nextBoolean();
            byte[] payloadBytes = new byte[this.payloadSize];
            this.payload = new BytesRef(payloadBytes);
            this.doPositions = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS.compareTo((Enum)options) <= 0;
        }

        public int nextDoc() {
            this._nextDoc();
            return this.docID;
        }

        private int _nextDoc() {
            if (this.docID == -1) {
                this.docID = 0;
            }
            while (this.posUpto < this.freq) {
                this.nextPosition();
            }
            if (this.upto < this.docFreq) {
                if (this.upto != 0 || !this.docRandom.nextBoolean()) {
                    this.docID = this.maxDocSpacing == 1 ? ++this.docID : (this.docID += TestUtil.nextInt(this.docRandom, 1, this.maxDocSpacing));
                }
                this.freq = this.random.nextInt(200) == 17 ? TestUtil.nextInt(this.random, 1, 1000) : (this.random.nextInt(10) == 17 ? TestUtil.nextInt(this.random, 1, 20) : TestUtil.nextInt(this.random, 1, 4));
                this.pos = 0;
                this.offset = 0;
                this.posUpto = 0;
                this.posSpacing = TestUtil.nextInt(this.random, 1, 100);
                ++this.upto;
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() {
            if (!this.doPositions) {
                this.posUpto = this.freq;
                return -1;
            }
            assert (this.posUpto < this.freq);
            if (this.posUpto != 0 || !this.random.nextBoolean()) {
                this.pos = this.posSpacing == 1 ? ++this.pos : (this.pos += TestUtil.nextInt(this.random, 1, this.posSpacing));
            }
            if (this.payloadSize != 0) {
                if (this.fixedPayloads) {
                    this.payload.length = this.payloadSize;
                    this.random.nextBytes(this.payload.bytes);
                } else {
                    int thisPayloadSize = this.random.nextInt(this.payloadSize);
                    if (thisPayloadSize != 0) {
                        this.payload.length = this.payloadSize;
                        this.random.nextBytes(this.payload.bytes);
                    } else {
                        this.payload.length = 0;
                    }
                }
            } else {
                this.payload.length = 0;
            }
            if (!this.allowPayloads) {
                this.payload.length = 0;
            }
            this.startOffset = this.offset + this.random.nextInt(5);
            this.offset = this.endOffset = this.startOffset + this.random.nextInt(10);
            ++this.posUpto;
            return this.pos;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public BytesRef getPayload() {
            return this.payload.length == 0 ? null : this.payload;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.docFreq;
        }
    }

    public static enum Option {
        SKIPPING,
        REUSE_ENUMS,
        LIVE_DOCS,
        TERM_STATE,
        PARTIAL_DOC_CONSUME,
        PARTIAL_POS_CONSUME,
        PAYLOADS,
        THREADS;

    }
}

