/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathParser;

public final class XMPPathFactory {
    private XMPPathFactory() {
    }

    public static String composeArrayItemPath(String string, int n) throws XMPException {
        if (n > 0) {
            return string + '[' + n + ']';
        }
        if (n == -1) {
            return string + "[last()]";
        }
        throw new XMPException("Array index must be larger than zero", 104);
    }

    public static String composeStructFieldPath(String string, String string2) throws XMPException {
        XMPPathFactory.assertFieldNS(string);
        XMPPathFactory.assertFieldName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        if (xMPPath.size() != 2) {
            throw new XMPException("The field name must be simple", 102);
        }
        return '/' + xMPPath.getSegment(1).getName();
    }

    public static String composeQualifierPath(String string, String string2) throws XMPException {
        XMPPathFactory.assertQualNS(string);
        XMPPathFactory.assertQualName(string2);
        XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
        if (xMPPath.size() != 2) {
            throw new XMPException("The qualifier name must be simple", 102);
        }
        return "/?" + xMPPath.getSegment(1).getName();
    }

    public static String composeLangSelector(String string, String string2) {
        return string + "[?xml:lang=\"" + Utils.normalizeLangValue(string2) + "\"]";
    }

    public static String composeFieldSelector(String string, String string2, String string3, String string4) throws XMPException {
        XMPPath xMPPath = XMPPathParser.expandXPath(string2, string3);
        if (xMPPath.size() != 2) {
            throw new XMPException("The fieldName name must be simple", 102);
        }
        return string + '[' + xMPPath.getSegment(1).getName() + "=\"" + string4 + "\"]";
    }

    private static void assertQualNS(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty qualifier namespace URI", 101);
        }
    }

    private static void assertQualName(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty qualifier name", 102);
        }
    }

    private static void assertFieldNS(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty field namespace URI", 101);
        }
    }

    private static void assertFieldName(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty f name", 102);
        }
    }
}

