/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.util.Arrays;
import java.util.HashMap;
import org.carrot2.shaded.guava.common.base.Function;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.resource.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ResourceCache<V> {
    private static Logger logger = LoggerFactory.getLogger(ResourceCache.class);
    private final HashMap<ResourceLookup, V> cache = Maps.newHashMap();
    private final Function<ResourceLookup, V> valueMaker;

    public ResourceCache(Function<ResourceLookup, V> valueMaker) {
        this.valueMaker = valueMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(ResourceLookup resourceLookup, boolean recreate) {
        HashMap<ResourceLookup, V> hashMap = this.cache;
        synchronized (hashMap) {
            if (recreate || !this.cache.containsKey(resourceLookup)) {
                logger.debug("{} resources, locations: {}", new Object[]{recreate ? "Reloading" : "Loading", Arrays.toString(resourceLookup.getLocators())});
                this.cache.put(resourceLookup, this.valueMaker.apply((Object)resourceLookup));
            }
            return this.cache.get(resourceLookup);
        }
    }
}

