/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.core.SolrCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatStream
extends TupleStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String commaDelimitedFilepaths;
    private final int maxLines;
    private StreamContext context;
    private String chroot;
    private Iterator<CrawlFile> allFilesToCrawl;
    private int linesReturned = 0;
    private CrawlFile currentFilePath;
    private LineIterator currentFileLines;

    public CatStream(StreamExpression expression, StreamFactory factory) throws IOException {
        this(factory.getValueOperand(expression, 0), factory.getIntOperand(expression, "maxLines", Integer.valueOf(-1)));
    }

    public CatStream(String commaDelimitedFilepaths, int maxLines) {
        if (commaDelimitedFilepaths == null) {
            throw new IllegalArgumentException("No filepaths provided to stream");
        }
        String filepathsWithoutSurroundingQuotes = this.stripSurroundingQuotesIfTheyExist(commaDelimitedFilepaths);
        if (StringUtils.isEmpty((String)filepathsWithoutSurroundingQuotes)) {
            throw new IllegalArgumentException("No filepaths provided to stream");
        }
        this.commaDelimitedFilepaths = filepathsWithoutSurroundingQuotes;
        this.maxLines = maxLines;
    }

    private String stripSurroundingQuotesIfTheyExist(String value) {
        if (value.length() < 2) {
            return value;
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public void setStreamContext(StreamContext context) {
        this.context = context;
        Object solrCoreObj = context.get((Object)"solr-core");
        if (solrCoreObj == null || !(solrCoreObj instanceof SolrCore)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "StreamContext must have SolrCore in solr-core key");
        }
        SolrCore core = (SolrCore)context.get((Object)"solr-core");
        this.chroot = Paths.get(core.getCoreContainer().getSolrHome(), "userfiles").toString();
        if (!new File(this.chroot).exists()) {
            throw new IllegalStateException("userfiles directory used to load files must exist but could not be found!");
        }
    }

    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    public void open() throws IOException {
        List<CrawlFile> initialCrawlSeeds = this.validateAndSetFilepathsInSandbox();
        ArrayList<CrawlFile> filesToCrawl = new ArrayList<CrawlFile>();
        for (CrawlFile crawlSeed : initialCrawlSeeds) {
            this.findReadableFiles(crawlSeed, filesToCrawl);
        }
        log.debug("Found files [{}] to stream from roots: [{}]", filesToCrawl, initialCrawlSeeds);
        this.allFilesToCrawl = filesToCrawl.iterator();
    }

    public void close() throws IOException {
    }

    public Tuple read() throws IOException {
        if (this.maxLines >= 0 && this.linesReturned >= this.maxLines) {
            this.closeCurrentFileIfSet();
            return this.createEofTuple();
        }
        if (this.currentFileHasMoreLinesToRead()) {
            return this.fetchNextLineFromCurrentFile();
        }
        if (this.advanceToNextFileWithData()) {
            return this.fetchNextLineFromCurrentFile();
        }
        this.closeCurrentFileIfSet();
        return this.createEofTuple();
    }

    public StreamComparator getStreamSort() {
        return null;
    }

    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(((Object)((Object)this)).getClass()));
        expression.addParameter("\"" + this.commaDelimitedFilepaths + "\"");
        return expression;
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName(factory.getFunctionName(((Object)((Object)this)).getClass())).withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-source").withExpression(this.toExpression(factory).toString());
    }

    private List<CrawlFile> validateAndSetFilepathsInSandbox() {
        String[] relativePathRoots = this.commaDelimitedFilepaths.split(",");
        ArrayList<CrawlFile> crawlSeeds = new ArrayList<CrawlFile>();
        for (String crawlRoot : relativePathRoots) {
            File crawlRootFile = new File(crawlRoot);
            if (crawlRootFile.isAbsolute()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "file/directory to stream must be provided as an absolute path: " + crawlRoot);
            }
            if (crawlRoot.contains("..")) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "relative file/directory paths cannot contain '..': " + crawlRoot);
            }
            String rootAbsolutePath = this.getAbsolutePath(crawlRoot);
            if (!new File(this.getAbsolutePath(crawlRoot)).exists()) {
                log.warn("Unable to find abs path: {}", (Object)this.getAbsolutePath(crawlRoot));
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "file/directory to stream doesn't exist: " + crawlRoot);
            }
            crawlSeeds.add(new CrawlFile(crawlRoot, rootAbsolutePath));
        }
        return crawlSeeds;
    }

    private boolean advanceToNextFileWithData() throws IOException {
        while (this.allFilesToCrawl.hasNext()) {
            this.closeCurrentFileIfSet();
            this.currentFilePath = this.allFilesToCrawl.next();
            this.currentFileLines = FileUtils.lineIterator((File)new File(this.currentFilePath.absolutePath), (String)"UTF-8");
            if (!this.currentFileLines.hasNext()) continue;
            return true;
        }
        return false;
    }

    private Tuple fetchNextLineFromCurrentFile() {
        ++this.linesReturned;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("file", this.currentFilePath.displayPath);
        m.put("line", this.currentFileLines.next());
        return new Tuple(m);
    }

    private Tuple createEofTuple() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("EOF", true);
        return new Tuple(m);
    }

    private boolean currentFileHasMoreLinesToRead() {
        return this.currentFileLines != null && this.currentFileLines.hasNext();
    }

    private String getAbsolutePath(String pathRelativeToChroot) {
        return Paths.get(this.chroot, pathRelativeToChroot).toString();
    }

    private void closeCurrentFileIfSet() {
        if (this.currentFilePath != null) {
            this.currentFileLines.close();
            this.currentFilePath = null;
            this.currentFileLines = null;
        }
    }

    private void findReadableFiles(CrawlFile seed, List<CrawlFile> foundFiles) {
        File entry = new File(seed.absolutePath);
        if (!entry.exists() || !entry.canRead() || Files.isSymbolicLink(entry.toPath())) {
            return;
        }
        if (entry.isFile()) {
            foundFiles.add(seed);
        } else if (entry.isDirectory()) {
            Object[] directoryContents = entry.list();
            Arrays.sort(directoryContents);
            if (directoryContents != null) {
                for (Object item : directoryContents) {
                    String itemDisplayPath = Paths.get(seed.displayPath, new String[]{item}).toString();
                    String itemAbsolutePath = Paths.get(seed.absolutePath, new String[]{item}).toString();
                    this.findReadableFiles(new CrawlFile(itemDisplayPath, itemAbsolutePath), foundFiles);
                }
            }
        }
    }

    public class CrawlFile {
        private final String displayPath;
        private final String absolutePath;

        public CrawlFile(String displayPath, String absolutePath) {
            this.displayPath = displayPath;
            this.absolutePath = absolutePath;
        }
    }
}

