/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;

public class NumberUtils {
    public static String readableSize(long size) {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ROOT);
        formatter.setMaximumFractionDigits(2);
        if (size / 0x40000000L > 0L) {
            return formatter.format((double)size * 1.0 / 1.073741824E9) + " GB";
        }
        if (size / 0x100000L > 0L) {
            return formatter.format((double)size * 1.0 / 1048576.0) + " MB";
        }
        if (size / 1024L > 0L) {
            return formatter.format((double)size * 1.0 / 1024.0) + " KB";
        }
        return String.valueOf(size) + " bytes";
    }

    public static String int2sortableStr(int val) {
        char[] arr = new char[3];
        NumberUtils.int2sortableStr(val, arr, 0);
        return new String(arr, 0, 3);
    }

    public static String int2sortableStr(String val) {
        return NumberUtils.int2sortableStr(Integer.parseInt(val));
    }

    public static String SortableStr2int(String val) {
        int ival = NumberUtils.SortableStr2int(val, 0, 3);
        return Integer.toString(ival);
    }

    public static String SortableStr2int(BytesRef val) {
        return NumberUtils.SortableStr2int(val.utf8ToString());
    }

    public static String long2sortableStr(long val) {
        char[] arr = new char[5];
        NumberUtils.long2sortableStr(val, arr, 0);
        return new String(arr, 0, 5);
    }

    public static String long2sortableStr(String val) {
        return NumberUtils.long2sortableStr(Long.parseLong(val));
    }

    public static String SortableStr2long(String val) {
        long ival = NumberUtils.SortableStr2long(val, 0, 5);
        return Long.toString(ival);
    }

    public static String SortableStr2long(BytesRef val) {
        return NumberUtils.SortableStr2long(val.utf8ToString());
    }

    public static String float2sortableStr(float val) {
        int f = Float.floatToRawIntBits(val);
        if (f < 0) {
            f ^= Integer.MAX_VALUE;
        }
        return NumberUtils.int2sortableStr(f);
    }

    public static String float2sortableStr(String val) {
        return NumberUtils.float2sortableStr(Float.parseFloat(val));
    }

    public static float SortableStr2float(String val) {
        int f = NumberUtils.SortableStr2int(val, 0, 3);
        if (f < 0) {
            f ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(f);
    }

    public static float SortableStr2float(BytesRef val) {
        return NumberUtils.SortableStr2float(val.utf8ToString());
    }

    public static String SortableStr2floatStr(String val) {
        return Float.toString(NumberUtils.SortableStr2float(val));
    }

    public static String double2sortableStr(double val) {
        long f = Double.doubleToRawLongBits(val);
        if (f < 0L) {
            f ^= Long.MAX_VALUE;
        }
        return NumberUtils.long2sortableStr(f);
    }

    public static String double2sortableStr(String val) {
        return NumberUtils.double2sortableStr(Double.parseDouble(val));
    }

    public static double SortableStr2double(String val) {
        long f = NumberUtils.SortableStr2long(val, 0, 6);
        if (f < 0L) {
            f ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(f);
    }

    public static double SortableStr2double(BytesRef val) {
        return NumberUtils.SortableStr2double(val.utf8ToString());
    }

    public static String SortableStr2doubleStr(String val) {
        return Double.toString(NumberUtils.SortableStr2double(val));
    }

    public static int int2sortableStr(int val, char[] out, int offset) {
        out[offset++] = (char)((val -= Integer.MIN_VALUE) >>> 24);
        out[offset++] = (char)(val >>> 12 & 0xFFF);
        out[offset++] = (char)(val & 0xFFF);
        return 3;
    }

    public static int SortableStr2int(String sval, int offset, int len) {
        int val = sval.charAt(offset++) << 24;
        val |= sval.charAt(offset++) << 12;
        val |= sval.charAt(offset++);
        return val -= Integer.MIN_VALUE;
    }

    public static int SortableStr2int(BytesRef sval, int offset, int len) {
        return NumberUtils.SortableStr2int(sval.utf8ToString(), offset, len);
    }

    public static int long2sortableStr(long val, char[] out, int offset) {
        out[offset++] = (char)((val += Long.MIN_VALUE) >>> 60);
        out[offset++] = (char)(val >>> 45 & 0x7FFFL);
        out[offset++] = (char)(val >>> 30 & 0x7FFFL);
        out[offset++] = (char)(val >>> 15 & 0x7FFFL);
        out[offset] = (char)(val & 0x7FFFL);
        return 5;
    }

    public static long SortableStr2long(String sval, int offset, int len) {
        long val = (long)sval.charAt(offset++) << 60;
        val |= (long)sval.charAt(offset++) << 45;
        val |= (long)sval.charAt(offset++) << 30;
        val |= (long)(sval.charAt(offset++) << 15);
        val |= (long)sval.charAt(offset);
        return val -= Long.MIN_VALUE;
    }

    public static long SortableStr2long(BytesRef sval, int offset, int len) {
        return NumberUtils.SortableStr2long(sval.utf8ToString(), offset, len);
    }

    public static byte[] intToBytes(int val) {
        byte[] result = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        return result;
    }

    public static int bytesToInt(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        assert (bytes.length == 4);
        return bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }
}

